/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.azure.core.util.HttpClientOptions;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.trino.filesystem.azure.AzureFileSystemFactory;
import io.trino.plugin.deltalake.BaseDeltaLakeConnectorSmokeTest;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.testcontainers.containers.Network;
import reactor.netty.resources.ConnectionProvider;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeAdlsConnectorSmokeTest
extends BaseDeltaLakeConnectorSmokeTest {
    private final String container = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-container");
    private final String account = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-account");
    private final String accessKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-access-key");
    private final String adlsDirectory = String.format("abfs://%s@%s.dfs.core.windows.net/%s/", this.container, this.account, this.bucketName);
    private BlobContainerClient azureContainerClient;

    @Override
    protected HiveHadoop createHiveHadoop() throws Exception {
        String connectionString = String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", this.account, this.accessKey);
        ConnectionProvider provider = ConnectionProvider.create((String)"TestDeltaLakeAdsl");
        this.closeAfterClass(() -> ((ConnectionProvider)provider).dispose());
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        this.closeAfterClass(() -> ((EventLoopGroup)eventLoopGroup).shutdownGracefully());
        BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().connectionString(connectionString).httpClient(AzureFileSystemFactory.createAzureHttpClient((ConnectionProvider)provider, (EventLoopGroup)eventLoopGroup, (HttpClientOptions)new HttpClientOptions())).buildClient();
        this.azureContainerClient = blobServiceClient.getBlobContainerClient(this.container);
        String abfsSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"io/trino/plugin/deltalake/hdp3.1-core-site.xml.abfs-template"), (Charset)StandardCharsets.UTF_8).replace("%ABFS_ACCESS_KEY%", this.accessKey).replace("%ABFS_ACCOUNT%", this.account);
        FileAttribute<Set<PosixFilePermission>> posixFilePermissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
        Path hadoopCoreSiteXmlTempFile = Files.createTempFile("core-site", ".xml", posixFilePermissions);
        hadoopCoreSiteXmlTempFile.toFile().deleteOnExit();
        Files.writeString(hadoopCoreSiteXmlTempFile, (CharSequence)abfsSpecificCoreSiteXmlContent, new OpenOption[0]);
        HiveHadoop hiveHadoop = ((HiveHadoop.Builder)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(HiveHadoop.HIVE3_IMAGE)).withNetwork((Network)this.closeAfterClass((AutoCloseable)Network.newNetwork()))).withFilesToMount((Map)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.normalize().toAbsolutePath().toString()))).build();
        hiveHadoop.start();
        return hiveHadoop;
    }

    @Override
    protected Map<String, String> hiveStorageConfiguration() {
        return ImmutableMap.builder().put((Object)"fs.native-azure.enabled", (Object)"true").put((Object)"azure.auth-type", (Object)"ACCESS_KEY").put((Object)"azure.access-key", (Object)this.accessKey).buildOrThrow();
    }

    @Override
    protected Map<String, String> deltaStorageConfiguration() {
        return this.hiveStorageConfiguration();
    }

    @AfterAll
    public void removeTestData() {
        if (this.adlsDirectory != null) {
            this.hiveHadoop.executeInContainerFailOnError(new String[]{"hadoop", "fs", "-rm", "-f", "-r", this.adlsDirectory});
        }
        Assertions.assertThat((Iterable)this.azureContainerClient.listBlobsByHierarchy(this.bucketName + "/")).isEmpty();
    }

    @Override
    protected void registerTableFromResources(String table, String resourcePath, QueryRunner queryRunner) {
        String targetDirectory = this.bucketName + "/" + table;
        try {
            List resources = (List)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources().stream().filter(resourceInfo -> resourceInfo.getResourceName().startsWith(resourcePath + "/")).collect(ImmutableList.toImmutableList());
            for (ClassPath.ResourceInfo resourceInfo2 : resources) {
                String fileName = resourceInfo2.getResourceName().replaceFirst("^" + Pattern.quote(resourcePath), Matcher.quoteReplacement(targetDirectory));
                ByteSource byteSource = resourceInfo2.asByteSource();
                this.azureContainerClient.getBlobClient(fileName).upload(byteSource.openBufferedStream(), byteSource.size());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        queryRunner.execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", table, this.getLocationForTable(this.bucketName, table)));
    }

    @Override
    protected String getLocationForTable(String bucketName, String tableName) {
        return this.bucketUrl() + tableName;
    }

    @Override
    protected List<String> getTableFiles(String tableName) {
        return this.listAllFilesRecursive(tableName);
    }

    @Override
    protected List<String> listFiles(String directory) {
        return (List)this.listAllFilesRecursive(directory).stream().collect(ImmutableList.toImmutableList());
    }

    private List<String> listAllFilesRecursive(String directory) {
        String azurePath = this.bucketName + "/" + directory;
        Duration timeout = Duration.ofMinutes(5L);
        List allPaths = (List)this.azureContainerClient.listBlobs(new ListBlobsOptions().setPrefix(azurePath), timeout).stream().map(BlobItem::getName).map(relativePath -> String.format("abfs://%s@%s.dfs.core.windows.net/%s", this.container, this.account, relativePath)).collect(ImmutableList.toImmutableList());
        Set directories = (Set)allPaths.stream().map(path -> path.replaceFirst("/[^/]+$", "")).collect(ImmutableSet.toImmutableSet());
        return (List)allPaths.stream().filter(path -> !path.endsWith("/") && !directories.contains(path)).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected void deleteFile(String filePath) {
        String blobName = this.bucketName + "/" + filePath.substring(this.bucketUrl().length());
        this.azureContainerClient.getBlobClient(blobName).delete();
    }

    @Override
    protected String bucketUrl() {
        return String.format("abfs://%s@%s.dfs.core.windows.net/%s/", this.container, this.account, this.bucketName);
    }
}

