/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProperties;
import io.trino.testing.containers.TestContainers;
import io.trino.tpch.TpchTable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testcontainers.containers.Network;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeAdlsStorage
extends AbstractTestQueryFramework {
    private static final String HADOOP_BASE_IMAGE = System.getenv().getOrDefault("HADOOP_BASE_IMAGE", "ghcr.io/trinodb/testing/hdp3.1-hive");
    private static final List<String> TABLES = ImmutableList.of((Object)TpchTable.NATION.getTableName(), (Object)TpchTable.REGION.getTableName(), (Object)TpchTable.CUSTOMER.getTableName());
    private final String account;
    private final String accessKey;
    private final String adlsDirectory;
    private HiveHadoop hiveHadoop;

    public TestDeltaLakeAdlsStorage() {
        String container = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-container");
        this.account = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-account");
        this.accessKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.azure-abfs-access-key");
        String directoryBase = String.format("abfs://%s@%s.dfs.core.windows.net", container, this.account);
        this.adlsDirectory = String.format("%s/tpch-tiny-%s/", directoryBase, UUID.randomUUID());
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Path hadoopCoreSiteXmlTempFile = this.createHadoopCoreSiteXmlTempFileWithAbfsSettings();
        this.hiveHadoop = (HiveHadoop)this.closeAfterClass((AutoCloseable)((HiveHadoop.Builder)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withNetwork(Network.newNetwork())).withImage(HADOOP_BASE_IMAGE)).withFilesToMount((Map)ImmutableMap.of((Object)"/tmp/tpch-tiny", (Object)TestContainers.getPathFromClassPathResource((String)"io/trino/plugin/deltalake/testing/resources/databricks73"), (Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.toString()))).build());
        this.hiveHadoop.start();
        return DeltaLakeQueryRunner.builder().setDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)this.hiveHadoop.getHiveMetastoreEndpoint().toString()).put((Object)"fs.native-azure.enabled", (Object)"true").put((Object)"azure.auth-type", (Object)"ACCESS_KEY").put((Object)"azure.access-key", (Object)this.accessKey).put((Object)"delta.register-table-procedure.enabled", (Object)"true").buildOrThrow()).build();
    }

    private Path createHadoopCoreSiteXmlTempFileWithAbfsSettings() throws Exception {
        String abfsSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"io/trino/plugin/deltalake/hdp3.1-core-site.xml.abfs-template"), (Charset)StandardCharsets.UTF_8).replace("%ABFS_ACCESS_KEY%", this.accessKey).replace("%ABFS_ACCOUNT%", this.account);
        FileAttribute<Set<PosixFilePermission>> posixFilePermissions = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
        Path coreSiteXml = Files.createTempFile("core-site", ".xml", posixFilePermissions);
        coreSiteXml.toFile().deleteOnExit();
        Files.writeString(coreSiteXml, (CharSequence)abfsSpecificCoreSiteXmlContent, new OpenOption[0]);
        return coreSiteXml;
    }

    @BeforeAll
    public void setUp() {
        this.hiveHadoop.executeInContainerFailOnError(new String[]{"hadoop", "fs", "-mkdir", "-p", this.adlsDirectory});
        TABLES.forEach(table -> {
            this.hiveHadoop.executeInContainerFailOnError(new String[]{"hadoop", "fs", "-copyFromLocal", "-f", "/tmp/tpch-tiny/" + table, this.adlsDirectory});
            this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s/%s')", table, this.adlsDirectory, table));
        });
    }

    @AfterAll
    public void tearDown() {
        if (this.adlsDirectory != null && this.hiveHadoop != null) {
            this.hiveHadoop.executeInContainerFailOnError(new String[]{"hadoop", "fs", "-rm", "-f", "-r", this.adlsDirectory});
        }
    }

    @Test
    public void testQuery() {
        this.assertQuery("SELECT n.name FROM nation n JOIN region r ON n.regionkey = r.regionkey WHERE r.name = 'EUROPE'");
        this.assertQuery("SELECT count(*) FROM nation n JOIN customer c ON n.nationkey = c.nationkey WHERE n.name = 'ROMANIA'", "SELECT 64");
    }
}

