/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import io.trino.filesystem.tracing.CacheFileSystemTraceUtils;
import io.trino.plugin.deltalake.DeltaLakeAlluxioCacheTestUtils;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDeltaLakeAlluxioCacheFileOperations
extends AbstractTestQueryFramework {
    protected DistributedQueryRunner createQueryRunner() throws Exception {
        Path cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)cacheDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        return ((DeltaLakeQueryRunner.Builder)((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"))).setDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.register-table-procedure.enabled", (Object)"true").buildOrThrow()).setWorkerCount(1)).build();
    }

    private URL getResourceLocation(String resourcePath) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
    }

    private void registerTable(String name, String resourcePath) {
        String dataPath = this.getResourceLocation(resourcePath).toExternalForm();
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", name, dataPath));
    }

    @Test
    public void testCacheFileOperations() {
        this.assertUpdate("DROP TABLE IF EXISTS test_cache_file_operations");
        this.assertUpdate("CREATE TABLE test_cache_file_operations(key varchar, data varchar) with (partitioned_by=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p1', '1-abc')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p2', '2-xyz')", 1L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_cache_file_operations')");
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 816L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p2/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p2/", 0L, 229L)).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 816L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L)).build());
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p3', '3-xyz')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p4', '4-xyz')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('p5', '5-xyz')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 816L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000004.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000004.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000005.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000005.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000005.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000005.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000005.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000006.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p3/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p4/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p5/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p3/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p4/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p5/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p3/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p4/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p5/", 0L, 229L)).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 816L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000004.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000004.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000005.json", 0L, 658L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000005.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000006.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L), 1).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L), 1).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p3/", 0L, 229L), 1).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p4/", 0L, 229L), 1).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p5/", 0L, 229L), 1).build());
    }

    @Test
    public void testCacheCheckpointAndExtendedStatsFileOperations() {
        this.registerTable("checkpoint_and_extended_stats", "trino432/partition_values_parsed");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'checkpoint_and_extended_stats')");
        this.assertFileSystemAccesses("SELECT * FROM checkpoint_and_extended_stats", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.checkpoint.parquet", 0L, 7077L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000004.json")).addAll(Stream.of("int_part=10/string_part=part1/", "int_part=20/string_part=part2/", "int_part=__HIVE_DEFAULT_PARTITION__/string_part=__HIVE_DEFAULT_PARTITION__/").flatMap(fileId -> Stream.of(new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", fileId, 0L, 199L), new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", fileId, 0L, 199L), new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", fileId, 0L, 199L))).iterator()).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("EXPLAIN ANALYZE SELECT * FROM checkpoint_and_extended_stats", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.checkpoint.parquet", 0L, 7077L), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.checkpoint.parquet"), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000004.json")).addAll(Stream.of("int_part=10/string_part=part1/", "int_part=20/string_part=part2/", "int_part=__HIVE_DEFAULT_PARTITION__/string_part=__HIVE_DEFAULT_PARTITION__/").flatMap(fileId -> Stream.of(new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", fileId, 0L, 199L))).iterator()).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extended_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
    }

    @Test
    public void testCacheDeletionVectorsFileOperations() {
        this.registerTable("deletion_vectors", "databricks122/deletion_vectors");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'deletion_vectors')");
        this.assertFileSystemAccesses("SELECT * FROM deletion_vectors", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 924L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 851L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 1607L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 796L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 796L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 796L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "deletion_vector", 1L, 42L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "deletion_vector", 0L, 43L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "deletion_vector")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "deletion_vector", 0L, 43L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("EXPLAIN ANALYZE SELECT * FROM deletion_vectors", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 924L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 851L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 1607L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 796L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "deletion_vector", 1L, 42L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "deletion_vector")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extended_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extendeded_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
    }

    @Test
    public void testChangeDataFileOperations() {
        this.registerTable("cdc_table", "trino/cdc_table");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'cdc_table')");
        this.assertFileSystemAccesses("SELECT * FROM TABLE(system.table_changes(schema_name=>CURRENT_SCHEMA, table_name=>'cdc_table', since_version=>0))", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1117L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 1100L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=1/", 0L, 389L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=1/", 4L, 74L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "change_data/key=1/", 0L, 389L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "change_data/key=1/", 0L, 389L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=2/", 0L, 394L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=2/", 4L, 75L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "change_data/key=2/", 0L, 394L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "change_data/key=2/", 0L, 394L)).build());
        this.assertFileSystemAccesses("EXPLAIN ANALYZE SELECT * FROM TABLE(system.table_changes(schema_name=>CURRENT_SCHEMA, table_name=>'cdc_table', since_version=>0))", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1117L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 1100L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=1/", 0L, 389L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=1/", 4L, 74L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=2/", 0L, 394L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "change_data/key=2/", 4L, 75L)).build());
    }

    @Test
    public void testTimeTravelWithLastCheckpoint() {
        this.registerTable("time_travel_with_last_checkpoint", "trino440/time_travel");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'time_travel_with_last_checkpoint')");
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint FOR VERSION AS OF 1", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint FOR VERSION AS OF 2", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint FOR VERSION AS OF 2", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertUpdate("DROP TABLE time_travel_with_last_checkpoint");
    }

    @Test
    public void testTimeTravelWithLastCheckpointUsingTemporalVersion() {
        this.registerTable("time_travel_with_last_checkpoint_using_temporal", "trino440/time_travel");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'time_travel_with_last_checkpoint_using_temporal')");
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.122 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json"), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000002.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000002.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000002.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.342 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_with_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.342 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).build());
        this.assertUpdate("DROP TABLE time_travel_with_last_checkpoint_using_temporal");
    }

    @Test
    public void testTimeTravelWithoutLastCheckpoint() throws Exception {
        Path tableLocation = Files.createTempFile("time_travel", null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"trino440/time_travel").toURI()).toPath(), tableLocation);
        Files.delete(tableLocation.resolve("_delta_log/_last_checkpoint"));
        this.getQueryRunner().execute("CALL system.register_table(CURRENT_SCHEMA, 'time_travel_without_last_checkpoint', '" + String.valueOf(tableLocation.toUri()) + "')");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'time_travel_without_last_checkpoint')");
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint FOR VERSION AS OF 1", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000001.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint FOR VERSION AS OF 2", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "00000000000000000002.checkpoint.parquet", 0L, 5884L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000002.checkpoint.parquet", 0L, 5884L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint FOR VERSION AS OF 2", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000002.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertUpdate("DROP TABLE time_travel_without_last_checkpoint");
    }

    @Test
    public void testTimeTravelWithoutLastCheckpointUsingTemporal() throws Exception {
        Path tableLocation = Files.createTempFile("time_travel_using_temporal", null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"trino440/time_travel").toURI()).toPath(), tableLocation);
        Files.delete(tableLocation.resolve("_delta_log/_last_checkpoint"));
        this.getQueryRunner().execute("CALL system.register_table(CURRENT_SCHEMA, 'time_travel_without_last_checkpoint_using_temporal', '" + String.valueOf(tableLocation.toUri()) + "')");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'time_travel_without_last_checkpoint_using_temporal')");
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.122 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000000.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json"), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json"), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.342 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 199L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 199L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "00000000000000000002.checkpoint.parquet", 0L, 5884L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000002.checkpoint.parquet", 0L, 5884L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.json", 0L, 613L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM time_travel_without_last_checkpoint_using_temporal FOR TIMESTAMP AS OF TIMESTAMP '2024-03-13 04:33:19.342 UTC'", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1015L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.json", 0L, 613L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 199L), 3).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.checkpoint.parquet", 0L, 5884L), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000002.json", 0L, 613L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000003.json", 0L, 613L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint"), 2).build());
        this.assertUpdate("DROP TABLE time_travel_without_last_checkpoint_using_temporal");
    }

    @Test
    public void testReadV2CheckpointJson() {
        String dataPath = this.getResourceLocation("deltalake/v2_checkpoint_json").toExternalForm();
        this.assertFileSystemAccesses(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", "v2_checkpoint_json", dataPath), (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", 0L, 765L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", 0L, 765L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", 0L, 765L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'v2_checkpoint_json')");
        this.assertFileSystemAccesses("SELECT * FROM v2_checkpoint_json", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", 0L, 765L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", 0L, 9176L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", 0L, 9176L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", 0L, 9176L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 666L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 666L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 666L)).build());
        this.assertFileSystemAccesses("SELECT * FROM v2_checkpoint_json", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", 0L, 765L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", 0L, 9176L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 666L)).build());
    }

    @Test
    public void testReadV2CheckpointParquet() {
        String dataPath = this.getResourceLocation("deltalake/v2_checkpoint_parquet").toExternalForm();
        this.assertFileSystemAccesses(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", "v2_checkpoint_parquet", dataPath), (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", 0L, 19019L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", 0L, 19019L)).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", 0L, 19019L)).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'v2_checkpoint_parquet')");
        this.assertFileSystemAccesses("SELECT * FROM v2_checkpoint_parquet", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", 0L, 19019L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet"), 4).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", 0L, 9415L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", 0L, 9415L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", 0L, 9415L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "data", 0L, 666L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 666L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "data", 0L, 666L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertFileSystemAccesses("SELECT * FROM v2_checkpoint_parquet", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", 0L, 19019L), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet"), 4).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", 0L, 9415L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "data", 0L, 666L)).build());
    }

    @Test
    public void testCreateOrReplaceTable() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.of());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 821L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000000.json", 0L, 821L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000000.json", 0L, 821L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "extended_stats.json")).build());
        this.assertUpdate("DROP TABLE test_create_or_replace");
    }

    @Test
    public void testCreateOrReplaceTableAsSelect() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "extendeded_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extendeded_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extended_stats.json")).build());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "00000000000000000000.json", 0L, 1063L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readExternalStream", "00000000000000000000.json", 0L, 1063L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "00000000000000000000.json", 0L, 1063L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000000.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "00000000000000000001.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.exists", "extendeded_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "extended_stats.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).build());
        this.assertUpdate("DROP TABLE test_create_or_replace_as_select");
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<CacheFileSystemTraceUtils.CacheOperation> expectedCacheAccesses) {
        this.assertUpdate("CALL system.flush_metadata_cache()");
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        queryRunner.executeWithPlan(queryRunner.getDefaultSession(), query);
        MultisetAssertions.assertMultisetsEqual(DeltaLakeAlluxioCacheTestUtils.getCacheOperations((QueryRunner)queryRunner), expectedCacheAccesses);
    }
}

