/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.TestDeltaLakeMinioAndHmsConnectorSmokeTest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public class TestDeltaLakeAlluxioCacheMinioAndHmsConnectorSmokeTest
extends TestDeltaLakeMinioAndHmsConnectorSmokeTest {
    private Path cacheDirectory;

    @BeforeAll
    public void init() throws Exception {
        this.cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        super.init();
    }

    @Override
    @AfterAll
    public void cleanUp() {
        try (Stream<Path> walk = Files.walk(this.cacheDirectory, new FileVisitOption[0]);){
            Iterator iterator = walk.sorted(Comparator.reverseOrder()).iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                Files.delete(path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        super.cleanUp();
    }

    @Override
    protected Map<String, String> deltaStorageConfiguration() {
        return ImmutableMap.builder().putAll(super.deltaStorageConfiguration()).put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)this.cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").buildOrThrow();
    }
}

