/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.filesystem.tracing.CacheFileSystemTraceUtils;
import io.trino.plugin.deltalake.DeltaLakeAlluxioCacheTestUtils;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDeltaLakeAlluxioCacheMutableTransactionLog
extends AbstractTestQueryFramework {
    protected DistributedQueryRunner createQueryRunner() throws Exception {
        Path cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)cacheDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        return ((DeltaLakeQueryRunner.Builder)((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"))).setDeltaProperties((Map<String, String>)ImmutableMap.builder().put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.register-table-procedure.enabled", (Object)"true").put((Object)"delta.fs.cache.disable-transaction-log-caching", (Object)"true").buildOrThrow()).setWorkerCount(1)).build();
    }

    @Test
    public void testTableDataCachedWhileTransactionLogNotCached() {
        this.assertUpdate("DROP TABLE IF EXISTS test_transaction_log_not_cached");
        this.assertUpdate("CREATE TABLE test_transaction_log_not_cached(key varchar, data varchar) with (partitioned_by=ARRAY['key'], checkpoint_interval = 2)");
        this.assertUpdate("INSERT INTO test_transaction_log_not_cached VALUES ('p1', '1-abc')", 1L);
        this.assertUpdate("INSERT INTO test_transaction_log_not_cached VALUES ('p2', '2-xyz')", 1L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_transaction_log_not_cached')");
        this.assertFileSystemAccesses("SELECT * FROM test_transaction_log_not_cached", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readTail", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p2/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p2/", 0L, 229L)).build());
        this.assertFileSystemAccesses("SELECT * FROM test_transaction_log_not_cached", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000002.checkpoint.parquet"), 2).addCopies((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readTail", "00000000000000000002.checkpoint.parquet"), 2).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.length", "00000000000000000003.json")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("InputFile.newStream", "_last_checkpoint")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/", 0L, 229L)).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/", 0L, 229L)).build());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<CacheFileSystemTraceUtils.CacheOperation> expectedCacheAccesses) {
        this.assertUpdate("CALL system.flush_metadata_cache()");
        QueryRunner queryRunner = this.getQueryRunner();
        queryRunner.executeWithPlan(this.getSession(), query);
        MultisetAssertions.assertMultisetsEqual(DeltaLakeAlluxioCacheTestUtils.getCacheOperations(queryRunner), expectedCacheAccesses);
    }
}

