/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeColumnMapping
extends AbstractTestQueryFramework {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private static final Pattern PHYSICAL_COLUMN_NAME_PATTERN = Pattern.compile("^col-[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    protected QueryRunner createQueryRunner() throws Exception {
        Path catalogDir = Files.createTempDirectory("catalog-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)catalogDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        return DeltaLakeQueryRunner.builder().addDeltaProperty("hive.metastore.catalog.dir", catalogDir.toUri().toString()).addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
    }

    @Test
    public void testCreateTableWithColumnMappingMode() throws Exception {
        this.testCreateTableColumnMappingMode(tableName -> {
            this.assertUpdate("CREATE TABLE " + tableName + "(a_int integer, a_row row(x integer)) WITH (column_mapping_mode='id')");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, row(11))", 1L);
        });
        this.testCreateTableColumnMappingMode(tableName -> {
            this.assertUpdate("CREATE TABLE " + tableName + "(a_int integer, a_row row(x integer)) WITH (column_mapping_mode='name')");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, row(11))", 1L);
        });
    }

    @Test
    public void testCreateTableAsSelectWithColumnMappingMode() throws Exception {
        this.testCreateTableColumnMappingMode(tableName -> this.assertUpdate("CREATE TABLE " + tableName + " WITH (column_mapping_mode='id') AS SELECT 1 AS a_int, CAST(row(11) AS row(x integer)) AS a_row", 1L));
        this.testCreateTableColumnMappingMode(tableName -> this.assertUpdate("CREATE TABLE " + tableName + " WITH (column_mapping_mode='name') AS SELECT 1 AS a_int, CAST(row(11) AS row(x integer)) AS a_row", 1L));
    }

    private void testCreateTableColumnMappingMode(Consumer<String> createTable) throws IOException {
        String tableName = "test_create_table_column_mapping_mode_" + TestingNames.randomNameSuffix();
        createTable.accept(tableName);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, CAST(row(11) AS row(x integer)))");
        String tableLocation = this.getTableLocation(tableName);
        MetadataEntry metadata = TestDeltaLakeColumnMapping.loadMetadataEntry(0L, Path.of(tableLocation, new String[0]));
        Assertions.assertThat((Map)metadata.getConfiguration()).containsEntry((Object)"delta.columnMapping.maxColumnId", (Object)"3");
        JsonNode schema = OBJECT_MAPPER.readTree(metadata.getSchemaString());
        ImmutableList fields = ImmutableList.copyOf((Iterator)schema.get("fields").elements());
        Assertions.assertThat((List)fields).hasSize(2);
        JsonNode intColumn = (JsonNode)fields.get(0);
        JsonNode rowColumn = (JsonNode)fields.get(1);
        ImmutableList rowFields = ImmutableList.copyOf((Iterator)rowColumn.get("type").get("fields").elements());
        Assertions.assertThat((List)rowFields).hasSize(1);
        JsonNode nestedInt = (JsonNode)rowFields.get(0);
        Assertions.assertThat((int)intColumn.get("metadata").get("delta.columnMapping.id").asInt()).isEqualTo(1);
        Assertions.assertThat((String)intColumn.get("metadata").get("delta.columnMapping.physicalName").asText()).containsPattern(PHYSICAL_COLUMN_NAME_PATTERN);
        Assertions.assertThat((int)rowColumn.get("metadata").get("delta.columnMapping.id").asInt()).isEqualTo(3);
        Assertions.assertThat((String)rowColumn.get("metadata").get("delta.columnMapping.physicalName").asText()).containsPattern(PHYSICAL_COLUMN_NAME_PATTERN);
        Assertions.assertThat((int)nestedInt.get("metadata").get("delta.columnMapping.id").asInt()).isEqualTo(2);
        Assertions.assertThat((String)nestedInt.get("metadata").get("delta.columnMapping.physicalName").asText()).containsPattern(PHYSICAL_COLUMN_NAME_PATTERN);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getTableLocation(String tableName) {
        Pattern locationPattern = Pattern.compile(".*location = '(.*?)'.*", 32);
        Matcher m = locationPattern.matcher((String)this.computeActual("SHOW CREATE TABLE " + tableName).getOnlyValue());
        if (m.find()) {
            String location = m.group(1);
            Verify.verify((!m.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in SHOW CREATE TABLE result");
    }

    private static MetadataEntry loadMetadataEntry(long entryNumber, Path tableLocation) throws IOException {
        TrinoFileSystem fileSystem = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS).create(DeltaTestingConnectorSession.SESSION);
        DeltaLakeTransactionLogEntry transactionLog = (DeltaLakeTransactionLogEntry)((TransactionLogEntries)TransactionLogTail.getEntriesFromJson((long)entryNumber, (String)tableLocation.resolve("_delta_log").toString(), (TrinoFileSystem)fileSystem, (DataSize)DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE).orElseThrow()).getEntriesList(fileSystem).stream().filter(log -> log.getMetaData() != null).collect(MoreCollectors.onlyElement());
        return transactionLog.getMetaData();
    }
}

