/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.hive.HiveCompressionOption;
import io.trino.plugin.hive.util.TestHiveUtil;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((DeltaLakeConfig)ConfigAssertions.recordDefaults(DeltaLakeConfig.class)).setDataFileCacheSize(DeltaLakeConfig.DEFAULT_DATA_FILE_CACHE_SIZE).setDataFileCacheTtl(new Duration(30.0, TimeUnit.MINUTES)).setMetadataCacheTtl(new Duration(30.0, TimeUnit.MINUTES)).setMetadataCacheMaxRetainedSize(DeltaLakeConfig.DEFAULT_METADATA_CACHE_MAX_RETAINED_SIZE).setTransactionLogMaxCachedFileSize(DeltaLakeConfig.DEFAULT_TRANSACTION_LOG_MAX_CACHED_SIZE).setDomainCompactionThreshold(1000).setMaxSplitsPerSecond(Integer.MAX_VALUE).setMaxOutstandingSplits(1000).setMaxSplitSize(DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMinimumAssignedSplitWeight(0.05).setMaxPartitionsPerWriter(100).setUnsafeWritesEnabled(false).setDefaultCheckpointWritingInterval(10L).setCheckpointFilteringEnabled(true).setCheckpointRowStatisticsWritingEnabled(true).setVacuumMinRetention(new Duration(7.0, TimeUnit.DAYS)).setHiveCatalogName(null).setDynamicFilteringWaitTimeout(new Duration(0.0, TimeUnit.SECONDS)).setTableStatisticsEnabled(true).setExtendedStatisticsEnabled(true).setCollectExtendedStatisticsOnWrite(true).setCompressionCodec(HiveCompressionOption.ZSTD).setDeleteSchemaLocationsFallback(false).setParquetTimeZone(TimeZone.getDefault().getID()).setPerTransactionMetastoreCacheMaximumSize(1000L).setStoreTableMetadataEnabled(false).setStoreTableMetadataThreads("5").setStoreTableMetadataInterval(new Duration(1.0, TimeUnit.SECONDS)).setTargetMaxFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setIdleWriterMinFileSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setUniqueTableLocation(true).setRegisterTableProcedureEnabled(false).setProjectionPushdownEnabled(true).setQueryPartitionFilterRequired(false).setDeletionVectorsEnabled(false).setDeltaLogFileSystemCacheDisabled(false).setMetadataParallelism(8).setCheckpointProcessingParallelism(4));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"delta.metadata.cache-ttl", (Object)"10m").put((Object)"delta.metadata.cache-max-retained-size", (Object)"1GB").put((Object)"delta.transaction-log.max-cached-file-size", (Object)"1MB").put((Object)"delta.metadata.live-files.cache-size", (Object)"0 MB").put((Object)"delta.metadata.live-files.cache-ttl", (Object)"60m").put((Object)"delta.domain-compaction-threshold", (Object)"500").put((Object)"delta.max-outstanding-splits", (Object)"200").put((Object)"delta.max-splits-per-second", (Object)"10").put((Object)"delta.max-split-size", (Object)"10 MB").put((Object)"delta.minimum-assigned-split-weight", (Object)"0.01").put((Object)"delta.max-partitions-per-writer", (Object)"200").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.default-checkpoint-writing-interval", (Object)"15").put((Object)"delta.checkpoint-filtering.enabled", (Object)"false").put((Object)"delta.checkpoint-row-statistics-writing.enabled", (Object)"false").put((Object)"delta.vacuum.min-retention", (Object)"13h").put((Object)"delta.hive-catalog-name", (Object)"hive").put((Object)"delta.dynamic-filtering.wait-timeout", (Object)"30m").put((Object)"delta.table-statistics-enabled", (Object)"false").put((Object)"delta.extended-statistics.enabled", (Object)"false").put((Object)"delta.extended-statistics.collect-on-write", (Object)"false").put((Object)"delta.compression-codec", (Object)"GZIP").put((Object)"delta.per-transaction-metastore-cache-maximum-size", (Object)"500").put((Object)"delta.delete-schema-locations-fallback", (Object)"true").put((Object)"delta.metastore.store-table-metadata", (Object)"true").put((Object)"delta.metastore.store-table-metadata-threads", (Object)"1").put((Object)"delta.metastore.store-table-metadata-interval", (Object)"30m").put((Object)"delta.parquet.time-zone", (Object)TestHiveUtil.nonDefaultTimeZone().getID()).put((Object)"delta.target-max-file-size", (Object)"2 GB").put((Object)"delta.idle-writer-min-file-size", (Object)"1MB").put((Object)"delta.unique-table-location", (Object)"false").put((Object)"delta.register-table-procedure.enabled", (Object)"true").put((Object)"delta.projection-pushdown-enabled", (Object)"false").put((Object)"delta.query-partition-filter-required", (Object)"true").put((Object)"delta.deletion-vectors-enabled", (Object)"true").put((Object)"delta.fs.cache.disable-transaction-log-caching", (Object)"true").put((Object)"delta.metadata.parallelism", (Object)"10").put((Object)"delta.checkpoint-processing.parallelism", (Object)"8").buildOrThrow();
        DeltaLakeConfig expected = new DeltaLakeConfig().setDataFileCacheSize(DataSize.succinctBytes((long)0L)).setDataFileCacheTtl(new Duration(60.0, TimeUnit.MINUTES)).setMetadataCacheTtl(new Duration(10.0, TimeUnit.MINUTES)).setMetadataCacheMaxRetainedSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setTransactionLogMaxCachedFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setDomainCompactionThreshold(500).setMaxOutstandingSplits(200).setMaxSplitsPerSecond(10).setMaxSplitSize(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMinimumAssignedSplitWeight(0.01).setMaxPartitionsPerWriter(200).setUnsafeWritesEnabled(true).setDefaultCheckpointWritingInterval(15L).setCheckpointRowStatisticsWritingEnabled(false).setCheckpointFilteringEnabled(false).setVacuumMinRetention(new Duration(13.0, TimeUnit.HOURS)).setHiveCatalogName("hive").setDynamicFilteringWaitTimeout(new Duration(30.0, TimeUnit.MINUTES)).setTableStatisticsEnabled(false).setExtendedStatisticsEnabled(false).setCollectExtendedStatisticsOnWrite(false).setCompressionCodec(HiveCompressionOption.GZIP).setDeleteSchemaLocationsFallback(true).setParquetTimeZone(TestHiveUtil.nonDefaultTimeZone().getID()).setPerTransactionMetastoreCacheMaximumSize(500L).setStoreTableMetadataEnabled(true).setStoreTableMetadataThreads("1").setStoreTableMetadataInterval(new Duration(30.0, TimeUnit.MINUTES)).setTargetMaxFileSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setIdleWriterMinFileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setUniqueTableLocation(false).setRegisterTableProcedureEnabled(true).setProjectionPushdownEnabled(false).setQueryPartitionFilterRequired(true).setDeletionVectorsEnabled(true).setDeltaLogFileSystemCacheDisabled(true).setMetadataParallelism(10).setCheckpointProcessingParallelism(8);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

