/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.QueryInfo;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.Table;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.BaseConnectorTest;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingConnectorBehavior;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import io.trino.testing.containers.Minio;
import io.trino.testing.minio.MinioClient;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import io.trino.testing.sql.TrinoSqlExecutor;
import io.trino.type.InternalTypeManager;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeConnectorTest
extends BaseConnectorTest {
    protected static final String SCHEMA = "test_schema";
    protected final String bucketName = "test-bucket-" + TestingNames.randomNameSuffix();
    protected MinioClient minioClient;
    protected HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Minio minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        minio.start();
        minio.createBucket(this.bucketName);
        this.minioClient = (MinioClient)this.closeAfterClass((AutoCloseable)minio.createMinioClient());
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("delta").setSchema(SCHEMA).build()).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin((Plugin)new DeltaLakePlugin());
            queryRunner.createCatalog("delta", "delta_lake", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)queryRunner.getCoordinator().getBaseDataDir().resolve("file-metastore").toString()).put((Object)"hive.metastore.disable-location-checks", (Object)"true").put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"delta.metastore.store-table-metadata", (Object)"true").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.register-table-procedure.enabled", (Object)"true").buildOrThrow());
            queryRunner.execute("CREATE SCHEMA test_schema WITH (location = 's3://" + this.bucketName + "/test_schema')");
            queryRunner.execute("CREATE SCHEMA schemawithoutunderscore WITH (location = 's3://" + this.bucketName + "/schemawithoutunderscore')");
            QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", (Iterable)REQUIRED_TPCH_TABLES);
            this.metastore = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
        return queryRunner;
    }

    protected boolean hasBehavior(TestingConnectorBehavior connectorBehavior) {
        return switch (connectorBehavior) {
            case TestingConnectorBehavior.SUPPORTS_CREATE_OR_REPLACE_TABLE, TestingConnectorBehavior.SUPPORTS_REPORTING_WRITTEN_BYTES -> true;
            case TestingConnectorBehavior.SUPPORTS_ADD_COLUMN_WITH_POSITION, TestingConnectorBehavior.SUPPORTS_ADD_FIELD, TestingConnectorBehavior.SUPPORTS_AGGREGATION_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_CREATE_MATERIALIZED_VIEW, TestingConnectorBehavior.SUPPORTS_DROP_FIELD, TestingConnectorBehavior.SUPPORTS_LIMIT_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_PREDICATE_PUSHDOWN, TestingConnectorBehavior.SUPPORTS_RENAME_FIELD, TestingConnectorBehavior.SUPPORTS_RENAME_SCHEMA, TestingConnectorBehavior.SUPPORTS_SET_COLUMN_TYPE, TestingConnectorBehavior.SUPPORTS_TOPN_PUSHDOWN -> false;
            default -> super.hasBehavior(connectorBehavior);
        };
    }

    protected String errorMessageForInsertIntoNotNullColumn(String columnName) {
        return "NULL value not allowed for NOT NULL column: " + columnName;
    }

    protected void verifyConcurrentUpdateFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessage("Failed to write Delta Lake transaction log entry").cause().hasMessageMatching(TestDeltaLakeConnectorTest.transactionConflictErrors());
    }

    protected void verifyConcurrentInsertFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessage("Failed to write Delta Lake transaction log entry").cause().hasMessageMatching(TestDeltaLakeConnectorTest.transactionConflictErrors());
    }

    protected void verifyConcurrentAddColumnFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Unable to add '.*' column for: .*").cause().hasMessageMatching(TestDeltaLakeConnectorTest.transactionConflictErrors());
    }

    @Language(value="RegExp")
    private static String transactionConflictErrors() {
        return "Transaction log locked.*|Target file already exists: .*/_delta_log/\\d+.json|Conflicting concurrent writes found\\..*|Multiple live locks found for:.*|Target file was created during locking: .*|Conflict detected while writing Transaction Log .* to S3";
    }

    protected Optional<BaseConnectorTest.DataMappingTestSetup> filterCaseSensitiveDataMappingTestData(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("char(3)")) {
            return Optional.of(new BaseConnectorTest.DataMappingTestSetup(typeName, "'ab '", dataMappingTestSetup.getHighValueLiteral()));
        }
        return Optional.of(dataMappingTestSetup);
    }

    protected Optional<BaseConnectorTest.DataMappingTestSetup> filterDataMappingSmokeTestData(BaseConnectorTest.DataMappingTestSetup dataMappingTestSetup) {
        String typeName = dataMappingTestSetup.getTrinoTypeName();
        if (typeName.equals("time") || typeName.equals("time(6)") || typeName.equals("timestamp(6) with time zone")) {
            return Optional.of(dataMappingTestSetup.asUnsupported());
        }
        if (typeName.equals("char(3)")) {
            return Optional.of(new BaseConnectorTest.DataMappingTestSetup(typeName, "'ab '", dataMappingTestSetup.getHighValueLiteral()));
        }
        return Optional.of(dataMappingTestSetup);
    }

    protected TestTable createTableWithDefaultColumns() {
        return (TestTable)Assumptions.abort((String)"Delta Lake does not support columns with a default value");
    }

    protected MaterializedResult getDescribeOrdersResult() {
        return MaterializedResult.resultBuilder((Session)this.getQueryRunner().getDefaultSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"orderkey", "bigint", "", ""}).row(new Object[]{"custkey", "bigint", "", ""}).row(new Object[]{"orderstatus", "varchar", "", ""}).row(new Object[]{"totalprice", "double", "", ""}).row(new Object[]{"orderdate", "date", "", ""}).row(new Object[]{"orderpriority", "varchar", "", ""}).row(new Object[]{"clerk", "varchar", "", ""}).row(new Object[]{"shippriority", "integer", "", ""}).row(new Object[]{"comment", "varchar", "", ""}).build();
    }

    @Test
    public void testShowCreateTable() {
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE orders"))).matches((CharSequence)"\\QCREATE TABLE delta.test_schema.orders (\n   orderkey bigint,\n   custkey bigint,\n   orderstatus varchar,\n   totalprice double,\n   orderdate date,\n   orderpriority varchar,\n   clerk varchar,\n   shippriority integer,\n   comment varchar\n)\nWITH (\n   location = \\E'.*/test_schema/orders.*'\n\\Q)");
    }

    @Test
    public void testQueryNullPartitionWithNotPushdownablePredicate() {
        String tableName = "test_null_partitions_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a, b, c) WITH (location = '" + String.format("s3://%s/%s", this.bucketName, tableName) + "', partitioned_by = ARRAY['c']) AS VALUES (1, 1, 1), (2, 2, 2), (3, 3, 3), (null, null, null), (4, 4, 4)", "VALUES 5");
        this.assertQuery("SELECT a FROM " + tableName + " WHERE c % 5 = 1", "VALUES (1)");
    }

    @Test
    public void testPartitionColumnOrderIsDifferentFromTableDefinition() {
        String tableName = "test_partition_order_is_different_from_table_definition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(data int, first varchar, second varchar) WITH (partitioned_by = ARRAY['second', 'first'], location = '" + String.format("s3://%s/%s", this.bucketName, tableName) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'first#1', 'second#1')", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'first#1', 'second#1')");
        this.assertUpdate("INSERT INTO " + tableName + " (data, first) VALUES (2, 'first#2')", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'first#1', 'second#1'), (2, 'first#2', NULL)");
        this.assertUpdate("INSERT INTO " + tableName + " (data, second) VALUES (3, 'second#3')", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'first#1', 'second#1'), (2, 'first#2', NULL), (3, NULL, 'second#3')");
        this.assertUpdate("INSERT INTO " + tableName + " (data) VALUES (4)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'first#1', 'second#1'), (2, 'first#2', NULL), (3, NULL, 'second#3'), (4, NULL, NULL)");
    }

    @Test
    public void testPartialFilterWhenPartitionColumnOrderIsDifferentFromTableDefinition() {
        this.testPartialFilterWhenPartitionColumnOrderIsDifferentFromTableDefinition(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testPartialFilterWhenPartitionColumnOrderIsDifferentFromTableDefinition(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testPartialFilterWhenPartitionColumnOrderIsDifferentFromTableDefinition(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testPartialFilterWhenPartitionColumnOrderIsDifferentFromTableDefinition(DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode) {
        try (TestTable table = this.newTrinoTable("test_delete_with_partial_filter_composed_partition", "(_bigint BIGINT, _date DATE, _varchar VARCHAR) WITH (column_mapping_mode='" + String.valueOf(columnMappingMode) + "', partitioned_by = ARRAY['_varchar', '_date'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES  (1, CAST('2019-09-10' AS DATE), 'a'), (2, CAST('2019-09-10' AS DATE), 'a')", 2L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, null, 'c'), (4, CAST('2019-09-08' AS DATE), 'd')", 2L);
            this.assertUpdate("UPDATE " + table.getName() + " SET _bigint = 10 WHERE _bigint =  BIGINT '1'", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE _date =  DATE '2019-09-08'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES\n    (10, DATE '2019-09-10', 'a'),\n    (2, DATE '2019-09-10', 'a'),\n    (3, null, 'c')\n");
        }
    }

    @Test
    public void testCreateTableWithAllPartitionColumns() {
        String tableName = "test_create_table_all_partition_columns_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(part INT) WITH (partitioned_by = ARRAY['part'])", "Using all columns for partition columns is unsupported");
    }

    @Test
    public void testCreateTableAsSelectAllPartitionColumns() {
        String tableName = "test_create_table_all_partition_columns_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 part", "Using all columns for partition columns is unsupported");
    }

    @Test
    public void testCreateTableWithUnsupportedPartitionType() {
        String tableName = "test_create_table_unsupported_partition_types_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(a INT, part ARRAY(INT)) WITH (partitioned_by = ARRAY['part'])", "Using array, map or row type on partitioned columns is unsupported");
        this.assertQueryFails("CREATE TABLE " + tableName + "(a INT, part MAP(INT,INT)) WITH (partitioned_by = ARRAY['part'])", "Using array, map or row type on partitioned columns is unsupported");
        this.assertQueryFails("CREATE TABLE " + tableName + "(a INT, part ROW(field INT)) WITH (partitioned_by = ARRAY['part'])", "Using array, map or row type on partitioned columns is unsupported");
    }

    @Test
    public void testInsertIntoUnsupportedVarbinaryPartitionType() {
        try (TestTable table = this.newTrinoTable("test_varbinary_partition", "(x int, part varbinary) WITH (partitioned_by = ARRAY['part'])");){
            this.assertQueryFails("INSERT INTO " + table.getName() + " VALUES (1, X'01')", "Unsupported type for partition: varbinary");
        }
    }

    @Test
    public void testCreateTableAsSelectWithUnsupportedPartitionType() {
        String tableName = "test_ctas_unsupported_partition_types_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 a, array[1] part", "Using array, map or row type on partitioned columns is unsupported");
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 a, map() part", "Using array, map or row type on partitioned columns is unsupported");
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (partitioned_by = ARRAY['part']) AS SELECT 1 a, row(1) part", "Using array, map or row type on partitioned columns is unsupported");
    }

    @Test
    public void testShowCreateSchema() {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE SCHEMA " + schemaName))).isEqualTo(String.format("CREATE SCHEMA %s.%s\nWITH (\n   location = 's3://%s/test_schema'\n)", this.getSession().getCatalog().orElseThrow(), schemaName, this.bucketName));
    }

    @Test
    public void testDropNonEmptySchemaWithTable() {
        String schemaName = "test_drop_non_empty_schema_" + TestingNames.randomNameSuffix();
        if (!this.hasBehavior(TestingConnectorBehavior.SUPPORTS_CREATE_SCHEMA)) {
            return;
        }
        this.assertUpdate("CREATE SCHEMA " + schemaName + " WITH (location = 's3://" + this.bucketName + "/" + schemaName + "')");
        this.assertUpdate("CREATE TABLE " + schemaName + ".t(x int)");
        this.assertQueryFails("DROP SCHEMA " + schemaName, ".*Cannot drop non-empty schema '\\Q" + schemaName + "\\E'");
        this.assertUpdate("DROP TABLE " + schemaName + ".t");
        this.assertUpdate("DROP SCHEMA " + schemaName);
    }

    @Test
    public void testDropColumn() {
        Assertions.assertThatThrownBy(() -> super.testDropColumn()).hasMessageContaining("Cannot drop column from table using column mapping mode NONE");
    }

    @Test
    public void testAddAndDropColumnName() {
        for (String columnName : this.testColumnNameDataProvider()) {
            Assertions.assertThatThrownBy(() -> this.testAddAndDropColumnName(columnName, TestDeltaLakeConnectorTest.requiresDelimiting((String)columnName))).hasMessageContaining("Cannot drop column from table using column mapping mode NONE");
        }
    }

    @Test
    public void testDropAndAddColumnWithSameName() {
        Assertions.assertThatThrownBy(() -> super.testDropAndAddColumnWithSameName()).hasMessageContaining("Cannot drop column from table using column mapping mode NONE");
    }

    @Test
    public void testDropPartitionColumn() {
        this.testDropPartitionColumn(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testDropPartitionColumn(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    public void testDropPartitionColumn(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_drop_partition_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(data int, part int) WITH (partitioned_by = ARRAY['part'], column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN part", "Cannot drop partition column: part");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDropLastNonPartitionColumn() {
        String tableName = "test_drop_last_non_partition_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(data int, part int) WITH (partitioned_by = ARRAY['part'], column_mapping_mode = 'name')");
        this.assertQueryFails("ALTER TABLE " + tableName + " DROP COLUMN data", "Dropping the last non-partition column is unsupported");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRenameColumn() {
        Assertions.assertThatThrownBy(() -> super.testRenameColumn()).hasMessageContaining("Cannot rename column in table using column mapping mode NONE");
    }

    @Test
    public void testRenameColumnWithComment() {
        Assertions.assertThatThrownBy(() -> super.testRenameColumnWithComment()).hasMessageContaining("Cannot rename column in table using column mapping mode NONE");
    }

    @Test
    public void testDeltaRenameColumnWithComment() {
        this.testDeltaRenameColumnWithComment(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testDeltaRenameColumnWithComment(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    private void testDeltaRenameColumnWithComment(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_rename_column_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col INT COMMENT 'test column comment', part INT COMMENT 'test partition comment')WITH (partitioned_by = ARRAY['part'],location = 's3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "',column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN col TO new_col");
        Assertions.assertThat((String)this.getColumnComment(tableName, "new_col")).isEqualTo("test column comment");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN part TO new_part");
        Assertions.assertThat((String)this.getColumnComment(tableName, "new_part")).isEqualTo("test partition comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testAlterTableRenameColumnToLongName() {
        Assertions.assertThatThrownBy(() -> super.testAlterTableRenameColumnToLongName()).hasMessageContaining("Cannot rename column in table using column mapping mode NONE");
    }

    @Test
    public void testRenameColumnName() {
        for (String columnName : this.testColumnNameDataProvider()) {
            Assertions.assertThatThrownBy(() -> this.testRenameColumnName(columnName, TestDeltaLakeConnectorTest.requiresDelimiting((String)columnName))).hasMessageContaining("Cannot rename column in table using column mapping mode NONE");
        }
    }

    @Test
    public void testCharVarcharComparison() {
        try (TestTable table = this.newTrinoTable("test_char_varchar", "(k, v) AS VALUES   (-1, CAST(NULL AS CHAR(3))),    (3, CAST('   ' AS CHAR(3))),   (6, CAST('x  ' AS CHAR(3)))");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('  ' AS varchar(2))"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('    ' AS varchar(4))"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('x ' AS varchar(2))"))).returnsEmptyResult();
            this.assertQuery("SELECT k, v FROM " + table.getName() + " WHERE v = CAST('   ' AS varchar(3))", "VALUES (3, '   ')");
        }
    }

    @Test
    public void testCreateTableWithCompressionCodec() {
        for (HiveCompressionCodec compressionCodec : HiveCompressionCodec.values()) {
            this.testCreateTableWithCompressionCodec(compressionCodec);
        }
    }

    private void testCreateTableWithCompressionCodec(HiveCompressionCodec compressionCodec) {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "compression_codec", compressionCodec.name()).build();
        String tableName = "test_table_with_compression_" + String.valueOf(compressionCodec);
        String createTableSql = String.format("CREATE TABLE %s AS TABLE tpch.tiny.nation", tableName);
        if (compressionCodec == HiveCompressionCodec.LZ4) {
            this.assertQueryFails(session, createTableSql, "Unsupported codec: " + String.valueOf(compressionCodec));
            return;
        }
        this.assertUpdate(session, createTableSql, 25L);
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM nation");
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 25");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampPredicatePushdown() {
        this.testTimestampPredicatePushdown("1965-10-31 01:00:08.123 UTC");
        this.testTimestampPredicatePushdown("1965-10-31 01:00:08.999 UTC");
        this.testTimestampPredicatePushdown("1970-01-01 01:13:42.000 America/Bahia_Banderas");
        this.testTimestampPredicatePushdown("1970-01-01 00:00:00.000 Asia/Kathmandu");
        this.testTimestampPredicatePushdown("2018-10-28 01:33:17.456 Europe/Vilnius");
        this.testTimestampPredicatePushdown("9999-12-31 23:59:59.999 UTC");
    }

    private void testTimestampPredicatePushdown(String value) {
        String tableName = "test_parquet_timestamp_predicate_pushdown_" + TestingNames.randomNameSuffix();
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " (t TIMESTAMP WITH TIME ZONE)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (TIMESTAMP '" + value + "')", 1L);
        QueryRunner queryRunner = this.getQueryRunner();
        QueryRunner.MaterializedResultWithPlan queryResult = queryRunner.executeWithPlan(this.getSession(), "SELECT * FROM " + tableName + " WHERE t < TIMESTAMP '" + value + "'");
        Assertions.assertThat((long)this.getQueryInfo(queryRunner, queryResult).getQueryStats().getProcessedInputDataSize().toBytes()).isEqualTo(0L);
        queryResult = queryRunner.executeWithPlan(this.getSession(), "SELECT * FROM " + tableName + " WHERE t > TIMESTAMP '" + value + "'");
        Assertions.assertThat((long)this.getQueryInfo(queryRunner, queryResult).getQueryStats().getProcessedInputDataSize().toBytes()).isEqualTo(0L);
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE t = TIMESTAMP '" + value + "'", queryStats -> Assertions.assertThat((long)queryStats.getProcessedInputDataSize().toBytes()).isGreaterThan(0L), results -> {});
    }

    @Test
    public void testTimestampPartition() {
        String tableName = "test_timestamp_ntz_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(id INT, part TIMESTAMP(6)) WITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, NULL),(2, TIMESTAMP '0001-01-01 00:00:00.000'),(3, TIMESTAMP '2023-07-20 01:02:03.9999999'),(4, TIMESTAMP '9999-12-31 23:59:59.999999')", 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, NULL),(2, TIMESTAMP '0001-01-01 00:00:00.000000'),(3, TIMESTAMP '2023-07-20 01:02:04.000000'),(4, TIMESTAMP '9999-12-31 23:59:59.999999')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('id', null, 4.0, 0.0, null, 1, 4),('part', null, 3.0, 0.25, null, null, null),(null, null, null, null, 4.0, null, null)");
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 1"))).contains(new CharSequence[]{"/part=__HIVE_DEFAULT_PARTITION__/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 2"))).contains(new CharSequence[]{"/part=0001-01-01 00%3A00%3A00/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 3"))).contains(new CharSequence[]{"/part=2023-07-20 01%3A02%3A04/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 4"))).contains(new CharSequence[]{"/part=9999-12-31 23%3A59%3A59.999999/"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZonePartition() {
        String tableName = "test_timestamp_tz_partition_" + TestingNames.randomNameSuffix();
        this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(id INT, part TIMESTAMP WITH TIME ZONE) WITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, NULL),(2, TIMESTAMP '0001-01-01 00:00:00.000 UTC'),(3, TIMESTAMP '2023-07-20 01:02:03.9999 -01:00'),(4, TIMESTAMP '9999-12-31 23:59:59.999 UTC')", 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, NULL),(2, TIMESTAMP '0001-01-01 00:00:00.000 UTC'),(3, TIMESTAMP '2023-07-20 02:02:04.000 UTC'),(4, TIMESTAMP '9999-12-31 23:59:59.999 UTC')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('id', null, 4.0, 0.0, null, 1, 4),('part', null, 3.0, 0.25, null, null, null),(null, null, null, null, 4.0, null, null)");
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 1"))).contains(new CharSequence[]{"/part=__HIVE_DEFAULT_PARTITION__/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 2"))).contains(new CharSequence[]{"/part=0001-01-01 00%3A00%3A00/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 3"))).contains(new CharSequence[]{"/part=2023-07-20 02%3A02%3A04/"});
        Assertions.assertThat((String)((String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 4"))).contains(new CharSequence[]{"/part=9999-12-31 23%3A59%3A59.999/"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimestampWithTimeZoneOptimization() {
        String tableName = "test_timestamp_tz_optimization_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id INT, part TIMESTAMP WITH TIME ZONE) WITH (partitioned_by = ARRAY['part'])");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, NULL),(2, TIMESTAMP '0001-01-01 00:00:00.000 UTC'),(3, TIMESTAMP '2023-11-21 09:19:00.000 +02:00'),(4, TIMESTAMP '2005-09-10 13:00:00.000 UTC')", 4L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE date_trunc('day', part) >= TIMESTAMP '2005-09-10 07:00:00.000 +07:00'"))).isFullyPushedDown().matches("VALUES (3, TIMESTAMP '2023-11-21 07:19:00.000 UTC'),(4, TIMESTAMP '2005-09-10 13:00:00.000 UTC')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE date_trunc('day', part) = TIMESTAMP '2005-09-10 00:00:00.000 +07:00'"))).isReplacedWithEmptyValues();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE date_trunc('hour', part) >= TIMESTAMP '2005-09-10 13:00:00.001 +00:00'"))).isFullyPushedDown().matches("VALUES (3, TIMESTAMP '2023-11-21 07:19:00.000 UTC')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(Session.builder((Session)this.getSession()).setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")).build(), "SELECT * FROM " + tableName + " WHERE date_trunc('day', part) = DATE '2005-09-10'"))).isReplacedWithEmptyValues();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE date_trunc('week', part) >= TIMESTAMP '2005-09-10 00:00:00.000 +00:00'"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE cast(part AS date) >= DATE '2005-09-10'"))).isFullyPushedDown().matches("VALUES (3, TIMESTAMP '2023-11-21 07:19:00.000 UTC'),(4, TIMESTAMP '2005-09-10 13:00:00.000 UTC')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE cast(part AS date) = DATE '2005-10-10'"))).isFullyPushedDown().returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE year(part) >= 2005"))).isFullyPushedDown().matches("VALUES (3, TIMESTAMP '2023-11-21 07:19:00.000 UTC'),(4, TIMESTAMP '2005-09-10 13:00:00.000 UTC')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName + " WHERE year(part) = 2006"))).isFullyPushedDown().returnsEmptyResult();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testShowStatsForTimestampWithTimeZone() {
        try (TestTable table = this.newTrinoTable("test_stats_timestamptz_", "(x TIMESTAMP(3) WITH TIME ZONE) WITH (checkpoint_interval = 2)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (TIMESTAMP '+10000-01-02 13:34:56.123 +01:00')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table.getName()))).result().projected(new String[]{"column_name", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('x', '+10000-01-02 12:34:56.123 UTC', '+10000-01-02 12:34:56.123 UTC'),(null, null, null)");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (TIMESTAMP '-9999-01-02 13:34:56.123 +01:00')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR " + table.getName()))).result().projected(new String[]{"column_name", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('x', '+10000-01-02 12:34:56.123 UTC', '+10000-01-02 12:34:56.123 UTC'),(null, null, null)");
        }
    }

    @Test
    public void testAddColumnToPartitionedTable() {
        try (TestTable table = this.newTrinoTable("test_add_column_partitioned_table_", "(x VARCHAR, part VARCHAR) WITH (partitioned_by = ARRAY['part'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first', 'part-0001'", 1L);
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN x bigint", ".* Column 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN part bigint", ".* Column 'part' already exists");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'part-0002', 'xxx'", 1L);
            this.assertQuery("SELECT x, part, a FROM " + table.getName(), "VALUES ('first', 'part-0001', NULL), ('second', 'part-0002', 'xxx')");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN b double");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'third', 'part-0003', 'yyy', 33.3E0", 1L);
            this.assertQuery("SELECT x, part, a, b FROM " + table.getName(), "VALUES ('first', 'part-0001', NULL, NULL), ('second', 'part-0002', 'xxx', NULL), ('third', 'part-0003', 'yyy', 33.3)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS c varchar(50)");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN IF NOT EXISTS part varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'fourth', 'part-0004', 'zzz', 55.3E0, 'newColumn'", 1L);
            this.assertQuery("SELECT x, part, a, b, c FROM " + table.getName(), "VALUES ('first', 'part-0001', NULL, NULL, NULL), ('second', 'part-0002', 'xxx', NULL, NULL), ('third', 'part-0003', 'yyy', 33.3, NULL), ('fourth', 'part-0004', 'zzz', 55.3, 'newColumn')");
        }
    }

    private QueryInfo getQueryInfo(QueryRunner queryRunner, QueryRunner.MaterializedResultWithPlan queryResult) {
        return queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(queryResult.queryId());
    }

    @Test
    public void testAddColumnAndOptimize() {
        try (TestTable table = this.newTrinoTable("test_add_column_and_optimize", "(x VARCHAR)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'xxx'", 1L);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
            Set<String> beforeActiveFiles = this.getActiveFiles(table.getName());
            this.computeActual("ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE");
            Assertions.assertThat(beforeActiveFiles).isNotEqualTo(this.getActiveFiles(table.getName()));
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', NULL), ('second', 'xxx')");
        }
    }

    @Test
    public void testAddColumnAndVacuum() throws Exception {
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        try (TestTable table = this.newTrinoTable("test_add_column_and_optimize", "(x VARCHAR)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second'", 1L);
            Set<String> initialFiles = this.getActiveFiles(table.getName());
            Assertions.assertThat(initialFiles).hasSize(2);
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("UPDATE " + table.getName() + " SET a = 'new column'", 2L);
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(table.getName());
            ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSizeGreaterThanOrEqualTo(1)).hasSizeLessThanOrEqualTo(2)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', 'new column'), ('second', 'new column')");
            TimeUnit.MILLISECONDS.sleep(1000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + table.getName() + "', retention => '1s')");
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo(updatedFiles);
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', 'new column'), ('second', 'new column')");
        }
    }

    @Test
    public void testDropNotNullConstraintWithColumnMapping() {
        this.testDropNotNullConstraintWithColumnMapping(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testDropNotNullConstraintWithColumnMapping(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testDropNotNullConstraintWithColumnMapping(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testDropNotNullConstraintWithColumnMapping(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_drop_not_null_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "( data integer NOT NULL COMMENT 'test comment', part integer NOT NULL COMMENT 'test part comment')WITH (partitioned_by = ARRAY['part'], column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("ALTER TABLE " + tableName + " ALTER COLUMN data DROP NOT NULL");
        Assertions.assertThat((boolean)this.columnIsNullable(tableName, "data")).isTrue();
        Assertions.assertThat((boolean)this.columnIsNullable(tableName, "part")).isFalse();
        this.assertUpdate("ALTER TABLE " + tableName + " ALTER COLUMN part DROP NOT NULL");
        Assertions.assertThat((boolean)this.columnIsNullable(tableName, "data")).isTrue();
        Assertions.assertThat((boolean)this.columnIsNullable(tableName, "part")).isTrue();
        Assertions.assertThat((String)this.getColumnComment(tableName, "data")).isEqualTo("test comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "part")).isEqualTo("test part comment");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (NULL, NULL)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (NULL, NULL)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTargetMaxFileSize() {
        String tableName = "test_default_max_file_size" + TestingNames.randomNameSuffix();
        String createTableSql = String.format("CREATE TABLE %s AS SELECT * FROM tpch.sf1.lineitem LIMIT 100000", tableName);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").build();
        this.assertUpdate(session, createTableSql, 100000L);
        Set<String> initialFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)initialFiles.size()).isLessThanOrEqualTo(3);
        this.assertUpdate(String.format("DROP TABLE %s", tableName));
        DataSize maxSize = DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        session = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").setSystemProperty("task_scale_writers_enabled", "false").setCatalogSessionProperty("delta", "target_max_file_size", maxSize.toString()).build();
        this.assertUpdate(session, createTableSql, 100000L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT count(*) FROM %s", tableName)))).matches("VALUES BIGINT '100000'");
        Set<String> updatedFiles = this.getActiveFiles(tableName);
        Assertions.assertThat((int)updatedFiles.size()).isGreaterThan(10);
        MaterializedResult result = this.computeActual("SELECT DISTINCT \"$path\", \"$file_size\" FROM " + tableName);
        for (MaterializedRow row : result) {
            Assertions.assertThat((Long)((Long)row.getField(1))).isLessThan(maxSize.toBytes() * 5L);
        }
    }

    @Test
    public void testPathColumn() {
        try (TestTable table = this.newTrinoTable("test_path_column", "(x VARCHAR, part VARCHAR) WITH (partitioned_by = ARRAY['part'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first', 'a#sharp'", 1L);
            String firstFilePath = (String)this.computeScalar("SELECT \"$path\" FROM " + table.getName());
            Assertions.assertThat((boolean)firstFilePath.contains("a#sharp")).isFalse();
            Assertions.assertThat((boolean)firstFilePath.contains("a%23sharp")).isTrue();
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second', 'a%23sharp'", 1L);
            String secondFilePath = (String)this.computeScalar("SELECT \"$path\" FROM " + table.getName() + " WHERE x = 'second'");
            Assertions.assertThat((boolean)secondFilePath.contains("a%23sharp")).isFalse();
            Assertions.assertThat((boolean)secondFilePath.contains("a%2523sharp")).isTrue();
            this.assertQuery("SELECT x FROM " + table.getName() + " WHERE part = 'a#sharp'", "VALUES 'first'");
            this.assertQuery("SELECT x FROM " + table.getName() + " WHERE part = 'a%23sharp'", "VALUES 'second'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$path\" = '" + firstFilePath + "'"))).matches("VALUES CAST('first' AS VARCHAR)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$path\" <> '" + firstFilePath + "'"))).matches("VALUES CAST('second' AS VARCHAR)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$path\" IN ('" + firstFilePath + "', '" + secondFilePath + "')"))).matches("VALUES (CAST('first' AS VARCHAR)), (CAST('second' AS VARCHAR))").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT x FROM " + table.getName() + " WHERE \"$path\" IS NOT NULL"))).matches("VALUES (CAST('first' AS VARCHAR)), (CAST('second' AS VARCHAR))").isFullyPushedDown();
            this.assertQueryReturnsEmptyResult("SELECT x FROM " + table.getName() + " WHERE \"$path\" IS NULL");
            this.assertQuery("SHOW STATS FOR (SELECT x FROM " + table.getName() + " WHERE \"$path\" = '" + firstFilePath + "')", "VALUES ('x', 11.0, 1.0, 0.0, null, null, null),(null, null, null, null, 1.0, null, null)");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$path\" = 'not exist'", 0L);
            this.assertQuery("SELECT x FROM " + table.getName(), "VALUES 'first', 'second'");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$path\" = '" + firstFilePath + "'", 1L);
            this.assertQuery("SELECT x FROM " + table.getName(), "VALUES 'second'");
            this.assertUpdate("UPDATE " + table.getName() + " SET x = 'update' WHERE \"$path\" = '" + secondFilePath + "'", 1L);
            this.assertQuery("SELECT x FROM " + table.getName(), "VALUES 'update'");
        }
    }

    @Test
    public void testOptimizeWithPathColumn() {
        try (TestTable table = this.newTrinoTable("test_optimize_with_path_column", "(id integer)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 1", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 3", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 4", 1L);
            String firstPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 1");
            String secondPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 2");
            String thirdPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 3");
            String fourthPath = (String)this.computeScalar("SELECT \"$path\" FROM " + tableName + " WHERE id = 4");
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(4);
            Session singleWriterSession = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").build();
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$path\" = '" + firstPath + "' OR \"$path\" = '" + secondPath + "'");
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$path\" = '" + thirdPath + "' OR \"$path\" = '" + fourthPath + "'");
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
        }
    }

    @Test
    public void testFileModifiedTimeHiddenColumn() throws Exception {
        ZonedDateTime beforeTime = (ZonedDateTime)this.computeScalar("SELECT current_timestamp(3)");
        TimeUnit.MILLISECONDS.sleep(1L);
        try (TestTable table = this.newTrinoTable("test_file_modified_time_", "(col) AS VALUES 1");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE " + table.getName()))).skippingTypesCheck().matches("VALUES ('col', 'integer', '', '')");
            ZonedDateTime fileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + table.getName());
            ZonedDateTime afterTime = (ZonedDateTime)this.computeScalar("SELECT current_timestamp(3)");
            Assertions.assertThat((ZonedDateTime)fileModifiedTime).isBetween(beforeTime, afterTime);
            TimeUnit.MILLISECONDS.sleep(1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2)", 1L);
            ZonedDateTime anotherFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT max(\"$file_modified_time\") FROM " + table.getName());
            Assertions.assertThat((ZonedDateTime)fileModifiedTime).isNotEqualTo((Object)anotherFileModifiedTime);
            Assertions.assertThat((ZonedDateTime)anotherFileModifiedTime).isAfter(fileModifiedTime);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')"))).matches("VALUES 1").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IN (from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'), from_iso8601_timestamp('" + anotherFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'))"))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" <> from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')"))).matches("VALUES 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IS NOT NULL"))).matches("VALUES 1, 2").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" IS NULL"))).returnsEmptyResult().isFullyPushedDown();
            this.assertQuery("SHOW STATS FOR (SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "'))", "VALUES ('col', null, 1.0, 0.0, null, 1, 1), (null, null, null, null, 1.0, null, null)");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + beforeTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')", 0L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 1, 2");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')", 1L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 2");
            this.assertUpdate("UPDATE " + table.getName() + " SET col = 100 WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + anotherFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')", 1L);
            this.assertQuery("SELECT col FROM " + table.getName(), "VALUES 100");
            this.assertQuerySucceeds("EXPLAIN SELECT col FROM " + table.getName() + " WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + fileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
        }
    }

    @Test
    public void testOptimizeWithFileModifiedTimeColumn() throws Exception {
        try (TestTable table = this.newTrinoTable("test_optimize_with_file_modified_time_", "(id INT)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 1", 1L);
            TimeUnit.MILLISECONDS.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
            TimeUnit.MILLISECONDS.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 3", 1L);
            TimeUnit.MILLISECONDS.sleep(1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES 4", 1L);
            ZonedDateTime firstFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 1");
            ZonedDateTime secondFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 2");
            ZonedDateTime thirdFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 3");
            ZonedDateTime fourthFileModifiedTime = (ZonedDateTime)this.computeScalar("SELECT \"$file_modified_time\" FROM " + tableName + " WHERE id = 4");
            Assertions.assertThat(List.of(firstFileModifiedTime, secondFileModifiedTime, thirdFileModifiedTime, fourthFileModifiedTime)).doesNotHaveDuplicates();
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(4);
            TimeUnit.MILLISECONDS.sleep(1L);
            Session singleWriterSession = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").build();
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + firstFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "') OR \"$file_modified_time\" = from_iso8601_timestamp('" + secondFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_modified_time\" = from_iso8601_timestamp('" + thirdFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "') OR \"$file_modified_time\" = from_iso8601_timestamp('" + fourthFileModifiedTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "')");
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
        }
    }

    @Test
    public void testFileSizeHiddenColumn() {
        try (TestTable table = this.newTrinoTable("test_file_size_column", "(val VARCHAR)");){
            String tableName = table.getName();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE " + table.getName()))).skippingTypesCheck().matches("VALUES ('val', 'varchar', '', '')");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '1'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '12345'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '1234567890'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '12345678901234567890'", 1L);
            long firstFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '1'");
            long secondFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '12345'");
            long thirdFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '1234567890'");
            long fourthFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '12345678901234567890'");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT val FROM " + table.getName() + " WHERE \"$file_size\" = " + firstFileSize))).matches("VALUES CAST('1' AS VARCHAR)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT val FROM " + table.getName() + " WHERE \"$file_size\" > " + firstFileSize + " AND \"$file_size\" <= " + thirdFileSize))).matches("VALUES CAST('12345' AS VARCHAR), CAST('1234567890' AS VARCHAR)").isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT val FROM " + table.getName() + " WHERE \"$file_size\" > " + secondFileSize + " AND \"$file_size\" <= " + fourthFileSize))).matches("VALUES CAST('1234567890' AS VARCHAR), CAST('12345678901234567890' AS VARCHAR)").isFullyPushedDown();
            this.assertQuery("SHOW STATS FOR (SELECT val FROM " + table.getName() + " WHERE \"$file_size\" > " + thirdFileSize + ")", "VALUES ('val', 36.0, 1.0, 0.0, null, null, null), (null, null, null, null, 1.0, null, null)");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$file_size\" = 0", 0L);
            this.assertQuery("SELECT val FROM " + table.getName(), "VALUES '1', '12345', '1234567890', '12345678901234567890'");
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE \"$file_size\" = " + firstFileSize, 1L);
            this.assertQuery("SELECT val FROM " + table.getName(), "VALUES '12345', '1234567890', '12345678901234567890'");
            this.assertUpdate("UPDATE " + table.getName() + " SET val = 'update' WHERE \"$file_size\" = " + secondFileSize, 1L);
            this.assertQuery("SELECT val FROM " + table.getName(), "VALUES 'update', '1234567890', '12345678901234567890'");
        }
    }

    @Test
    public void testOptimizeWithFileSizeColumn() throws Exception {
        try (TestTable table = this.newTrinoTable("test_optimize_with_file_size_", "(val VARCHAR)");){
            String tableName = table.getName();
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '1'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '12345'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '1234567890'", 1L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES '12345678901234567890'", 1L);
            long secondFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '12345'");
            long thirdFileSize = (Long)this.computeScalar("SELECT \"$file_size\" FROM " + tableName + " WHERE val = '1234567890'");
            Set<String> initialFiles = this.getActiveFiles(tableName);
            Assertions.assertThat(initialFiles).hasSize(4);
            TimeUnit.MILLISECONDS.sleep(1L);
            Session singleWriterSession = Session.builder((Session)this.getSession()).setSystemProperty("task_min_writer_count", "1").build();
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_size\" <= " + secondFileSize);
            this.assertQuerySucceeds(singleWriterSession, "ALTER TABLE " + tableName + " EXECUTE OPTIMIZE WHERE \"$file_size\" >= " + thirdFileSize);
            Set<String> updatedFiles = this.getActiveFiles(tableName);
            ((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSize(2)).doesNotContainAnyElementsOf(initialFiles);
        }
    }

    @Test
    public void testTableLocationTrailingSpace() {
        String tableName = "table_with_space_" + TestingNames.randomNameSuffix();
        String tableLocationWithTrailingSpace = "s3://" + this.bucketName + "/" + tableName + " ";
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR) WITH (location = '%s')", tableName, tableLocationWithTrailingSpace));
        this.assertUpdate("INSERT INTO " + tableName + " (customer) VALUES ('Aaron'), ('Bill')", 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('Aaron'), ('Bill')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTableLocationTrailingSlash() {
        String tableWithSlash = "table_with_slash";
        String tableWithoutSlash = "table_without_slash";
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR) WITH (location = 's3://%s/%s/')", tableWithSlash, this.bucketName, tableWithSlash));
        this.assertUpdate(String.format("INSERT INTO %s (customer) VALUES ('Aaron'), ('Bill')", tableWithSlash), 2L);
        this.assertQuery("SELECT * FROM " + tableWithSlash, "VALUES ('Aaron'), ('Bill')");
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR) WITH (location = 's3://%s/%s')", tableWithoutSlash, this.bucketName, tableWithoutSlash));
        this.assertUpdate(String.format("INSERT INTO %s (customer) VALUES ('Carol'), ('Dave')", tableWithoutSlash), 2L);
        this.assertQuery("SELECT * FROM " + tableWithoutSlash, "VALUES ('Carol'), ('Dave')");
        this.assertUpdate("DROP TABLE " + tableWithSlash);
        this.assertUpdate("DROP TABLE " + tableWithoutSlash);
    }

    @Test
    public void testMergeSimpleSelectPartitioned() {
        String targetTable = "merge_simple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_simple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", targetTable, this.bucketName, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')", sourceTable, this.bucketName, sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(sql, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Ed', 7, 'Etherville'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeUpdateWithVariousLayouts() {
        this.testMergeUpdateWithVariousLayouts("");
        this.testMergeUpdateWithVariousLayouts(", partitioned_by = ARRAY['customer']");
        this.testMergeUpdateWithVariousLayouts(", partitioned_by = ARRAY['purchase']");
    }

    private void testMergeUpdateWithVariousLayouts(String partitionPhase) {
        String targetTable = "merge_formats_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_formats_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) WITH (location = 's3://%s/%s'%s)", targetTable, this.bucketName, targetTable, partitionPhase));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')", targetTable), 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Lou', 'limes'), ('Carol', 'candles')");
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchase VARCHAR) WITH (location = 's3://%s/%s')", sourceTable, this.bucketName, sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase) VALUES ('Craig', 'candles'), ('Len', 'limes'), ('Joe', 'jellybeans')", sourceTable), 3L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.purchase = s.purchase)", targetTable, sourceTable) + "    WHEN MATCHED AND s.purchase = 'limes' THEN DELETE    WHEN MATCHED THEN UPDATE SET customer = CONCAT(t.customer, '_', s.customer)    WHEN NOT MATCHED THEN INSERT (customer, purchase) VALUES(s.customer, s.purchase)";
        this.assertUpdate(sql, 3L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Dave', 'dates'), ('Carol_Craig', 'candles'), ('Joe', 'jellybeans')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleOperations() {
        this.testMergeMultipleOperations("");
        this.testMergeMultipleOperations(", partitioned_by = ARRAY['customer']");
        this.testMergeMultipleOperations(", partitioned_by = ARRAY['purchase']");
    }

    private void testMergeMultipleOperations(String partitioning) {
        int targetCustomerCount = 32;
        String targetTable = "merge_multiple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (purchase INT, zipcode INT, spouse VARCHAR, address VARCHAR, customer VARCHAR) WITH (location = 's3://%s/%s'%s)", targetTable, this.bucketName, targetTable, partitioning));
        String originalInsertFirstHalf = IntStream.range(1, targetCustomerCount / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 1000, 91000, intValue, intValue)).collect(Collectors.joining(", "));
        String originalInsertSecondHalf = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 2000, 92000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase, zipcode, spouse, address) VALUES %s, %s", targetTable, originalInsertFirstHalf, originalInsertSecondHalf), targetCustomerCount - 1);
        String firstMergeSource = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 83000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchase, zipcode, spouse, address)", targetTable, firstMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED THEN UPDATE SET purchase = s.purchase, zipcode = s.zipcode, spouse = s.spouse, address = s.address", targetCustomerCount / 2);
        this.assertQuery("SELECT customer, purchase, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s", originalInsertFirstHalf, firstMergeSource));
        String nextInsert = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchase, zipcode, spouse, address) VALUES %s", targetTable, nextInsert), targetCustomerCount / 2);
        String secondMergeSource = IntStream.range(1, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertUpdate(String.format("MERGE INTO %s t USING (VALUES %s) AS s(customer, purchase, zipcode, spouse, address)", targetTable, secondMergeSource) + "    ON t.customer = s.customer    WHEN MATCHED AND t.zipcode = 91000 THEN DELETE    WHEN MATCHED AND s.zipcode = 85000 THEN UPDATE SET zipcode = 60000    WHEN MATCHED THEN UPDATE SET zipcode = s.zipcode, spouse = s.spouse, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchase, zipcode, spouse, address) VALUES(s.customer, s.purchase, s.zipcode, s.spouse, s.address)", targetCustomerCount * 3 / 2 - 1);
        String updatedBeginning = IntStream.range(targetCustomerCount / 2, targetCustomerCount).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jill_%s', '%s Eop Ct')", intValue, 3000, 60000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedMiddle = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('joe_%s', %s, %s, 'jen_%s', '%s Poe Ct')", intValue, 5000, 85000, intValue, intValue)).collect(Collectors.joining(", "));
        String updatedEnd = IntStream.range(targetCustomerCount, targetCustomerCount * 3 / 2).mapToObj(intValue -> String.format("('jack_%s', %s, %s, 'jan_%s', '%s Poe Ct')", intValue, 4000, 74000, intValue, intValue)).collect(Collectors.joining(", "));
        this.assertQuery("SELECT customer, purchase, zipcode, spouse, address FROM " + targetTable, String.format("VALUES %s, %s, %s", updatedBeginning, updatedMiddle, updatedEnd));
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeSimpleQueryPartitioned() {
        String targetTable = "merge_simple_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", targetTable, this.bucketName, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        String query = String.format("MERGE INTO %s t USING ", targetTable) + "(SELECT * FROM (VALUES ('Aaron', 6, 'Arches'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire'), ('Ed', 7, 'Etherville'))) AS s(customer, purchases, address)    ON (t.customer = s.customer)    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(query, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeMultipleRowsMatchFails() {
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (purchases INT, customer VARCHAR, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address', 'customer'])");
        this.testMergeMultipleRowsMatchFails("CREATE TABLE %s (purchases INT, address VARCHAR, customer VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address', 'customer'])");
    }

    private void testMergeMultipleRowsMatchFails(String createTableSql) {
        String targetTable = "merge_multiple_target_" + TestingNames.randomNameSuffix();
        String sourceTable = "merge_multiple_source_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format(createTableSql, targetTable, this.bucketName, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch')", targetTable), 2L);
        this.assertUpdate(String.format("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')", sourceTable, this.bucketName, sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Adelphi'), ('Aaron', 8, 'Ashland')", sourceTable), 2L);
        Assertions.assertThatThrownBy(() -> this.computeActual(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED THEN UPDATE SET address = s.address")).hasMessage("One MERGE target table row matched more than one source row");
        this.assertUpdate(String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Adelphi' THEN UPDATE SET address = s.address", 1L);
        this.assertQuery("SELECT customer, purchases, address FROM " + targetTable, "VALUES ('Aaron', 5, 'Adelphi'), ('Bill', 7, 'Antioch')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testMergeWithDifferentPartitioning() {
        this.testMergeWithDifferentPartitioning("target_partitioned_source_and_target_partitioned", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address', 'customer'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])");
        this.testMergeWithDifferentPartitioning("target_partitioned_source_and_target_partitioned", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer', 'address'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])");
        this.testMergeWithDifferentPartitioning("target_flat_source_partitioned_by_customer", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')", "CREATE TABLE %s (purchases INT, address VARCHAR, customer VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer'])");
        this.testMergeWithDifferentPartitioning("target_partitioned_by_customer_source_flat", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')");
        this.testMergeWithDifferentPartitioning("target_bucketed_by_customer_source_flat", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer', 'address'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')");
        this.testMergeWithDifferentPartitioning("target_partitioned_source_partitioned", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])");
        this.testMergeWithDifferentPartitioning("target_partitioned_target_partitioned", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer'])");
    }

    private void testMergeWithDifferentPartitioning(String testDescription, String createTargetTableSql, String createSourceTableSql) {
        String targetTable = String.format("%s_target_%s", testDescription, TestingNames.randomNameSuffix());
        String sourceTable = String.format("%s_source_%s", testDescription, TestingNames.randomNameSuffix());
        this.assertUpdate(String.format(createTargetTableSql, targetTable, this.bucketName, targetTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Buena'), ('Carol', 3, 'Cambridge'), ('Dave', 11, 'Devon')", targetTable), 4L);
        this.assertUpdate(String.format(createSourceTableSql, sourceTable, this.bucketName, sourceTable));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 6, 'Arches'), ('Ed', 7, 'Etherville'), ('Carol', 9, 'Centreville'), ('Dave', 11, 'Darbyshire')", sourceTable), 4L);
        String sql = String.format("MERGE INTO %s t USING %s s ON (t.customer = s.customer)", targetTable, sourceTable) + "    WHEN MATCHED AND s.address = 'Centreville' THEN DELETE    WHEN MATCHED THEN UPDATE SET purchases = s.purchases + t.purchases, address = s.address    WHEN NOT MATCHED THEN INSERT (customer, purchases, address) VALUES(s.customer, s.purchases, s.address)";
        this.assertUpdate(sql, 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES ('Aaron', 11, 'Arches'), ('Bill', 7, 'Buena'), ('Dave', 22, 'Darbyshire'), ('Ed', 7, 'Etherville')");
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testTableWithNonNullableColumns() {
        this.testTableWithNonNullableColumns(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testTableWithNonNullableColumns(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testTableWithNonNullableColumns(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testTableWithNonNullableColumns(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_table_with_non_nullable_columns_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col1 INTEGER NOT NULL, col2 INTEGER, col3 INTEGER) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 10, 100)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(2, 20, 200)", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES(null, 30, 300)"))).failure().hasMessageContaining("NULL value not allowed for NOT NULL column: col1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES(TRY(5/0), 40, 400)"))).failure().hasMessageContaining("NULL value not allowed for NOT NULL column: col1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("UPDATE " + tableName + " SET col1 = NULL where col3 = 100"))).failure().hasMessageContaining("NULL value not allowed for NOT NULL column: col1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("UPDATE " + tableName + " SET col1 = TRY(5/0) where col3 = 200"))).failure().hasMessageContaining("NULL value not allowed for NOT NULL column: col1");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES(1, 10, 100), (2, 20, 200)");
    }

    @Test
    public void testCreateTableWithChangeDataFeedColumnName() {
        for (String columnName : DeltaLakeMetadata.CHANGE_DATA_FEED_COLUMN_NAMES) {
            try (TestTable table = this.newTrinoTable("test_create_table_cdf", "(" + columnName + " int)");){
                this.assertTableColumnNames(table.getName(), new String[]{columnName});
            }
            table = this.newTrinoTable("test_create_table_cdf", "AS SELECT 1 AS " + columnName);
            try {
                this.assertTableColumnNames(table.getName(), new String[]{columnName});
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    @Test
    public void testCreateTableWithChangeDataFeed() {
        try (TestTable table = this.newTrinoTable("test_cdf", "(x int) WITH (change_data_feed_enabled = true)");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$properties\""))).skippingTypesCheck().matches("VALUES ('delta.enableChangeDataFeed', 'true'),('delta.enableDeletionVectors', 'false'),('delta.minReaderVersion', '1'),('delta.minWriterVersion', '4')");
        }
        table = this.newTrinoTable("test_cdf", "(x timestamp) WITH (change_data_feed_enabled = true)");
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$properties\""))).skippingTypesCheck().matches("VALUES ('delta.enableChangeDataFeed', 'true'),('delta.enableDeletionVectors', 'false'),('delta.minReaderVersion', '3'),('delta.minWriterVersion', '7'),('delta.feature.timestampNtz', 'supported'),('delta.feature.changeDataFeed', 'supported')");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testChangeDataFeedWithDeletionVectors() {
        try (TestTable table = this.newTrinoTable("test_cdf", "(x VARCHAR, y INT) WITH (change_data_feed_enabled = true, deletion_vectors_enabled = true)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES('test1', 1)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES('test2', 2)", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET y = 20 WHERE x = 'test2'", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).skippingTypesCheck().matches("VALUES ('test1', 1), ('test2', 20)");
            this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + table.getName() + "'))", "VALUES\n    ('test1', 1, 'insert', BIGINT '1'),\n    ('test2', 2, 'insert', BIGINT '2'),\n    ('test2', 2, 'update_preimage', BIGINT '3'),\n    ('test2', 20, 'update_postimage', BIGINT '3')\n");
        }
    }

    @Test
    public void testUnsupportedCreateTableWithChangeDataFeed() {
        for (String columnName : DeltaLakeMetadata.CHANGE_DATA_FEED_COLUMN_NAMES) {
            String tableName = "test_unsupported_create_table_cdf" + TestingNames.randomNameSuffix();
            this.assertQueryFails("CREATE TABLE " + tableName + "(" + columnName + " int) WITH (change_data_feed_enabled = true)", "\\QUnable to use [%s] when change data feed is enabled\\E".formatted(columnName));
            Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
            this.assertQueryFails("CREATE TABLE " + tableName + " WITH (change_data_feed_enabled = true) AS SELECT 1 AS " + columnName, "\\QUnable to use [%s] when change data feed is enabled\\E".formatted(columnName));
            Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
        }
    }

    @Test
    public void testUnsupportedAddColumnWithChangeDataFeed() {
        for (String columnName : DeltaLakeMetadata.CHANGE_DATA_FEED_COLUMN_NAMES) {
            TestTable table = this.newTrinoTable("test_add_column", "(col int) WITH (change_data_feed_enabled = true)");
            try {
                this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN " + columnName + " int", "\\QColumn name %s is forbidden when change data feed is enabled\\E".formatted(columnName));
                this.assertTableColumnNames(table.getName(), new String[]{"col"});
                this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES change_data_feed_enabled = false");
                this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN " + columnName + " int");
                this.assertTableColumnNames(table.getName(), new String[]{"col", columnName});
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    @Test
    public void testUnsupportedRenameColumnWithChangeDataFeed() {
        for (String columnName : DeltaLakeMetadata.CHANGE_DATA_FEED_COLUMN_NAMES) {
            TestTable table = this.newTrinoTable("test_rename_column", "(col int) WITH (change_data_feed_enabled = true)");
            try {
                this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN col TO " + columnName, "Cannot rename column when change data feed is enabled");
                this.assertTableColumnNames(table.getName(), new String[]{"col"});
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    @Test
    public void testUnsupportedSetTablePropertyWithChangeDataFeed() {
        for (String columnName : DeltaLakeMetadata.CHANGE_DATA_FEED_COLUMN_NAMES) {
            TestTable table = this.newTrinoTable("test_set_properties", "(" + columnName + " int)");
            try {
                this.assertQueryFails("ALTER TABLE " + table.getName() + " SET PROPERTIES change_data_feed_enabled = true", "\\QUnable to enable change data feed because table contains [%s] columns\\E".formatted(columnName));
                Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).doesNotContain(new CharSequence[]{"change_data_feed_enabled = true"});
            }
            finally {
                if (table == null) continue;
                table.close();
            }
        }
    }

    @Test
    public void testThatEnableCdfTablePropertyIsShownForCtasTables() {
        String tableName = "test_show_create_show_property_for_table_created_with_ctas_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(page_url, views)WITH (change_data_feed_enabled = true) AS VALUES ('url1', 1), ('url2', 2)", 2L);
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"change_data_feed_enabled = true"});
    }

    @Test
    public void testCreateTableWithColumnMappingMode() {
        this.testCreateTableWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCreateTableWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCreateTableWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    public void testCreateTableWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        this.testCreateTableColumnMappingMode(mode, tableName -> {
            this.assertUpdate("CREATE TABLE " + tableName + "(a_int integer, a_row row(x integer)) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, row(11))", 1L);
        });
    }

    @Test
    public void testCreateTableAsSelectWithColumnMappingMode() {
        this.testCreateTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCreateTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCreateTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCreateTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        this.testCreateTableColumnMappingMode(mode, tableName -> this.assertUpdate("CREATE TABLE " + tableName + " WITH (column_mapping_mode='" + String.valueOf(mode) + "') AS SELECT 1 AS a_int, CAST(row(11) AS row(x integer)) AS a_row", 1L));
    }

    @Test
    public void testCreatePartitionTableAsSelectWithColumnMappingMode() {
        this.testCreatePartitionTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCreatePartitionTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCreatePartitionTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCreatePartitionTableAsSelectWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        this.testCreateTableColumnMappingMode(mode, tableName -> this.assertUpdate("CREATE TABLE " + tableName + " WITH (column_mapping_mode='" + String.valueOf(mode) + "', partitioned_by=ARRAY['a_int']) AS SELECT 1 AS a_int, CAST(row(11) AS row(x integer)) AS a_row", 1L));
    }

    private void testCreateTableColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode, Consumer<String> createTable) {
        String tableName = "test_create_table_column_mapping_" + TestingNames.randomNameSuffix();
        createTable.accept(tableName);
        String showCreateTableResult = (String)this.computeScalar("SHOW CREATE TABLE " + tableName);
        if (mode != DeltaLakeSchemaSupport.ColumnMappingMode.NONE) {
            Assertions.assertThat((String)showCreateTableResult).contains(new CharSequence[]{"column_mapping_mode = '" + String.valueOf(mode) + "'"});
        } else {
            Assertions.assertThat((String)showCreateTableResult).doesNotContain(new CharSequence[]{"column_mapping_mode"});
        }
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES (1, CAST(row(11) AS row(x integer)))");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testCreateTableWithColumnMappingModeAndTimestampNtz() {
        try (TestTable table = this.newTrinoTable("test_column_mapping", "(x int) WITH (column_mapping_mode = 'NAME')");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$properties\""))).skippingTypesCheck().matches("VALUES ('delta.enableDeletionVectors', 'false'),('delta.columnMapping.mode', 'name'),('delta.columnMapping.maxColumnId', '1'),('delta.minReaderVersion', '2'),('delta.minWriterVersion', '5')");
        }
        table = this.newTrinoTable("test_column_mapping", "(x timestamp) WITH (column_mapping_mode = 'NAME')");
        try {
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + table.getName() + "$properties\""))).skippingTypesCheck().matches("VALUES ('delta.enableDeletionVectors', 'false'),('delta.columnMapping.mode', 'name'),('delta.columnMapping.maxColumnId', '1'),('delta.minReaderVersion', '3'),('delta.minWriterVersion', '7'),('delta.feature.columnMapping', 'supported'),('delta.feature.timestampNtz', 'supported')");
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }

    @Test
    public void testDropAndAddColumnShowStatsForColumnMappingMode() {
        this.testDropAndAddColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testDropAndAddColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    private void testDropAndAddColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_drop_add_column_show_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT, b_number INT) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 10), (2, 20), (null, null)", 3L);
        this.assertUpdate("ANALYZE " + tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('b_number', null, 2.0, 0.33333333333, null, 10, 20),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN b_number");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN b_number INT");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches("VALUES\n    (1, CAST(null AS INT)),\n    (2, CAST(null AS INT)),\n    (null, CAST(null AS INT))\n");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('b_number', null, null, null, null, null, null),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('b_number', 0.0, 0.0, 1.0, null, null, null),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testRenameColumnShowStatsForColumnMappingMode() {
        this.testRenameColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testRenameColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    private void testRenameColumnShowStatsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_rename_column_show_stats_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT, b_number INT) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 10), (2, 20), (null, null)", 3L);
        this.assertUpdate("ANALYZE " + tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('b_number', null, 2.0, 0.33333333333, null, 10, 20),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("ALTER TABLE " + tableName + " RENAME COLUMN b_number TO new_b");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('new_b', null, 2.0, 0.33333333333, null, 10, 20),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("ANALYZE " + tableName);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 2.0, 0.33333333333, null, 1, 2),('new_b', null, 2.0, 0.33333333333, null, 10, 20),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCommentOnTableForColumnMappingMode() {
        this.testCommentOnTableForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCommentOnTableForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCommentOnTableForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCommentOnTableForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_comment_on_table_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT, b_number INT) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("COMMENT ON TABLE " + tableName + " IS 'test comment' ");
        Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("test comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCommentOnColumnForColumnMappingMode() {
        this.testCommentOnColumnForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCommentOnColumnForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCommentOnColumnForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCommentOnColumnForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_comment_on_column_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT, b_number INT) WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".a_number IS 'test column comment'");
        Assertions.assertThat((String)this.getColumnComment(tableName, "a_number")).isEqualTo("test column comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableWithCommentsForColumnMappingMode() {
        this.testCreateTableWithCommentsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCreateTableWithCommentsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCreateTableWithCommentsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCreateTableWithCommentsForColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_create_table_with_comments_for_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT COMMENT 'test column comment', b_number INT)  COMMENT 'test table comment' WITH (column_mapping_mode='" + String.valueOf(mode) + "')");
        Assertions.assertThat((String)this.getTableComment(tableName)).isEqualTo("test table comment");
        Assertions.assertThat((String)this.getColumnComment(tableName, "a_number")).isEqualTo("test column comment");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testPartitionPredicateOnCheckpointWithColumnMappingMode() {
        this.testPartitionPredicateOnCheckpointWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testPartitionPredicateOnCheckpointWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testPartitionPredicateOnCheckpointWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testPartitionPredicateOnCheckpointWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        try (TestTable table = this.newTrinoTable("test_partition_checkpoint_with_column_mapping_mode", "(x int, part int) WITH (column_mapping_mode='" + String.valueOf(mode) + "', checkpoint_interval = 3, partitioned_by = ARRAY['part'])");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 10)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 20)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 30)", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " WHERE part = 10"))).matches("VALUES (1, 10)");
        }
    }

    @Test
    public void testSpecialCharacterColumnNamesWithColumnMappingMode() {
        this.testSpecialCharacterColumnNamesWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testSpecialCharacterColumnNamesWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testSpecialCharacterColumnNamesWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testSpecialCharacterColumnNamesWithColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_special_characters_column_namnes_with_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (\";{}()\\n\\t=\" INT) WITH (column_mapping_mode='" + String.valueOf(mode) + "', checkpoint_interval=3)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (0)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (null)", 1L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES(';{}()\\n\\t=', null, 2.0, 0.33333333333, null, 0, 1),(null, null, null, null, 3.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeltaColumnMappingModeAllDataTypes() {
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.ID, false);
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.ID, true);
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.NAME, false);
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.NAME, true);
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.NONE, false);
        this.testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode.NONE, true);
    }

    private void testDeltaColumnMappingModeAllDataTypes(DeltaLakeSchemaSupport.ColumnMappingMode mode, boolean partitioned) {
        String tableName = "test_column_mapping_mode_name_all_types_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (    a_boolean BOOLEAN,    a_tinyint TINYINT,    a_smallint SMALLINT,    a_int INT,    a_bigint BIGINT,    a_decimal_5_2 DECIMAL(5,2),    a_decimal_21_3 DECIMAL(21,3),    a_double DOUBLE,    a_float REAL,    a_string VARCHAR,    a_date DATE,    a_timestamp TIMESTAMP(3) WITH TIME ZONE,    a_binary VARBINARY,    a_string_array ARRAY(VARCHAR),    a_struct_array ARRAY(ROW(a_string VARCHAR)),    a_map MAP(VARCHAR, VARCHAR),    a_complex_map MAP(VARCHAR, ROW(a_string VARCHAR)),    a_struct ROW(a_string VARCHAR, a_int INT),    a_complex_struct ROW(nested_struct ROW(a_string VARCHAR), a_int INT)" + (partitioned ? ", part VARCHAR" : "") + ")WITH (" + (partitioned ? " partitioned_by = ARRAY['part']," : "") + "column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (   true,    1,    10,   100,    1000,    CAST('123.12' AS DECIMAL(5,2)),    CAST('123456789012345678.123' AS DECIMAL(21,3)),    DOUBLE '0',    REAL '0',    'a',    DATE '2020-08-21',    TIMESTAMP '2020-10-21 01:00:00.123 UTC',    X'abcd',    ARRAY['element 1'],    ARRAY[ROW('nested 1')],    MAP(ARRAY['key'], ARRAY['value1']),    MAP(ARRAY['key'], ARRAY[ROW('nested value1')]),    ROW('item 1', 1),    ROW(ROW('nested item 1'), 11) " + (partitioned ? ", 'part1'" : "") + "), (   true,    2,    20,   200,    2000,    CAST('223.12' AS DECIMAL(5,2)),    CAST('223456789012345678.123' AS DECIMAL(21,3)),    DOUBLE '0',    REAL '0',    'b',    DATE '2020-08-22',    TIMESTAMP '2020-10-22 02:00:00.456 UTC',    X'abcd',    ARRAY['element 2'],    ARRAY[ROW('nested 2')],    MAP(ARRAY['key'], ARRAY[null]),    MAP(ARRAY['key'], ARRAY[null]),    ROW('item 2', 2),    ROW(ROW('nested item 2'), 22) " + (partitioned ? ", 'part2'" : "") + ")", 2L);
        String selectTrinoValues = "SELECT a_boolean, a_tinyint, a_smallint, a_int, a_bigint, a_decimal_5_2, a_decimal_21_3, a_double , a_float, a_string, a_date, a_binary, a_string_array[1], a_struct_array[1].a_string, a_map['key'], a_complex_map['key'].a_string, a_struct.a_string, a_struct.a_int, a_complex_struct.nested_struct.a_string, a_complex_struct.a_int FROM " + tableName;
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectTrinoValues))).skippingTypesCheck().matches("VALUES(true, tinyint '1', smallint '10', integer '100', bigint '1000', decimal '123.12', decimal '123456789012345678.123', double '0', real '0', 'a', date '2020-08-21', X'abcd', 'element 1', 'nested 1', 'value1', 'nested value1', 'item 1', 1, 'nested item 1', 11),(true, tinyint '2', smallint '20', integer '200', bigint '2000', decimal '223.12', decimal '223456789012345678.123', double '0.0', real '0.0', 'b', date '2020-08-22', X'abcd', 'element 2', 'nested 2', null, null, 'item 2', 2, 'nested item 2', 22)");
        this.assertQuery("SELECT format('%1$tF %1$tT.%1$tL', a_timestamp) FROM " + tableName, "VALUES '2020-10-21 01:00:00.123', '2020-10-22 02:00:00.456'");
        this.assertUpdate("UPDATE " + tableName + " SET a_boolean = false where a_tinyint = 1", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectTrinoValues))).skippingTypesCheck().matches("VALUES(false, tinyint '1', smallint '10', integer '100', bigint '1000', decimal '123.12', decimal '123456789012345678.123', double '0', real '0', 'a', date '2020-08-21', X'abcd', 'element 1', 'nested 1', 'value1', 'nested value1', 'item 1', 1, 'nested item 1', 11),(true, tinyint '2', smallint '20', integer '200', bigint '2000', decimal '223.12', decimal '223456789012345678.123', double '0.0', real '0.0', 'b', date '2020-08-22', X'abcd', 'element 2', 'nested 2', null, null, 'item 2', 2, 'nested item 2', 22)");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_tinyint = 2", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(selectTrinoValues))).skippingTypesCheck().matches("VALUES(false, tinyint '1', smallint '10', integer '100', bigint '1000', decimal '123.12', decimal '123456789012345678.123', double '0', real '0', 'a', date '2020-08-21', X'abcd', 'element 1', 'nested 1', 'value1', 'nested value1', 'item 1', 1, 'nested item 1', 11)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testOptimizeProcedureColumnMappingMode() {
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID, false);
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.ID, true);
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME, false);
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NAME, true);
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE, false);
        this.testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode.NONE, true);
    }

    private void testOptimizeProcedureColumnMappingMode(DeltaLakeSchemaSupport.ColumnMappingMode mode, boolean partitioned) {
        String tableName = "test_optimize_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(a_number INT, a_struct ROW(x INT), a_string VARCHAR) WITH (" + (partitioned ? "partitioned_by=ARRAY['a_string']," : "") + "location='s3://" + this.bucketName + "/databricks-compatibility-test-" + tableName + "',column_mapping_mode='" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, row(11), 'a')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (2, row(22), 'b')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, row(33), 'c')", 1L);
        Double stringColumnSize = partitioned ? null : Double.valueOf(3.0);
        String expectedStats = "VALUES('a_number', null, 3.0, 0.0, null, '1', '3'),('a_struct', null, null, null, null, null, null),('a_string', " + stringColumnSize + ", 3.0, 0.0, null, null, null),(null, null, null, null, 3.0, null, null)";
        this.assertQuery("SHOW STATS FOR " + tableName, expectedStats);
        this.assertUpdate("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertQuery("SHOW STATS FOR " + tableName, expectedStats);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (4, row(44), 'd')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (5, row(55), 'e')", 1L);
        this.assertQuery("SELECT a_number, a_struct.x, a_string FROM " + tableName, "VALUES(1, 11, 'a'),(2, 22, 'b'),(3, 33, 'c'),(4, 44, 'd'),(5, 55, 'e')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSupportedNonPartitionedColumnMappingIdWrites() throws Exception {
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_id", true);
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_id", false);
    }

    @Test
    public void testSupportedNonPartitionedColumnMappingNameWrites() throws Exception {
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_name", true);
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_name", false);
    }

    @Test
    public void testSupportedNonPartitionedColumnMappingNoneWrites() throws Exception {
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_none", true);
        this.testSupportedNonPartitionedColumnMappingWrites("write_stats_as_json_column_mapping_none", false);
    }

    @Test
    public void testCreateOrReplaceTableOnNonExistingTable() {
        String tableName = "create_or_replace_table" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE OR REPLACE TABLE " + tableName + " (id BIGINT)");
            this.assertLatestTableOperation(tableName, "CREATE OR REPLACE TABLE");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testCreateOrReplaceTableAsSelectOnNonExistingTable() {
        String tableName = "create_or_replace_table_as_select_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE OR REPLACE TABLE " + tableName + " AS SELECT 1 as colA", 1L);
            this.assertLatestTableOperation(tableName, "CREATE OR REPLACE TABLE AS SELECT");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testCreateOrReplaceTableAsSelectWithSwappedColumns() {
        this.testCreateOrReplaceTableAsSelectWithSwappedColumns(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCreateOrReplaceTableAsSelectWithSwappedColumns(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCreateOrReplaceTableAsSelectWithSwappedColumns(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCreateOrReplaceTableAsSelectWithSwappedColumns(DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode) {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_column", "AS SELECT 'abc' colA, BIGINT '1' colB");){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT colA, colB FROM " + table.getName()))).matches("VALUES (CAST('abc' AS VARCHAR), BIGINT '1')");
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (column_mapping_mode='" + columnMappingMode.name() + "') AS SELECT BIGINT '42' colA, 'def' colB", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT colA, colB FROM " + table.getName()))).matches("VALUES (BIGINT '42', CAST('def' AS VARCHAR))");
            this.assertLatestTableOperation(table.getName(), "CREATE OR REPLACE TABLE AS SELECT");
        }
    }

    @Test
    public void testCreateOrReplaceTableChangeUnpartitionedTableIntoPartitioned() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " AS SELECT BIGINT '22' a, CAST('some data' AS VARCHAR) b");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (partitioned_by=ARRAY['a']) AS SELECT BIGINT '42' a, 'some data' b UNION ALL SELECT BIGINT '43' a, 'another data' b", 2L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (BIGINT '42', CAST('some data' AS VARCHAR)), (BIGINT '43', CAST('another data' AS VARCHAR))");
            this.assertLatestTableOperation(table.getName(), "CREATE OR REPLACE TABLE AS SELECT");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"partitioned_by = ARRAY['a']"});
        }
    }

    @Test
    public void testCreateOrReplaceTableChangePartitionedTableIntoUnpartitioned() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", "  WITH (partitioned_by=ARRAY['a']) AS SELECT BIGINT '42' a, 'some data' b UNION ALL SELECT BIGINT '43' a, 'another data' b");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT BIGINT '42' a, 'some data' b UNION ALL SELECT BIGINT '43' a, 'another data' b", 2L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (BIGINT '42', CAST('some data' AS VARCHAR)), (BIGINT '43', CAST('another data' AS VARCHAR))");
            this.assertLatestTableOperation(table.getName(), "CREATE OR REPLACE TABLE AS SELECT");
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).matches((CharSequence)("CREATE TABLE delta.test_schema.%s \\(\n".formatted(table.getName()) + "   a bigint,\n   b varchar\n\\)\nWITH \\(\n   location = '.*'\n\\)"));
        }
    }

    @Test
    public void testCreateOrReplaceTableTableCommentIsRemoved() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_", " (a BIGINT) COMMENT 'This is a table'");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (a BIGINT COMMENT 'This is a column')");
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
            Assertions.assertThat((String)this.getColumnComment(table.getName(), "a")).isEqualTo("This is a column");
            Assertions.assertThat((String)this.getTableComment(table.getName())).isNull();
            this.assertLatestTableOperation(table.getName(), "CREATE OR REPLACE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithEnablingCdcProperty() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_cdc", " (a BIGINT)");){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (c BIGINT) WITH (change_data_feed_enabled = true)", "CREATE OR REPLACE is not supported for tables with change data feed enabled");
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithEnablingCdcProperty() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_cdc", " (a BIGINT)");){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " WITH (change_data_feed_enabled = true) AS SELECT 1 new_column", "CREATE OR REPLACE is not supported for tables with change data feed enabled");
        }
    }

    @Test
    public void testCreateOrReplaceOnCdcEnabledTables() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_cdc", " (a BIGINT) WITH (change_data_feed_enabled = true)");){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (d BIGINT)", "CREATE OR REPLACE is not supported for tables with change data feed enabled");
        }
    }

    @Test
    public void testCreateOrReplaceTableAsOnCdcEnabledTables() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_cdc", " (a BIGINT) WITH (change_data_feed_enabled = true)");){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT 1 new_column", "CREATE OR REPLACE is not supported for tables with change data feed enabled");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithSameLocationForManagedTable() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_same_location_", " (a BIGINT)");){
            String location = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getStorage().getLocation();
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (d BIGINT) WITH (location = '" + location + "')");
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (d BIGINT) WITH (location = '" + location + "/')");
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithSameLocationForManagedTable() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_with_same_location_", " (a BIGINT)");){
            String location = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getStorage().getLocation();
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '" + location + "') AS SELECT 'abc' as colA", 1L);
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '" + location + "/') AS SELECT 'abc' as colA", 1L);
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableWithChangeInLocationForManagedTable() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_change_location_", " (a BIGINT) ");){
            String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (a BIGINT) WITH (location = '%s')".formatted(location), "The provided location '%s' does not match the existing table location '.*'".formatted(location));
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (a BIGINT) WITH (location = '%s/')".formatted(location), "The provided location '%s/' does not match the existing table location '.*'".formatted(location));
            this.assertLatestTableOperation(table.getName(), "CREATE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceAsTableWithChangeInLocationForManagedTable() {
        try (TestTable table = this.newTrinoTable("test_create_or_replace_change_location_", " (a BIGINT) ");){
            String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '%s') AS SELECT 'a' colA".formatted(location), "The provided location '%s' does not match the existing table location '.*'".formatted(location));
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '%s/')  AS SELECT 'a' colA".formatted(location), "The provided location '%s/' does not match the existing table location '.*'".formatted(location));
            this.assertLatestTableOperation(table.getName(), "CREATE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithChangeInLocationForExternalTable() {
        String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
        try (TestTable table = this.newTrinoTable("test_create_or_replace_change_location_", " (a BIGINT) WITH (location = '%s')".formatted(location));){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " (a BIGINT) WITH (location = '%s_2')".formatted(location), "The provided location '%1$s_2' does not match the existing table location '%1$s'".formatted(location));
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"location = '%s'".formatted(location)});
            this.assertLatestTableOperation(table.getName(), "CREATE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithChangeInLocationForExternalTable() {
        String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
        try (TestTable table = this.newTrinoTable("test_create_or_replace_change_location_", " (a BIGINT) WITH (location = '%s')".formatted(location));){
            this.assertQueryFails("CREATE OR REPLACE TABLE " + table.getName() + " WITH (location = '%s_2') AS SELECT 'a' colA".formatted(location), "The provided location '%1$s_2' does not match the existing table location '%1$s'".formatted(location));
            Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + table.getName()))).contains(new CharSequence[]{"location = '%s'".formatted(location)});
            this.assertLatestTableOperation(table.getName(), "CREATE TABLE");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithNoLocationSpecifiedForExternalTable() {
        String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
        try (TestTable table = this.newTrinoTable("create_or_replace_with_no_location_", " (a BIGINT) WITH (location = '%s')".formatted(location));){
            this.assertTableType(SCHEMA, table.getName(), TableType.EXTERNAL_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (colA VARCHAR)");
            this.assertTableType(SCHEMA, table.getName(), TableType.EXTERNAL_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithNoLocationSpecifiedForExternalTable() {
        String location = "s3://%s/%s".formatted(this.bucketName, TestingNames.randomNameSuffix());
        try (TestTable table = this.newTrinoTable("create_or_replace_with_no_location_", " (a BIGINT) WITH (location = '%s')".formatted(location));){
            this.assertTableType(SCHEMA, table.getName(), TableType.EXTERNAL_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT 'abc' as colA", 1L);
            this.assertTableType(SCHEMA, table.getName(), TableType.EXTERNAL_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableWithNoLocationSpecifiedForManagedTable() {
        try (TestTable table = this.newTrinoTable("create_or_replace_with_no_location_", " (a BIGINT)");){
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (colA VARCHAR)");
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithNoLocationSpecifiedForManagedTable() {
        try (TestTable table = this.newTrinoTable("create_or_replace_with_no_location_", " (a BIGINT)");){
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT 'abc' as colA", 1L);
            this.assertTableType(SCHEMA, table.getName(), TableType.MANAGED_TABLE.name());
        }
    }

    @Test
    public void testCreateOrReplaceTableWithStatsUpdated() {
        try (TestTable table = this.newTrinoTable("create_or_replace_for_stats_", " AS SELECT 1 as colA");){
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES('cola', null, 1.0, 0.0, null, '1', '1'),(null, null, null, null, 1.0, null, null)");
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " (colA BIGINT) ");
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES('cola', 0.0, 0.0, 1.0, null, null, null),(null, null, null, null, 0.0, null, null)");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES null", 1L);
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES('cola', 0.0, 0.0, 1.0, null, null, null),(null, null, null, null, 1.0, null, null)");
        }
    }

    @Test
    public void testCreateOrReplaceTableAsWithStatsUpdated() {
        try (TestTable table = this.newTrinoTable("create_or_replace_for_stats_", " AS SELECT 1 as colA");){
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES('cola', null, 1.0, 0.0, null, '1', '1'),(null, null, null, null, 1.0, null, null)");
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " AS SELECT 25 colb ", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (null)", 1L);
            this.assertQuery("SHOW STATS FOR " + table.getName(), "VALUES('colb', null, 1.0, 0.5, null, '25', '25'),(null, null, null, null, 2.0, null, null)");
        }
    }

    @Test
    public void testCreateOrReplaceTableWithChangeInColumnMappingToId() {
        this.testTableOperationWithChangeInColumnMappingMode("id");
    }

    @Test
    public void testCreateOrReplaceTableWithChangeInColumnMappingToName() {
        this.testTableOperationWithChangeInColumnMappingMode("name");
    }

    public void testTableOperationWithChangeInColumnMappingMode(String columnMappingMode) {
        try (TestTable table = this.newTrinoTable("create_or_replace_with_change_column_mapping_", " AS SELECT 1 as colA, 'B' as colB");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " DROP COLUMN colA", "Cannot drop column from table using column mapping mode NONE");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " RENAME COLUMN colA TO renamed_column", "Cannot rename column in table using column mapping mode NONE");
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " WITH (column_mapping_mode = '" + columnMappingMode + "') AS SELECT 25 colc, 'D' cold ", 1L);
            this.assertQuery("SELECT colc FROM " + table.getName(), "VALUES 25");
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN colc");
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN cold TO colc");
            this.assertQuery("SELECT colc FROM " + table.getName(), "VALUES 'D'");
        }
    }

    private void assertLatestTableOperation(String tableName, String operation) {
        this.assertQuery("SELECT operation FROM \"%s$history\" ORDER BY version DESC LIMIT 1".formatted(tableName), "VALUES '%s'".formatted(operation));
    }

    private void assertTableType(String schemaName, String tableName, String tableType) {
        Assertions.assertThat((String)((Table)this.metastore.getTable(schemaName, tableName).orElseThrow()).getTableType()).isEqualTo(tableType);
    }

    private void testSupportedNonPartitionedColumnMappingWrites(String resourceName, boolean statsAsJsonEnabled) throws Exception {
        String tableName = "test_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String entry = Resources.toString((URL)Resources.getResource((String)"deltalake/%s/_delta_log/00000000000000000000.json".formatted(resourceName)), (Charset)StandardCharsets.UTF_8).replace("%WRITE_STATS_AS_JSON%", Boolean.toString(statsAsJsonEnabled)).replace("%WRITE_STATS_AS_STRUCT%", Boolean.toString(!statsAsJsonEnabled));
        String targetPath = "%s/%s/_delta_log/00000000000000000000.json".formatted(SCHEMA, tableName);
        this.minioClient.putObject(this.bucketName, entry.getBytes(StandardCharsets.UTF_8), targetPath);
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation));
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),(2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),(3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),(4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", 4L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES(1, 'first value', 'nested 1', 'databricks 1'),(2, 'two', 'nested 2', 'databricks 2'),(3, 'third value', 'nested 3', 'databricks 3'),(4, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 4.0, 0.0, null, '1', '4'),('a_string', 29.0, 4.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 4.0, null, null)");
        this.assertUpdate("UPDATE " + tableName + " SET a_number = a_number + 10 WHERE a_number in (3, 4)", 2L);
        this.assertUpdate("UPDATE " + tableName + " SET a_number = a_number + 20 WHERE a_number in (1, 2)", 2L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES(21, 'first value', 'nested 1', 'databricks 1'),(22, 'two', 'nested 2', 'databricks 2'),(13, 'third value', 'nested 3', 'databricks 3'),(14, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 4.0, 0.0, null, '13', '22'),('a_string', 29.0, 4.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 4.0, null, null)");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 22", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 13", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 21", 1L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES (14, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 1.0, 0.0, null, '14', '14'),('a_string', 29.0, 1.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 1.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSupportedPartitionedColumnMappingIdWrites() throws Exception {
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_id", true);
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_id", false);
    }

    @Test
    public void testSupportedPartitionedColumnMappingNameWrites() throws Exception {
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_name", true);
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_name", false);
    }

    @Test
    public void testSupportedPartitionedColumnMappingNoneWrites() throws Exception {
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_none", true);
        this.testSupportedPartitionedColumnMappingWrites("write_stats_as_json_partition_column_mapping_none", false);
    }

    private void testSupportedPartitionedColumnMappingWrites(String resourceName, boolean statsAsJsonEnabled) throws Exception {
        String tableName = "test_column_mapping_mode_" + TestingNames.randomNameSuffix();
        String entry = Resources.toString((URL)Resources.getResource((String)"deltalake/%s/_delta_log/00000000000000000000.json".formatted(resourceName)), (Charset)StandardCharsets.UTF_8).replace("%WRITE_STATS_AS_JSON%", Boolean.toString(statsAsJsonEnabled)).replace("%WRITE_STATS_AS_STRUCT%", Boolean.toString(!statsAsJsonEnabled));
        String targetPath = "%s/%s/_delta_log/00000000000000000000.json".formatted(SCHEMA, tableName);
        this.minioClient.putObject(this.bucketName, entry.getBytes(StandardCharsets.UTF_8), targetPath);
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation));
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(1, 'first value', ARRAY[ROW('nested 1')], ROW('databricks 1')),(2, 'two', ARRAY[ROW('nested 2')], ROW('databricks 2')),(3, 'third value', ARRAY[ROW('nested 3')], ROW('databricks 3')),(4, 'four', ARRAY[ROW('nested 4')], ROW('databricks 4'))", 4L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES(1, 'first value', 'nested 1', 'databricks 1'),(2, 'two', 'nested 2', 'databricks 2'),(3, 'third value', 'nested 3', 'databricks 3'),(4, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 4.0, 0.0, null, '1', '4'),('a_string', null, 4.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 4.0, null, null)");
        this.assertUpdate("UPDATE " + tableName + " SET a_number = a_number + 10 WHERE a_number in (3, 4)", 2L);
        this.assertUpdate("UPDATE " + tableName + " SET a_number = a_number + 20 WHERE a_number in (1, 2)", 2L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES(21, 'first value', 'nested 1', 'databricks 1'),(22, 'two', 'nested 2', 'databricks 2'),(13, 'third value', 'nested 3', 'databricks 3'),(14, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 4.0, 0.0, null, '13', '22'),('a_string', null, 4.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 4.0, null, null)");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 22", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 13", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a_number = 21", 1L);
        this.assertQuery("SELECT a_number, a_string, array_col[1].array_struct_element, nested.field1 FROM " + tableName, "VALUES (14, 'four', 'nested 4', 'databricks 4')");
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES('a_number', null, 1.0, 0.0, null, '14', '14'),('a_string', null, 1.0, 0.0, null, null, null),('array_col', null, null, null, null, null, null),('nested', null, null, null, null, null, null),(null, null, null, null, 1.0, null, null)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeltaColumnMappingModeAllPartitionTypesCheckpointing() {
        this.testDeltaColumnMappingModeAllPartitionTypesCheckpointing(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
        this.testDeltaColumnMappingModeAllPartitionTypesCheckpointing(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testDeltaColumnMappingModeAllPartitionTypesCheckpointing(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    private void testDeltaColumnMappingModeAllPartitionTypesCheckpointing(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_column_mapping_mode_name_all_types_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (\n    data INT,\n    part_boolean BOOLEAN,\n    part_tinyint TINYINT,\n    part_smallint SMALLINT,\n    part_int INT,\n    part_bigint BIGINT,\n    part_decimal_5_2 DECIMAL(5,2),\n    part_decimal_21_3 DECIMAL(21,3),\n    part_double DOUBLE,\n    part_float REAL,\n    part_varchar VARCHAR,\n    part_date DATE,\n    part_timestamp TIMESTAMP(3) WITH TIME ZONE\n)\nWITH (\n    partitioned_by = ARRAY['part_boolean', 'part_tinyint', 'part_smallint', 'part_int', 'part_bigint', 'part_decimal_5_2', 'part_decimal_21_3', 'part_double', 'part_float', 'part_varchar', 'part_date', 'part_timestamp'],\n    column_mapping_mode = '%s',\n    checkpoint_interval = 3\n)".formatted(tableName, mode));
        this.assertUpdate("INSERT INTO %s\n    VALUES (\n   1,\n   true,\n   1,\n   10,\n   100,\n   1000,\n   CAST('123.12' AS DECIMAL(5,2)),\n   CAST('123456789012345678.123' AS DECIMAL(21,3)),\n   DOUBLE '0',\n   REAL '0',\n   'a',\n   DATE '2020-08-21',\n   TIMESTAMP '2020-10-21 01:00:00.123 UTC')".formatted(tableName), 1L);
        this.assertUpdate("INSERT INTO %s\n    VALUES (\n        2,\n        true,\n        2,\n        20,\n        200,\n        2000,\n        CAST('223.12' AS DECIMAL(5,2)),\n        CAST('223456789012345678.123' AS DECIMAL(21,3)),\n        DOUBLE '0',\n        REAL '0',\n        'b',\n        DATE '2020-08-22',\n        TIMESTAMP '2020-10-22 02:00:00.456 UTC')".formatted(tableName), 1L);
        this.assertUpdate("INSERT INTO %s\n    VALUES (\n        3,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL,\n        NULL)".formatted(tableName), 1L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT data, part_boolean, part_tinyint, part_smallint, part_int, part_bigint, part_decimal_5_2, part_decimal_21_3, part_double , part_float, part_varchar, part_date, part_timestamp\nFROM %s".formatted(tableName)))).skippingTypesCheck().matches("VALUES\n    (1, true, tinyint '1', smallint '10', integer '100', bigint '1000', decimal '123.12', decimal '123456789012345678.123', double '0', real '0', 'a', date '2020-08-21', TIMESTAMP '2020-10-21 01:00:00.123 UTC'),\n    (2, true, tinyint '2', smallint '20', integer '200', bigint '2000', decimal '223.12', decimal '223456789012345678.123', double '0.0', real '0.0', 'b', date '2020-08-22', TIMESTAMP '2020-10-22 02:00:00.456 UTC'),\n    (3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)\n");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableUnsupportedColumnMappingMode() {
        String tableName = "test_unsupported_column_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(a integer) WITH (column_mapping_mode = 'illegal')", ".* \\QInvalid value [illegal]. Valid values: [ID, NAME, NONE]");
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (column_mapping_mode = 'illegal') AS SELECT 1 a", ".* \\QInvalid value [illegal]. Valid values: [ID, NAME, NONE]");
        this.assertQueryFails("CREATE TABLE " + tableName + "(a integer) WITH (column_mapping_mode = 'unknown')", ".* \\QInvalid value [unknown]. Valid values: [ID, NAME, NONE]");
        this.assertQueryFails("CREATE TABLE " + tableName + " WITH (column_mapping_mode = 'unknown') AS SELECT 1 a", ".* \\QInvalid value [unknown]. Valid values: [ID, NAME, NONE]");
        Assertions.assertThat((boolean)this.getQueryRunner().tableExists(this.getSession(), tableName)).isFalse();
    }

    @Test
    public void testAlterTableWithUnsupportedProperties() {
        String tableName = "test_alter_table_with_unsupported_properties_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (a_number INT)");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = true, checkpoint_interval = 10", "The following properties cannot be updated: checkpoint_interval");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES partitioned_by = ARRAY['a']", "The following properties cannot be updated: partitioned_by");
        this.assertQueryFails("ALTER TABLE " + tableName + " SET PROPERTIES column_mapping_mode = 'ID'", "The following properties cannot be updated: column_mapping_mode");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSettingChangeDataFeedEnabledProperty() {
        String tableName = "test_enable_and_disable_cdf_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER)");
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = false");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"change_data_feed_enabled = false"});
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = true");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"change_data_feed_enabled = true"});
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = false");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"change_data_feed_enabled = false"});
        this.assertUpdate("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = true");
        Assertions.assertThat((String)((String)this.computeScalar("SHOW CREATE TABLE " + tableName))).contains(new CharSequence[]{"change_data_feed_enabled = true"});
    }

    @Test
    public void testCreateTableWithExistingLocation() {
        String tableName = "test_legacy_create_table_" + TestingNames.randomNameSuffix();
        this.assertQuerySucceeds("CREATE TABLE " + tableName + " AS SELECT 1 as a, 'INDIA' as b, true as c");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'INDIA', true)");
        String tableLocation = (String)this.computeScalar("SELECT DISTINCT regexp_replace(\"$path\", '/[^/]*$', '') FROM " + tableName);
        this.assertUpdate("CALL system.unregister_table(CURRENT_SCHEMA, '" + tableName + "')");
        this.assertQueryFails(String.format("CREATE TABLE %s (dummy int) with (location = '%s')", tableName, tableLocation), ".*Using CREATE \\[OR REPLACE] TABLE with an existing table content is disallowed.*");
    }

    @Test
    public void testProjectionPushdownOnPartitionedTables() {
        String tableNamePartitionAtBeginning = "test_table_with_partition_at_beginning_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableNamePartitionAtBeginning + " (id BIGINT, root ROW(f1 BIGINT, f2 BIGINT)) WITH (partitioned_by = ARRAY['id'])");
        this.assertUpdate("INSERT INTO " + tableNamePartitionAtBeginning + " VALUES (1, ROW(1, 2)), (1, ROW(2, 3)), (1, ROW(3, 4))", 3L);
        this.assertQuery("SELECT root.f1, id, root.f2 FROM " + tableNamePartitionAtBeginning, "VALUES (1, 1, 2), (2, 1, 3), (3, 1, 4)");
        this.assertUpdate("DROP TABLE " + tableNamePartitionAtBeginning);
        String tableNamePartitioningAtEnd = "tes_table_with_partition_at_end_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableNamePartitioningAtEnd + " (root ROW(f1 BIGINT, f2 BIGINT), id BIGINT) WITH (partitioned_by = ARRAY['id'])");
        this.assertUpdate("INSERT INTO " + tableNamePartitioningAtEnd + " VALUES (ROW(1, 2), 1), (ROW(2, 3), 1), (ROW(3, 4), 1)", 3L);
        this.assertQuery("SELECT root.f2, id, root.f1 FROM " + tableNamePartitioningAtEnd, "VALUES (2, 1, 1), (3, 1, 2), (4, 1, 3)");
        this.assertUpdate("DROP TABLE " + tableNamePartitioningAtEnd);
    }

    @Test
    public void testProjectionPushdownColumnReorderInSchemaAndDataFile() {
        try (TestTable testTable = this.newTrinoTable("test_projection_pushdown_column_reorder_", "(id BIGINT, nested1 ROW(a BIGINT, b VARCHAR, c INT), nested2 ROW(d DOUBLE, e BOOLEAN, f DATE))");){
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (100, ROW(10, 'a', 100), ROW(10.10, true, DATE '2023-04-19'))", 1L);
            String tableDataFile = ((String)this.computeScalar("SELECT \"$path\" FROM " + testTable.getName())).replaceFirst("s3://" + this.bucketName, "");
            try (TestTable temporaryTable = this.newTrinoTable("test_projection_pushdown_column_reorder_temporary_", "(nested2 ROW(d DOUBLE, e BOOLEAN, f DATE), id BIGINT, nested1 ROW(a BIGINT, b VARCHAR, c INT))");){
                this.assertUpdate("INSERT INTO " + temporaryTable.getName() + " VALUES (ROW(10.10, true, DATE '2023-04-19'), 100, ROW(10, 'a', 100))", 1L);
                String temporaryDataFile = ((String)this.computeScalar("SELECT \"$path\" FROM " + temporaryTable.getName())).replaceFirst("s3://" + this.bucketName, "");
                this.minioClient.copyObject(this.bucketName, temporaryDataFile, this.bucketName, tableDataFile);
            }
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT nested2.e, nested1.a, nested2.f, nested1.b, id FROM " + testTable.getName()))).isFullyPushedDown();
        }
    }

    @Test
    public void testProjectionPushdownExplain() {
        String tableName = "test_projection_pushdown_explain_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id BIGINT, root ROW(f1 BIGINT, f2 BIGINT)) WITH (partitioned_by = ARRAY['id'])");
        this.assertExplain("EXPLAIN SELECT root.f2 FROM " + tableName, new String[]{"TableScan\\[table = (.*)]", "(.*) := (.*):bigint:REGULAR"});
        Session sessionWithoutPushdown = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "projection_pushdown_enabled", "false").build();
        this.assertExplain(sessionWithoutPushdown, "EXPLAIN SELECT root.f2 FROM " + tableName, new String[]{"ScanProject\\[table = (.*)]", "expr := root.1", "root := root:row\\(f1 bigint, f2 bigint\\):REGULAR"});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testProjectionPushdownNonPrimitiveTypeExplain() {
        String tableName = "test_projection_pushdown_non_primtive_type_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (id BIGINT, _row ROW(child BIGINT), _array ARRAY(ROW(child BIGINT)), _map MAP(BIGINT, BIGINT))");
        this.assertExplain("EXPLAIN SELECT id, _row.child, _array[1].child, _map[1] FROM " + tableName, new String[]{"ScanProject\\[table = (.*)]", "expr(.*) := .*\\$subscript\\(.*, bigint '1'\\).0", "id(.*) := id:bigint:REGULAR", "(.*) := _array:array\\(row\\(child bigint\\)\\):REGULAR", "(.*) := _map:map\\(bigint, bigint\\):REGULAR", "(.*) := _row#child:bigint:REGULAR"});
    }

    @Test
    public void testReadCdfChanges() {
        this.testReadCdfChanges(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadCdfChanges(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadCdfChanges(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadCdfChanges(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_basic_operations_on_table_with_cdf_enabled_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2), ('url3', 'domain3', 3)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url4', 'domain4', 4), ('url5', 'domain5', 2), ('url6', 'domain6', 6)", 3L);
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url22' WHERE views = 2", 2L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'insert', BIGINT '2'),\n    ('url5', 'domain5', 2, 'insert', BIGINT '2'),\n    ('url6', 'domain6', 6, 'insert', BIGINT '2'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '3'),\n    ('url5', 'domain5', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain5', 2, 'update_postimage', BIGINT '3')\n");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE views = 2", 2L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "VALUES\n    ('url22', 'domain2', 2, 'delete', BIGINT '4'),\n    ('url22', 'domain5', 2, 'delete', BIGINT '4')\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "')) ORDER BY _commit_version, _change_type, domain", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'insert', BIGINT '2'),\n    ('url5', 'domain5', 2, 'insert', BIGINT '2'),\n    ('url6', 'domain6', 6, 'insert', BIGINT '2'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '3'),\n    ('url22', 'domain5', 2, 'update_postimage', BIGINT '3'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '3'),\n    ('url5', 'domain5', 2, 'update_preimage', BIGINT '3'),\n    ('url22', 'domain2', 2, 'delete', BIGINT '4'),\n    ('url22', 'domain5', 2, 'delete', BIGINT '4')\n");
    }

    @Test
    public void testReadCdfChangesOnPartitionedTable() {
        this.testReadCdfChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadCdfChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadCdfChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadCdfChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_basic_operations_on_table_with_cdf_enabled_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, partitioned_by = ARRAY['domain'], column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2), ('url3', 'domain1', 3)", 3L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url4', 'domain1', 400), ('url5', 'domain2', 500), ('url6', 'domain3', 2)", 3L);
        this.assertUpdate("UPDATE " + tableName + " SET domain = 'domain4' WHERE views = 2", 2L);
        this.assertQuery("SELECT * FROM " + tableName, "    VALUES\n        ('url1', 'domain1', 1),\n        ('url2', 'domain4', 2),\n        ('url3', 'domain1', 3),\n        ('url4', 'domain1', 400),\n        ('url5', 'domain2', 500),\n        ('url6', 'domain4', 2)\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain1', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain1', 400, 'insert', BIGINT '2'),\n    ('url5', 'domain2', 500, 'insert', BIGINT '2'),\n    ('url6', 'domain3', 2, 'insert', BIGINT '2'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '3'),\n    ('url2', 'domain4', 2, 'update_postimage', BIGINT '3'),\n    ('url6', 'domain3', 2, 'update_preimage', BIGINT '3'),\n    ('url6', 'domain4', 2, 'update_postimage', BIGINT '3')\n");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE domain = 'domain4'", 2L);
        this.assertQuery("SELECT * FROM " + tableName, "    VALUES\n        ('url1', 'domain1', 1),\n        ('url3', 'domain1', 3),\n        ('url4', 'domain1', 400),\n        ('url5', 'domain2', 500)\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "VALUES\n    ('url2', 'domain4', 2, 'delete', BIGINT '4'),\n    ('url6', 'domain4', 2, 'delete', BIGINT '4')\n");
    }

    @Test
    public void testCdfWithNameMappingModeOnTableWithColumnDropped() {
        this.testCdfWithMappingModeOnTableWithColumnDropped(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
    }

    @Test
    public void testCdfWithIdMappingModeOnTableWithColumnDropped() {
        this.testCdfWithMappingModeOnTableWithColumnDropped(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
    }

    private void testCdfWithMappingModeOnTableWithColumnDropped(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_dropping_column_with_cdf_enabled_and_mapping_mode_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, page_views INTEGER, column_to_drop INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 1, 111)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 2, 222)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url3', 3, 333)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url4', 4, 444)", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " DROP COLUMN column_to_drop");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url5', 5)", 1L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "VALUES\n    ('url1', 1, 'insert', BIGINT '1'),\n    ('url2', 2, 'insert', BIGINT '2'),\n    ('url3', 3, 'insert', BIGINT '3'),\n    ('url4', 4, 'insert', BIGINT '4'),\n    ('url5', 5, 'insert', BIGINT '6')\n");
    }

    @Test
    public void testReadMergeChanges() {
        this.testReadMergeChanges(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadMergeChanges(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadMergeChanges(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadMergeChanges(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName1 = "test_basic_operations_on_table_with_cdf_enabled_merge_into_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName1 + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName1 + " VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2), ('url3', 'domain3', 3), ('url4', 'domain4', 4)", 4L);
        String tableName2 = "test_basic_operations_on_table_with_cdf_enabled_merge_from_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName2 + " (page_url VARCHAR, domain VARCHAR, views INTEGER)");
        this.assertUpdate("INSERT INTO " + tableName2 + " VALUES('url1', 'domain10', 10), ('url2', 'domain20', 20), ('url5', 'domain5', 50)", 3L);
        this.assertUpdate("INSERT INTO " + tableName2 + " VALUES('url4', 'domain40', 40)", 1L);
        this.assertUpdate("MERGE INTO " + tableName1 + " tableWithCdf USING " + tableName2 + " source ON (tableWithCdf.page_url = source.page_url) WHEN MATCHED AND tableWithCdf.views > 1 THEN UPDATE SET views = (tableWithCdf.views + source.views) WHEN MATCHED AND tableWithCdf.views <= 1 THEN DELETE WHEN NOT MATCHED THEN INSERT (page_url, domain, views) VALUES (source.page_url, source.domain, source.views)", 4L);
        this.assertQuery("SELECT * FROM " + tableName1, "    VALUES\n        ('url2', 'domain2', 22),\n        ('url3', 'domain3', 3),\n        ('url4', 'domain4', 44),\n        ('url5', 'domain5', 50)\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName1 + "', 0))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'insert', BIGINT '1'),\n    ('url4', 'domain4', 4, 'update_preimage', BIGINT '2'),\n    ('url4', 'domain4', 44, 'update_postimage', BIGINT '2'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '2'),\n    ('url2', 'domain2', 22, 'update_postimage', BIGINT '2'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '2'),\n    ('url5', 'domain5', 50, 'insert', BIGINT '2')\n");
    }

    @Test
    public void testReadMergeChangesOnPartitionedTable() {
        this.testReadMergeChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadMergeChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadMergeChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadMergeChangesOnPartitionedTable(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String targetTable = "test_basic_operations_on_partitioned_table_with_cdf_enabled_target_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + targetTable + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, partitioned_by = ARRAY['domain'], column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + targetTable + " VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2), ('url3', 'domain3', 3), ('url4', 'domain1', 4)", 4L);
        String sourceTable1 = "test_basic_operations_on_partitioned_table_with_cdf_enabled_source_1_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTable1 + " (page_url VARCHAR, domain VARCHAR, views INTEGER)");
        this.assertUpdate("INSERT INTO " + sourceTable1 + " VALUES('url1', 'domain1', 10), ('url2', 'domain2', 20), ('url5', 'domain3', 5)", 3L);
        this.assertUpdate("INSERT INTO " + sourceTable1 + " VALUES('url4', 'domain2', 40)", 1L);
        this.assertUpdate("MERGE INTO " + targetTable + " target USING " + sourceTable1 + " source ON (target.page_url = source.page_url) WHEN MATCHED AND target.views > 2 THEN UPDATE SET views = (target.views + source.views) WHEN MATCHED AND target.views <= 2 THEN DELETE WHEN NOT MATCHED THEN INSERT (page_url, domain, views) VALUES (source.page_url, source.domain, source.views)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES\n    ('url3', 'domain3', 3),\n    ('url4', 'domain1', 44),\n    ('url5', 'domain3', 5)\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + targetTable + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', 1),\n    ('url2', 'domain2', 2, 'insert', BIGINT '1'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '1'),\n    ('url4', 'domain1', 4, 'insert', BIGINT '1'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '2'),\n    ('url2', 'domain2', 2, 'delete', BIGINT '2'),\n    ('url4', 'domain1', 4, 'update_preimage', BIGINT '2'),\n    ('url4', 'domain1', 44, 'update_postimage', BIGINT '2'),\n    ('url5', 'domain3', 5, 'insert', BIGINT '2')\n");
        String sourceTable2 = "test_basic_operations_on_partitioned_table_with_cdf_enabled_source_1_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + sourceTable2 + " (page_url VARCHAR, domain VARCHAR, views INTEGER)");
        this.assertUpdate("INSERT INTO " + sourceTable2 + " VALUES('url3', 'domain1', 300), ('url4', 'domain2', 400), ('url5', 'domain3', 500), ('url6', 'domain1', 600)", 4L);
        this.assertUpdate("MERGE INTO " + targetTable + " target USING " + sourceTable2 + " source ON (target.page_url = source.page_url) WHEN MATCHED AND target.views > 3 THEN UPDATE SET domain = source.domain, views = (source.views + target.views) WHEN MATCHED AND target.views <= 3 THEN DELETE WHEN NOT MATCHED THEN INSERT (page_url, domain, views) VALUES (source.page_url, source.domain, source.views)", 4L);
        this.assertQuery("SELECT * FROM " + targetTable, "VALUES\n   ('url4', 'domain2', 444),\n   ('url5', 'domain3', 505),\n   ('url6', 'domain1', 600)\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + targetTable + "', 2))", "VALUES\n    ('url3', 'domain3', 3, 'delete', BIGINT '3'),\n    ('url4', 'domain1', 44, 'update_preimage', BIGINT '3'),\n    ('url4', 'domain2', 444, 'update_postimage', BIGINT '3'),\n    ('url5', 'domain3', 5, 'update_preimage', BIGINT '3'),\n    ('url5', 'domain3', 505, 'update_postimage', BIGINT '3'),\n    ('url6', 'domain1', 600, 'insert', BIGINT '3')\n");
    }

    @Test
    public void testCdfCommitTimestamp() {
        this.testCdfCommitTimestamp(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCdfCommitTimestamp(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCdfCommitTimestamp(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCdfCommitTimestamp(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_cdf_commit_timestamp_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        ZonedDateTime historyCommitTimestamp = (ZonedDateTime)this.computeScalar("SELECT timestamp FROM \"" + tableName + "$history\" WHERE version = 1");
        ZonedDateTime tableChangesCommitTimestamp = (ZonedDateTime)this.computeScalar("SELECT _commit_timestamp FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0)) WHERE _commit_Version = 1");
        Assertions.assertThat((ZonedDateTime)historyCommitTimestamp).isEqualTo((Object)tableChangesCommitTimestamp);
    }

    @Test
    public void testReadDifferentChangeRanges() {
        this.testReadDifferentChangeRanges(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadDifferentChangeRanges(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadDifferentChangeRanges(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadDifferentChangeRanges(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_reading_ranges_of_changes_on_table_with_cdf_enabled_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertQueryReturnsEmptyResult("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url3', 'domain3', 3)", 1L);
        this.assertQueryReturnsEmptyResult("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))");
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url22' WHERE domain = 'domain2'", 1L);
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url33' WHERE views = 3", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE page_url = 'url1'", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES\n   ('url22', 'domain2', 2),\n   ('url33', 'domain3', 3)\n");
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 1000))", "since_version: 1000 is higher then current table version: 6");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '2'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '3'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '4'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '4'),\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '5'),\n    ('url33', 'domain3', 3, 'update_postimage', BIGINT '5'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '6')\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '2'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '3'),\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '4'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '4'),\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '5'),\n    ('url33', 'domain3', 3, 'update_postimage', BIGINT '5'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '6')\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "VALUES\n    ('url2', 'domain2', 2, 'update_preimage', BIGINT '4'),\n    ('url22', 'domain2', 2, 'update_postimage', BIGINT '4'),\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '5'),\n    ('url33', 'domain3', 3, 'update_postimage', BIGINT '5'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '6')\n");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 5))", "VALUES ('url1', 'domain1', 1, 'delete', BIGINT '6')");
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 10))", "since_version: 10 is higher then current table version: 6");
    }

    @Test
    public void testReadChangesOnTableWithColumnAdded() {
        this.testReadChangesOnTableWithColumnAdded(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadChangesOnTableWithColumnAdded(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadChangesOnTableWithColumnAdded(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadChangesOnTableWithColumnAdded(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_reading_changes_on_table_with_columns_added_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN company VARCHAR");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 'domain2', 2, 'starburst')", 1L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, null, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'starburst', 'insert', BIGINT '3')\n");
    }

    @Test
    public void testReadChangesOnTableWithRowColumn() {
        this.testReadChangesOnTableWithRowColumn(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadChangesOnTableWithRowColumn(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadChangesOnTableWithRowColumn(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadChangesOnTableWithRowColumn(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_reading_changes_on_table_with_columns_added_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, costs ROW(month VARCHAR, amount BIGINT)) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', ROW('01', 11))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', ROW('02', 19))", 1L);
        this.assertUpdate("UPDATE " + tableName + " SET costs = ROW('02', 37) WHERE costs.month = '02'", 1L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', ROW('01', BIGINT '11') , 'insert', BIGINT '1'),\n    ('url2', ROW('02', BIGINT '19') , 'insert', BIGINT '2'),\n    ('url2', ROW('02', BIGINT '19') , 'update_preimage', BIGINT '3'),\n    ('url2', ROW('02', BIGINT '37') , 'update_postimage', BIGINT '3')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT costs.month, costs.amount, _commit_version FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))"))).matches("VALUES\n    (VARCHAR '01', BIGINT '11', BIGINT '1'),\n    (VARCHAR '02', BIGINT '19', BIGINT '2'),\n    (VARCHAR '02', BIGINT '19', BIGINT '3'),\n    (VARCHAR '02', BIGINT '37', BIGINT '3')\n");
    }

    @Test
    public void testCdfOnTableWhichDoesntHaveItEnabledInitially() {
        this.testCdfOnTableWhichDoesntHaveItEnabledInitially(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCdfOnTableWhichDoesntHaveItEnabledInitially(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCdfOnTableWhichDoesntHaveItEnabledInitially(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCdfOnTableWhichDoesntHaveItEnabledInitially(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_cdf_on_table_without_it_initially_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url3', 'domain3', 3)", 1L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '2'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '3')\n");
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url22' WHERE domain = 'domain2'", 1L);
        this.assertQuerySucceeds("ALTER TABLE " + tableName + " SET PROPERTIES change_data_feed_enabled = true");
        this.assertUpdate("UPDATE " + tableName + " SET page_url = 'url33' WHERE views = 3", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE page_url = 'url1'", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES\n   ('url22', 'domain2', 2),\n   ('url33', 'domain3', 3)\n");
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "Change Data Feed is not enabled at version 4. Version contains 'remove' entries without 'cdc' entries");
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "Change Data Feed is not enabled at version 4. Version contains 'remove' entries without 'cdc' entries");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 5))", "VALUES\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '6'),\n    ('url33', 'domain3', 3, 'update_postimage', BIGINT '6'),\n    ('url1', 'domain1', 1, 'delete', BIGINT '7')\n");
    }

    @Test
    public void testReadChangesFromCtasTable() {
        this.testReadChangesFromCtasTable(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testReadChangesFromCtasTable(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testReadChangesFromCtasTable(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testReadChangesFromCtasTable(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_basic_operations_on_table_with_cdf_enabled_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "') AS SELECT * FROM (VALUES('url1', 'domain1', 1), ('url2', 'domain2', 2)) t(page_url, domain, views)", 2L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "'))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '0'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '0')\n");
    }

    @Test
    public void testVacuumTableUsingVersionDeletedCheckpoints() throws Exception {
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        String tableName = "test_vacuum_deleted_version_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        String deltaLog = "%s/%s/_delta_log".formatted(SCHEMA, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + tableLocation + "', checkpoint_interval = 1) AS SELECT 1 id", 1L);
        Set<String> initialFiles = this.getActiveFiles(tableName);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        this.assertUpdate("UPDATE " + tableName + " SET id = 3 WHERE id = 1", 1L);
        Stopwatch timeSinceUpdate = Stopwatch.createStarted();
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(7);
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000000.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.checkpoint.parquet");
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(4);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 2, 3");
        Set<String> updatedFiles = this.getActiveFiles(tableName);
        this.assertUpdate("CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '7d')");
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 2, 3");
        TimeUnit.MILLISECONDS.sleep(1000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
        this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + tableName + "', retention => '1s')");
        Assertions.assertThat(this.getAllDataFilesFromTableDirectory(tableName)).isEqualTo(updatedFiles);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 2, 3");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testVacuumDeletesCdfFiles() throws InterruptedException {
        this.testVacuumDeletesCdfFiles(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testVacuumDeletesCdfFiles(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testVacuumDeletesCdfFiles(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testVacuumDeletesCdfFiles(DeltaLakeSchemaSupport.ColumnMappingMode mode) throws InterruptedException {
        String tableName = "test_vacuum_correctly_deletes_cdf_files_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1), ('url3', 'domain3', 3), ('url2', 'domain2', 2)", 3L);
        this.assertUpdate("UPDATE " + tableName + " SET views = views * 10 WHERE views = 1", 1L);
        this.assertUpdate("UPDATE " + tableName + " SET views = views * 10 WHERE views = 2", 1L);
        Stopwatch timeSinceUpdate = Stopwatch.createStarted();
        Thread.sleep(2000L);
        this.assertUpdate("UPDATE " + tableName + " SET views = views * 30 WHERE views = 3", 1L);
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        Set<String> allFilesFromCdfDirectory = this.getAllFilesFromCdfDirectory(tableName);
        Assertions.assertThat(allFilesFromCdfDirectory).hasSizeGreaterThanOrEqualTo(3);
        long retention = timeSinceUpdate.elapsed().getSeconds();
        this.getQueryRunner().execute(sessionWithShortRetentionUnlocked, "CALL system.vacuum(CURRENT_SCHEMA, '" + tableName + "', '" + retention + "s')");
        allFilesFromCdfDirectory = this.getAllFilesFromCdfDirectory(tableName);
        Assertions.assertThat(allFilesFromCdfDirectory).hasSizeBetween(1, 2);
        this.assertQueryFails("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 2))", "Error opening Hive split.*/_change_data/.*");
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 3))", "VALUES\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '4'),\n    ('url3', 'domain3', 90, 'update_postimage', BIGINT '4')\n");
    }

    @Test
    public void testCdfWithOptimize() {
        this.testCdfWithOptimize(DeltaLakeSchemaSupport.ColumnMappingMode.ID);
        this.testCdfWithOptimize(DeltaLakeSchemaSupport.ColumnMappingMode.NAME);
        this.testCdfWithOptimize(DeltaLakeSchemaSupport.ColumnMappingMode.NONE);
    }

    private void testCdfWithOptimize(DeltaLakeSchemaSupport.ColumnMappingMode mode) {
        String tableName = "test_cdf_with_optimize_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, column_mapping_mode = '" + String.valueOf(mode) + "')");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url3', 'domain3', 3)", 1L);
        this.assertUpdate("UPDATE " + tableName + " SET views = views * 30 WHERE views = 3", 1L);
        this.computeActual("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url10', 'domain10', 10)", 1L);
        this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "VALUES\n    ('url1', 'domain1', 1, 'insert', BIGINT '1'),\n    ('url2', 'domain2', 2, 'insert', BIGINT '2'),\n    ('url3', 'domain3', 3, 'insert', BIGINT '3'),\n    ('url10', 'domain10', 10, 'insert', BIGINT '6'),\n    ('url3', 'domain3', 3, 'update_preimage', BIGINT '4'),\n    ('url3', 'domain3', 90, 'update_postimage', BIGINT '4')\n");
    }

    @Test
    public void testTableChangesAccessControl() {
        String tableName = "test_deny_table_changes_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (page_url VARCHAR, domain VARCHAR, views INTEGER) ");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES('url3', 'domain3', 3)", 1L);
        this.assertAccessDenied("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "Cannot execute function .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"delta.system.table_changes", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessDenied("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + tableName + "', 0))", "Cannot select from columns .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTableWithTrailingSlashLocation() {
        this.testTableWithTrailingSlashLocation(true);
        this.testTableWithTrailingSlashLocation(false);
    }

    public void testTableWithTrailingSlashLocation(boolean partitioned) {
        String tableName = "test_table_with_trailing_slash_location_" + TestingNames.randomNameSuffix();
        String location = String.format("s3://%s/%s/", this.bucketName, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + "(col_str, col_int)WITH (location = '" + location + "'" + (partitioned ? ",partitioned_by = ARRAY['col_str']" : "") + ") AS VALUES ('str1', 1), ('str2', 2)", 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('str1', 1), ('str2', 2)");
        this.assertUpdate("UPDATE " + tableName + " SET col_str = 'other'", 2L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('other', 1), ('other', 2)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ('str3', 3)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('other', 1), ('other', 2), ('str3', 3)");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE col_int = 2", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES ('other', 1), ('str3', 3)");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWithFilter() {
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, purchases INT, address VARCHAR) WITH (location = 's3://%s/%s')", "address = 'Antioch'", false);
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "starts_with(address, 'Antioch')", false);
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "address = 'Antioch'", true);
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "address = 'Antioch' AND \"$file_size\" > 0", true);
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address'])", "starts_with(address, 'Antioch')", false);
        this.testDeleteWithFilter("CREATE TABLE %s (customer VARCHAR, address VARCHAR, purchases INT) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer'])", "address = 'Antioch'", false);
        this.testDeleteWithFilter("CREATE TABLE %s (purchases INT, customer VARCHAR, address VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address', 'customer'])", "address = 'Antioch' AND (customer = 'Aaron' OR customer = 'Bill')", true);
        this.testDeleteWithFilter("CREATE TABLE %s (purchases INT, address VARCHAR, customer VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['address', 'customer'])", "address = 'Antioch'", true);
        this.testDeleteWithFilter("CREATE TABLE %s (purchases INT, address VARCHAR, customer VARCHAR) WITH (location = 's3://%s/%s', partitioned_by = ARRAY['customer', 'address'])", "address = 'Antioch'", true);
    }

    private void testDeleteWithFilter(String createTableSql, String deleteFilter, boolean pushDownDelete) {
        String table = "delete_with_filter_" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format(createTableSql, table, this.bucketName, table));
        this.assertUpdate(String.format("INSERT INTO %s (customer, purchases, address) VALUES ('Aaron', 5, 'Antioch'), ('Bill', 7, 'Antioch'), ('Mary', 10, 'Adelphi'), ('Aaron', 3, 'Dallas')", table), 4L);
        this.assertUpdate(this.getSession(), String.format("DELETE FROM %s WHERE %s", table, deleteFilter), 2L, plan -> {
            if (pushDownDelete) {
                boolean tableDelete = PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(node -> node instanceof TableDeleteNode).matches();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)tableDelete).describedAs("A TableDeleteNode should be present", new Object[0])).isTrue();
            } else {
                TableFinishNode finishNode = (TableFinishNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(TableFinishNode.class::isInstance).findOnlyElement();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)(finishNode.getTarget() instanceof TableWriterNode.MergeTarget)).describedAs("Delete operation should be performed through MERGE mechanism", new Object[0])).isTrue();
            }
        });
        this.assertQuery("SELECT customer, purchases, address FROM " + table, "VALUES ('Mary', 10, 'Adelphi'), ('Aaron', 3, 'Dallas')");
        this.assertUpdate("DROP TABLE " + table);
    }

    protected void verifyAddNotNullColumnToNonEmptyTableFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Unable to add NOT NULL column '.*' for non-empty table: .*");
    }

    protected String createSchemaSql(String schemaName) {
        return "CREATE SCHEMA " + schemaName + " WITH (location = 's3://" + this.bucketName + "/" + schemaName + "')";
    }

    protected OptionalInt maxSchemaNameLength() {
        return OptionalInt.of(128);
    }

    protected void verifySchemaNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Schema name must be shorter than or equal to '128' characters but got.*");
    }

    protected OptionalInt maxTableNameLength() {
        return OptionalInt.of(128);
    }

    protected void verifyTableNameLengthFailurePermissible(Throwable e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("Table name must be shorter than or equal to '128' characters but got.*");
    }

    private Set<String> getActiveFiles(String tableName) {
        return this.getActiveFiles(tableName, this.getQueryRunner().getDefaultSession());
    }

    private Set<String> getActiveFiles(String tableName, Session session) {
        return (Set)this.computeActual(session, "SELECT DISTINCT \"$path\" FROM " + tableName).getOnlyColumnAsSet().stream().map(String.class::cast).collect(ImmutableSet.toImmutableSet());
    }

    private Set<String> getAllDataFilesFromTableDirectory(String tableName) {
        return (Set)this.getTableFiles(tableName).stream().filter(path -> !path.contains("/_delta_log")).collect(ImmutableSet.toImmutableSet());
    }

    private List<String> getTableFiles(String tableName) {
        return (List)this.minioClient.listObjects(this.bucketName, String.format("%s/%s", SCHEMA, tableName)).stream().map(path -> String.format("s3://%s/%s", this.bucketName, path)).collect(ImmutableList.toImmutableList());
    }

    private void assertTableChangesQuery(@Language(value="SQL") String sql, @Language(value="SQL") String expectedResult) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(sql))).result().exceptColumns(new String[]{"_commit_timestamp"}).skippingTypesCheck().matches(expectedResult);
    }

    private Set<String> getAllFilesFromCdfDirectory(String tableName) {
        return (Set)this.getTableFiles(tableName).stream().filter(path -> path.contains("/_change_data")).collect(ImmutableSet.toImmutableSet());
    }

    @Test
    public void testPartitionFilterQueryNotDemanded() {
        Map catalogProperties = this.getSession().getCatalogProperties((String)this.getSession().getCatalog().orElseThrow());
        Assertions.assertThat((Map)catalogProperties).doesNotContainKey((Object)"query_partition_filter_required");
        try (TestTable table = this.newTrinoTable("test_partition_filter_not_demanded", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"'a', 'part_a'", (Object)"'b', 'part_b'"));){
            this.assertQuery("SELECT * FROM %s WHERE x='a'".formatted(table.getName()), "VALUES('a', 'part_a')");
            this.assertQuery("SELECT * FROM %s WHERE part='part_a'".formatted(table.getName()), "VALUES('a', 'part_a')");
        }
    }

    @Test
    public void testQueryWithoutPartitionOnNonPartitionedTableNotDemanded() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_no_partition_table_", "(x varchar, part varchar)", (List)ImmutableList.of((Object)"('a', 'part_a')", (Object)"('b', 'part_b')"));){
            this.assertQuery(session, "SELECT * FROM %s WHERE x='a'".formatted(table.getName()), "VALUES('a', 'part_a')");
            this.assertQuery(session, "SELECT * FROM %s WHERE part='part_a'".formatted(table.getName()), "VALUES('a', 'part_a')");
        }
    }

    @Test
    public void testQueryWithoutPartitionFilterNotAllowed() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_no_partition_filter_", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 'part_a')", (Object)"('b', 'part_b')"));){
            this.assertQueryFails(session, "SELECT * FROM %s WHERE x='a'".formatted(table.getName()), "Filter required on .*" + table.getName() + " for at least one partition column:.*");
        }
    }

    @Test
    public void testPartitionFilterRemovedByPlanner() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_removed_", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 'part_a')", (Object)"('b', 'part_b')"));){
            this.assertQueryFails(session, "SELECT x FROM " + table.getName() + " WHERE part IS NOT NULL OR TRUE", "Filter required on .*" + table.getName() + " for at least one partition column:.*");
        }
    }

    @Test
    public void testPartitionFilterIncluded() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_included", "(x varchar, part integer) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 1)", (Object)"('a', 2)", (Object)"('a', 3)", (Object)"('a', 4)", (Object)"('b', 1)", (Object)"('b', 2)", (Object)"('b', 3)", (Object)"('b', 4)"));){
            this.assertQuery(session, "SELECT * FROM " + table.getName() + " WHERE part = 1", "VALUES ('a', 1), ('b', 1)");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part < 2", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE Part < 2", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE PART < 2", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE parT < 2", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part % 2 = 0", "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part - 2 = 0", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part * 4 = 4", "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part % 2 > 0", "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part % 2 = 1 and part IS NOT NULL", "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part IS NULL", "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part = 1 OR x = 'a' ", "VALUES 5");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part = 1 AND  x = 'a' ", "VALUES 1");
            this.assertQuery(session, "SELECT count(*) FROM " + table.getName() + " WHERE part IS NOT NULL", "VALUES 8");
            this.assertQuery(session, "SELECT x, count(*) AS COUNT FROM " + table.getName() + " WHERE part > 2 GROUP BY x ", "VALUES ('a', 2), ('b', 2)");
            this.assertQueryFails(session, "SELECT count(*) FROM " + table.getName() + " WHERE x= 'a'", "Filter required on .*" + table.getName() + " for at least one partition column:.*");
        }
    }

    @Test
    public void testRequiredPartitionFilterOnJoin() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable leftTable = this.newTrinoTable("test_partition_left_", "(x varchar, part varchar)", (List)ImmutableList.of((Object)"('a', 'part_a')"));
             TestTable rightTable = new TestTable((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), "test_partition_right_", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 'part_a')"));){
            this.assertQueryFails(session, "SELECT a.x, b.x from %s a JOIN %s b on (a.x = b.x) where a.x = 'a'".formatted(leftTable.getName(), rightTable.getName()), "Filter required on .*" + rightTable.getName() + " for at least one partition column:.*");
            this.assertQuery(session, "SELECT a.x, b.x from %s a JOIN %s b on (a.part = b.part) where a.part = 'part_a'".formatted(leftTable.getName(), rightTable.getName()), "VALUES ('a', 'a')");
        }
    }

    @Test
    public void testRequiredPartitionFilterOnJoinBothTablePartitioned() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable leftTable = this.newTrinoTable("test_partition_inferred_left_", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 'part_a')"));
             TestTable rightTable = new TestTable((SqlExecutor)new TrinoSqlExecutor(this.getQueryRunner(), session), "test_partition_inferred_right_", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', 'part_a')"));){
            this.assertQueryFails(session, "SELECT a.x, b.x from %s a JOIN %s b on (a.x = b.x) where a.x = 'a'".formatted(leftTable.getName(), rightTable.getName()), "Filter required on .*" + leftTable.getName() + " for at least one partition column:.*");
            this.assertQuery(session, "SELECT a.x, b.x from %s a JOIN %s b on (a.part = b.part) where a.part = 'part_a'".formatted(leftTable.getName(), rightTable.getName()), "VALUES ('a', 'a')");
        }
    }

    @Test
    public void testComplexPartitionPredicateWithCasting() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_predicate", "(x varchar, part varchar) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"('a', '1')", (Object)"('b', '2')"));){
            this.assertQuery(session, "SELECT * FROM " + table.getName() + " WHERE CAST (part AS integer) = 1", "VALUES ('a', 1)");
        }
    }

    @Test
    public void testPartitionPredicateInOuterQuery() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_predicate", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"(1, 11)", (Object)"(2, 22)"));){
            this.assertQuery(session, "SELECT * FROM (SELECT * FROM " + table.getName() + " WHERE x = 1) WHERE part = 11", "VALUES (1, 11)");
        }
    }

    @Test
    public void testPartitionPredicateInInnerQuery() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_predicate", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"(1, 11)", (Object)"(2, 22)"));){
            this.assertQuery(session, "SELECT * FROM (SELECT * FROM " + table.getName() + " WHERE part = 11) WHERE x = 1", "VALUES (1, 11)");
        }
    }

    @Test
    public void testPartitionPredicateFilterAndAnalyzeOnPartitionedTable() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_predicate_analyze_", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"(1, 11)", (Object)"(2, 22)"));){
            String expectedMessageRegExp = "ANALYZE statement can not be performed on partitioned tables because filtering is required on at least one partition. However, the partition filtering check can be disabled with the catalog session property 'query_partition_filter_required'.";
            this.assertQueryFails(session, "ANALYZE " + table.getName(), expectedMessageRegExp);
            this.assertQueryFails(session, "EXPLAIN ANALYZE " + table.getName(), expectedMessageRegExp);
        }
    }

    @Test
    public void testPartitionPredicateFilterAndAnalyzeOnNonPartitionedTable() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable nonPartitioned = this.newTrinoTable("test_partition_predicate_analyze_nonpartitioned", "(a integer, b integer) ", (List)ImmutableList.of((Object)"(1, 11)", (Object)"(2, 22)"));){
            this.assertUpdate(session, "ANALYZE " + nonPartitioned.getName());
            this.computeActual(session, "EXPLAIN ANALYZE " + nonPartitioned.getName());
        }
    }

    @Test
    public void testPartitionFilterMultiplePartition() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_multiple_partition_", "(x varchar, part1 integer, part2 integer) WITH (partitioned_by = ARRAY['part1', 'part2'])", (List)ImmutableList.of((Object)"('a', 1, 1)", (Object)"('a', 1, 2)", (Object)"('a', 2, 1)", (Object)"('a', 2, 2)", (Object)"('b', 1, 1)", (Object)"('b', 1, 2)", (Object)"('b', 2, 1)", (Object)"('b', 2, 2)"));){
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 = 1".formatted(table.getName()), "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part2 = 1".formatted(table.getName()), "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 = 1 AND part2 = 2".formatted(table.getName()), "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part2 IS NOT NULL".formatted(table.getName()), "VALUES 8");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part2 IS NULL".formatted(table.getName()), "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part2 < 0".formatted(table.getName()), "VALUES 0");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 = 1 OR part2 > 1".formatted(table.getName()), "VALUES 6");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 = 1 AND part2 > 1".formatted(table.getName()), "VALUES 2");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 IS NOT NULL OR part2 > 1".formatted(table.getName()), "VALUES 8");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE part1 IS NOT NULL AND part2 > 1".formatted(table.getName()), "VALUES 4");
            this.assertQuery(session, "SELECT count(*) FROM %s WHERE x = 'a' AND part2 = 2".formatted(table.getName()), "VALUES 2");
            this.assertQuery(session, "SELECT x, PART1 * 10 + PART2 AS Y FROM %s WHERE x = 'a' AND part2 = 2".formatted(table.getName()), "VALUES ('a', 12), ('a', 22)");
            this.assertQuery(session, "SELECT x, CAST (PART1 AS varchar) || CAST (PART2 AS varchar) FROM %s WHERE x = 'a' AND part2 = 2".formatted(table.getName()), "VALUES ('a', '12'), ('a', '22')");
            this.assertQuery(session, "SELECT x, MAX(PART1) FROM %s WHERE part2 = 2 GROUP BY X".formatted(table.getName()), "VALUES ('a', 2), ('b', 2)");
            this.assertQuery(session, "SELECT x, reduce_agg(part1, 0, (a, b) -> a + b, (a, b) -> a + b) FROM " + table.getName() + " WHERE part2 > 1 GROUP BY X", "VALUES ('a', 3), ('b', 3)");
            String expectedMessageRegExp = "Filter required on .*" + table.getName() + " for at least one partition column:.*";
            this.assertQueryFails(session, "SELECT X, CAST (PART1 AS varchar) || CAST (PART2 AS varchar) FROM %s WHERE x = 'a'".formatted(table.getName()), expectedMessageRegExp);
            this.assertQueryFails(session, "SELECT count(*) FROM %s WHERE x='a'".formatted(table.getName()), expectedMessageRegExp);
        }
    }

    @Test
    public void testPartitionFilterRequiredAndOptimize() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_optimize", "(part integer, name varchar(50)) WITH (partitioned_by = ARRAY['part'])", (List)ImmutableList.of((Object)"(1, 'Bob')", (Object)"(2, 'Alice')"));){
            this.assertUpdate(session, "ALTER TABLE " + table.getName() + " ADD COLUMN last_name varchar(50)");
            this.assertUpdate(session, "INSERT INTO " + table.getName() + " SELECT 3, 'John', 'Doe'", 1L);
            this.assertQuery(session, "SELECT part, name, last_name  FROM " + table.getName() + " WHERE part < 4", "VALUES (1, 'Bob', NULL), (2, 'Alice', NULL), (3, 'John', 'Doe')");
            Set<String> beforeActiveFiles = this.getActiveFiles(table.getName());
            this.assertQueryFails(session, "ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE", "Filter required on .*" + table.getName() + " for at least one partition column:.*");
            this.computeActual(session, "ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE WHERE part=1");
            Assertions.assertThat(beforeActiveFiles).isEqualTo(this.getActiveFiles(table.getName()));
            this.assertUpdate(session, "INSERT INTO " + table.getName() + " SELECT 1, 'Dave', 'Doe'", 1L);
            this.assertQuery(session, "SELECT part, name, last_name  FROM " + table.getName() + " WHERE part < 4", "VALUES (1, 'Bob', NULL), (2, 'Alice', NULL), (3, 'John', 'Doe'), (1, 'Dave', 'Doe')");
            this.computeActual(session, "ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE WHERE part=1");
            Assertions.assertThat(beforeActiveFiles).isNotEqualTo(this.getActiveFiles(table.getName()));
            this.assertQuery(session, "SELECT part, name, last_name  FROM " + table.getName() + " WHERE part < 4", "VALUES (1, 'Bob', NULL), (2, 'Alice', NULL), (3, 'John', 'Doe'), (1, 'Dave', 'Doe')");
        }
    }

    @Test
    public void testPartitionFilterEnabledAndOptimizeForNonPartitionedTable() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_nonpartitioned_optimize", "(part integer, name varchar(50))", (List)ImmutableList.of((Object)"(1, 'Bob')", (Object)"(2, 'Alice')"));){
            this.assertUpdate(session, "ALTER TABLE " + table.getName() + " ADD COLUMN last_name varchar(50)");
            this.assertUpdate(session, "INSERT INTO " + table.getName() + " SELECT 3, 'John', 'Doe'", 1L);
            this.assertQuery(session, "SELECT part, name, last_name  FROM " + table.getName() + " WHERE part < 4", "VALUES (1, 'Bob', NULL), (2, 'Alice', NULL), (3, 'John', 'Doe')");
            Set<String> beforeActiveFiles = this.getActiveFiles(table.getName());
            this.computeActual(session, "ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE (file_size_threshold => '10kB')");
            Assertions.assertThat(beforeActiveFiles).isNotEqualTo(this.getActiveFiles(table.getName()));
            this.assertQuery(session, "SELECT part, name, last_name  FROM " + table.getName() + " WHERE part < 4", "VALUES (1, 'Bob', NULL), (2, 'Alice', NULL), (3, 'John', 'Doe')");
        }
    }

    @Test
    public void testPartitionFilterRequiredAndWriteOperation() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_table_changes", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'], change_data_feed_enabled = true)", (List)ImmutableList.of((Object)"(1, 11)", (Object)"(2, 22)", (Object)"(3, 33)"));){
            String expectedMessageRegExp = "Filter required on test_schema\\." + table.getName() + " for at least one partition column: part";
            this.assertQueryFails(session, "UPDATE " + table.getName() + " SET x = 10 WHERE x = 1", expectedMessageRegExp);
            this.assertUpdate(session, "UPDATE " + table.getName() + " SET x = 20 WHERE part = 22", 1L);
            this.assertQueryFails(session, "MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES (3, 99), (4,44))) AS s(x, part) ON t.x = s.x WHEN MATCHED THEN DELETE ", expectedMessageRegExp);
            this.assertUpdate(session, "MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES (2, 22), (4 , 44))) AS s(x, part) ON (t.part = s.part) WHEN MATCHED THEN UPDATE  SET x = t.x + s.x, part = t.part ", 1L);
            this.assertQueryFails(session, "MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES (4,44))) AS s(x, part) ON t.x = s.x WHEN NOT MATCHED THEN INSERT (x, part) VALUES(s.x, s.part) ", expectedMessageRegExp);
            this.assertUpdate(session, "MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES (4, 44))) AS s(x, part) ON (t.part = s.part) WHEN NOT MATCHED THEN INSERT (x, part) VALUES(s.x, s.part) ", 1L);
            this.assertQueryFails(session, "DELETE FROM " + table.getName() + " WHERE x = 3", expectedMessageRegExp);
            this.assertUpdate(session, "DELETE FROM " + table.getName() + " WHERE part = 33 and x = 3", 1L);
        }
    }

    @Test
    public void testPartitionFilterRequiredAndTableChanges() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_table_changes", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'], change_data_feed_enabled = true)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 11)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 22)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 33)", 1L);
            String expectedMessageRegExp = "Filter required on test_schema\\." + table.getName() + " for at least one partition column: part";
            this.assertQueryFails(session, "UPDATE " + table.getName() + " SET x = 10 WHERE x = 1", expectedMessageRegExp);
            this.assertUpdate(session, "UPDATE " + table.getName() + " SET x = 20 WHERE part = 22", 1L);
            this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + table.getName() + "'))", "VALUES\n    (1,   11,  'insert',           BIGINT '1'),\n    (2,   22,  'insert',           BIGINT '2'),\n    (3,   33,  'insert',           BIGINT '3'),\n    (2,   22,  'update_preimage',  BIGINT '4'),\n    (20,  22,  'update_postimage', BIGINT '4')\n");
            this.assertQueryFails(session, "DELETE FROM " + table.getName() + " WHERE x = 3", expectedMessageRegExp);
            this.assertUpdate(session, "DELETE FROM " + table.getName() + " WHERE part = 33 and x = 3", 1L);
            this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + table.getName() + "', 4))", "VALUES\n    (3, 33, 'delete', BIGINT '5')\n");
            this.assertTableChangesQuery("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, '" + table.getName() + "')) ORDER BY _commit_version, _change_type, part", "VALUES\n    (1,   11,  'insert',           BIGINT '1'),\n    (2,   22,  'insert',           BIGINT '2'),\n    (3,   33,  'insert',           BIGINT '3'),\n    (2,   22,  'update_preimage',  BIGINT '4'),\n    (20,  22,  'update_postimage', BIGINT '4'),\n    (3,   33,  'delete',           BIGINT '5')\n");
        }
    }

    @Test
    public void testPartitionFilterRequiredAndHistoryTable() {
        Session session = this.sessionWithPartitionFilterRequirement();
        try (TestTable table = this.newTrinoTable("test_partition_filter_table_changes", "(x integer, part integer) WITH (partitioned_by = ARRAY['part'], change_data_feed_enabled = true)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 11)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 22)", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 33)", 1L);
            String expectedMessageRegExp = "Filter required on test_schema\\." + table.getName() + " for at least one partition column: part";
            this.assertQuery("SELECT version, operation, read_version FROM \"" + table.getName() + "$history\"", "VALUES\n    (0, 'CREATE TABLE', 0),\n    (1, 'WRITE', 0),\n    (2, 'WRITE', 1),\n    (3, 'WRITE', 2)\n");
            this.assertQueryFails(session, "UPDATE " + table.getName() + " SET x = 10 WHERE x = 1", expectedMessageRegExp);
            this.assertUpdate(session, "UPDATE " + table.getName() + " SET x = 20 WHERE part = 22", 1L);
            this.assertQuery("SELECT version, operation, read_version FROM \"" + table.getName() + "$history\"", "VALUES\n    (0, 'CREATE TABLE', 0),\n    (1, 'WRITE', 0),\n    (2, 'WRITE', 1),\n    (3, 'WRITE', 2),\n    (4, 'MERGE', 3)\n");
        }
    }

    protected Session withoutSmallFileThreshold(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "parquet_small_file_threshold", "0B").build();
    }

    private Session sessionWithPartitionFilterRequirement() {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "query_partition_filter_required", "true").build();
    }

    @Test
    public void testTrinoCacheInvalidatedOnCreateTable() {
        String tableName = "test_create_table_invalidate_cache_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        String initialValues = "VALUES (1, BOOLEAN 'false', TINYINT '-128'),(2, BOOLEAN 'true', TINYINT '127'),(3, BOOLEAN 'false', TINYINT '0'),(4, BOOLEAN 'false', TINYINT '1'),(5, BOOLEAN 'true', TINYINT '37')";
        this.assertUpdate("CREATE TABLE " + tableName + "(id, boolean, tinyint) WITH (location = '" + tableLocation + "') AS " + initialValues, 5L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches(initialValues);
        this.metastore.dropTable(SCHEMA, tableName, false);
        for (String file : this.minioClient.listObjects(this.bucketName, "test_schema/" + tableName)) {
            this.minioClient.removeObject(this.bucketName, file);
        }
        String newValues = "VALUES (1, BOOLEAN 'true', TINYINT '1'),(2, BOOLEAN 'true', TINYINT '1'),(3, BOOLEAN 'false', TINYINT '2'),(4, BOOLEAN 'true', TINYINT '3'),(5, BOOLEAN 'true', TINYINT '5'),(6, BOOLEAN 'false', TINYINT '8'),(7, BOOLEAN 'true', TINYINT '13')";
        this.assertUpdate("CREATE TABLE " + tableName + "(id, boolean, tinyint) WITH (location = '" + tableLocation + "') AS " + newValues, 7L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + tableName))).matches(newValues);
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testQueriesWithoutCheckpointFiltering() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("delta", "checkpoint_filtering_enabled", "false").build();
        String tableName = "test_without_checkpoint_filtering_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (col INT) WITH (checkpoint_interval=3)");
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 1", 1L);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 2, 3", 2L);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 4, 5", 2L);
        this.assertQuery(session, "SELECT * FROM " + tableName, "VALUES 1, 2, 3, 4, 5");
        this.assertUpdate(session, "UPDATE " + tableName + " SET col = 44 WHERE col = 4", 1L);
        this.assertUpdate(session, "DELETE FROM " + tableName + " WHERE col = 3", 1L);
        this.assertQuery(session, "SELECT * FROM " + tableName, "VALUES 1, 2, 44, 5");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    void testAddTimestampNtzColumnToCdfEnabledTable() {
        try (TestTable table = this.newTrinoTable("test_timestamp_ntz", "(x int) WITH (change_data_feed_enabled = true)");){
            Assertions.assertThat(this.getTableProperties(table.getName())).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.builder().put((Object)"delta.enableChangeDataFeed", (Object)"true").put((Object)"delta.enableDeletionVectors", (Object)"false").put((Object)"delta.minReaderVersion", (Object)"1").put((Object)"delta.minWriterVersion", (Object)"4").buildOrThrow());
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN ts TIMESTAMP");
            Assertions.assertThat(this.getTableProperties(table.getName())).containsExactlyInAnyOrderEntriesOf((Map)ImmutableMap.builder().put((Object)"delta.enableChangeDataFeed", (Object)"true").put((Object)"delta.enableDeletionVectors", (Object)"false").put((Object)"delta.feature.changeDataFeed", (Object)"supported").put((Object)"delta.feature.timestampNtz", (Object)"supported").put((Object)"delta.minReaderVersion", (Object)"3").put((Object)"delta.minWriterVersion", (Object)"7").buildOrThrow());
        }
    }

    private Map<String, String> getTableProperties(String tableName) {
        return (Map)this.computeActual("SELECT key, value FROM \"" + tableName + "$properties\"").getMaterializedRows().stream().collect(ImmutableMap.toImmutableMap(row -> (String)row.getField(0), row -> (String)row.getField(1)));
    }

    @Test
    public void testTypeCoercionOnCreateTable() {
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.900000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.56'", "TIMESTAMP '1970-01-01 00:00:00.560000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.4896'", "TIMESTAMP '1970-01-01 00:00:00.489600'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.89356'", "TIMESTAMP '1970-01-01 00:00:00.893560'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.100000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.900000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.123456999999'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampCoercionOnCreateTable("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testCharCoercionOnCreateTable("CHAR 'ab '", "'ab '");
        this.testCharCoercionOnCreateTable("CHAR 'A'", "'A'");
        this.testCharCoercionOnCreateTable("CHAR '\u00e9'", "'\u00e9'");
        this.testCharCoercionOnCreateTable("CHAR 'A '", "'A '");
        this.testCharCoercionOnCreateTable("CHAR ' A'", "' A'");
        this.testCharCoercionOnCreateTable("CHAR 'ABc'", "'ABc'");
    }

    private void testTimestampCoercionOnCreateTable(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table", "(ts TIMESTAMP)");){
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (" + actualValue + ")", 1L);
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("timestamp(6)");
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES " + expectedValue);
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTable(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table", "(vch VARCHAR)");){
            this.assertUpdate("INSERT INTO " + testTable.getName() + " VALUES (" + actualValue + ")", 1L);
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "vch")).isEqualTo("varchar");
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES " + expectedValue);
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsSelect() {
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.900000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.56'", "TIMESTAMP '1970-01-01 00:00:00.560000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.4896'", "TIMESTAMP '1970-01-01 00:00:00.489600'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.89356'", "TIMESTAMP '1970-01-01 00:00:00.893560'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.100000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.900000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.123456999999'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampCoercionOnCreateTableAsSelect("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testCharCoercionOnCreateTableAsSelect("CHAR 'ab '", "'ab '");
        this.testCharCoercionOnCreateTableAsSelect("CHAR 'A'", "'A'");
        this.testCharCoercionOnCreateTableAsSelect("CHAR '\u00e9'", "'\u00e9'");
        this.testCharCoercionOnCreateTableAsSelect("CHAR 'A '", "'A '");
        this.testCharCoercionOnCreateTableAsSelect("CHAR ' A'", "' A'");
        this.testCharCoercionOnCreateTableAsSelect("CHAR 'ABc'", "'ABc'");
    }

    private void testTimestampCoercionOnCreateTableAsSelect(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table_as_select", "AS SELECT %s ts".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("timestamp(6)");
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES " + expectedValue);
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTableAsSelect(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table_as_select", "AS SELECT %s col".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "col")).isEqualTo("varchar");
            this.assertQuery("SELECT * FROM " + testTable.getName(), "VALUES " + expectedValue);
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsSelectWithNoData() {
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.9'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.56'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.4896'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.89356'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123000'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.999'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.1'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.9'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123000'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.999'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.1234561'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456499'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456499999'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.123456999999'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.1234565'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.111222333444'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 00:00:00.9999995'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1970-01-01 23:59:59.9999995'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.9999995'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.999999499999'");
        this.testTimestampCoercionOnCreateTableAsSelectWithNoData("TIMESTAMP '1969-12-31 23:59:59.9999994'");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR 'ab '");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR 'A'");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR '\u00e9'");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR 'A '");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR ' A'");
        this.testCharCoercionOnCreateTableAsSelectWithNoData("CHAR 'ABc'");
    }

    private void testTimestampCoercionOnCreateTableAsSelectWithNoData(@Language(value="SQL") String actualValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table_as_select_with_no_data", "AS SELECT %s ts WITH NO DATA".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("timestamp(6)");
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTableAsSelectWithNoData(@Language(value="SQL") String actualValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table_as_select_with_no_data", "AS SELECT %s col WITH NO DATA".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "col")).isEqualTo("varchar");
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsWithRowType() {
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.56'", "TIMESTAMP '1970-01-01 00:00:00.56'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.4896'", "TIMESTAMP '1970-01-01 00:00:00.4896'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.89356'", "TIMESTAMP '1970-01-01 00:00:00.89356'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.123456999999'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampCoercionOnCreateTableAsWithRowType("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR 'ab '", "CHAR(3)", "'ab '");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR 'A'", "CHAR(3)", "'A  '");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR 'A'", "CHAR(1)", "'A'");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR '\u00e9'", "CHAR(3)", "'\u00e9  '");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR 'A '", "CHAR(3)", "'A  '");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR ' A'", "CHAR(3)", "' A '");
        this.testCharCoercionOnCreateTableAsWithRowType("CHAR 'ABc'", "CHAR(3)", "'ABc'");
    }

    private void testTimestampCoercionOnCreateTableAsWithRowType(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table_as_with_row_type", "AS SELECT CAST(row(%s) AS row(value timestamp(6))) ts".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("row(value timestamp(6))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT ts.value FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES " + expectedValue);
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTableAsWithRowType(@Language(value="SQL") String actualValue, @Language(value="SQL") String actualTypeLiteral, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table_as_with_row_type", "AS SELECT CAST(row(%s) AS row(value %s)) col".formatted(actualValue, actualTypeLiteral));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "col")).isEqualTo("row(value varchar)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col.value FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES " + expectedValue);
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsWithArrayType() {
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.56'", "TIMESTAMP '1970-01-01 00:00:00.56'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.4896'", "TIMESTAMP '1970-01-01 00:00:00.4896'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.89356'", "TIMESTAMP '1970-01-01 00:00:00.89356'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.123456999999'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampCoercionOnCreateTableAsWithArrayType("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR 'ab '", "'ab '");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR 'A'", "'A'");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR '\u00e9'", "'\u00e9'");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR 'A '", "'A '");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR ' A'", "' A'");
        this.testCharCoercionOnCreateTableAsWithArrayType("CHAR 'ABc'", "'ABc'");
    }

    private void testTimestampCoercionOnCreateTableAsWithArrayType(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table_as_with_array_type", "AS SELECT array[%s] ts".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("array(timestamp(6))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT ts[1] FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES " + expectedValue);
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTableAsWithArrayType(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table_as_with_array_type", "AS SELECT array[%s] col".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "col")).isEqualTo("array(varchar)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT col[1] FROM " + testTable.getName()))).skippingTypesCheck().matches("VALUES " + expectedValue);
        }
    }

    @Test
    public void testTypeCoercionOnCreateTableAsWithMapType() {
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00'", "TIMESTAMP '1970-01-01 00:00:00'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.9'", "TIMESTAMP '1970-01-01 00:00:00.9'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.56'", "TIMESTAMP '1970-01-01 00:00:00.56'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.4896'", "TIMESTAMP '1970-01-01 00:00:00.4896'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.89356'", "TIMESTAMP '1970-01-01 00:00:00.89356'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123000'", "TIMESTAMP '1970-01-01 00:00:00.123'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.999'", "TIMESTAMP '1970-01-01 00:00:00.999'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123456'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.1'", "TIMESTAMP '2020-09-27 12:34:56.1'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.9'", "TIMESTAMP '2020-09-27 12:34:56.9'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.123'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.123000'", "TIMESTAMP '2020-09-27 12:34:56.123'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.999'", "TIMESTAMP '2020-09-27 12:34:56.999'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '2020-09-27 12:34:56.123456'", "TIMESTAMP '2020-09-27 12:34:56.123456'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.1234561'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123456499'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123456499999'", "TIMESTAMP '1970-01-01 00:00:00.123456'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.123456999999'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.1234565'", "TIMESTAMP '1970-01-01 00:00:00.123457'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.111222333444'", "TIMESTAMP '1970-01-01 00:00:00.111222'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 00:00:00.9999995'", "TIMESTAMP '1970-01-01 00:00:01.000000'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1970-01-01 23:59:59.9999995'", "TIMESTAMP '1970-01-02 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1969-12-31 23:59:59.9999995'", "TIMESTAMP '1970-01-01 00:00:00.000000'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1969-12-31 23:59:59.999999499999'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testTimestampCoercionOnCreateTableAsWithMapType("TIMESTAMP '1969-12-31 23:59:59.9999994'", "TIMESTAMP '1969-12-31 23:59:59.999999'");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR 'ab '", "'ab '");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR 'A'", "'A'");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR '\u00e9'", "'\u00e9'");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR 'A '", "'A '");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR ' A'", "' A'");
        this.testCharCoercionOnCreateTableAsWithMapType("CHAR 'ABc'", "'ABc'");
    }

    private void testTimestampCoercionOnCreateTableAsWithMapType(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_timestamp_coercion_on_create_table_as_with_map_type", "AS SELECT map(array[%1$s], array[%1$s]) ts".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "ts")).isEqualTo("map(timestamp(6), timestamp(6))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName()))).skippingTypesCheck().matches("SELECT map(array[%1$s], array[%1$s])".formatted(expectedValue));
            this.assertTimestampNtzFeature(testTable.getName());
        }
    }

    private void testCharCoercionOnCreateTableAsWithMapType(@Language(value="SQL") String actualValue, @Language(value="SQL") String expectedValue) {
        try (TestTable testTable = this.newTrinoTable("test_char_coercion_on_create_table_as_with_map_type", "AS SELECT map(array[%1$s], array[%1$s]) col".formatted(actualValue));){
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "col")).isEqualTo("map(varchar, varchar)");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + testTable.getName()))).skippingTypesCheck().matches("SELECT map(array[%1$s], array[%1$s])".formatted(expectedValue));
        }
    }

    @Test
    public void testAddColumnWithTypeCoercion() {
        this.testAddColumnWithTypeCoercion("timestamp", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(0)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(1)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(2)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(3)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(4)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(5)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(6)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(7)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(8)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(9)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(10)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(11)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("timestamp(12)", "timestamp(6)");
        this.testAddColumnWithTypeCoercion("char(1)", "varchar");
        this.testAddColumnWithTypeCoercion("array(char(10))", "array(varchar)");
        this.testAddColumnWithTypeCoercion("map(char(20), char(30))", "map(varchar, varchar)");
        this.testAddColumnWithTypeCoercion("row(x char(40))", "row(x varchar)");
    }

    private void testAddColumnWithTypeCoercion(String columnType, String expectedColumnType) {
        try (TestTable testTable = this.newTrinoTable("test_coercion_add_column", "(a varchar, b row(x integer))");){
            this.assertQueryFails("ALTER TABLE " + testTable.getName() + " ADD COLUMN b.y " + columnType, "This connector does not support adding fields");
            this.assertUpdate("ALTER TABLE " + testTable.getName() + " ADD COLUMN c " + columnType);
            Assertions.assertThat((String)this.getColumnType(testTable.getName(), "c")).isEqualTo(expectedColumnType);
        }
    }

    private void assertTimestampNtzFeature(String tableName) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM \"" + tableName + "$properties\""))).skippingTypesCheck().containsAll("VALUES ('delta.minReaderVersion', '3'), ('delta.minWriterVersion', '7'), ('delta.feature.timestampNtz', 'supported')");
    }

    @Test
    public void testSelectTableUsingVersion() {
        try (TestTable table = this.newTrinoTable("test_select_table_using_version", "(id INT, country VARCHAR)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 'India')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 'Germany')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 'United States')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0"))).returnsEmptyResult();
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 'India'), (2, 'Germany'), (3, 'United States')");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES (1, 'India')");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 3", "VALUES (1, 'India'), (2, 'Germany'), (3, 'United States')");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 4", "Delta Lake snapshot ID does not exists: 4");
            for (int i = 0; i < 20; ++i) {
                this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id  = 10", 0L);
            }
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 'Austria')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (5, 'Poland')", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET country = 'USA' WHERE id  = 3", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id  = 2", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (6, 'Japan')", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 'India'), (3, 'USA'), (4, 'Austria'), (5, 'Poland'), (6, 'Japan')");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 4", "VALUES (1, 'India'), (2, 'Germany'), (3, 'United States')");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 26", "VALUES (1, 'India'), (2, 'Germany'), (3, 'USA'), (4, 'Austria'), (5, 'Poland')");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 27", "VALUES (1, 'India'), (3, 'USA'), (4, 'Austria'), (5, 'Poland')");
            this.assertUpdate("DELETE FROM " + table.getName(), 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).returnsEmptyResult();
            this.assertUpdate("INSERT INTO " + table.getName() + " (id, country) SELECT * FROM " + table.getName() + " FOR VERSION AS OF 27", 4L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES (1, 'India'), (3, 'USA'), (4, 'Austria'), (5, 'Poland')");
        }
    }

    @Test
    public void testSelectTableUsingTemporalVersion() throws InterruptedException {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_select_table_using_temporal_version", "(id INT, country VARCHAR)");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 'India')", 1L);
            String timeAfterInsert1 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 'Germany')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 'United States')", 1L);
            String timeAfterInsert2 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'"))).returnsEmptyResult();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, CAST('India' AS varchar)), (2, CAST('Germany' AS varchar)), (3, CAST('United States' AS varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'"))).matches("VALUES (1, CAST('India' AS varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert2 + "'"))).matches("VALUES (1, CAST('India' AS varchar)), (2, CAST('Germany' AS varchar)), (3, CAST('United States' AS varchar))");
            for (int i = 0; i < 20; ++i) {
                this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id  = 10", 0L);
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 'Austria')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (5, 'Poland')", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET country = 'USA' WHERE id  = 3", 1L);
            String timeAfterUpdate = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id  = 2", 1L);
            String timeAfterDelete = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (6, 'Japan')", 1L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, CAST('India' AS varchar)), (3, CAST('USA' AS varchar)), (4, CAST('Austria' AS varchar)), (5, CAST('Poland' AS varchar)), (6, CAST('Japan' AS varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert2 + "'"))).matches("VALUES (1, CAST('India' AS varchar)), (2, CAST('Germany' AS varchar)), (3, CAST('United States' AS varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterUpdate + "'"))).matches("VALUES (1, CAST('India' AS varchar)), (2, CAST('Germany' AS varchar)), (3, CAST('USA' AS varchar)), (4, CAST('Austria' AS varchar)), (5, CAST('Poland' AS varchar))");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterDelete + "'"))).matches("VALUES (1, CAST('India' AS varchar)), (3, CAST('USA' AS varchar)), (4, CAST('Austria' AS varchar)), (5, CAST('Poland' AS varchar))");
            this.assertUpdate("DELETE FROM " + table.getName(), 5L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).returnsEmptyResult();
            this.assertUpdate("INSERT INTO " + table.getName() + " (id, country) SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterDelete + "'", 4L);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM " + table.getName()))).matches("VALUES (1, CAST('India' AS varchar)), (3, CAST('USA' AS varchar)), (4, CAST('Austria' AS varchar)), (5, CAST('Poland' AS varchar))");
        }
    }

    @Test
    public void testReadMultipleVersions() {
        try (TestTable table = this.newTrinoTable("test_read_multiple_versions", "AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0 UNION ALL SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES 1, 1, 2");
        }
    }

    @Test
    public void testReadMultipleTemporalVersions() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_read_multiple_versions_using_temporal", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            String timeAfterInsert = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'UNION ALL SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert + "'", "VALUES 1, 1, 2");
        }
    }

    @Test
    public void testReadVersionedTableWithOptimize() {
        try (TestTable table = this.newTrinoTable("test_read_versioned_optimize", "AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            Set<String> beforeActiveFiles = this.getActiveFiles(table.getName());
            this.computeActual("ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE");
            Assertions.assertThat(this.getActiveFiles(table.getName())).isNotEqualTo(beforeActiveFiles);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 2", "VALUES 1, 2");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 3", 1L);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 2", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 3", "VALUES 1, 2, 3");
        }
    }

    @Test
    public void testReadTemporalVersionedTableWithOptimize() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_read_temporal_versioned_optimize", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            String timeAfterInsert1 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            Set<String> beforeActiveFiles = this.getActiveFiles(table.getName());
            this.computeActual("ALTER TABLE " + table.getName() + " EXECUTE OPTIMIZE");
            String timeAfterOptimize = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            Assertions.assertThat(this.getActiveFiles(table.getName())).isNotEqualTo(beforeActiveFiles);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterOptimize + "'", "VALUES 1, 2");
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 3", 1L);
            String timeAfterInsert2 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterOptimize + "'", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert2 + "'", "VALUES 1, 2, 3");
        }
    }

    @Test
    public void testReadVersionedTableWithVacuum() throws Exception {
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        try (TestTable table = this.newTrinoTable("test_add_column_and_vacuum", "(x VARCHAR)");){
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second'", 1L);
            Set<String> initialFiles = this.getActiveFiles(table.getName());
            Assertions.assertThat(initialFiles).hasSize(2);
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            this.assertUpdate("UPDATE " + table.getName() + " SET a = 'new column'", 2L);
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(table.getName());
            ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSizeGreaterThanOrEqualTo(1)).hasSizeLessThanOrEqualTo(2)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', 'new column'), ('second', 'new column')");
            TimeUnit.MILLISECONDS.sleep(1000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + table.getName() + "', retention => '1s')");
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo(updatedFiles);
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "Error opening Hive split.*");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 2", "Error opening Hive split.*");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 3", "Error opening Hive split.*");
            this.assertQuery("SELECT x, a FROM " + table.getName() + " FOR VERSION AS OF 4", "VALUES ('first', 'new column'), ('second', 'new column')");
        }
    }

    @Test
    public void testReadTemporalVersionedTableWithVacuum() throws Exception {
        Session sessionWithShortRetentionUnlocked = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_add_column_and_vacuum_temporal", "(x VARCHAR)");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'first'", 1L);
            String timeAfterInsert1 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT 'second'", 1L);
            String timeAfterInsert2 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            Set<String> initialFiles = this.getActiveFiles(table.getName());
            Assertions.assertThat(initialFiles).hasSize(2);
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN a varchar(50)");
            String timeAfterAddColumn = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("UPDATE " + table.getName() + " SET a = 'new column'", 2L);
            String timeAfterUpdate = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            Stopwatch timeSinceUpdate = Stopwatch.createStarted();
            Set<String> updatedFiles = this.getActiveFiles(table.getName());
            ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(updatedFiles).hasSizeGreaterThanOrEqualTo(1)).hasSizeLessThanOrEqualTo(2)).doesNotContainAnyElementsOf(initialFiles);
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo((Object)Sets.union(initialFiles, updatedFiles));
            this.assertQuery("SELECT x, a FROM " + table.getName(), "VALUES ('first', 'new column'), ('second', 'new column')");
            TimeUnit.MILLISECONDS.sleep(1000L - timeSinceUpdate.elapsed(TimeUnit.MILLISECONDS) + 1L);
            this.assertUpdate(sessionWithShortRetentionUnlocked, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + table.getName() + "', retention => '1s')");
            Assertions.assertThat(this.getAllDataFilesFromTableDirectory(table.getName())).isEqualTo(updatedFiles);
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'", "Error opening Hive split.*");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert2 + "'", "Error opening Hive split.*");
            this.assertQueryFails("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterAddColumn + "'", "Error opening Hive split.*");
            this.assertQuery("SELECT x, a FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterUpdate + "'", "VALUES ('first', 'new column'), ('second', 'new column')");
        }
    }

    @Test
    public void testInsertFromVersionedTable() {
        try (TestTable targetTable = this.newTrinoTable("test_read_versioned_insert", "(col int)");
             TestTable sourceTable = this.newTrinoTable("test_read_versioned_insert", "AS SELECT 1 col");){
            this.assertUpdate("INSERT INTO " + sourceTable.getName() + " VALUES 2", 1L);
            this.assertUpdate("INSERT INTO " + sourceTable.getName() + " VALUES 3", 1L);
            this.assertUpdate("INSERT INTO " + targetTable.getName() + " SELECT * FROM " + sourceTable.getName() + " FOR VERSION AS OF 0", 1L);
            this.assertQuery("SELECT * FROM " + targetTable.getName(), "VALUES 1");
            this.assertUpdate("INSERT INTO " + targetTable.getName() + " SELECT * FROM " + sourceTable.getName() + " FOR VERSION AS OF 1", 2L);
            this.assertQuery("SELECT * FROM " + targetTable.getName(), "VALUES 1, 1, 2");
        }
    }

    @Test
    public void testInsertFromTemporalVersionedTable() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable targetTable = this.newTrinoTable("test_read_versioned_insert", "(col int)");
             TestTable sourceTable = this.newTrinoTable("test_read_versioned_insert", "AS SELECT 1 col");){
            String timeAfterCreateSourceTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + sourceTable.getName() + " VALUES 2", 1L);
            String timeAfterInsertSourceTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + sourceTable.getName() + " VALUES 3", 1L);
            this.assertUpdate("INSERT INTO " + targetTable.getName() + " SELECT * FROM " + sourceTable.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateSourceTable + "'", 1L);
            this.assertQuery("SELECT * FROM " + targetTable.getName(), "VALUES 1");
            this.assertUpdate("INSERT INTO " + targetTable.getName() + " SELECT * FROM " + sourceTable.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsertSourceTable + "'", 2L);
            this.assertQuery("SELECT * FROM " + targetTable.getName(), "VALUES 1, 1, 2");
        }
    }

    @Test
    public void testInsertFromVersionedSameTable() {
        try (TestTable table = this.newTrinoTable("test_read_versioned_insert", "AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", 2L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1, 2, 1");
            this.assertQuery("SELECT version, operation, read_version, is_blind_append FROM \"" + table.getName() + "$history\"", "VALUES\n    (0, 'CREATE TABLE AS SELECT', 0, true),\n    (1, 'WRITE', 0, true),\n    (2, 'WRITE', 1, true),\n    (3, 'WRITE', 2, true)\n");
        }
    }

    @Test
    public void testInsertFromTemporalVersionedSameTable() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_read_temporal_versioned_insert", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            String timeAfterInsert1 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'", 2L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1, 2, 1");
        }
    }

    @Test
    public void testInsertFromMultipleVersionedSameTable() {
        try (TestTable table = this.newTrinoTable("test_read_versioned_insert", "AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0 UNION ALL SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", 3L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1, 1, 2");
        }
    }

    @Test
    public void testInsertFromMultipleTemporalVersionedSameTable() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_read_temporal_versioned_insert", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            String timeAfterInsert = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2");
            this.assertUpdate("INSERT INTO " + table.getName() + " SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'UNION ALL SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert + "'", 3L);
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2, 1, 1, 2");
        }
    }

    @Test
    public void testReadVersionedTableWithChangeDataFeed() {
        try (TestTable table = this.newTrinoTable("test_read_versioned_cdf", "WITH (change_data_feed_enabled=true) AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertUpdate("UPDATE " + table.getName() + " SET id = -2 WHERE id = 2", 1L);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id = 1", 1L);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 2", "VALUES 1, -2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 3", "VALUES -2");
        }
    }

    @Test
    public void testReadTemporalVersionedTableWithChangeDataFeed() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_read_temporal_versioned_cdf", "WITH (change_data_feed_enabled=true) AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            String timeAfterInsert = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("UPDATE " + table.getName() + " SET id = -2 WHERE id = 2", 1L);
            String timeAfterUpdate = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE id = 1", 1L);
            String timeAfterDelete = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert + "'", "VALUES 1, 2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterUpdate + "'", "VALUES 1, -2");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterDelete + "'", "VALUES -2");
        }
    }

    @Test
    public void testSelectTableUsingVersionSchemaEvolution() {
        try (TestTable table = this.newTrinoTable("test_select_table_using_version", "AS SELECT 1 id");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN new_col VARCHAR");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 1", "VALUES (1, NULL)");
        }
    }

    @Test
    public void testSelectTableUsingTemporalVersionSchemaEvolution() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_select_table_using_temporal_version", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN new_col VARCHAR");
            String timeAfterAddColumn = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterAddColumn + "'", "VALUES (1, NULL)");
        }
    }

    @Test
    public void testSelectTableUsingVersionDeletedCheckpoints() {
        String tableName = "test_time_travel_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        String deltaLog = "%s/%s/_delta_log".formatted(SCHEMA, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + tableLocation + "', checkpoint_interval = 1) AS SELECT 1 id", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 3", 1L);
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(7);
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000000.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.checkpoint.parquet");
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(4);
        Assertions.assertThat((Collection)this.computeActual("SELECT version FROM \"" + tableName + "$history\"").getOnlyColumnAsSet()).containsExactly(new Object[]{2L});
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1, 2, 3");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF 0", "Delta Lake snapshot ID does not exists: 0");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR VERSION AS OF 1", "Delta Lake snapshot ID does not exists: 1");
        this.assertQuery("SELECT * FROM " + tableName + " FOR VERSION AS OF 2", "VALUES 1, 2, 3");
    }

    @Test
    public void testSelectTableUsingTemporalVersionDeletedCheckpoints() throws InterruptedException {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        String tableName = "test_time_travel_temporal_" + TestingNames.randomNameSuffix();
        String tableLocation = "s3://%s/%s/%s".formatted(this.bucketName, SCHEMA, tableName);
        String deltaLog = "%s/%s/_delta_log".formatted(SCHEMA, tableName);
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (location = '" + tableLocation + "', checkpoint_interval = 1) AS SELECT 1 id", 1L);
        TimeUnit.MILLISECONDS.sleep(10L);
        Instant InstantAfterCreateTable = Instant.ofEpochMilli(System.currentTimeMillis());
        String timeAfterCreateTable = ZonedDateTime.ofInstant(InstantAfterCreateTable, ZoneId.of("UTC")).format(timestampWithTimeZoneFormatter);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        Instant InstantAfterInsert = Instant.ofEpochMilli(System.currentTimeMillis());
        String timeAfterInsert = ZonedDateTime.ofInstant(InstantAfterInsert, ZoneId.of("UTC")).format(timestampWithTimeZoneFormatter);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 3", 1L);
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(7);
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000000.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.json");
        this.minioClient.removeObject(this.bucketName, deltaLog + "/00000000000000000001.checkpoint.parquet");
        Assertions.assertThat((List)this.minioClient.listObjects(this.bucketName, deltaLog)).hasSize(4);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1, 2, 3");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "No temporal version history at or before " + String.valueOf(InstantAfterCreateTable));
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert + "'", "No temporal version history at or before " + String.valueOf(InstantAfterInsert));
        this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + ZonedDateTime.now().format(timestampWithTimeZoneFormatter) + "'", "VALUES 1, 2, 3");
    }

    @Test
    public void testSelectAfterReadVersionedTable() {
        try (TestTable table = this.newTrinoTable("test_select_after_version", "AS SELECT 1 id");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR VERSION AS OF 0", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2");
        }
    }

    @Test
    public void testSelectAfterReadTemporalVersionedTable() {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        try (TestTable table = this.newTrinoTable("test_select_after_temporal_version", "AS SELECT 1 id");){
            String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 2", 1L);
            this.assertQuery("SELECT * FROM " + table.getName() + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", "VALUES 1");
            this.assertQuery("SELECT * FROM " + table.getName(), "VALUES 1, 2");
        }
    }

    @Test
    public void testReadVersionedTableWithoutCheckpointFiltering() {
        String tableName = "test_without_checkpoint_filtering_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("delta", "checkpoint_filtering_enabled", "false").build();
        this.assertUpdate("CREATE TABLE " + tableName + "(col INT) WITH (checkpoint_interval = 3)");
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 1", 1L);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 2, 3", 2L);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 4, 5", 2L);
        this.assertQueryReturnsEmptyResult(session, "SELECT * FROM " + tableName + " FOR VERSION AS OF 0");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR VERSION AS OF 1", "VALUES 1");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR VERSION AS OF 2", "VALUES 1, 2, 3");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR VERSION AS OF 3", "VALUES 1, 2, 3, 4, 5");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadTemporalVersionedTableWithoutCheckpointFiltering() {
        String tableName = "test_without_checkpoint_filtering_temporal_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setCatalogSessionProperty("delta", "checkpoint_filtering_enabled", "false").build();
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        this.assertUpdate("CREATE TABLE " + tableName + "(col INT) WITH (checkpoint_interval = 3)");
        String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 1", 1L);
        String timeAfterInsert1 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 2, 3", 2L);
        String timeAfterInsert2 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
        this.assertUpdate(session, "INSERT INTO " + tableName + " VALUES 4, 5", 2L);
        String timeAfterInsert3 = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
        this.assertQueryReturnsEmptyResult(session, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert1 + "'", "VALUES 1");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert2 + "'", "VALUES 1, 2, 3");
        this.assertQuery(session, "SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert3 + "'", "VALUES 1, 2, 3, 4, 5");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testTimeTravelUsingTemporalVersionWithDifferentTimePrecision() throws InterruptedException {
        this.testTimeTravelUsingTemporalVersionWithDifferentTimePrecision(true);
        this.testTimeTravelUsingTemporalVersionWithDifferentTimePrecision(false);
    }

    private void testTimeTravelUsingTemporalVersionWithDifferentTimePrecision(boolean partition) throws InterruptedException {
        String tableName = "test_time_travel_temporal_different_precision_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(col INT, part varchar)" + (partition ? " WITH (partitioned_by = ARRAY['part'])" : ""));
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')", 3L);
        ZonedDateTime timeAfterInsert = ZonedDateTime.now(ZoneId.of("UTC"));
        TimeUnit.SECONDS.sleep(1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE col = 3", 1L);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '" + timeAfterInsert.plusDays(2L).format(dateFormatter) + "'", ".* Pointer value '" + timeAfterInsert.plusDays(2L).format(dateFormatter) + "' is not in the past");
        this.assertQueryFails("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF DATE '" + timeAfterInsert.minusSeconds(1L).format(dateFormatter) + "'", "No temporal version history at or before .*");
        String pattern = "yyyy-MM-dd HH:mm:ss.%s VV";
        for (int precision = 1; precision <= 9; ++precision) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern.formatted("S".repeat(precision)));
            this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert.plusSeconds(1L).format(formatter) + "'", "VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterInsert.plusSeconds(1L).format(formatter) + "'", "VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')");
        String timestampWithPrecision10 = timeAfterInsert.plusSeconds(1L).format(formatter) + "." + "0".repeat(10) + " UTC";
        this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timestampWithPrecision10 + "'", "VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')");
        String timestampWithPrecision11 = timeAfterInsert.plusSeconds(1L).format(formatter) + "." + "0".repeat(11) + " UTC";
        this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timestampWithPrecision11 + "'", "VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')");
        String timestampWithPrecision12 = timeAfterInsert.plusSeconds(1L).format(formatter) + "." + "0".repeat(12) + " UTC";
        this.assertQuery("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timestampWithPrecision12 + "'", "VALUES (1, 'aa'), (2, 'bb'), (3, 'bb')");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadVersionedSystemTables() {
        this.assertQueryFails("SELECT * FROM \"region$history\" FOR VERSION AS OF 0", "This connector does not support versioned tables");
        this.assertQueryFails("SELECT * FROM \"region$history\" FOR TIMESTAMP AS OF DATE '2025-01-01'", "This connector does not support versioned tables");
    }

    protected void verifyVersionedQueryFailurePermissible(Exception e) {
        Assertions.assertThat((Throwable)e).hasMessageMatching("This connector does not support reading tables with TIMESTAMP AS OF|Delta Lake snapshot ID does not exists: .*|Unsupported type for table version: .*|No temporal version history at or before .*");
    }

    @Test
    public void testMissingFieldName() {
        this.assertQueryFails("CREATE TABLE test_missing_field_name(a row(int, int))", "\\QRow type field does not have a name: row(integer, integer)");
    }

    @Test
    public void testDuplicatedFieldNames() {
        String tableName = "test_duplicated_field_names" + TestingNames.randomNameSuffix();
        this.assertQueryFails("CREATE TABLE " + tableName + "(col row(x int, \"X\" int))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS row(x int, \"X\" int)) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col array(row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS array(row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col map(int, row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS map(int, row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + "(col row(a row(x int, \"X\" int)))", "Field name 'x' specified more than once");
        this.assertQueryFails("CREATE TABLE " + tableName + " AS SELECT cast(NULL AS row(a row(x int, \"X\" int))) col", "Field name 'x' specified more than once");
        try (TestTable table = this.newTrinoTable("test_duplicated_field_names_", "(id int)");){
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col row(x int, \"X\" int)", ".* Field name 'x' specified more than once");
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN col row(\"X\" int)");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ADD COLUMN col.x int", "line 1:1: Field 'x' already exists");
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE row(x int, \"X\" int)", "This connector does not support setting column types");
        }
    }

    @Test
    void testRegisterTableAccessControl() {
        String tableName = "test_register_table_access_control_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 a", 1L);
        String tableLocation = ((Table)this.metastore.getTable(SCHEMA, tableName).orElseThrow()).getStorage().getLocation();
        this.metastore.dropTable(SCHEMA, tableName, false);
        this.assertAccessDenied("CALL system.register_table(CURRENT_SCHEMA, '" + tableName + "', '" + tableLocation + "')", "Cannot create table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE)});
    }

    @Test
    public void testMetastoreAfterCreateTable() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int) COMMENT 'test comment'");){
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "test comment"), Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")});
        }
    }

    @Test
    public void testMetastoreAfterCreateOrReplaceTable() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int) COMMENT 'test comment'");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + "(new_col varchar) COMMENT 'new comment'");
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "new comment"), Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"new_col\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}")});
        }
    }

    @Test
    public void testMetastoreAfterCreateTableAsSelect() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "COMMENT 'test comment' AS SELECT 1 col");){
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "test comment"), Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")});
        }
    }

    @Test
    public void testMetastoreAfterCreateOrReplaceTableAsSelect() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "COMMENT 'test comment' AS SELECT 1 col");){
            this.assertUpdate("CREATE OR REPLACE TABLE " + table.getName() + " COMMENT 'new comment' AS SELECT 'test' new_col", 1L);
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "new comment"), Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"new_col\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}")});
        }
    }

    @Test
    public void testMetastoreAfterCommentTable() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")});
            this.assertUpdate("COMMENT ON TABLE " + table.getName() + " IS 'test comment'");
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "test comment"), Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")}));
        }
    }

    @Test
    public void testMetastoreAfterCommentColumn() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int COMMENT 'test comment')");){
            ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{\"comment\":\"test comment\"}}]}")});
            this.assertUpdate("COMMENT ON COLUMN " + table.getName() + ".col IS 'new test comment'");
            Assert.assertEventually(() -> ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{\"comment\":\"new test comment\"}}]}")}));
        }
    }

    @Test
    public void testMetastoreAfterAlterColumn() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int NOT NULL) WITH (column_mapping_mode = 'name')");){
            Map initialParameters = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters();
            ((MapAssert)Assertions.assertThat((Map)initialParameters).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0")});
            List initialColumns = DeltaLakeSchemaSupport.getColumnMetadata((String)((String)initialParameters.get("trino_metadata_schema_string")), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NAME, (List)ImmutableList.of());
            Assertions.assertThat((List)initialColumns).extracting(DeltaLakeColumnMetadata::columnMetadata).containsExactly((Object[])new ColumnMetadata[]{ColumnMetadata.builder().setName("col").setType((Type)IntegerType.INTEGER).setNullable(false).build()});
            this.assertUpdate("ALTER TABLE " + table.getName() + " ALTER COLUMN col DROP NOT NULL");
            Assert.assertEventually(() -> ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1")}));
            Map dropNotNullParameters = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters();
            List dropNotNullColumns = DeltaLakeSchemaSupport.getColumnMetadata((String)((String)dropNotNullParameters.get("trino_metadata_schema_string")), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NAME, (List)ImmutableList.of());
            Assertions.assertThat((List)dropNotNullColumns).extracting(DeltaLakeColumnMetadata::columnMetadata).containsExactly((Object[])new ColumnMetadata[]{ColumnMetadata.builder().setName("col").setType((Type)IntegerType.INTEGER).build()});
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN new_col int COMMENT 'test comment'");
            Assert.assertEventually(() -> ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "2")}));
            Map addColumnParameters = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters();
            List columnsAfterAddColumn = DeltaLakeSchemaSupport.getColumnMetadata((String)((String)addColumnParameters.get("trino_metadata_schema_string")), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NAME, (List)ImmutableList.of());
            Assertions.assertThat((List)columnsAfterAddColumn).extracting(DeltaLakeColumnMetadata::columnMetadata).containsExactly((Object[])new ColumnMetadata[]{ColumnMetadata.builder().setName("col").setType((Type)IntegerType.INTEGER).build(), ColumnMetadata.builder().setName("new_col").setType((Type)IntegerType.INTEGER).setComment(Optional.of("test comment")).build()});
            this.assertUpdate("ALTER TABLE " + table.getName() + " RENAME COLUMN new_col TO renamed_col");
            Assert.assertEventually(() -> ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "3")}));
            Map renameColumnParameters = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters();
            List columnsAfterRenameColumn = DeltaLakeSchemaSupport.getColumnMetadata((String)((String)renameColumnParameters.get("trino_metadata_schema_string")), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NAME, (List)ImmutableList.of());
            Assertions.assertThat((List)columnsAfterRenameColumn).extracting(DeltaLakeColumnMetadata::columnMetadata).containsExactly((Object[])new ColumnMetadata[]{ColumnMetadata.builder().setName("col").setType((Type)IntegerType.INTEGER).build(), ColumnMetadata.builder().setName("renamed_col").setType((Type)IntegerType.INTEGER).setComment(Optional.of("test comment")).build()});
            this.assertUpdate("ALTER TABLE " + table.getName() + " DROP COLUMN renamed_col");
            Assert.assertEventually(() -> ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKey((Object)"comment")).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "4")}));
            Map dropColumnParameters = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters();
            List columnsAfterDropColumn = DeltaLakeSchemaSupport.getColumnMetadata((String)((String)dropColumnParameters.get("trino_metadata_schema_string")), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NAME, (List)ImmutableList.of());
            Assertions.assertThat((List)columnsAfterDropColumn).extracting(DeltaLakeColumnMetadata::columnMetadata).containsExactly((Object[])new ColumnMetadata[]{ColumnMetadata.builder().setName("col").setType((Type)IntegerType.INTEGER).build()});
            this.assertQueryFails("ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint", "This connector does not support setting column types");
        }
    }

    @Test
    public void testMetastoreAfterSetTableProperties() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " SET PROPERTIES change_data_feed_enabled = true");
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")}));
        }
    }

    @Test
    public void testMetastoreAfterOptimize() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            this.assertUpdate("ALTER TABLE " + table.getName() + " EXECUTE optimize");
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")}));
        }
    }

    @Test
    public void testMetastoreAfterRegisterTable() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int) COMMENT 'test comment'");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            String tableLocation = ((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getStorage().getLocation();
            this.metastore.dropTable(SCHEMA, table.getName(), false);
            this.assertUpdate("CALL system.register_table('%s', '%s', '%s')".formatted(SCHEMA, table.getName(), tableLocation));
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "test comment"), Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")});
        }
    }

    @Test
    public void testMetastoreAfterCreateTableRemotely() {
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int) COMMENT 'test comment'");){
            Table metastoreTable = (Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow();
            this.metastore.dropTable(SCHEMA, table.getName(), false);
            ImmutableSet filterKeys = ImmutableSet.of((Object)"comment", (Object)"trino_last_transaction_version", (Object)"trino_metadata_schema_string");
            Table newMetastoreTable = Table.builder((Table)metastoreTable).setParameters(Maps.filterKeys((Map)metastoreTable.getParameters(), arg_0 -> TestDeltaLakeConnectorTest.lambda$testMetastoreAfterCreateTableRemotely$0((Set)filterKeys, arg_0))).build();
            this.metastore.createTable(newMetastoreTable, MetastoreUtil.buildInitialPrivilegeSet((String)((String)metastoreTable.getOwner().orElseThrow())));
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKeys((Object[])new String[]{"comment", "trino_last_transaction_version", "trino_metadata_schema_string"});
            this.assertQueryReturnsEmptyResult("SELECT * FROM " + table.getName());
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("comment", "test comment"), Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}")}));
        }
    }

    @Test
    public void testMetastoreAfterDataManipulation() {
        String schemaString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}";
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", schemaString)});
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", schemaString)}));
            this.assertUpdate("UPDATE " + table.getName() + " SET col = 2", 1L);
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "2"), Map.entry("trino_metadata_schema_string", schemaString)}));
            this.assertUpdate("MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES 2)) AS s(col) ON (t.col = s.col) WHEN MATCHED THEN UPDATE SET col = 3", 1L);
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "3"), Map.entry("trino_metadata_schema_string", schemaString)}));
            this.assertUpdate("DELETE FROM " + table.getName() + " WHERE col = 3", 1L);
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "4"), Map.entry("trino_metadata_schema_string", schemaString)}));
            this.assertUpdate("DELETE FROM " + table.getName(), 0L);
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "5"), Map.entry("trino_metadata_schema_string", schemaString)}));
        }
    }

    @Test
    public void testMetastoreAfterTruncateTable() {
        String schemaString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}";
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "AS SELECT 1 col");){
            Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", schemaString)});
            this.assertUpdate("TRUNCATE TABLE " + table.getName());
            Assert.assertEventually(() -> Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "1"), Map.entry("trino_metadata_schema_string", schemaString)}));
        }
    }

    @Test
    public void testMetastoreAfterCreateView() {
        try (TestView table = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "test_cache_metastore", "SELECT 1 col");){
            ((MapAssert)Assertions.assertThat((Map)((Table)this.metastore.getTable(SCHEMA, table.getName()).orElseThrow()).getParameters()).doesNotContainKeys((Object[])new String[]{"trino_last_transaction_version", "trino_metadata_schema_string"})).contains(new Map.Entry[]{Map.entry("comment", "Presto View")});
        }
    }

    @Test
    public void testWriteLargeCheckpoint() {
        int columnSize = 100;
        String string = "data_%d bigint";
        String columns = IntStream.range(0, columnSize).mapToObj(arg_0 -> TestDeltaLakeConnectorTest.lambda$testWriteLargeCheckpoint$0("data_%d bigint", arg_0)).collect(Collectors.joining(", ", "(", ")"));
        int size = 200;
        try (TestTable table = this.newTrinoTable("test_large_checkpoint", columns + " WITH (checkpoint_interval = %d)".formatted(size));){
            for (int i = 0; i < size; ++i) {
                String value = ",%d".formatted(i).repeat(columnSize).substring(1);
                this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (" + value + ")", 1L);
            }
            this.assertQuery("SELECT COUNT(*) FROM " + table.getName(), "VALUES " + size);
        }
    }

    private static /* synthetic */ String lambda$testWriteLargeCheckpoint$0(String rec$, Object xva$0) {
        return "data_%d bigint".formatted(xva$0);
    }

    private static /* synthetic */ boolean lambda$testMetastoreAfterCreateTableRemotely$0(Set filterKeys, String key) {
        return !filterKeys.contains(key);
    }
}

