/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class TestDeltaLakeCreateTableStatistics
extends AbstractTestQueryFramework {
    private String bucketName;
    private TransactionLogAccess transactionLogAccess;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "delta-test-create-table-statistics-" + TestingNames.randomNameSuffix();
        Hive3MinioDataLake hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        hiveMinioDataLake.start();
        return DeltaLakeQueryRunner.builder().addMetastoreProperties(hiveMinioDataLake.getHiveHadoop()).addS3Properties(hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
    }

    @BeforeAll
    public void initTransactionLogAccess() {
        this.transactionLogAccess = TestingDeltaLakeUtils.getConnectorService(this.getQueryRunner(), TransactionLogAccess.class);
    }

    @Test
    public void testComplexDataTypes() throws Exception {
        try (TestTable table = new TestTable("test_complex_data_types_", (List<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), "VALUES (CAST(ROW(1, 2) AS ROW(x BIGINT, y BIGINT)), ARRAY[1, 2, 3], MAP(ARRAY[1, 2], ARRAY['a', 'b']), 'foo'), (CAST(ROW(3, 4) AS ROW(x BIGINT, y BIGINT)), ARRAY[4, 5], MAP(ARRAY[3], ARRAY['c']), 'moo')");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle("d", (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), "d", (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(2L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"foo")));
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"moo")));
            Assertions.assertThat((Optional)fileStatistics.getNullCount("d")).isEqualTo(Optional.of(0L));
            for (String complexColumn : ImmutableList.of((Object)"a", (Object)"b", (Object)"c")) {
                columnHandle = new DeltaLakeColumnHandle(complexColumn, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), complexColumn, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEmpty();
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEmpty();
                Assertions.assertThat((Optional)fileStatistics.getNullCount(complexColumn)).isEmpty();
            }
        }
    }

    @Test
    public void testDoubleTypesNaN() throws Exception {
        for (String type : Arrays.asList("DOUBLE", "REAL")) {
            String columnName = "t_double";
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
            try (TestTable table = new TestTable("test_nan_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES CAST(nan() AS %1$s), CAST(0.0 AS %1$s)", type));){
                List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
                AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
                Assertions.assertThat((Optional)entry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(2L));
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.empty());
            }
        }
    }

    @Test
    public void testDoubleTypesInf() throws Exception {
        for (String type : Arrays.asList("DOUBLE", "REAL")) {
            String columnName = "t_double";
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
            try (TestTable table = new TestTable("test_inf_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES CAST(infinity() AS %1$s), CAST(0.0 AS %1$s), CAST((infinity() * -1) AS %1$s)", type));){
                List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
                AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
                Assertions.assertThat((Optional)entry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(3L));
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(Double.NEGATIVE_INFINITY));
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(Double.POSITIVE_INFINITY));
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
            }
        }
    }

    @Test
    public void testDoubleTypesInfAndNaN() throws Exception {
        for (String type : Arrays.asList("DOUBLE", "REAL")) {
            String columnName = "t_double";
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
            try (TestTable table = new TestTable("test_inf_nan_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES CAST(nan() AS %1$s), CAST(0.0 AS %1$s), CAST(infinity() AS %1$s), CAST((infinity() * -1) AS %1$s)", type));){
                List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
                AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
                Assertions.assertThat((Optional)entry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.empty());
            }
        }
    }

    @Test
    public void testDoubleTypesNaNPositive() throws Exception {
        for (String type : Arrays.asList("DOUBLE", "REAL")) {
            String columnName = "t_double";
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
            try (TestTable table = new TestTable("test_nan_positive_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES CAST(nan() AS %1$s), CAST(1.0 AS %1$s), CAST(100.0 AS %1$s), CAST(0.0001 AS %1$s)", type));){
                List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
                AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
                Assertions.assertThat((Optional)entry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.empty());
            }
        }
    }

    @Test
    public void testDoubleTypesNaNNegative() throws Exception {
        for (String type : Arrays.asList("DOUBLE", "REAL")) {
            String columnName = "t_double";
            DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
            try (TestTable table = new TestTable("test_nan_positive_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES CAST(nan() AS %1$s), CAST(-1.0 AS %1$s), CAST(-100.0 AS %1$s), CAST(-0.0001 AS %1$s)", type));){
                List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
                AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
                Assertions.assertThat((Optional)entry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.empty());
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.empty());
            }
        }
    }

    @Test
    public void testDecimalLowPrecisionRecords() throws Exception {
        this.testDecimal(5, 1);
    }

    @Test
    public void testDecimalMediumPrecisionRecords() throws Exception {
        this.testDecimal(10, 2);
    }

    @Test
    public void testDecimalHighPrecisionRecords() throws Exception {
        this.testDecimal(25, 3);
    }

    private void testDecimal(int precision, int scale) throws Exception {
        String low = "1" + "0".repeat(precision - scale) + "." + "0".repeat(scale - 1) + "1";
        String high = "2" + "0".repeat(precision - scale) + "." + "0".repeat(scale - 1) + "2";
        String negative = "-1" + "0".repeat(precision - scale) + "." + "0".repeat(scale - 1) + "1";
        String columnName = "t_decimal";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DecimalType.createDecimalType((int)precision, (int)scale), OptionalInt.empty(), columnName, (Type)DecimalType.createDecimalType((int)precision, (int)scale), DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_decimal_records_", (List<String>)ImmutableList.of((Object)columnName), String.format("VALUES DECIMAL '%s', DECIMAL '%s', DECIMAL '%s'", negative, high, low));){
            Optional<Object> expectedMax;
            Optional<Object> expectedMin;
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(3L));
            if (precision <= 18) {
                expectedMin = Optional.of(new BigDecimal(negative).unscaledValue().longValueExact());
                expectedMax = Optional.of(new BigDecimal(high).unscaledValue().longValueExact());
            } else {
                expectedMin = Optional.of(Decimals.encodeScaledValue((BigDecimal)new BigDecimal(negative), (int)scale));
                expectedMax = Optional.of(Decimals.encodeScaledValue((BigDecimal)new BigDecimal(high), (int)scale));
            }
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(expectedMin);
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(expectedMax);
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
        }
    }

    @Test
    public void testNullRecords() throws Exception {
        String columnName = "t_double";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_null_records_", (List<String>)ImmutableList.of((Object)columnName), "VALUES null, 0, null, 1");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(0.0));
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(1.0));
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(2L));
        }
    }

    @Test
    public void testOnlyNullRecords() throws Exception {
        String columnName = "t_varchar";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), columnName, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_only_null_records_", (List<String>)ImmutableList.of((Object)columnName), "VALUES CAST(null AS VARCHAR), CAST(null AS VARCHAR), CAST(null AS VARCHAR), CAST(null AS VARCHAR)");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.empty());
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(4L));
        }
    }

    @Test
    public void testDateRecords() throws Exception {
        String columnName = "t_date";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DateType.DATE, OptionalInt.empty(), columnName, (Type)DateType.DATE, DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_date_records_", (List<String>)ImmutableList.of((Object)columnName), "VALUES DATE '2011-08-08', DATE '2012-08-08', DATE '2013-08-08', DATE '2013-08-09'");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(LocalDate.parse("2011-08-08").toEpochDay()));
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(LocalDate.parse("2013-08-09").toEpochDay()));
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
        }
    }

    @Test
    public void testTimestampMilliRecords() throws Exception {
        String columnName = "t_timestamp";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, OptionalInt.empty(), columnName, (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_timestamp_records_", (List<String>)ImmutableList.of((Object)columnName), "VALUES timestamp '2012-10-31 01:00:00.123 America/New_York', timestamp '2012-10-31 01:00:00.123 America/Los_Angeles', timestamp '2012-10-31 01:00:00.123 UTC'");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(3L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(DateTimeEncoding.packDateTimeWithZone((long)ZonedDateTime.parse("2012-10-31T01:00:00.123Z").toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(DateTimeEncoding.packDateTimeWithZone((long)ZonedDateTime.parse("2012-10-31T08:00:00.123Z").toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY)));
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
        }
    }

    @Test
    public void testUnicodeValues() throws Exception {
        String columnName = "t_string";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), columnName, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_unicode_", (List<String>)ImmutableList.of((Object)columnName), "VALUES 'ab\ufad8', 'ab\ud83d\udd74'");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            AddFileEntry entry = (AddFileEntry)Iterables.getOnlyElement(addFileEntries);
            Assertions.assertThat((Optional)entry.getStats()).isPresent();
            DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)entry.getStats().get();
            Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(2L));
            Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"ab\ufad8")));
            Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"ab\ud83d\udd74")));
            Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
        }
    }

    @Test
    public void testPartitionedTable() throws Exception {
        String columnName = "t_string";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), columnName, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
        String partitionColumn = "t_int";
        try (TestTable table = new TestTable("test_partitioned_table_", (List<String>)ImmutableList.of((Object)columnName, (Object)partitionColumn), (List<String>)ImmutableList.of((Object)partitionColumn), "VALUES ('a', 1), ('b', 1), ('c', 1), ('c', 2), ('d', 2), ('e', 2), (null, 1)");){
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            Assertions.assertThat(addFileEntries).hasSize(2);
            for (AddFileEntry addFileEntry : addFileEntries) {
                Assertions.assertThat((Optional)addFileEntry.getStats()).isPresent();
                DeltaLakeFileStatistics fileStatistics = (DeltaLakeFileStatistics)addFileEntry.getStats().get();
                if (((String)addFileEntry.getPartitionValues().get(partitionColumn)).equals("1")) {
                    Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"a")));
                    Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"c")));
                    Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(4L));
                    Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(1L));
                    continue;
                }
                if (!((String)addFileEntry.getPartitionValues().get(partitionColumn)).equals("2")) continue;
                Assertions.assertThat((Optional)fileStatistics.getMinColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"c")));
                Assertions.assertThat((Optional)fileStatistics.getMaxColumnValue(columnHandle)).isEqualTo(Optional.of(Slices.utf8Slice((String)"e")));
                Assertions.assertThat((Optional)fileStatistics.getNumRecords()).isEqualTo(Optional.of(3L));
                Assertions.assertThat((Optional)fileStatistics.getNullCount(columnName)).isEqualTo(Optional.of(0L));
            }
        }
    }

    @Test
    public void testMultiFileTableWithNaNValue() throws Exception {
        String columnName = "key";
        DeltaLakeColumnHandle columnHandle = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
        try (TestTable table = new TestTable("test_multi_file_table_nan_value_", (List<String>)ImmutableList.of((Object)columnName), (List<String>)ImmutableList.of(), "SELECT IF(custkey = 1143, nan(), CAST(custkey AS double)) FROM tpch.tiny.customer");){
            this.assertUpdate("INSERT INTO %s SELECT CAST(nationkey AS double) FROM tpch.tiny.nation".formatted(table.getName()), 25L);
            List<AddFileEntry> addFileEntries = this.getAddFileEntries(table.getName());
            Assertions.assertThat((int)addFileEntries.size()).isGreaterThan(1);
            List statistics = (List)addFileEntries.stream().map(entry -> (DeltaLakeFileStatistics)entry.getStats().get()).collect(ImmutableList.toImmutableList());
            Assertions.assertThat((long)statistics.stream().filter(stat -> stat.getMinColumnValue(columnHandle).isEmpty() && stat.getMaxColumnValue(columnHandle).isEmpty()).count()).isEqualTo(1L);
            Assertions.assertThat((long)statistics.stream().filter(stat -> stat.getMinColumnValue(columnHandle).isPresent() && stat.getMaxColumnValue(columnHandle).isPresent()).count()).isEqualTo((long)(statistics.size() - 1));
        }
    }

    protected List<AddFileEntry> getAddFileEntries(String tableName) throws IOException {
        return TestingDeltaLakeUtils.getTableActiveFiles(this.transactionLogAccess, String.format("s3://%s/%s", this.bucketName, tableName));
    }

    protected class TestTable
    implements AutoCloseable {
        private final String name;

        public TestTable(String name, List<String> columnNames, String values) {
            this(name, columnNames, (List<String>)ImmutableList.of(), values);
        }

        public TestTable(String name, List<String> columnNames, List<String> partitionNames, String values, Session session) {
            this.name = name + TestingNames.randomNameSuffix();
            String columns = columnNames.isEmpty() ? "" : "(" + String.join((CharSequence)",", columnNames) + ")";
            String partitionedBy = partitionNames.isEmpty() ? "" : String.format(", partitioned_by = ARRAY[%s]", partitionNames.stream().map(partitionName -> "'" + partitionName + "'").collect(Collectors.joining(",")));
            TestDeltaLakeCreateTableStatistics.this.computeActual(session, String.format("CREATE TABLE %s %s WITH (location = 's3://%s/%1$s' %s) AS %s", this.name, columns, TestDeltaLakeCreateTableStatistics.this.bucketName, partitionedBy, values));
        }

        public TestTable(String name, List<String> columnNames, List<String> partitionNames, String values) {
            this(name, columnNames, partitionNames, values, this$0.getSession());
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void close() {
            TestDeltaLakeCreateTableStatistics.this.computeActual("DROP TABLE " + this.name);
        }
    }
}

