/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableSet;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class TestDeltaLakeDelete
extends AbstractTestQueryFramework {
    private final String bucketName = "test-delta-lake-connector-test-" + TestingNames.randomNameSuffix();
    private Hive3MinioDataLake hiveMinioDataLake;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        return DeltaLakeQueryRunner.builder().addMetastoreProperties(this.hiveMinioDataLake.getHiveHadoop()).addS3Properties(this.hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
    }

    @Test
    public void testTargetedDeleteWhenTableIsPartitionedWithColumnContainingSpecialCharacters() {
        String tableName = "test_targeted_delete_with_special_characters_in_partition_key";
        this.assertUpdate("CREATE TABLE " + tableName + " (id, col_name) WITH (partitioned_by = ARRAY['col_name'])  AS VALUES (1, 'with-hyphen'), (2, 'with:colon'), (3, 'with:colon'), (4, 'with?question')", 4L);
        this.assertQuery("SELECT count(*), count(DISTINCT \"$path\"), col_name FROM " + tableName + " GROUP BY 3", "VALUES (1, 1, 'with-hyphen'), (2, 1, 'with:colon'), (1, 1, 'with?question')");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE id = 2", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 'with-hyphen'), (3, 'with:colon'), (4, 'with?question')");
        this.assertUpdate("DELETE FROM " + tableName, 3L);
        this.assertQueryReturnsEmptyResult("SELECT * FROM " + tableName);
    }

    @Test
    public void testTargetedDelete() {
        String tableName = "test_targeted_delete";
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM tpch.tiny.orders", "SELECT count(*) FROM orders");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE orderkey = 60000", "VALUES 1");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM orders WHERE orderkey != 60000");
    }

    @Test
    public void testDeleteDatabricksMultiFile() {
        this.testDeleteMultiFile("multi_file_databricks", "io/trino/plugin/deltalake/testing/resources/databricks73");
    }

    @Test
    public void testDeleteOssDeltaLakeMultiFile() {
        this.testDeleteMultiFile("multi_file_deltalake", "io/trino/plugin/deltalake/testing/resources/ossdeltalake");
    }

    private void testDeleteMultiFile(String tableName, String resourcePath) {
        this.hiveMinioDataLake.copyResources(resourcePath + "/lineitem", tableName);
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', 's3://%s/%s')", tableName, this.bucketName, tableName));
        this.assertQuery("SELECT count(*) FROM " + tableName, "SELECT count(*) FROM lineitem");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE partkey % 2 = 0", "SELECT count(*) FROM lineitem WHERE partkey % 2 = 0");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM lineitem WHERE partkey % 2 = 1");
    }

    @Test
    public void testDeleteOnPartitionKey() {
        String tableName = "test_delete_on_partition_key";
        this.assertUpdate("CREATE TABLE " + tableName + " (a, p_key) WITH (partitioned_by = ARRAY['p_key']) AS VALUES (1, 'a'), (2, 'b'), (3, 'c'), (2, 'a'), (null, null), (1, null)", 6L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE p_key IS NULL", "VALUES 2");
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 4");
    }

    @Test
    public void testDeleteFromPartitionedTable() {
        String tableName = "test_delete_from_partitioned_table";
        this.assertUpdate("CREATE TABLE " + tableName + " (a, p_key) WITH (partitioned_by = ARRAY['p_key']) AS VALUES (1, 'a'), (2, 'b'), (3, 'c'), (2, 'a'), (null, null), (1, null)", 6L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a = 2", "VALUES 2");
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 4");
    }

    @Test
    public void testDeleteTimestamps() {
        String tableName = "test_delete_timestamps";
        this.assertUpdate("CREATE TABLE " + tableName + " (ts) AS VALUES TIMESTAMP '2021-02-03 01:02:03.456 UTC', TIMESTAMP '2021-02-04 01:02:03.456 UTC'", 2L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE ts = TIMESTAMP '2021-02-03 01:02:03.456 UTC'", 1L);
        this.assertQuery("SELECT CAST(ts AS VARCHAR) FROM " + tableName, "VALUES '2021-02-04 01:02:03.456 UTC'");
    }

    @Test
    public void testDeleteOnRowType() {
        String tableName = "test_delete_on_row_type";
        this.assertUpdate("CREATE TABLE " + tableName + " (nested, a, b) AS VALUES (CAST(ROW(1, 2) AS ROW(a int, b int)), 2, 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ((1, 2), 2, 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ((2, 1), 2, 1)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " VALUES ((1, 2), null, null)", 1L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a = 1", 0L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE nested.a = 1", 3L);
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 1");
    }

    @Test
    public void testDeleteAllDatabricks() {
        String tableName = "test_delete_all_databricks";
        Set<String> originalFiles = this.testDeleteAllAndReturnInitialDataLakeFilesSet(tableName, "io/trino/plugin/deltalake/testing/resources/databricks73");
        ImmutableSet expected = ImmutableSet.builder().addAll(originalFiles).add((Object)(tableName + "/_delta_log/00000000000000000021.json")).build();
        Assertions.assertThat((List)this.hiveMinioDataLake.listFiles(tableName)).containsExactlyInAnyOrder((Object[])expected.toArray(new String[0]));
    }

    @Test
    public void testDeleteAllOssDeltaLake() {
        String tableName = "test_delete_all_deltalake";
        this.hiveMinioDataLake.copyResources("io/trino/plugin/deltalake/testing/resources/ossdeltalake/customer", tableName);
        ImmutableSet originalFiles = ImmutableSet.copyOf((Collection)this.hiveMinioDataLake.listFiles(tableName));
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', 's3://%s/%s')", tableName, this.bucketName, tableName));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM customer");
        this.assertUpdate("DELETE FROM " + tableName);
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 0");
        ImmutableSet expected = ImmutableSet.builder().addAll((Iterable)originalFiles).add((Object)(tableName + "/_delta_log/00000000000000000001.json")).build();
        Assertions.assertThat((List)this.hiveMinioDataLake.listFiles(tableName)).containsExactlyInAnyOrder((Object[])expected.toArray(new String[0]));
    }

    private Set<String> testDeleteAllAndReturnInitialDataLakeFilesSet(String tableName, String resourcePath) {
        this.hiveMinioDataLake.copyResources(resourcePath + "/customer", tableName);
        ImmutableSet originalFiles = ImmutableSet.copyOf((Collection)this.hiveMinioDataLake.listFiles(tableName));
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', 's3://%s/%s')", tableName, this.bucketName, tableName));
        this.assertQuery("SELECT * FROM " + tableName, "SELECT * FROM customer");
        this.assertUpdate("DELETE FROM " + tableName, "SELECT count(*) FROM customer");
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 0");
        return originalFiles;
    }

    @Test
    public void testStatsAfterDelete() {
        String tableName = "test_stats_after_delete";
        this.assertUpdate("CREATE TABLE " + tableName + " (a, b, c) AS VALUES (1, 3, 5), (7, 9, null), (null, null, null), (null, null, null)", 4L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('a', null, 2.0, 0.5, null, 1, 7),('b', null, 2.0, 0.5, null, 3, 9),('c', null, 1.0, 0.75, null, 5, 5),(null, null, null, null, 4.0, null, null)");
        this.assertUpdate("DELETE FROM " + tableName + " WHERE c IS NULL", 3L);
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('a', null, 1.0, 0.0, null, 1, 1),('b', null, 1.0, 0.0, null, 3, 3),('c', null, 1.0, 0.0, null, 5, 5),(null, null, null, null, 1.0, null, null)");
    }

    @Test
    public void testDeleteWithHiddenColumn() {
        String tableName = "test_delete_with_hidden_column";
        this.assertUpdate("CREATE TABLE " + tableName + " (a, b, c) AS VALUES (1, 3, 5), (2, 4, 6), (null, null, null), (0, 0, 0)", 4L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE \"$file_size\" > 0", 4L);
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 0");
    }

    @Test
    public void testDeleteWithRowFilter() {
        String tableName = "test_delete_with_row_filter";
        this.assertUpdate("CREATE TABLE " + tableName + " WITH (partitioned_by = ARRAY['regionkey']) AS SELECT nationkey, regionkey FROM tpch.tiny.nation", 25L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE regionkey = 4 AND nationkey < 100", "SELECT count(*) FROM nation WHERE regionkey = 4 AND nationkey < 100");
        this.assertQuery("SELECT * FROM " + tableName, "SELECT nationkey, regionkey FROM nation WHERE regionkey != 4 OR nationkey >= 100");
    }

    @Test
    public void testDeleteMultiplePartitionKeys() {
        String tableName = "test_delete_multiple_partition_keys";
        this.assertUpdate("CREATE TABLE " + tableName + " (a, b, c) WITH (partitioned_by = ARRAY['b', 'c']) AS VALUES (1, 2, 3), (1, 2, 4), (3, 2, 1), (null, null, null), (1, 1, 1)", 5L);
        this.assertUpdate("DELETE FROM " + tableName + " WHERE a = 1 AND c = 3", "VALUES 1");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 2, 4), (3, 2, 1), (null, null, null), (1, 1, 1)");
    }
}

