/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.QueryStats;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import io.trino.split.SplitSource;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.tpch.TpchTable;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class TestDeltaLakeDynamicFiltering
extends AbstractTestQueryFramework {
    private final String bucketName = "delta-lake-test-dynamic-filtering-" + TestingNames.randomNameSuffix();
    private Hive3MinioDataLake hiveMinioDataLake;

    protected QueryRunner createQueryRunner() throws Exception {
        Verify.verify((boolean)new DynamicFilterConfig().isEnableDynamicFiltering(), (String)"this class assumes dynamic filtering is enabled by default", (Object[])new Object[0]);
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        DistributedQueryRunner queryRunner = DeltaLakeQueryRunner.builder().addMetastoreProperties(this.hiveMinioDataLake.getHiveHadoop()).addS3Properties(this.hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
        ImmutableList.of((Object)TpchTable.LINE_ITEM, (Object)TpchTable.ORDERS).forEach(arg_0 -> this.lambda$createQueryRunner$0((QueryRunner)queryRunner, arg_0));
        return queryRunner;
    }

    @Test
    @Timeout(value=60L)
    public void testDynamicFiltering() {
        for (OptimizerConfig.JoinDistributionType joinDistributionType : OptimizerConfig.JoinDistributionType.values()) {
            String query = "SELECT * FROM lineitem JOIN orders ON lineitem.orderkey = orders.orderkey AND orders.totalprice > 59995 AND orders.totalprice < 60000";
            QueryRunner.MaterializedResultWithPlan filteredResult = this.getDistributedQueryRunner().executeWithPlan(this.sessionWithDynamicFiltering(true, joinDistributionType), query);
            QueryRunner.MaterializedResultWithPlan unfilteredResult = this.getDistributedQueryRunner().executeWithPlan(this.sessionWithDynamicFiltering(false, joinDistributionType), query);
            Assertions.assertThat((List)filteredResult.result().getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)unfilteredResult.result().getMaterializedRows());
            QueryStats filteredStats = this.getQueryStats(filteredResult.queryId());
            QueryStats unfilteredStats = this.getQueryStats(unfilteredResult.queryId());
            Assertions.assertThat((long)unfilteredStats.getPhysicalInputPositions()).isGreaterThan(filteredStats.getPhysicalInputPositions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testIncompleteDynamicFilterTimeout() throws Exception {
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        QueryRunner runner = this.getQueryRunner();
        TransactionManager transactionManager = runner.getTransactionManager();
        TransactionId transactionId = transactionManager.beginTransaction(true);
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("delta", "dynamic_filtering_wait_timeout", "1s").build().beginTransactionId(transactionId, transactionManager, (AccessControl)new AllowAllAccessControl());
        QualifiedObjectName tableName = new QualifiedObjectName("delta", schemaName, "orders");
        TableHandle tableHandle = (TableHandle)runner.getPlannerContext().getMetadata().getTableHandle(session, tableName).orElseThrow();
        CompletableFuture<Object> dynamicFilterBlocked = new CompletableFuture<Object>();
        try {
            SplitSource splitSource = runner.getSplitManager().getSplits(session, Span.getInvalid(), tableHandle, (DynamicFilter)new BlockedDynamicFilter(dynamicFilterBlocked), Constraint.alwaysTrue());
            ArrayList splits = new ArrayList();
            while (!splitSource.isFinished()) {
                splits.addAll(((SplitSource.SplitBatch)splitSource.getNextBatch(1000).get()).getSplits());
            }
            splitSource.close();
            Assertions.assertThat(splits).isNotEmpty();
        }
        finally {
            dynamicFilterBlocked.complete(null);
        }
    }

    private Session sessionWithDynamicFiltering(boolean enabled, OptimizerConfig.JoinDistributionType joinDistributionType) {
        return Session.builder((Session)this.noJoinReordering(joinDistributionType)).setSystemProperty("enable_dynamic_filtering", String.valueOf(enabled)).setCatalogSessionProperty("delta", "dynamic_filtering_wait_timeout", "1h").build();
    }

    private QueryStats getQueryStats(QueryId queryId) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats();
    }

    private /* synthetic */ void lambda$createQueryRunner$0(QueryRunner queryRunner, TpchTable table) {
        String tableName = table.getTableName();
        this.hiveMinioDataLake.copyResources("io/trino/plugin/deltalake/testing/resources/databricks73/" + tableName, tableName);
        queryRunner.execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%1$s', 's3://%2$s/%1$s')", tableName, this.bucketName));
    }

    private static class BlockedDynamicFilter
    implements DynamicFilter {
        private final CompletableFuture<?> isBlocked;

        public BlockedDynamicFilter(CompletableFuture<?> isBlocked) {
            this.isBlocked = Objects.requireNonNull(isBlocked, "isBlocked is null");
        }

        public Set<ColumnHandle> getColumnsCovered() {
            return ImmutableSet.of();
        }

        public CompletableFuture<?> isBlocked() {
            return this.isBlocked;
        }

        public boolean isComplete() {
            return false;
        }

        public boolean isAwaitable() {
            return true;
        }

        public TupleDomain<ColumnHandle> getCurrentPredicate() {
            return TupleDomain.all();
        }
    }
}

