/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.testing.BaseDynamicPartitionPruningTest;
import io.trino.testing.QueryRunner;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeDynamicPartitionPruningTest
extends BaseDynamicPartitionPruningTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().setExtraProperties(EXTRA_PROPERTIES)).addDeltaProperty("delta.dynamic-filtering.wait-timeout", "1h").addDeltaProperty("delta.enable-non-concurrent-writes", "true").setInitialTables(REQUIRED_TABLES).build();
    }

    @Test
    public void testJoinDynamicFilteringMultiJoinOnBucketedTables() {
        Assumptions.abort((String)"Delta Lake does not support bucketing");
    }

    protected void createLineitemTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s WITH (partitioned_by=ARRAY[%s]) AS SELECT %s FROM tpch.tiny.lineitem", tableName, partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")), String.join((CharSequence)",", columns));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedTable(String tableName, List<String> columns, List<String> partitionColumns) {
        String sql = String.format("CREATE TABLE %s (%s) WITH (location='%s', partitioned_by=ARRAY[%s])", tableName, String.join((CharSequence)",", columns), TestDeltaLakeDynamicPartitionPruningTest.createTableLocation(tableName), partitionColumns.stream().map(column -> "'" + column + "'").collect(Collectors.joining(",")));
        this.getQueryRunner().execute(sql);
    }

    protected void createPartitionedAndBucketedTable(String tableName, List<String> columns, List<String> partitionColumns, List<String> bucketColumns) {
        throw new UnsupportedOperationException();
    }

    private static URI createTableLocation(String tableName) {
        try {
            return Files.createTempDirectory(tableName, new FileAttribute[0]).toFile().toURI();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

