/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.Session;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.Table;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDeltaLakeFileOperations
extends AbstractTestQueryFramework {
    private static final int MAX_PREFIXES_COUNT = 10;
    private HiveMetastore metastore;
    private DeltaLakeTableMetadataScheduler metadataScheduler;

    protected QueryRunner createQueryRunner() throws Exception {
        Path catalogDir = Files.createTempDirectory("catalog-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)catalogDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        DistributedQueryRunner queryRunner = ((DeltaLakeQueryRunner.Builder)DeltaLakeQueryRunner.builder().addCoordinatorProperty("optimizer.experimental-max-prefetched-information-schema-prefixes", Integer.toString(10))).addDeltaProperty("hive.metastore.catalog.dir", catalogDir.toUri().toString()).addDeltaProperty("delta.enable-non-concurrent-writes", "true").addDeltaProperty("delta.register-table-procedure.enabled", "true").addDeltaProperty("delta.metastore.store-table-metadata", "true").addDeltaProperty("delta.metastore.store-table-metadata-threads", "0").addDeltaProperty("delta.metastore.store-table-metadata-interval", "30m").build();
        this.metastore = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        this.metadataScheduler = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, DeltaLakeTableMetadataScheduler.class);
        return queryRunner;
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertFileSystemAccesses("CREATE TABLE test_create_as_select AS SELECT 1 col_name", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "OutputFile.create")).add((Object)new FileOperation(FileType.DATA, "no partition", "OutputFile.create")).build());
        this.assertUpdate("DROP TABLE test_create_as_select");
        this.assertFileSystemAccesses("CREATE TABLE test_create_partitioned_as_select WITH (partitioned_by=ARRAY['key']) AS SELECT * FROM (VALUES (1, 'a'), (2, 'b')) t(key, col)", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "OutputFile.create")).add((Object)new FileOperation(FileType.DATA, "key=1/", "OutputFile.create")).add((Object)new FileOperation(FileType.DATA, "key=2/", "OutputFile.create")).build());
        this.assertUpdate("DROP TABLE test_create_partitioned_as_select");
    }

    @Test
    public void testCreateOrReplaceTable() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "OutputFile.create")).build());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.exists")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertUpdate("DROP TABLE test_create_or_replace");
    }

    @Test
    public void testCreateOrReplaceTableAsSelect() {
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "OutputFile.create")).add((Object)new FileOperation(FileType.DATA, "no partition", "OutputFile.create")).build());
        this.assertFileSystemAccesses("CREATE OR REPLACE TABLE test_create_or_replace_as_select AS SELECT 1 col_name", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.DATA, "no partition", "OutputFile.create")).build());
        this.assertUpdate("DROP TABLE test_create_or_replace_as_select");
    }

    @Test
    public void testReadUnpartitionedTable() {
        this.assertUpdate("DROP TABLE IF EXISTS test_read_unpartitioned");
        this.assertUpdate("CREATE TABLE test_read_unpartitioned(key varchar, data varchar)");
        this.assertUpdate("INSERT INTO test_read_unpartitioned(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_read_unpartitioned(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_unpartitioned')");
        this.assertFileSystemAccesses("TABLE test_read_unpartitioned", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_unpartitioned')");
        this.assertFileSystemAccesses("SELECT key, max(data) FROM test_read_unpartitioned GROUP BY key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertUpdate("DROP TABLE test_read_unpartitioned");
    }

    @Test
    public void testReadTableCheckpointInterval() {
        this.assertUpdate("DROP TABLE IF EXISTS test_read_checkpoint");
        this.assertUpdate("CREATE TABLE test_read_checkpoint(key varchar, data varchar) WITH (checkpoint_interval = 2)");
        this.assertUpdate("INSERT INTO test_read_checkpoint(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_read_checkpoint(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_checkpoint')");
        this.assertFileSystemAccesses("TABLE test_read_checkpoint", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000002.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000002.checkpoint.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertUpdate("DROP TABLE test_read_checkpoint");
    }

    @Test
    public void testReadPartitionTableWithCheckpointFiltering() {
        this.assertUpdate("DROP TABLE IF EXISTS test_checkpoint_filtering");
        this.assertUpdate("CREATE TABLE test_checkpoint_filtering(key varchar, data varchar) WITH (partitioned_by = ARRAY['key'], checkpoint_interval = 2)");
        this.assertUpdate("INSERT INTO test_checkpoint_filtering(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_checkpoint_filtering(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_checkpoint_filtering')");
        this.assertFileSystemAccesses("TABLE test_checkpoint_filtering", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000002.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000002.checkpoint.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "key=p1/", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "key=p2/", "InputFile.newInput"), 2).build());
        this.assertUpdate("DROP TABLE test_checkpoint_filtering");
    }

    @Test
    public void testReadWholePartition() {
        this.assertUpdate("DROP TABLE IF EXISTS test_read_part_key");
        this.assertUpdate("CREATE TABLE test_read_part_key(key varchar, data varchar) WITH (partitioned_by=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_read_part_key(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_read_part_key(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("TABLE test_read_part_key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "key=p1/", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "key=p2/", "InputFile.newInput"), 2).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("SELECT key, max(data) FROM test_read_part_key GROUP BY key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.DATA, "key=p1/", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "key=p2/", "InputFile.newInput"), 2).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("SELECT key, count(*) FROM test_read_part_key GROUP BY key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("SELECT count(*) FROM test_read_part_key WHERE key = 'p1'", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("SELECT count(*), array_agg(\"$path\"), max(\"$file_modified_time\") FROM test_read_part_key GROUP BY key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_part_key')");
        this.assertFileSystemAccesses("SELECT count(*) FROM test_read_part_key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
        this.assertUpdate("DROP TABLE test_read_part_key");
    }

    @Test
    public void testReadWholePartitionSplittableFile() {
        String catalog = (String)this.getSession().getCatalog().orElseThrow();
        this.assertUpdate("DROP TABLE IF EXISTS test_read_whole_splittable_file");
        this.assertUpdate("CREATE TABLE test_read_whole_splittable_file(key varchar, data varchar) WITH (partitioned_by=ARRAY['key'])");
        this.assertUpdate(Session.builder((Session)this.getSession()).setSystemProperty("writer_scaling_min_data_processed", "1PB").build(), "INSERT INTO test_read_whole_splittable_file SELECT 'single partition', comment FROM tpch.tiny.orders", 15000L);
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty(catalog, "max_split_size", "1kB").build();
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_whole_splittable_file')");
        this.assertFileSystemAccesses(session, "SELECT key, count(*) FROM test_read_whole_splittable_file GROUP BY key", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).build());
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_read_whole_splittable_file')");
        this.assertFileSystemAccesses(session, "SELECT count(*) FROM test_read_whole_splittable_file", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).build());
        this.assertUpdate("DROP TABLE test_read_whole_splittable_file");
    }

    @Test
    public void testSelfJoin() {
        this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 as age, 0 parent, 3 AS id", 1L);
        Session sessionWithoutDynamicFiltering = Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").build();
        this.assertFileSystemAccesses(sessionWithoutDynamicFiltering, "SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertUpdate("DROP TABLE test_self_join_table");
    }

    @Test
    public void testSelectFromVersionedTable() {
        String tableName = "test_select_from_versioned_table" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id int)");
        for (int i = 0; i < 25; ++i) {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + i, 1L);
        }
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 0", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 1", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists")).add((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 2", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 8", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000006.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000007.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000008.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000006.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000007.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000008.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000008.json", "InputFile.exists")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 8).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 13", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000010.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000010.checkpoint.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000011.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000012.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000013.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000011.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000012.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000013.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000013.json", "InputFile.exists")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 13).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 20", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.exists")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 20).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR VERSION AS OF 23", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000022.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000023.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000022.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000023.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000023.json", "InputFile.exists")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 23).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testSelectFromTemporalVersionedTable() throws InterruptedException {
        DateTimeFormatter timestampWithTimeZoneFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS VV");
        String tableName = "test_select_from_temporal_versioned_table" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + "(id int)");
        String timeAfterCreateTable = ZonedDateTime.now().format(timestampWithTimeZoneFormatter);
        ArrayList<String> timesAfterInsert = new ArrayList<String>();
        for (int i = 0; i < 25; ++i) {
            this.assertUpdate("INSERT INTO " + tableName + " VALUES " + i, 1L);
            timesAfterInsert.add(ZonedDateTime.now().format(timestampWithTimeZoneFormatter));
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        ImmutableList.Builder allVersionOperationsBuilder = ImmutableList.builder();
        for (int i = 0; i <= 25; ++i) {
            allVersionOperationsBuilder.add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "%020d.json".formatted(i), "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "%020d.json".formatted(i), "InputFile.length"));
        }
        ImmutableList allInsertOperations = allVersionOperationsBuilder.build();
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + timeAfterCreateTable + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(0, 41)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.length")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(1) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(0, 41)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 2).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(2) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(0, 41)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 3).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(8) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(0, 41)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000009.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000009.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 9).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(13) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(22, 41)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000014.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000014.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000020.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000010.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000010.checkpoint.parquet", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 14).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(20) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(40, 45)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000022.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 21).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName + " FOR TIMESTAMP AS OF TIMESTAMP '" + (String)timesAfterInsert.get(23) + "'", (Multiset<FileOperation>)ImmutableMultiset.builder().addAll(allInsertOperations.subList(40, 51)).addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000021.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000022.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000022.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000023.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000023.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000024.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000024.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000025.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000020.checkpoint.parquet", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 24).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeleteWholePartition() {
        this.assertUpdate("DROP TABLE IF EXISTS test_delete_part_key");
        this.assertUpdate("CREATE TABLE test_delete_part_key(key varchar, data varchar) WITH (partitioned_by=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_delete_part_key(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_delete_part_key(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_delete_part_key')");
        this.assertFileSystemAccesses("DELETE FROM test_delete_part_key WHERE key = 'p1'", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
        this.assertUpdate("DROP TABLE test_delete_part_key");
    }

    @Test
    public void testDeleteWholeTable() {
        this.assertUpdate("DROP TABLE IF EXISTS test_delete_whole_table");
        this.assertUpdate("CREATE TABLE test_delete_whole_table(key varchar, data varchar)");
        this.assertUpdate("INSERT INTO test_delete_whole_table(key, data) VALUES ('p1', '1-abc'), ('p1', '1-def'), ('p2', '2-abc'), ('p2', '2-def')", 4L);
        this.assertUpdate("INSERT INTO test_delete_whole_table(key, data) VALUES ('p1', '1-baz'), ('p2', '2-baz')", 2L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_delete_whole_table')");
        this.assertFileSystemAccesses("DELETE FROM test_delete_whole_table WHERE true", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
        this.assertUpdate("DROP TABLE test_delete_whole_table");
    }

    @Test
    public void testDeleteWithNonPartitionFilter() {
        this.assertUpdate("CREATE TABLE test_delete_with_non_partition_filter (page_url VARCHAR, key VARCHAR, views INTEGER) WITH (partitioned_by=ARRAY['key'])");
        this.assertUpdate("INSERT INTO test_delete_with_non_partition_filter VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO test_delete_with_non_partition_filter VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO test_delete_with_non_partition_filter VALUES('url3', 'domain3', 3)", 1L);
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'test_delete_with_non_partition_filter')");
        this.assertFileSystemAccesses("DELETE FROM test_delete_with_non_partition_filter WHERE page_url ='url1'", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.exists")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "OutputFile.createOrOverwrite")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "key=domain1/", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.DATA, "key=domain1/", "InputFile.length")).add((Object)new FileOperation(FileType.DATA, "key=domain1/", "OutputFile.create")).build());
        this.assertUpdate("DROP TABLE test_delete_with_non_partition_filter");
    }

    @Test
    public void testHistorySystemTable() {
        this.assertUpdate("CREATE TABLE test_history_system_table (a INT, b INT)");
        this.assertUpdate("INSERT INTO test_history_system_table VALUES (1, 2)", 1L);
        this.assertUpdate("INSERT INTO test_history_system_table VALUES (2, 3)", 1L);
        this.assertUpdate("INSERT INTO test_history_system_table VALUES (3, 4)", 1L);
        this.assertUpdate("INSERT INTO test_history_system_table VALUES (4, 5)", 1L);
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\"", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\" WHERE version = 3", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\" WHERE version > 3", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\" WHERE version >= 3 OR version = 1", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\" WHERE version >= 1 AND version < 3", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        this.assertFileSystemAccesses("SELECT * FROM \"test_history_system_table$history\" WHERE version > 1 AND version < 2", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
    }

    @Test
    public void testTableChangesFileSystemAccess() {
        this.assertUpdate("CREATE TABLE table_changes_file_system_access (page_url VARCHAR, key VARCHAR, views INTEGER) WITH (change_data_feed_enabled = true, partitioned_by=ARRAY['key'])");
        this.assertUpdate("INSERT INTO table_changes_file_system_access VALUES('url1', 'domain1', 1)", 1L);
        this.assertUpdate("INSERT INTO table_changes_file_system_access VALUES('url2', 'domain2', 2)", 1L);
        this.assertUpdate("INSERT INTO table_changes_file_system_access VALUES('url3', 'domain3', 3)", 1L);
        this.assertUpdate("UPDATE table_changes_file_system_access SET page_url = 'url22' WHERE key = 'domain2'", 1L);
        this.assertUpdate("UPDATE table_changes_file_system_access SET page_url = 'url33' WHERE views = 3", 1L);
        this.assertUpdate("DELETE FROM table_changes_file_system_access WHERE page_url = 'url1'", 1L);
        int cdfFilesForDomain2 = this.countCdfFilesForKey("domain2");
        int cdfFilesForDomain3 = this.countCdfFilesForKey("domain3");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'table_changes_file_system_access')");
        this.assertFileSystemAccesses("SELECT * FROM TABLE(system.table_changes(CURRENT_SCHEMA, 'table_changes_file_system_access'))", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000006.json", "InputFile.newStream"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000006.json", "InputFile.length"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000007.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.CDF_DATA, "key=domain1/", "InputFile.newInput")).addCopies((Object)new FileOperation(FileType.CDF_DATA, "key=domain2/", "InputFile.newInput"), cdfFilesForDomain2).addCopies((Object)new FileOperation(FileType.CDF_DATA, "key=domain3/", "InputFile.newInput"), cdfFilesForDomain3).add((Object)new FileOperation(FileType.DATA, "key=domain1/", "InputFile.newInput")).add((Object)new FileOperation(FileType.DATA, "key=domain2/", "InputFile.newInput")).add((Object)new FileOperation(FileType.DATA, "key=domain3/", "InputFile.newInput")).build());
    }

    @Test
    public void testInformationSchemaColumns() {
        this.testInformationSchemaColumns(true);
        this.testInformationSchemaColumns(false);
    }

    private void testInformationSchemaColumns(boolean removeCachedProperties) {
        for (int tables : Arrays.asList(3, 10, 13)) {
            int i;
            String schemaName = "test_i_s_columns_schema" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            for (i = 0; i < tables; ++i) {
                this.assertUpdate(session, "CREATE TABLE test_select_i_s_columns" + i + "(id varchar, age integer)");
                this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('abc', 11)", 1L);
                this.assertUpdate(session, "INSERT INTO test_select_i_s_columns" + i + " VALUES ('xyz', 12)", 1L);
                this.assertUpdate(session, "CREATE TABLE test_other_select_i_s_columns" + i + "(id varchar, age integer)");
                if (!removeCachedProperties) continue;
                this.removeLastTransactionVersionFromMetastore(schemaName, "test_select_i_s_columns" + i);
                this.removeLastTransactionVersionFromMetastore(schemaName, "test_other_select_i_s_columns" + i);
                this.metadataScheduler.clear();
            }
            this.metadataScheduler.process();
            this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA", (Multiset<FileOperation>)(removeCachedProperties ? ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), tables).build() : ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build()));
            this.metadataScheduler.process();
            this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns%'", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name = 'test_select_i_s_columns0'", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA AND table_name LIKE 'test_select_i_s_columns0'", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "DESCRIBE test_select_i_s_columns0", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
            for (i = 0; i < tables; ++i) {
                this.assertUpdate(session, "DROP TABLE test_select_i_s_columns" + i);
                this.assertUpdate(session, "DROP TABLE test_other_select_i_s_columns" + i);
            }
        }
    }

    @Test
    public void testSystemMetadataTableComments() {
        this.testSystemMetadataTableComments(true);
        this.testSystemMetadataTableComments(false);
    }

    private void testSystemMetadataTableComments(boolean removeCachedProperties) {
        for (int tables : Arrays.asList(3, 10, 13)) {
            int i;
            String schemaName = "test_s_m_table_comments" + TestingNames.randomNameSuffix();
            this.assertUpdate("CREATE SCHEMA " + schemaName);
            Session session = Session.builder((Session)this.getSession()).setSchema(schemaName).build();
            for (i = 0; i < tables; ++i) {
                this.assertUpdate(session, "CREATE TABLE test_select_s_m_t_comments" + i + "(id varchar, age integer)");
                this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('abc', 11)", 1L);
                this.assertUpdate(session, "INSERT INTO test_select_s_m_t_comments" + i + " VALUES ('xyz', 12)", 1L);
                this.assertUpdate(session, "CREATE TABLE test_other_select_s_m_t_comments" + i + "(id varchar, age integer)");
                if (!removeCachedProperties) continue;
                this.removeLastTransactionVersionFromMetastore(schemaName, "test_select_s_m_t_comments" + i);
                this.removeLastTransactionVersionFromMetastore(schemaName, "test_other_select_s_m_t_comments" + i);
                this.metadataScheduler.clear();
            }
            this.metadataScheduler.process();
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA", (Multiset<FileOperation>)(removeCachedProperties ? ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length"), tables * 2).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length"), tables).build() : ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build()));
            this.metadataScheduler.process();
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name IN (CURRENT_SCHEMA, 'non_existent') AND table_name LIKE 'test_select_s_m_t_comments%'", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name = 'test_select_s_m_t_comments0'", (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).build());
            this.assertFileSystemAccesses(session, "SELECT * FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA AND table_name LIKE 'test_select_s_m_t_comments0'", (Multiset<FileOperation>)ImmutableMultiset.builder().addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.exists"), tables).addCopies((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.exists"), tables).build());
            for (i = 0; i < tables; ++i) {
                this.assertUpdate(session, "DROP TABLE test_select_s_m_t_comments" + i);
                this.assertUpdate(session, "DROP TABLE test_other_select_s_m_t_comments" + i);
            }
        }
    }

    @Test
    public void testShowTables() {
        this.assertFileSystemAccesses("SHOW TABLES", (Multiset<FileOperation>)ImmutableMultiset.of());
    }

    @Test
    public void testReadMultipartCheckpoint() throws Exception {
        String tableName = "test_multipart_checkpoint_" + TestingNames.randomNameSuffix();
        Path tableLocation = Files.createTempFile(tableName, null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"deltalake/multipart_checkpoint").toURI()).toPath(), tableLocation);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation.toUri()));
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000006.checkpoint.0000000001.0000000002.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000006.checkpoint.0000000001.0000000002.parquet", "InputFile.newInput"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000006.checkpoint.0000000002.0000000002.parquet", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000006.checkpoint.0000000002.0000000002.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000007.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000007.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000008.json", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 7).build());
    }

    @Test
    public void testReadMultipartV2Checkpoint() throws Exception {
        String tableName = "test_multipart_v2_checkpoint_" + TestingNames.randomNameSuffix();
        Path tableLocation = Files.createTempFile(tableName, null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"deltalake/multipart_v2_checkpoint").toURI()).toPath(), tableLocation);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation.toUri()));
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.42f48375-5c72-4d2f-8dcc-7ce4d45e2d8c.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.42f48375-5c72-4d2f-8dcc-7ce4d45e2d8c.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000001.0000000004.9f573e40-495e-4fb5-9a86-638dbdf0909e.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000001.0000000004.9f573e40-495e-4fb5-9a86-638dbdf0909e.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000002.0000000004.72848a80-e6d1-40fd-b702-344ecbb4c2fa.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000002.0000000004.72848a80-e6d1-40fd-b702-344ecbb4c2fa.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000003.0000000004.93080a9b-6c0d-4a19-ac28-e3654e3096f9.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000003.0000000004.93080a9b-6c0d-4a19-ac28-e3654e3096f9.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000004.0000000004.994ab05a-4806-4f96-8e7b-5dcf653a8e48.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000004.checkpoint.0000000004.0000000004.994ab05a-4806-4f96-8e7b-5dcf653a8e48.parquet", "InputFile.length")).addCopies((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput"), 4).build());
    }

    @Test
    public void testV2CheckpointJson() throws Exception {
        String tableName = "test_v2_checkpoint_json_" + TestingNames.randomNameSuffix();
        Path tableLocation = Files.createTempFile(tableName, null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"deltalake/v2_checkpoint_json").toURI()).toPath(), tableLocation);
        this.assertFileSystemAccesses("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation.toUri()), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", "InputFile.length"), 2).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.73a4ddb8-2bfc-40d8-b09f-1b6a0abdfb04.json", "InputFile.newStream"), 2).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.0000000001.0000000001.90cf4e21-dbaa-41d6-8ae5-6709cfbfbfe0.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput")).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testV2CheckpointParquet() throws Exception {
        String tableName = "test_v2_checkpoint_parquet_" + TestingNames.randomNameSuffix();
        Path tableLocation = Files.createTempFile(tableName, null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"deltalake/v2_checkpoint_parquet").toURI()).toPath(), tableLocation);
        this.assertFileSystemAccesses("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, tableLocation.toUri()), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", "InputFile.length"), 2).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).build());
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", "InputFile.length"), 4).addCopies((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.156b3304-76b2-49c3-a9a1-626f07df27c9.parquet", "InputFile.newInput"), 2).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000001.checkpoint.0000000001.0000000001.03288d7e-af16-44ed-829c-196064a71812.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput")).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testDeletionVectors() {
        String tableName = "test_deletion_vectors_" + TestingNames.randomNameSuffix();
        this.registerTable(tableName, "databricks122/deletion_vectors");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => '%s')".formatted(tableName));
        this.assertFileSystemAccesses("SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.DELETION_VECTOR, "deletion_vector_a52eda8c-0a57-4636-814b-9c165388f7ca.bin", "InputFile.newInput")).add((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput")).build());
        this.assertFileSystemAccesses("EXPLAIN ANALYZE SELECT * FROM " + tableName, (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, "extendeded_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, "extended_stats.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).add((Object)new FileOperation(FileType.DELETION_VECTOR, "deletion_vector_a52eda8c-0a57-4636-814b-9c165388f7ca.bin", "InputFile.newInput")).add((Object)new FileOperation(FileType.DATA, "no partition", "InputFile.newInput")).build());
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testReadMetadataAndProtocolEntry() {
        try (TestTable table = this.newTrinoTable("test_read_metadata_protocol", "(data int , part varchar) WITH (checkpoint_interval = 3)");){
            this.assertFileSystemAccesses("SHOW CREATE TABLE " + table.getName(), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (1, 'aa')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (2, 'bb')", 1L);
            this.assertFileSystemAccesses("SHOW CREATE TABLE " + table.getName(), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000000.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000001.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000002.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000003.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (3, 'cc')", 1L);
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES (4, 'dd')", 1L);
            this.assertFileSystemAccesses("SHOW CREATE TABLE " + table.getName(), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000003.checkpoint.parquet", "InputFile.newInput")).add((Object)new FileOperation(FileType.CHECKPOINT, "00000000000000000003.checkpoint.parquet", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
            this.assertUpdate("ALTER TABLE " + table.getName() + " ADD COLUMN y int");
            this.assertFileSystemAccesses("SHOW CREATE TABLE " + table.getName(), (Multiset<FileOperation>)ImmutableMultiset.builder().add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000004.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.length")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000005.json", "InputFile.newStream")).add((Object)new FileOperation(FileType.TRANSACTION_LOG_JSON, "00000000000000000006.json", "InputFile.length")).add((Object)new FileOperation(FileType.LAST_CHECKPOINT, "_last_checkpoint", "InputFile.newStream")).build());
        }
    }

    private int countCdfFilesForKey(String partitionValue) {
        String path = (String)this.computeScalar("SELECT \"$path\" FROM table_changes_file_system_access WHERE key = '" + partitionValue + "'");
        String partitionKey = "key=" + partitionValue;
        String tableLocation = path.substring(0, path.lastIndexOf(partitionKey));
        String partitionCdfFolder = URI.create(tableLocation).getPath() + "_change_data/" + partitionKey + "/";
        return Math.toIntExact(Arrays.stream(new File(partitionCdfFolder).list()).filter(file -> !file.contains(".crc")).count());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<FileOperation> expectedAccesses) {
        this.assertFileSystemAccesses(this.getSession(), query, expectedAccesses);
    }

    private void assertFileSystemAccesses(Session session, @Language(value="SQL") String query, Multiset<FileOperation> expectedAccesses) {
        this.assertUpdate("CALL system.flush_metadata_cache()");
        this.getDistributedQueryRunner().executeWithPlan(session, query);
        List spanData = this.getDistributedQueryRunner().getSpans();
        MultisetAssertions.assertMultisetsEqual(this.getOperations(spanData), expectedAccesses);
    }

    private Multiset<FileOperation> getOperations(List<SpanData> spanData) {
        return (Multiset)spanData.stream().filter(span -> span.getName().startsWith("InputFile.") || span.getName().startsWith("OutputFile.")).filter(span -> {
            String path = Objects.requireNonNull((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION), "FILE_LOCATION attribute is empty");
            return !path.endsWith(".trinoSchema") && !path.contains(".trinoPermissions");
        }).map(span -> FileOperation.create((String)span.getAttributes().get(FileSystemAttributes.FILE_LOCATION), span.getName())).collect(Collectors.toCollection(HashMultiset::create));
    }

    private void registerTable(String name, String resourcePath) {
        String dataPath = this.getResourceLocation(resourcePath).toExternalForm();
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", name, dataPath));
    }

    private URL getResourceLocation(String resourcePath) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource(resourcePath);
    }

    private void removeLastTransactionVersionFromMetastore(String schemaName, String tableName) {
        Table table = (Table)this.metastore.getTable(schemaName, tableName).orElseThrow();
        Table newMetastoreTable = Table.builder((Table)table).setParameters(Maps.filterKeys((Map)table.getParameters(), key -> !key.equals("trino_last_transaction_version"))).build();
        this.metastore.replaceTable(table.getDatabaseName(), table.getTableName(), newMetastoreTable, MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow())), (Map)ImmutableMap.of());
    }

    private record FileOperation(FileType fileType, String fileId, String operationType) {
        public FileOperation {
            Objects.requireNonNull(fileType, "fileType is null");
            Objects.requireNonNull(fileId, "fileId is null");
            Objects.requireNonNull(operationType, "operationType is null");
        }

        public static FileOperation create(String path, String operationType) {
            Matcher matcher;
            String fileName = path.replaceFirst(".*/", "");
            if (path.matches(".*/_delta_log/_last_checkpoint")) {
                return new FileOperation(FileType.LAST_CHECKPOINT, fileName, operationType);
            }
            if (path.matches(".*/_delta_log/.*.checkpoint.*")) {
                return new FileOperation(FileType.CHECKPOINT, fileName, operationType);
            }
            if (path.matches(".*/_delta_log/\\d+\\.json")) {
                return new FileOperation(FileType.TRANSACTION_LOG_JSON, fileName, operationType);
            }
            if (path.matches(".*/_delta_log/_trino_meta/extended_stats.json")) {
                return new FileOperation(FileType.TRINO_EXTENDED_STATS_JSON, fileName, operationType);
            }
            if (path.matches(".*/_delta_log/_starburst_meta/extendeded_stats.json")) {
                return new FileOperation(FileType.STARBURST_EXTENDED_STATS_JSON, fileName, operationType);
            }
            if (path.contains("/deletion_vector_")) {
                return new FileOperation(FileType.DELETION_VECTOR, fileName, operationType);
            }
            Pattern dataFilePattern = Pattern.compile(".*?/(?<partition>key=[^/]*/)?[^/]+");
            if (path.matches(".*/_change_data/.*") && (matcher = dataFilePattern.matcher(path)).matches()) {
                return new FileOperation(FileType.CDF_DATA, matcher.group("partition"), operationType);
            }
            if (!path.contains("_delta_log") && (matcher = dataFilePattern.matcher(path)).matches()) {
                return new FileOperation(FileType.DATA, (String)MoreObjects.firstNonNull((Object)matcher.group("partition"), (Object)"no partition"), operationType);
            }
            throw new IllegalArgumentException("File not recognized: " + path);
        }
    }

    static enum FileType {
        LAST_CHECKPOINT,
        CHECKPOINT,
        TRANSACTION_LOG_JSON,
        TRINO_EXTENDED_STATS_JSON,
        STARBURST_EXTENDED_STATS_JSON,
        DATA,
        CDF_DATA,
        DELETION_VECTOR;

    }
}

