/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.metastore.HiveMetastore;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeFlushMetadataCacheProcedure
extends AbstractTestQueryFramework {
    private final String bucketName = "delta-lake-test-flush-metadata-cache-" + TestingNames.randomNameSuffix();
    private HiveMetastore metastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Hive3MinioDataLake hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName, HiveHadoop.HIVE3_IMAGE));
        hiveMinioDataLake.start();
        TestDeltaLakeFlushMetadataCacheProcedure testDeltaLakeFlushMetadataCacheProcedure = this;
        this.metastore = new BridgingHiveMetastore(TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(hiveMinioDataLake.getHiveMetastoreEndpoint()).build(x$0 -> testDeltaLakeFlushMetadataCacheProcedure.closeAfterClass((AutoCloseable)x$0)));
        return DeltaLakeQueryRunner.builder("default").addMetastoreProperties(hiveMinioDataLake.getHiveHadoop()).addS3Properties(hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("hive.metastore-cache-ttl", "10m").build();
    }

    @AfterAll
    public void tearDown() {
        this.metastore = null;
    }

    @Test
    public void testFlushMetadataCache() {
        this.assertUpdate("CREATE SCHEMA cached WITH (location = 's3://" + this.bucketName + "/cached')");
        this.assertUpdate("CREATE TABLE cached.cached AS SELECT * FROM tpch.tiny.nation", 25L);
        this.assertQuerySucceeds("SELECT name, regionkey FROM cached.cached");
        String showTablesSql = "SHOW TABLES FROM cached";
        this.assertQuery(showTablesSql, "VALUES 'cached'");
        this.metastore.renameTable("cached", "cached", "cached", "renamed");
        this.assertQuery(showTablesSql, "VALUES 'cached'");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => 'cached', table_name => 'cached')");
        this.assertQuery(showTablesSql, "VALUES 'renamed'");
        String showSchemasSql = "SHOW SCHEMAS FROM delta";
        this.assertQuery(showSchemasSql, "VALUES ('cached'), ('information_schema'), ('default')");
        this.metastore.dropTable("cached", "renamed", false);
        this.metastore.dropDatabase("cached", false);
        this.assertQuery(showSchemasSql, "VALUES ('cached'), ('information_schema'), ('default')");
        this.assertUpdate("CALL system.flush_metadata_cache()");
        this.assertQuery(showSchemasSql, "VALUES ('information_schema'), ('default')");
    }

    @Test
    public void testFlushMetadataCacheAfterTableCreated() {
        String schema = (String)this.getSession().getSchema().orElseThrow();
        String location = "s3://%s/test_flush_intermediate_tmp_table".formatted(this.bucketName);
        this.assertUpdate("CREATE TABLE test_flush_intermediate_tmp_table WITH (location = '" + location + "') AS TABLE tpch.tiny.region", 5L);
        this.assertQueryFails("TABLE flush_metadata_after_table_created", "\\Qline 1:1: Table 'delta.default.flush_metadata_after_table_created' does not exist");
        this.metastore.renameTable(schema, "test_flush_intermediate_tmp_table", schema, "flush_metadata_after_table_created");
        this.assertQueryFails("TABLE flush_metadata_after_table_created", "\\Qline 1:1: Table 'delta.default.flush_metadata_after_table_created' does not exist");
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => CURRENT_SCHEMA, table_name => 'flush_metadata_after_table_created')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE flush_metadata_after_table_created"))).skippingTypesCheck().matches("TABLE tpch.tiny.region");
        this.assertUpdate("DROP TABLE flush_metadata_after_table_created");
    }

    @Test
    public void testFlushMetadataCacheNonExistentTable() {
        this.assertUpdate("CALL system.flush_metadata_cache(schema_name => 'test_not_existing_schema', table_name => 'test_not_existing_table')");
    }
}

