/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import io.airlift.log.Logger;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.plugin.deltalake.BaseDeltaLakeConnectorSmokeTest;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.testcontainers.containers.Network;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDeltaLakeGcsConnectorSmokeTest
extends BaseDeltaLakeConnectorSmokeTest {
    private static final Logger LOG = Logger.get(TestDeltaLakeGcsConnectorSmokeTest.class);
    private static final FileAttribute<?> READ_ONLY_PERMISSIONS = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-r--r--"));
    private final String gcpStorageBucket = TestingProperties.requiredNonEmptySystemProperty((String)"testing.gcp-storage-bucket");
    private final String gcpCredentialKey = TestingProperties.requiredNonEmptySystemProperty((String)"testing.gcp-credentials-key");
    private Path gcpCredentialsFile;
    private String gcpCredentials;
    private TrinoFileSystem fileSystem;

    @Override
    protected void environmentSetup() {
        byte[] jsonKeyBytes = Base64.getDecoder().decode(this.gcpCredentialKey);
        this.gcpCredentials = new String(jsonKeyBytes, StandardCharsets.UTF_8);
        try {
            this.gcpCredentialsFile = Files.createTempFile("gcp-credentials", ".json", READ_ONLY_PERMISSIONS);
            this.gcpCredentialsFile.toFile().deleteOnExit();
            Files.write(this.gcpCredentialsFile, jsonKeyBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @AfterAll
    public void removeTestData() {
        if (this.fileSystem != null) {
            try {
                this.fileSystem.deleteDirectory(Location.of((String)this.bucketUrl()));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e, "Failed to clean up GCS test directory: %s", new Object[]{this.bucketUrl()});
            }
            this.fileSystem = null;
        }
    }

    @Override
    protected HiveHadoop createHiveHadoop() throws Exception {
        String gcpSpecificCoreSiteXmlContent = Resources.toString((URL)Resources.getResource((String)"io/trino/plugin/deltalake/hdp3.1-core-site.xml.gcs-template"), (Charset)StandardCharsets.UTF_8).replace("%GCP_CREDENTIALS_FILE_PATH%", "/etc/hadoop/conf/gcp-credentials.json");
        Path hadoopCoreSiteXmlTempFile = Files.createTempFile("core-site", ".xml", READ_ONLY_PERMISSIONS);
        hadoopCoreSiteXmlTempFile.toFile().deleteOnExit();
        Files.writeString(hadoopCoreSiteXmlTempFile, (CharSequence)gcpSpecificCoreSiteXmlContent, new OpenOption[0]);
        HiveHadoop hiveHadoop = ((HiveHadoop.Builder)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(HiveHadoop.HIVE3_IMAGE)).withNetwork((Network)this.closeAfterClass((AutoCloseable)Network.newNetwork()))).withFilesToMount((Map)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)hadoopCoreSiteXmlTempFile.normalize().toAbsolutePath().toString(), (Object)"/etc/hadoop/conf/gcp-credentials.json", (Object)this.gcpCredentialsFile.toAbsolutePath().toString()))).build();
        hiveHadoop.start();
        return hiveHadoop;
    }

    @Override
    protected Map<String, String> hiveStorageConfiguration() {
        return ImmutableMap.builder().put((Object)"fs.native-gcs.enabled", (Object)"true").put((Object)"gcs.json-key", (Object)this.gcpCredentials).buildOrThrow();
    }

    @Override
    protected Map<String, String> deltaStorageConfiguration() {
        return ImmutableMap.builder().putAll(this.hiveStorageConfiguration()).put((Object)"delta.unique-table-location", (Object)"false").buildOrThrow();
    }

    @Override
    protected void registerTableFromResources(String table, String resourcePath, QueryRunner queryRunner) {
        this.fileSystem = TestingDeltaLakeUtils.getConnectorService(queryRunner, TrinoFileSystemFactory.class).create(ConnectorIdentity.ofUser((String)"test"));
        String targetDirectory = this.bucketUrl() + table;
        try {
            List resources = (List)ClassPath.from((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getResources().stream().filter(resourceInfo -> resourceInfo.getResourceName().startsWith(resourcePath + "/")).collect(ImmutableList.toImmutableList());
            for (ClassPath.ResourceInfo resourceInfo2 : resources) {
                String fileName = resourceInfo2.getResourceName().replaceFirst("^" + Pattern.quote(resourcePath), Matcher.quoteReplacement(targetDirectory));
                byte[] bytes = resourceInfo2.asByteSource().read();
                TrinoOutputFile trinoOutputFile = this.fileSystem.newOutputFile(Location.of((String)fileName));
                trinoOutputFile.createOrOverwrite(bytes);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        queryRunner.execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", table, this.getLocationForTable(this.bucketName, table)));
    }

    @Override
    protected String getLocationForTable(String bucketName, String tableName) {
        return this.bucketUrl() + tableName;
    }

    @Override
    protected List<String> getTableFiles(String tableName) {
        return this.listAllFilesRecursive(tableName);
    }

    @Override
    protected List<String> listFiles(String directory) {
        return (List)this.listAllFilesRecursive(directory).stream().collect(ImmutableList.toImmutableList());
    }

    private List<String> listAllFilesRecursive(String directory) {
        ImmutableList.Builder locations = ImmutableList.builder();
        try {
            FileIterator files = this.fileSystem.listFiles(Location.of((String)this.bucketUrl()).appendPath(directory));
            while (files.hasNext()) {
                locations.add((Object)files.next().location().toString());
            }
            return locations.build();
        }
        catch (FileNotFoundException e) {
            return ImmutableList.of();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected void deleteFile(String filePath) {
        try {
            this.fileSystem.deleteFile(Location.of((String)filePath));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String bucketUrl() {
        return String.format("gs://%s/%s/", this.gcpStorageBucket, this.bucketName);
    }
}

