/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.airlift.testing.Closeables;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.DefaultCachingHostAddressProvider;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.TrinoHdfsFileSystemStats;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeInputInfo;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeModule;
import io.trino.plugin.deltalake.DeltaLakeSecurityModule;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastoreModule;
import io.trino.plugin.deltalake.metastore.HiveMetastoreBackedDeltaLakeMetastore;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorContext;
import io.trino.tests.BogusType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDeltaLakeMetadata {
    private static final String DATABASE_NAME = "mock_database";
    private static final ColumnMetadata BIGINT_COLUMN_1 = new ColumnMetadata("bigint_column1", (Type)BigintType.BIGINT);
    private static final ColumnMetadata BIGINT_COLUMN_2 = new ColumnMetadata("bigint_column2", (Type)BigintType.BIGINT);
    private static final ColumnMetadata TIMESTAMP_COLUMN = new ColumnMetadata("timestamp_column", (Type)TimestampType.TIMESTAMP_MILLIS);
    private static final ColumnMetadata MISSING_COLUMN = new ColumnMetadata("missing_column", (Type)BigintType.BIGINT);
    private static final RowType BOGUS_ROW_FIELD = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("test_field"), (Type)BogusType.BOGUS)));
    private static final RowType NESTED_ROW_FIELD = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("child1"), (Type)IntegerType.INTEGER), (Object)new RowType.Field(Optional.of("child2"), (Type)IntegerType.INTEGER)));
    private static final DeltaLakeColumnHandle BOOLEAN_COLUMN_HANDLE = new DeltaLakeColumnHandle("boolean_column_name", (Type)BooleanType.BOOLEAN, OptionalInt.empty(), "boolean_column_name", (Type)BooleanType.BOOLEAN, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle DOUBLE_COLUMN_HANDLE = new DeltaLakeColumnHandle("double_column_name", (Type)DoubleType.DOUBLE, OptionalInt.empty(), "double_column_name", (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle BOGUS_COLUMN_HANDLE = new DeltaLakeColumnHandle("bogus_column_name", (Type)BogusType.BOGUS, OptionalInt.empty(), "bogus_column_name", (Type)BogusType.BOGUS, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle VARCHAR_COLUMN_HANDLE = new DeltaLakeColumnHandle("varchar_column_name", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "varchar_column_name", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle DATE_COLUMN_HANDLE = new DeltaLakeColumnHandle("date_column_name", (Type)DateType.DATE, OptionalInt.empty(), "date_column_name", (Type)DateType.DATE, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle NESTED_COLUMN_HANDLE = new DeltaLakeColumnHandle("nested_column_name", (Type)NESTED_ROW_FIELD, OptionalInt.empty(), "nested_column_name", (Type)NESTED_ROW_FIELD, DeltaLakeColumnType.REGULAR, Optional.empty());
    private static final DeltaLakeColumnHandle EXPECTED_NESTED_COLUMN_HANDLE = new DeltaLakeColumnHandle("nested_column_name", (Type)NESTED_ROW_FIELD, OptionalInt.empty(), "nested_column_name", (Type)NESTED_ROW_FIELD, DeltaLakeColumnType.REGULAR, Optional.of(new DeltaLakeColumnProjectionInfo((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)"child2"))));
    private static final Map<String, ColumnHandle> SYNTHETIC_COLUMN_ASSIGNMENTS = ImmutableMap.of((Object)"test_synthetic_column_name_1", (Object)BOGUS_COLUMN_HANDLE, (Object)"test_synthetic_column_name_2", (Object)VARCHAR_COLUMN_HANDLE);
    private static final Map<String, ColumnHandle> NESTED_COLUMN_ASSIGNMENTS = ImmutableMap.of((Object)"nested_column_name", (Object)NESTED_COLUMN_HANDLE);
    private static final Map<String, ColumnHandle> EXPECTED_NESTED_COLUMN_ASSIGNMENTS = ImmutableMap.of((Object)"nested_column_name#child2", (Object)EXPECTED_NESTED_COLUMN_HANDLE);
    private static final ConnectorExpression DOUBLE_PROJECTION = new Variable("double_projection", (Type)DoubleType.DOUBLE);
    private static final ConnectorExpression BOOLEAN_PROJECTION = new Variable("boolean_projection", (Type)BooleanType.BOOLEAN);
    private static final ConnectorExpression DEREFERENCE_PROJECTION = new FieldDereference((Type)BOGUS_ROW_FIELD, (ConnectorExpression)new Constant((Object)1, (Type)BOGUS_ROW_FIELD), 0);
    private static final ConnectorExpression NESTED_DEREFERENCE_PROJECTION = new FieldDereference((Type)IntegerType.INTEGER, (ConnectorExpression)new Variable("nested_column_name", (Type)NESTED_ROW_FIELD), 1);
    private static final ConnectorExpression EXPECTED_NESTED_DEREFERENCE_PROJECTION = new Variable("nested_column_name#child2", (Type)IntegerType.INTEGER);
    private static final List<ConnectorExpression> SIMPLE_COLUMN_PROJECTIONS = ImmutableList.of((Object)DOUBLE_PROJECTION, (Object)BOOLEAN_PROJECTION);
    private static final List<ConnectorExpression> DEREFERENCE_COLUMN_PROJECTIONS = ImmutableList.of((Object)DOUBLE_PROJECTION, (Object)DEREFERENCE_PROJECTION, (Object)BOOLEAN_PROJECTION);
    private static final List<ConnectorExpression> NESTED_DEREFERENCE_COLUMN_PROJECTIONS = ImmutableList.of((Object)NESTED_DEREFERENCE_PROJECTION);
    private static final List<ConnectorExpression> EXPECTED_NESTED_DEREFERENCE_COLUMN_PROJECTIONS = ImmutableList.of((Object)EXPECTED_NESTED_DEREFERENCE_PROJECTION);
    private static final Set<DeltaLakeColumnHandle> PREDICATE_COLUMNS = ImmutableSet.of((Object)BOOLEAN_COLUMN_HANDLE, (Object)DOUBLE_COLUMN_HANDLE);
    private File temporaryCatalogDirectory;
    private DeltaLakeMetadataFactory deltaLakeMetadataFactory;

    @BeforeAll
    public void setUp() throws IOException {
        this.temporaryCatalogDirectory = Files.createTempDirectory("HiveCatalog", new FileAttribute[0]).toFile();
        ImmutableMap config = ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.temporaryCatalogDirectory.getPath()).buildOrThrow();
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), binder -> {
            TestingConnectorContext context = new TestingConnectorContext();
            binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
            binder.bind(CatalogName.class).toInstance((Object)new CatalogName("test"));
            binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
            binder.bind(Tracer.class).toInstance((Object)context.getTracer());
        }, new DeltaLakeSecurityModule(), new DeltaLakeMetastoreModule(), new DeltaLakeModule(), binder -> {
            binder.bind(HdfsEnvironment.class).toInstance((Object)HiveTestUtils.HDFS_ENVIRONMENT);
            binder.bind(TrinoHdfsFileSystemStats.class).toInstance((Object)HiveTestUtils.HDFS_FILE_SYSTEM_STATS);
            binder.bind(TrinoFileSystemFactory.class).to(HdfsFileSystemFactory.class).in(Scopes.SINGLETON);
            binder.bind(CachingHostAddressProvider.class).to(DefaultCachingHostAddressProvider.class).in(Scopes.SINGLETON);
        }, new AbstractModule(this){

            @Provides
            public DeltaLakeMetastore getDeltaLakeMetastore(@RawHiveMetastoreFactory HiveMetastoreFactory hiveMetastoreFactory) {
                return new HiveMetastoreBackedDeltaLakeMetastore(hiveMetastoreFactory.createMetastore(Optional.empty()));
            }
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties((Map)config).initialize();
        this.deltaLakeMetadataFactory = (DeltaLakeMetadataFactory)injector.getInstance(DeltaLakeMetadataFactory.class);
        ((DeltaLakeMetastore)injector.getInstance(DeltaLakeMetastore.class)).createDatabase(Database.builder().setDatabaseName(DATABASE_NAME).setOwnerName(Optional.of("test")).setOwnerType(Optional.of(PrincipalType.USER)).setLocation(Optional.empty()).build());
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{() -> MoreFiles.deleteRecursively((Path)this.temporaryCatalogDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE})});
        this.temporaryCatalogDirectory = null;
    }

    @Test
    public void testGetNewTableLayout() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        Optional newTableLayout = deltaLakeMetadata.getNewTableLayout(DeltaTestingConnectorSession.SESSION, this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_2)));
        Assertions.assertThat((Optional)newTableLayout).isPresent();
        Assertions.assertThat((Optional)((ConnectorTableLayout)newTableLayout.get()).getPartitioning()).isNotPresent();
        Assertions.assertThat((List)((ConnectorTableLayout)newTableLayout.get()).getPartitionColumns()).isEqualTo((Object)ImmutableList.of((Object)BIGINT_COLUMN_2.getName()));
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testGetNewTableLayoutNoPartitionColumns() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        Assertions.assertThat((Optional)deltaLakeMetadata.getNewTableLayout(DeltaTestingConnectorSession.SESSION, this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of()))).isNotPresent();
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testGetNewTableLayoutInvalidPartitionColumns() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> deltaLakeMetadata.getNewTableLayout(DeltaTestingConnectorSession.SESSION, this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_2, (Object)MISSING_COLUMN)))).isInstanceOf(TrinoException.class)).hasMessage("Table property 'partitioned_by' contained column names which do not exist: [missing_column]");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> deltaLakeMetadata.getNewTableLayout(DeltaTestingConnectorSession.SESSION, this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)TIMESTAMP_COLUMN, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_2)))).isInstanceOf(TrinoException.class)).hasMessage("Unsupported type: timestamp(3)");
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testGetInsertLayout() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ConnectorTableMetadata tableMetadata = this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1));
        deltaLakeMetadata.createTable(DeltaTestingConnectorSession.SESSION, tableMetadata, SaveMode.FAIL);
        Optional insertLayout = deltaLakeMetadata.getInsertLayout(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)deltaLakeMetadata.getTableHandle(DeltaTestingConnectorSession.SESSION, tableMetadata.getTable(), Optional.empty(), Optional.empty()));
        Assertions.assertThat((Optional)insertLayout).isPresent();
        Assertions.assertThat((Optional)((ConnectorTableLayout)insertLayout.get()).getPartitioning()).isNotPresent();
        Assertions.assertThat((List)((ConnectorTableLayout)insertLayout.get()).getPartitionColumns()).isEqualTo(TestDeltaLakeMetadata.getPartitionColumnNames((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1)));
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    private ConnectorTableMetadata newTableMetadata(List<ColumnMetadata> tableColumns, List<ColumnMetadata> partitionTableColumns) {
        return new ConnectorTableMetadata(TestDeltaLakeMetadata.newMockSchemaTableName(), tableColumns, (Map)ImmutableMap.of((Object)"partitioned_by", TestDeltaLakeMetadata.getPartitionColumnNames(partitionTableColumns), (Object)"column_mapping_mode", (Object)"none"));
    }

    @Test
    public void testGetInsertLayoutTableUnpartitioned() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ConnectorTableMetadata tableMetadata = this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1), (List<ColumnMetadata>)ImmutableList.of());
        deltaLakeMetadata.createTable(DeltaTestingConnectorSession.SESSION, tableMetadata, SaveMode.FAIL);
        Assertions.assertThat((Optional)deltaLakeMetadata.getInsertLayout(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)deltaLakeMetadata.getTableHandle(DeltaTestingConnectorSession.SESSION, tableMetadata.getTable(), Optional.empty(), Optional.empty()))).isNotPresent();
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testApplyProjection() {
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of(), SYNTHETIC_COLUMN_ASSIGNMENTS, SIMPLE_COLUMN_PROJECTIONS, SIMPLE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), SYNTHETIC_COLUMN_ASSIGNMENTS);
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)BOGUS_COLUMN_HANDLE), SYNTHETIC_COLUMN_ASSIGNMENTS, SIMPLE_COLUMN_PROJECTIONS, SIMPLE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), SYNTHETIC_COLUMN_ASSIGNMENTS);
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)DOUBLE_COLUMN_HANDLE, (Object)BOOLEAN_COLUMN_HANDLE, (Object)DATE_COLUMN_HANDLE, (Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), SYNTHETIC_COLUMN_ASSIGNMENTS, SIMPLE_COLUMN_PROJECTIONS, SIMPLE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), SYNTHETIC_COLUMN_ASSIGNMENTS);
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)DOUBLE_COLUMN_HANDLE, (Object)BOOLEAN_COLUMN_HANDLE, (Object)DATE_COLUMN_HANDLE, (Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), (Map<String, ColumnHandle>)ImmutableMap.of(), SIMPLE_COLUMN_PROJECTIONS, SIMPLE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of(), (Map<String, ColumnHandle>)ImmutableMap.of());
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)DOUBLE_COLUMN_HANDLE, (Object)BOOLEAN_COLUMN_HANDLE, (Object)DATE_COLUMN_HANDLE, (Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), (Map<String, ColumnHandle>)ImmutableMap.of(), DEREFERENCE_COLUMN_PROJECTIONS, DEREFERENCE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of(), (Map<String, ColumnHandle>)ImmutableMap.of());
        this.testApplyProjection((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)NESTED_COLUMN_HANDLE), NESTED_COLUMN_ASSIGNMENTS, NESTED_DEREFERENCE_COLUMN_PROJECTIONS, EXPECTED_NESTED_DEREFERENCE_COLUMN_PROJECTIONS, (Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)EXPECTED_NESTED_COLUMN_HANDLE), EXPECTED_NESTED_COLUMN_ASSIGNMENTS);
    }

    private void testApplyProjection(Set<DeltaLakeColumnHandle> inputProjectedColumns, Map<String, ColumnHandle> inputAssignments, List<ConnectorExpression> inputProjections, List<ConnectorExpression> expectedProjections, Set<DeltaLakeColumnHandle> expectedProjectedColumns, Map<String, ColumnHandle> expectedAssignments) {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ProjectionApplicationResult projection = (ProjectionApplicationResult)deltaLakeMetadata.applyProjection(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)TestDeltaLakeMetadata.createDeltaLakeTableHandle(inputProjectedColumns, PREDICATE_COLUMNS), inputProjections, inputAssignments).get();
        Assertions.assertThat((Optional)((DeltaLakeTableHandle)projection.getHandle()).getProjectedColumns()).isEqualTo(Optional.of(expectedProjectedColumns));
        Assertions.assertThat((List)projection.getProjections()).usingRecursiveComparison().isEqualTo(expectedProjections);
        Assertions.assertThat((List)projection.getAssignments()).usingRecursiveComparison().isEqualTo(TestDeltaLakeMetadata.createNewColumnAssignments(expectedAssignments));
        Assertions.assertThat((boolean)projection.isPrecalculateStatistics()).isFalse();
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testApplyProjectionWithEmptyResult() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        Assertions.assertThat((Optional)deltaLakeMetadata.applyProjection(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)TestDeltaLakeMetadata.createDeltaLakeTableHandle((Set<DeltaLakeColumnHandle>)ImmutableSet.of((Object)BOGUS_COLUMN_HANDLE, (Object)VARCHAR_COLUMN_HANDLE), PREDICATE_COLUMNS), SIMPLE_COLUMN_PROJECTIONS, SYNTHETIC_COLUMN_ASSIGNMENTS)).isEmpty();
        Assertions.assertThat((Optional)deltaLakeMetadata.applyProjection(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)TestDeltaLakeMetadata.createDeltaLakeTableHandle((Set<DeltaLakeColumnHandle>)ImmutableSet.of(), (Set<DeltaLakeColumnHandle>)ImmutableSet.of()), (List)ImmutableList.of(), (Map)ImmutableMap.of())).isEmpty();
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testGetInputInfoForPartitionedTable() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ConnectorTableMetadata tableMetadata = this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1));
        deltaLakeMetadata.createTable(DeltaTestingConnectorSession.SESSION, tableMetadata, SaveMode.FAIL);
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)deltaLakeMetadata.getTableHandle(DeltaTestingConnectorSession.SESSION, tableMetadata.getTable(), Optional.empty(), Optional.empty());
        Assertions.assertThat((Optional)deltaLakeMetadata.getInfo(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isEqualTo(Optional.of(new DeltaLakeInputInfo(true, 0L)));
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    @Test
    public void testGetInputInfoForUnPartitionedTable() {
        DeltaLakeMetadata deltaLakeMetadata = this.deltaLakeMetadataFactory.create(DeltaTestingConnectorSession.SESSION.getIdentity());
        ConnectorTableMetadata tableMetadata = this.newTableMetadata((List<ColumnMetadata>)ImmutableList.of((Object)BIGINT_COLUMN_1, (Object)BIGINT_COLUMN_2), (List<ColumnMetadata>)ImmutableList.of());
        deltaLakeMetadata.createTable(DeltaTestingConnectorSession.SESSION, tableMetadata, SaveMode.FAIL);
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)deltaLakeMetadata.getTableHandle(DeltaTestingConnectorSession.SESSION, tableMetadata.getTable(), Optional.empty(), Optional.empty());
        Assertions.assertThat((Optional)deltaLakeMetadata.getInfo(DeltaTestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isEqualTo(Optional.of(new DeltaLakeInputInfo(false, 0L)));
        deltaLakeMetadata.cleanupQuery(DeltaTestingConnectorSession.SESSION);
    }

    private static DeltaLakeTableHandle createDeltaLakeTableHandle(Set<DeltaLakeColumnHandle> projectedColumns, Set<DeltaLakeColumnHandle> constrainedColumns) {
        return new DeltaLakeTableHandle("test_schema_name", "test_table_name", true, "test_location", TestDeltaLakeMetadata.createMetadataEntry(), new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()), TestDeltaLakeMetadata.createConstrainedColumnsTuple(constrainedColumns), TupleDomain.all(), Optional.of(DeltaLakeTableHandle.WriteType.UPDATE), Optional.of(projectedColumns), Optional.of(ImmutableList.of((Object)BOOLEAN_COLUMN_HANDLE)), Optional.of(ImmutableList.of((Object)DOUBLE_COLUMN_HANDLE)), Optional.empty(), 0L, false);
    }

    private static TupleDomain<DeltaLakeColumnHandle> createConstrainedColumnsTuple(Set<DeltaLakeColumnHandle> constrainedColumns) {
        ImmutableMap.Builder tupleBuilder = ImmutableMap.builder();
        constrainedColumns.forEach(column -> {
            Verify.verify((boolean)column.isBaseColumn(), (String)"Unexpected dereference: %s", (Object)column);
            tupleBuilder.put(column, (Object)Domain.notNull((Type)column.baseType()));
        });
        return TupleDomain.withColumnDomains((Map)tupleBuilder.buildOrThrow());
    }

    private static List<Assignment> createNewColumnAssignments(Map<String, ColumnHandle> assignments) {
        return (List)assignments.entrySet().stream().map(assignment -> {
            DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)assignment.getValue();
            Type type = column.projectionInfo().map(DeltaLakeColumnProjectionInfo::getType).orElse(column.baseType());
            return new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), type);
        }).collect(ImmutableList.toImmutableList());
    }

    private static MetadataEntry createMetadataEntry() {
        return new MetadataEntry("test_id", "test_name", "test_description", new MetadataEntry.Format("test_provider", (Map)ImmutableMap.of()), "test_schema", (List)ImmutableList.of((Object)"test_partition_column"), (Map)ImmutableMap.of((Object)"test_configuration_key", (Object)"test_configuration_value"), 1L);
    }

    private static List<String> getPartitionColumnNames(List<ColumnMetadata> tableMetadataColumns) {
        return (List)tableMetadataColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
    }

    private static SchemaTableName newMockSchemaTableName() {
        String randomSuffix = UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        return new SchemaTableName(DATABASE_NAME, "table_" + randomSuffix);
    }
}

