/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.BaseDeltaLakeAwsConnectorSmokeTest;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeMinioAndHmsConnectorSmokeTest
extends BaseDeltaLakeAwsConnectorSmokeTest {
    @Override
    protected Map<String, String> hiveStorageConfiguration() {
        return ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.max-connections", (Object)"2").buildOrThrow();
    }

    @Override
    protected Map<String, String> deltaStorageConfiguration() {
        return ImmutableMap.builder().put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.max-connections", (Object)"4").buildOrThrow();
    }

    @Test
    public void testDeltaColumnInvariant() {
        String tableName = "test_invariants_" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.copyResources("deltalake/invariants", tableName);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, this.getLocationForTable(this.bucketName, tableName)));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(2)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1), (2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES(3)"))).failure().hasMessageContaining("Check constraint violation: (\"dummy\" < 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("UPDATE " + tableName + " SET dummy = 3 WHERE dummy = 1"))).failure().hasMessageContaining("Check constraint violation: (\"dummy\" < 3)");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1), (2)");
    }

    @Test
    public void testDeltaColumnInvariantWriterFeature() {
        String tableName = "test_invariants_writer_feature_" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.copyResources("databricks122/invariants_writer_feature", tableName);
        this.assertUpdate("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')".formatted(tableName, this.getLocationForTable(this.bucketName, tableName)));
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 2", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES 3"))).failure().hasMessageContaining("Check constraint violation: (\"col_invariants\" < 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("UPDATE " + tableName + " SET col_invariants = 3 WHERE col_invariants = 1"))).failure().hasMessageContaining("Check constraint violation: (\"col_invariants\" < 3)");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES 1, 2");
    }

    @Test
    public void testSchemaEvolutionOnTableWithColumnInvariant() {
        String tableName = "test_schema_evolution_on_table_with_column_invariant_" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.copyResources("deltalake/invariants", tableName);
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%s', '%s')", tableName, this.getLocationForTable(this.bucketName, tableName)));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES(3)"))).failure().hasMessageContaining("Check constraint violation: (\"dummy\" < 3)");
        this.assertUpdate("ALTER TABLE " + tableName + " ADD COLUMN c INT");
        this.assertUpdate("COMMENT ON COLUMN " + tableName + ".c IS 'example column comment'");
        this.assertUpdate("COMMENT ON TABLE " + tableName + " IS 'example table comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("INSERT INTO " + tableName + " VALUES(3, 30)"))).failure().hasMessageContaining("Check constraint violation: (\"dummy\" < 3)");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES(2, 20)", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, NULL), (2, 20)");
    }
}

