/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.transactionlog.writer.S3LockBasedTransactionLogSynchronizer;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import io.trino.testing.containers.Minio;
import io.trino.testing.minio.MinioClient;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeMinioAndLockBasedSynchronizerSmokeTest
extends AbstractTestQueryFramework {
    protected static final String SCHEMA = "test_schema";
    protected final String bucketName = "test-bucket-" + TestingNames.randomNameSuffix();
    protected MinioClient minioClient;
    protected Minio minio;
    protected HiveMetastore metastore;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(this.bucketName);
        this.minioClient = (MinioClient)this.closeAfterClass((AutoCloseable)this.minio.createMinioClient());
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("delta").setSchema(SCHEMA).build()).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin((Plugin)new DeltaLakePlugin());
            queryRunner.createCatalog("delta", "delta_lake", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)queryRunner.getCoordinator().getBaseDataDir().resolve("file-metastore").toString()).put((Object)"hive.metastore.disable-location-checks", (Object)"true").put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"s3.exclusive-create", (Object)"false").put((Object)"delta.metastore.store-table-metadata", (Object)"true").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.register-table-procedure.enabled", (Object)"true").buildOrThrow());
            this.metastore = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
            queryRunner.execute("CREATE SCHEMA test_schema WITH (location = 's3://" + this.bucketName + "/test_schema')");
            this.metastore = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
        return queryRunner;
    }

    @Test
    public void testWritesLocked() throws Exception {
        this.testWritesLocked("INSERT INTO %s VALUES (3, 'kota'), (4, 'psa')");
        this.testWritesLocked("UPDATE %s SET a_string = 'kota' WHERE a_number = 2");
        this.testWritesLocked("DELETE FROM %s WHERE a_number = 1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWritesLocked(String writeStatement) throws Exception {
        String tableName = "test_writes_locked" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string) WITH (location = 's3://%s/%s') AS VALUES (1, 'ala'), (2, 'ma')", tableName, this.bucketName, tableName), 2L);
            ImmutableSet originalFiles = ImmutableSet.copyOf(this.getTableFiles(tableName));
            Assertions.assertThat((Collection)originalFiles).isNotEmpty();
            String lockFilePath = this.lockTable(tableName, java.time.Duration.ofMinutes(5L));
            Assertions.assertThatThrownBy(() -> this.computeActual(String.format(writeStatement, tableName))).hasStackTraceContaining("Transaction log locked(1); lockingCluster=some_cluster; lockingQuery=some_query");
            Assertions.assertThat(this.listLocks(tableName)).containsExactly((Object[])new String[]{lockFilePath});
            ImmutableSet expectedFiles = ImmutableSet.builder().addAll((Iterable)originalFiles).add((Object)lockFilePath).build();
            Assert.assertEventually((Duration)new Duration(5.0, TimeUnit.SECONDS), () -> this.lambda$testWritesLocked$1(tableName, (Set)expectedFiles));
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    @Test
    public void testWritesLockExpired() throws Exception {
        this.testWritesLockExpired("INSERT INTO %s VALUES (3, 'kota')", "VALUES (1,'ala'), (2,'ma'), (3,'kota')");
        this.testWritesLockExpired("UPDATE %s SET a_string = 'kota' WHERE a_number = 2", "VALUES (1,'ala'), (2,'kota')");
        this.testWritesLockExpired("DELETE FROM %s WHERE a_number = 2", "VALUES (1,'ala')");
    }

    private void testWritesLockExpired(String writeStatement, String expectedValues) throws Exception {
        String tableName = "test_writes_locked" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string) WITH (location = 's3://%s/%s') AS VALUES (1, 'ala'), (2, 'ma')", tableName, this.bucketName, tableName), 2L);
        this.lockTable(tableName, java.time.Duration.ofSeconds(-5L));
        this.assertUpdate(String.format(writeStatement, tableName), 1L);
        this.assertQuery("SELECT * FROM " + tableName, expectedValues);
        Assertions.assertThat(this.listLocks(tableName)).isEmpty();
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testWritesLockInvalidContents() {
        this.testWritesLockInvalidContents("INSERT INTO %s VALUES (3, 'kota')", "VALUES (1,'ala'), (2,'ma'), (3,'kota')");
        this.testWritesLockInvalidContents("UPDATE %s SET a_string = 'kota' WHERE a_number = 2", "VALUES (1,'ala'), (2,'kota')");
        this.testWritesLockInvalidContents("DELETE FROM %s WHERE a_number = 2", "VALUES (1,'ala')");
    }

    private void testWritesLockInvalidContents(String writeStatement, String expectedValues) {
        String tableName = "test_writes_locked" + TestingNames.randomNameSuffix();
        this.assertUpdate(String.format("CREATE TABLE %s (a_number, a_string) WITH (location = 's3://%s/%s') AS VALUES (1, 'ala'), (2, 'ma')", tableName, this.bucketName, tableName), 2L);
        String lockFilePath = this.invalidLockTable(tableName);
        this.assertUpdate(String.format(writeStatement, tableName), 1L);
        this.assertQuery("SELECT * FROM " + tableName, expectedValues);
        Assertions.assertThat(this.listLocks(tableName)).containsExactly((Object[])new String[]{lockFilePath});
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String lockTable(String tableName, java.time.Duration lockDuration) throws Exception {
        String lockFilePath = String.format("%s/00000000000000000001.json.sb-lock_blah", this.getLockFileDirectory(tableName));
        String lockFileContents = OBJECT_MAPPER.writeValueAsString((Object)new S3LockBasedTransactionLogSynchronizer.LockFileContents("some_cluster", "some_query", Instant.now().plus(lockDuration).toEpochMilli()));
        this.minioClient.putObject(this.bucketName, lockFileContents.getBytes(StandardCharsets.UTF_8), lockFilePath);
        String lockUri = String.format("s3://%s/%s", this.bucketName, lockFilePath);
        Assertions.assertThat(this.listLocks(tableName)).containsExactly((Object[])new String[]{lockUri});
        return lockUri;
    }

    private String invalidLockTable(String tableName) {
        String lockFilePath = String.format("%s/00000000000000000001.json.sb-lock_blah", this.getLockFileDirectory(tableName));
        String invalidLockFileContents = "some very wrong json contents";
        this.minioClient.putObject(this.bucketName, invalidLockFileContents.getBytes(StandardCharsets.UTF_8), lockFilePath);
        String lockUri = String.format("s3://%s/%s", this.bucketName, lockFilePath);
        Assertions.assertThat(this.listLocks(tableName)).containsExactly((Object[])new String[]{lockUri});
        return lockUri;
    }

    private List<String> listLocks(String tableName) {
        List paths = this.minioClient.listObjects(this.bucketName, this.getLockFileDirectory(tableName));
        return (List)paths.stream().filter(path -> path.contains(".sb-lock_")).map(path -> String.format("s3://%s/%s", this.bucketName, path)).collect(ImmutableList.toImmutableList());
    }

    private String getLockFileDirectory(String tableName) {
        return String.format("%s/_delta_log/_sb_lock", tableName);
    }

    protected List<String> getTableFiles(String tableName) {
        return (List)this.minioClient.listObjects(this.bucketName, tableName).stream().map(path -> String.format("s3://%s/%s", this.bucketName, path)).collect(ImmutableList.toImmutableList());
    }

    private /* synthetic */ void lambda$testWritesLocked$1(String tableName, Set expectedFiles) throws RuntimeException {
        Assertions.assertThat(this.getTableFiles(tableName)).containsExactlyInAnyOrderElementsOf((Iterable)expectedFiles);
    }
}

