/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TempFile;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.filesystem.local.LocalInputFile;
import io.trino.filesystem.local.LocalOutputFile;
import io.trino.metadata.TableHandle;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakePageSourceProvider;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.spi.Page;
import io.trino.spi.SplitWeight;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingHandles;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.parquet.format.CompressionCodec;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeNodeLocalDynamicSplitPruning {
    private static final ParquetReaderConfig PARQUET_READER_CONFIG = new ParquetReaderConfig();
    private static final ParquetWriterConfig PARQUET_WRITER_CONFIG = new ParquetWriterConfig();

    @Test
    public void testDynamicSplitPruningOnUnpartitionedTable() throws IOException {
        String keyColumnName = "a_integer";
        DeltaLakeColumnHandle keyColumnHandle = new DeltaLakeColumnHandle(keyColumnName, (Type)IntegerType.INTEGER, OptionalInt.empty(), keyColumnName, (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty());
        int keyColumnValue = 42;
        String dataColumnName = "a_varchar";
        String dataColumnValue = "hello world";
        DeltaLakeColumnHandle dataColumnHandle = new DeltaLakeColumnHandle(dataColumnName, (Type)VarcharType.VARCHAR, OptionalInt.empty(), dataColumnName, (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)keyColumnName, (Object)dataColumnName), false, false);
        DeltaLakeConfig deltaLakeConfig = new DeltaLakeConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile file = new TempFile();){
            Files.delete(file.path());
            LocalOutputFile outputFile = new LocalOutputFile(file.file());
            LocalInputFile inputFile = new LocalInputFile(file.file());
            try (ParquetWriter writer = TestDeltaLakeNodeLocalDynamicSplitPruning.createParquetWriter((TrinoOutputFile)outputFile, schemaConverter);){
                BlockBuilder keyBuilder = IntegerType.INTEGER.createFixedSizeBlockBuilder(1);
                IntegerType.INTEGER.writeLong(keyBuilder, (long)keyColumnValue);
                VariableWidthBlockBuilder dataBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
                VarcharType.VARCHAR.writeString((BlockBuilder)dataBuilder, dataColumnValue);
                writer.write(new Page(new Block[]{keyBuilder.build(), dataBuilder.build()}));
            }
            DeltaLakeSplit split = new DeltaLakeSplit(inputFile.location().toString(), 0L, inputFile.length(), inputFile.length(), Optional.empty(), 0L, Optional.empty(), SplitWeight.standard(), TupleDomain.all(), (Map)ImmutableMap.of());
            MetadataEntry metadataEntry = new MetadataEntry("id", "name", "description", new MetadataEntry.Format("provider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"a_integer\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}},{\"name\":\"a_varchar\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of(), (Map)ImmutableMap.of(), 0L);
            TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new DeltaLakeTableHandle("test_schema_name", "unpartitioned_table", true, "test_location", metadataEntry, new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()), TupleDomain.all(), TupleDomain.all(), Optional.empty(), Optional.of(Set.of(keyColumnHandle, dataColumnHandle)), Optional.empty(), Optional.empty(), Optional.empty(), 0L, false), (ConnectorTransactionHandle)transaction);
            TupleDomain splitPruningPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
            try (ConnectorPageSource emptyPageSource = TestDeltaLakeNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, deltaLakeConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestDeltaLakeNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)splitPruningPredicate));){
                Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
            }
            TupleDomain nonSelectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)keyColumnHandle, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)keyColumnValue)));
            try (ConnectorPageSource nonEmptyPageSource = TestDeltaLakeNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, deltaLakeConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)keyColumnHandle, (Object)dataColumnHandle), TestDeltaLakeNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)nonSelectivePredicate));){
                SourcePage page = nonEmptyPageSource.getNextSourcePage();
                Assertions.assertThat((Object)page).isNotNull();
                Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(keyColumnValue);
                Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(1), 0).toStringUtf8()).isEqualTo(dataColumnValue);
            }
        }
    }

    @Test
    public void testDynamicSplitPruningWithExplicitPartitionFilter() throws IOException {
        String dateColumnName = "date";
        DeltaLakeColumnHandle dateColumnHandle = new DeltaLakeColumnHandle(dateColumnName, (Type)DateType.DATE, OptionalInt.empty(), dateColumnName, (Type)DateType.DATE, DeltaLakeColumnType.PARTITION_KEY, Optional.empty());
        long dateColumnValue = LocalDate.of(2023, 1, 10).toEpochDay();
        String receiptColumnName = "receipt";
        DeltaLakeColumnHandle receiptColumnHandle = new DeltaLakeColumnHandle(receiptColumnName, (Type)VarcharType.VARCHAR, OptionalInt.empty(), receiptColumnName, (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty());
        String receiptColumnValue = "#12345";
        String amountColumnName = "amount";
        DecimalType amountColumnType = DecimalType.createDecimalType((int)10, (int)2);
        DeltaLakeColumnHandle amountColumnHandle = new DeltaLakeColumnHandle(amountColumnName, (Type)amountColumnType, OptionalInt.empty(), amountColumnName, (Type)amountColumnType, DeltaLakeColumnType.REGULAR, Optional.empty());
        BigDecimal amountColumnValue = new BigDecimal("1234567.65");
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)amountColumnType), (List)ImmutableList.of((Object)receiptColumnName, (Object)amountColumnName), false, false);
        DeltaLakeConfig icebergConfig = new DeltaLakeConfig();
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        try (TempFile file = new TempFile();){
            Files.delete(file.path());
            LocalOutputFile outputFile = new LocalOutputFile(file.file());
            LocalInputFile inputFile = new LocalInputFile(file.file());
            try (ParquetWriter writer = TestDeltaLakeNodeLocalDynamicSplitPruning.createParquetWriter((TrinoOutputFile)outputFile, schemaConverter);){
                VariableWidthBlockBuilder receiptBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
                VarcharType.VARCHAR.writeString((BlockBuilder)receiptBuilder, receiptColumnValue);
                BlockBuilder amountBuilder = amountColumnType.createFixedSizeBlockBuilder(1);
                Decimals.writeShortDecimal((BlockBuilder)amountBuilder, (long)amountColumnValue.unscaledValue().longValueExact());
                writer.write(new Page(new Block[]{receiptBuilder.build(), amountBuilder.build()}));
            }
            DeltaLakeSplit split = new DeltaLakeSplit(inputFile.location().toString(), 0L, inputFile.length(), inputFile.length(), Optional.empty(), 0L, Optional.empty(), SplitWeight.standard(), TupleDomain.all(), (Map)ImmutableMap.of((Object)dateColumnName, Optional.of("2023-01-10")));
            MetadataEntry metadataEntry = new MetadataEntry("id", "name", "description", new MetadataEntry.Format("provider", (Map)ImmutableMap.of()), "{\"type\":\"struct\",\"fields\":[{\"name\":\"date\",\"type\":\"date\",\"nullable\":true,\"metadata\":{}},{\"name\":\"receipt\",\"type\":\"string\",\"nullable\":true,\"metadata\":{}},{\"name\":\"amount\",\"type\":\"decimal(10,2)\",\"nullable\":true,\"metadata\":{}}]}", (List)ImmutableList.of((Object)dateColumnName), (Map)ImmutableMap.of(), 0L);
            TableHandle tableHandle = new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new DeltaLakeTableHandle("test_schema_name", "unpartitioned_table", true, "test_location", metadataEntry, new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()), TupleDomain.all(), TupleDomain.all(), Optional.empty(), Optional.of(Set.of(dateColumnHandle, receiptColumnHandle, amountColumnHandle)), Optional.empty(), Optional.empty(), Optional.empty(), 0L, false), (ConnectorTransactionHandle)transaction);
            TupleDomain differentDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.singleValue((Type)DateType.DATE, (Object)LocalDate.of(2023, 2, 2).toEpochDay())));
            TupleDomain nonOverlappingDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DateType.DATE, (Object)LocalDate.of(2023, 2, 2).toEpochDay()), (Range[])new Range[0]), (boolean)true)));
            for (TupleDomain partitionPredicate : List.of(differentDatePredicate, nonOverlappingDatePredicate)) {
                ConnectorPageSource emptyPageSource = TestDeltaLakeNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)dateColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestDeltaLakeNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    Assertions.assertThat((Object)emptyPageSource.getNextSourcePage()).isNull();
                }
                finally {
                    if (emptyPageSource == null) continue;
                    emptyPageSource.close();
                }
            }
            TupleDomain sameDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.singleValue((Type)DateType.DATE, (Object)dateColumnValue)));
            TupleDomain overlappingDatePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)dateColumnHandle, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DateType.DATE, (Object)LocalDate.of(2023, 1, 1).toEpochDay(), (boolean)true, (Object)LocalDate.of(2023, 2, 1).toEpochDay(), (boolean)false), (Range[])new Range[0]), (boolean)true)));
            for (TupleDomain partitionPredicate : List.of(sameDatePredicate, overlappingDatePredicate)) {
                ConnectorPageSource nonEmptyPageSource = TestDeltaLakeNodeLocalDynamicSplitPruning.createTestingPageSource(transaction, icebergConfig, split, tableHandle, (List<ColumnHandle>)ImmutableList.of((Object)dateColumnHandle, (Object)receiptColumnHandle, (Object)amountColumnHandle), TestDeltaLakeNodeLocalDynamicSplitPruning.getDynamicFilter((TupleDomain<ColumnHandle>)partitionPredicate));
                try {
                    SourcePage page = nonEmptyPageSource.getNextSourcePage();
                    Assertions.assertThat((Object)page).isNotNull();
                    Assertions.assertThat((int)page.getPositionCount()).isEqualTo(1);
                    Assertions.assertThat((int)IntegerType.INTEGER.getInt(page.getBlock(0), 0)).isEqualTo(dateColumnValue);
                    Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(page.getBlock(1), 0).toStringUtf8()).isEqualTo(receiptColumnValue);
                    Assertions.assertThat((BigDecimal)((SqlDecimal)amountColumnType.getObjectValue(null, page.getBlock(2), 0)).toBigDecimal()).isEqualTo((Object)amountColumnValue);
                }
                finally {
                    if (nonEmptyPageSource == null) continue;
                    nonEmptyPageSource.close();
                }
            }
        }
    }

    private static ParquetWriter createParquetWriter(TrinoOutputFile outputFile, ParquetSchemaConverter schemaConverter) throws IOException {
        return new ParquetWriter(outputFile.create(), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().build(), CompressionCodec.SNAPPY, "test", Optional.of(DateTimeZone.UTC), Optional.empty());
    }

    private static ConnectorPageSource createTestingPageSource(HiveTransactionHandle transaction, DeltaLakeConfig deltaLakeConfig, DeltaLakeSplit split, TableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        FileFormatDataSourceStats stats = new FileFormatDataSourceStats();
        DeltaLakePageSourceProvider provider = new DeltaLakePageSourceProvider((TrinoFileSystemFactory)new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), stats, PARQUET_READER_CONFIG, deltaLakeConfig, InternalTypeManager.TESTING_TYPE_MANAGER);
        return provider.createPageSource((ConnectorTransactionHandle)transaction, (ConnectorSession)TestDeltaLakeNodeLocalDynamicSplitPruning.getSession(deltaLakeConfig), (ConnectorSplit)split, tableHandle.connectorHandle(), columns, dynamicFilter);
    }

    private static TestingConnectorSession getSession(DeltaLakeConfig deltaLakeConfig) {
        return TestingConnectorSession.builder().setPropertyMetadata(new DeltaLakeSessionProperties(deltaLakeConfig, PARQUET_READER_CONFIG, PARQUET_WRITER_CONFIG).getSessionProperties()).build();
    }

    private static DynamicFilter getDynamicFilter(final TupleDomain<ColumnHandle> tupleDomain) {
        return new DynamicFilter(){

            public Set<ColumnHandle> getColumnsCovered() {
                return tupleDomain.getDomains().map(Map::keySet).orElseGet(ImmutableSet::of);
            }

            public CompletableFuture<?> isBlocked() {
                return CompletableFuture.completedFuture(null);
            }

            public boolean isComplete() {
                return true;
            }

            public boolean isAwaitable() {
                return false;
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                return tupleDomain;
            }
        };
    }
}

