/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePageSinkProvider;
import io.trino.plugin.deltalake.DeltaLakeTable;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingPageSinkId;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemColumn;
import io.trino.tpch.LineItemGenerator;
import io.trino.tpch.TpchColumnType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakePageSink {
    private static final int NUM_ROWS = 1000;
    private static final String SCHEMA_NAME = "test";
    private static final String TABLE_NAME = "test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPageSinkStats() throws Exception {
        File tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            DeltaLakeWriterStats stats = new DeltaLakeWriterStats();
            String tablePath = tempDir.getAbsolutePath() + "/test_table";
            ConnectorPageSink pageSink = TestDeltaLakePageSink.createPageSink(tablePath, stats);
            ImmutableList columns = ImmutableList.copyOf((Object[])LineItemColumn.values());
            List columnTypes = columns.stream().map(LineItemColumn::getType).map(TestDeltaLakePageSink::getTrinoType).collect(Collectors.toList());
            PageBuilder pageBuilder = new PageBuilder(columnTypes);
            long rows = 0L;
            for (LineItem lineItem : new LineItemGenerator(0.01, 1, 1)) {
                if (rows >= 1000L) break;
                ++rows;
                pageBuilder.declarePosition();
                for (int i = 0; i < columns.size(); ++i) {
                    LineItemColumn column = (LineItemColumn)columns.get(i);
                    BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(i);
                    this.writeToBlock(blockBuilder, column, lineItem);
                }
            }
            Page page = pageBuilder.build();
            pageSink.appendPage(page).get(10L, TimeUnit.SECONDS);
            JsonCodec dataFileInfoCodec = new JsonCodecFactory().jsonCodec(DataFileInfo.class);
            Collection fragments = (Collection)MoreFutures.getFutureValue((Future)pageSink.finish());
            List dataFileInfos = (List)fragments.stream().map(Slice::getInput).map(arg_0 -> ((JsonCodec)dataFileInfoCodec).fromJson(arg_0)).collect(ImmutableList.toImmutableList());
            Assertions.assertThat((List)dataFileInfos).hasSize(1);
            DataFileInfo dataFileInfo = (DataFileInfo)dataFileInfos.get(0);
            ImmutableList files = ImmutableList.copyOf((Object[])new File(tablePath).listFiles((dir, name) -> !name.endsWith(".crc")));
            Assertions.assertThat((List)files).hasSize(1);
            File outputFile = (File)files.get(0);
            Assertions.assertThat((long)Math.round(stats.getInputPageSizeInBytes().getAllTime().getMax())).isEqualTo(page.getRetainedSizeInBytes());
            Assertions.assertThat((Optional)dataFileInfo.statistics().getNumRecords()).isEqualTo(Optional.of(rows));
            Assertions.assertThat((List)dataFileInfo.partitionValues()).isEqualTo((Object)ImmutableList.of());
            Assertions.assertThat((long)dataFileInfo.size()).isEqualTo(outputFile.length());
            Assertions.assertThat((String)dataFileInfo.path()).isEqualTo(outputFile.getName());
            Instant now = Instant.now();
            Assertions.assertThat((dataFileInfo.creationTime() < now.toEpochMilli() ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((dataFileInfo.creationTime() > now.minus(1L, ChronoUnit.MINUTES).toEpochMilli() ? 1 : 0) != 0).isTrue();
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private void writeToBlock(BlockBuilder blockBuilder, LineItemColumn column, LineItem lineItem) {
        switch (column.getType().getBase()) {
            case IDENTIFIER: {
                BigintType.BIGINT.writeLong(blockBuilder, column.getIdentifier(lineItem));
                break;
            }
            case INTEGER: {
                IntegerType.INTEGER.writeLong(blockBuilder, (long)column.getInteger(lineItem));
                break;
            }
            case DATE: {
                DateType.DATE.writeLong(blockBuilder, (long)column.getDate(lineItem));
                break;
            }
            case DOUBLE: {
                DoubleType.DOUBLE.writeDouble(blockBuilder, column.getDouble(lineItem));
                break;
            }
            case VARCHAR: {
                VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)column.getString(lineItem)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type " + String.valueOf(column.getType()));
            }
        }
    }

    private static ConnectorPageSink createPageSink(String outputPath, DeltaLakeWriterStats stats) {
        HiveTransactionHandle transaction = new HiveTransactionHandle(false);
        DeltaLakeConfig deltaLakeConfig = new DeltaLakeConfig();
        DeltaLakeTable.Builder deltaTable = DeltaLakeTable.builder();
        for (DeltaLakeColumnHandle column : TestDeltaLakePageSink.getColumnHandles()) {
            deltaTable.addColumn(column.columnName(), DeltaLakeSchemaSupport.serializeColumnType((DeltaLakeSchemaSupport.ColumnMappingMode)DeltaLakeSchemaSupport.ColumnMappingMode.NONE, (AtomicInteger)new AtomicInteger(), (Type)column.type()), true, null, (Map)ImmutableMap.of());
        }
        String schemaString = DeltaLakeSchemaSupport.serializeSchemaAsJson((DeltaLakeTable)deltaTable.build());
        DeltaLakeOutputTableHandle tableHandle = new DeltaLakeOutputTableHandle("test", "test", TestDeltaLakePageSink.getColumnHandles(), outputPath, Optional.of(deltaLakeConfig.getDefaultCheckpointWritingInterval()), true, Optional.empty(), Optional.of(false), false, schemaString, DeltaLakeSchemaSupport.ColumnMappingMode.NONE, OptionalInt.empty(), false, OptionalLong.empty(), new ProtocolEntry(1, 2, Optional.empty(), Optional.empty()));
        DeltaLakePageSinkProvider provider = new DeltaLakePageSinkProvider((PageIndexerFactory)new GroupByHashPageIndexerFactory(new FlatHashStrategyCompiler(new TypeOperators())), (TrinoFileSystemFactory)new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT, HiveTestUtils.HDFS_FILE_SYSTEM_STATS), JsonCodec.jsonCodec(DataFileInfo.class), JsonCodec.jsonCodec(DeltaLakeMergeResult.class), stats, new FileFormatDataSourceStats(), deltaLakeConfig, new ParquetReaderConfig(), (TypeManager)new TestingTypeManager(), new NodeVersion("test-version"));
        return provider.createPageSink((ConnectorTransactionHandle)transaction, DeltaTestingConnectorSession.SESSION, (ConnectorOutputTableHandle)tableHandle, (ConnectorPageSinkId)TestingPageSinkId.TESTING_PAGE_SINK_ID);
    }

    private static List<DeltaLakeColumnHandle> getColumnHandles() {
        LineItemColumn[] columns;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (LineItemColumn column : columns = LineItemColumn.values()) {
            handles.add((Object)new DeltaLakeColumnHandle(column.getColumnName(), TestDeltaLakePageSink.getTrinoType(column.getType()), OptionalInt.empty(), column.getColumnName(), TestDeltaLakePageSink.getTrinoType(column.getType()), DeltaLakeColumnType.REGULAR, Optional.empty()));
        }
        return handles.build();
    }

    private static Type getTrinoType(TpchColumnType type) {
        return switch (type.getBase()) {
            default -> throw new MatchException(null, null);
            case TpchColumnType.Base.IDENTIFIER -> BigintType.BIGINT;
            case TpchColumnType.Base.INTEGER -> IntegerType.INTEGER;
            case TpchColumnType.Base.DATE -> DateType.DATE;
            case TpchColumnType.Base.DOUBLE -> DoubleType.DOUBLE;
            case TpchColumnType.Base.VARCHAR -> VarcharType.createUnboundedVarcharType();
        };
    }
}

