/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemas;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeParquetSchemas {
    private final TypeManager typeManager = new TestingTypeManager();

    @Test
    public void testStringFieldColumnMappingNoneUnpartitioned() {
        String jsonSchema = "{\n    \"type\": \"struct\",\n    \"fields\": [\n        {\n            \"name\": \"a_string\",\n            \"type\": \"string\",\n            \"nullable\": true,\n            \"metadata\": {}\n        }\n    ]\n}\n";
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.ColumnMappingMode.NONE;
        ImmutableList partitionColumnNames = ImmutableList.of();
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a_string"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("a_string"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, columnMappingMode, (List<String>)partitionColumnNames, expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    @Test
    public void testStringFieldColumnMappingNonePartitioned() {
        String jsonSchema = "{\n     \"type\": \"struct\",\n     \"fields\": [\n         {\n             \"name\": \"a_string\",\n             \"type\": \"string\",\n             \"nullable\": true,\n             \"metadata\": {}\n         },\n         {\n             \"name\": \"part\",\n             \"type\": \"string\",\n             \"nullable\": true,\n             \"metadata\": {}\n         }\n     ]\n }\n";
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.ColumnMappingMode.NONE;
        ImmutableList partitionColumnNames = ImmutableList.of((Object)"part");
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("a_string"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("a_string"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, columnMappingMode, (List<String>)partitionColumnNames, expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    @Test
    public void testStringFieldColumnMappingIdUnpartitioned() {
        String jsonSchema = "{\n    \"type\": \"struct\",\n    \"fields\": [\n        {\n            \"name\": \"a_string\",\n            \"type\": \"string\",\n            \"nullable\": true,\n            \"metadata\": {\n                \"delta.columnMapping.id\": 1,\n                \"delta.columnMapping.physicalName\": \"col-eafe32e6-bd93-47f7-8921-34b7a4e66a06\"\n            }\n        }\n    ]\n}\n";
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(1)).named("col-eafe32e6-bd93-47f7-8921-34b7a4e66a06"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("col-eafe32e6-bd93-47f7-8921-34b7a4e66a06"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, DeltaLakeSchemaSupport.ColumnMappingMode.ID, (List<String>)ImmutableList.of(), expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    @Test
    public void testStringFieldColumnMappingIdPartitioned() {
        String jsonSchema = "{\n    \"type\": \"struct\",\n    \"fields\": [\n        {\n            \"name\": \"a_string\",\n            \"type\": \"string\",\n            \"nullable\": true,\n            \"metadata\": {\n                \"delta.columnMapping.id\": 1,\n                \"delta.columnMapping.physicalName\": \"col-40feefa6-d999-4c90-a923-190ecea9191c\"\n            }\n        },\n        {\n            \"name\": \"part\",\n            \"type\": \"string\",\n            \"nullable\": true,\n            \"metadata\": {\n                \"delta.columnMapping.id\": 2,\n                \"delta.columnMapping.physicalName\": \"col-77789070-4b77-44b4-adf2-32d5df94f9e7\"\n            }\n        }\n    ]\n}\n";
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(1)).named("col-40feefa6-d999-4c90-a923-190ecea9191c"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("col-40feefa6-d999-4c90-a923-190ecea9191c"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, DeltaLakeSchemaSupport.ColumnMappingMode.ID, (List<String>)ImmutableList.of((Object)"part"), expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    @Test
    public void testStringFieldColumnMappingNameUnpartitioned() {
        String jsonSchema = "{\n    \"type\": \"struct\",\n    \"fields\": [\n        {\n            \"name\": \"a_string\",\n            \"type\": \"string\",\n            \"nullable\": true,\n            \"metadata\": {\n                \"delta.columnMapping.id\": 1,\n                \"delta.columnMapping.physicalName\": \"col-0200c2be-bb8d-4be8-b724-674d71074143\"\n            }\n        }\n    ]\n}\n";
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(1)).named("col-0200c2be-bb8d-4be8-b724-674d71074143"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("col-0200c2be-bb8d-4be8-b724-674d71074143"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, DeltaLakeSchemaSupport.ColumnMappingMode.ID, (List<String>)ImmutableList.of(), expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    @Test
    public void testRowFieldColumnMappingNameUnpartitioned() {
        String jsonSchema = "{\n    \"type\": \"struct\",\n    \"fields\": [\n        {\n            \"name\": \"a_complex_struct\",\n            \"type\": {\n                \"type\": \"struct\",\n                \"fields\": [\n                    {\n                        \"name\": \"nested_struct\",\n                        \"type\": {\n                            \"type\": \"struct\",\n                            \"fields\": [\n                                {\n                                    \"name\": \"a_string\",\n                                    \"type\": \"string\",\n                                    \"nullable\": true,\n                                    \"metadata\": {\n                                        \"delta.columnMapping.id\": 3,\n                                        \"delta.columnMapping.physicalName\": \"col-1830cfed-bdd2-43c4-98c8-f2685cff6faf\"\n                                    }\n                                }\n                            ]\n                        },\n                        \"nullable\": true,\n                        \"metadata\": {\n                            \"delta.columnMapping.id\": 2,\n                            \"delta.columnMapping.physicalName\": \"col-5e0e4060-8e54-427b-8a8d-72a4fd6b67bd\"\n                        }\n                    },\n                    {\n                        \"name\": \"a_string_array\",\n                        \"type\": {\n                            \"type\": \"array\",\n                            \"elementType\": \"string\",\n                            \"containsNull\": true\n                        },\n                        \"nullable\": true,\n                        \"metadata\": {\n                            \"delta.columnMapping.id\": 4,\n                            \"delta.columnMapping.physicalName\": \"col-ff99c229-b1ce-4971-bfbc-3a68fec3dfea\"\n                        }\n                    },\n                    {\n                        \"name\": \"a_complex_map\",\n                        \"type\": {\n                            \"type\": \"map\",\n                            \"keyType\": \"string\",\n                            \"valueType\": {\n                                \"type\": \"struct\",\n                                \"fields\": [\n                                    {\n                                        \"name\": \"a_string\",\n                                        \"type\": \"string\",\n                                        \"nullable\": true,\n                                        \"metadata\": {\n                                            \"delta.columnMapping.id\": 6,\n                                            \"delta.columnMapping.physicalName\": \"col-5cb932a5-69aa-47e6-9d75-40f87bd8a239\"\n                                        }\n                                    }\n                                ]\n                            },\n                            \"valueContainsNull\": true\n                        },\n                        \"nullable\": true,\n                        \"metadata\": {\n                            \"delta.columnMapping.id\": 5,\n                            \"delta.columnMapping.physicalName\": \"col-85dededd-8dd2-4a81-ab3c-1439c1fd895a\"\n                        }\n                    }\n                ]\n            },\n            \"nullable\": true,\n            \"metadata\": {\n                \"delta.columnMapping.id\": 1,\n                \"delta.columnMapping.physicalName\": \"col-306694c6-846e-4c72-a3ea-976e4b19160a\"\n            }\n        }\n    ]\n}\n";
        Type expectedMessageType = (Type)((Types.GroupBuilder)Types.buildMessage().addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(3)).named("col-1830cfed-bdd2-43c4-98c8-f2685cff6faf"))).id(2)).named("col-5e0e4060-8e54-427b-8a8d-72a4fd6b67bd"))).addField((Type)((Types.ListBuilder)Types.optionalList().element((Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("element")).id(4)).named("col-ff99c229-b1ce-4971-bfbc-3a68fec3dfea"))).addField((Type)((Types.MapBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.map((Type.Repetition)Type.Repetition.OPTIONAL).key((Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("key"))).value((Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).addField((Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.OPTIONAL).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).id(6)).named("col-5cb932a5-69aa-47e6-9d75-40f87bd8a239"))).named("value"))).id(5)).named("col-85dededd-8dd2-4a81-ab3c-1439c1fd895a"))).id(1)).named("col-306694c6-846e-4c72-a3ea-976e4b19160a"))).named("trino_schema");
        ImmutableMap expectedPrimitiveTypes = ImmutableMap.builder().put(List.of("col-306694c6-846e-4c72-a3ea-976e4b19160a", "col-5e0e4060-8e54-427b-8a8d-72a4fd6b67bd", "col-1830cfed-bdd2-43c4-98c8-f2685cff6faf"), (Object)VarcharType.VARCHAR).put(List.of("col-306694c6-846e-4c72-a3ea-976e4b19160a", "col-ff99c229-b1ce-4971-bfbc-3a68fec3dfea", "list", "element"), (Object)VarcharType.VARCHAR).put(List.of("col-306694c6-846e-4c72-a3ea-976e4b19160a", "col-85dededd-8dd2-4a81-ab3c-1439c1fd895a", "key_value", "key"), (Object)VarcharType.VARCHAR).put(List.of("col-306694c6-846e-4c72-a3ea-976e4b19160a", "col-85dededd-8dd2-4a81-ab3c-1439c1fd895a", "key_value", "value", "col-5cb932a5-69aa-47e6-9d75-40f87bd8a239"), (Object)VarcharType.VARCHAR).buildOrThrow();
        this.assertParquetSchemaMappingCreationAccuracy(jsonSchema, DeltaLakeSchemaSupport.ColumnMappingMode.ID, (List<String>)ImmutableList.of(), expectedMessageType, (Map<List<String>, io.trino.spi.type.Type>)expectedPrimitiveTypes);
    }

    private void assertParquetSchemaMappingCreationAccuracy(@Language(value="JSON") String jsonSchema, DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode, List<String> partitionColumnNames, Type expectedMessageType, Map<List<String>, io.trino.spi.type.Type> expectedPrimitiveTypes) {
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping((String)jsonSchema, (TypeManager)this.typeManager, (DeltaLakeSchemaSupport.ColumnMappingMode)columnMappingMode, partitionColumnNames);
        Assertions.assertThat((Object)parquetSchemaMapping.messageType()).isEqualTo((Object)expectedMessageType);
        Assertions.assertThat((Map)parquetSchemaMapping.primitiveTypes()).isEqualTo(expectedPrimitiveTypes);
    }
}

