/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakePartitioning
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return DeltaLakeQueryRunner.builder().addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
    }

    @BeforeAll
    public void registerTables() {
        String dataPath = ((Object)((Object)this)).getClass().getClassLoader().getResource("deltalake/partitions").toExternalForm();
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, 'partitions', '%s')", dataPath));
    }

    @Test
    public void testDescribeTable() {
        this.assertQuery("DESCRIBE partitions", "VALUES ('p_string', 'varchar', '', ''), ('p_byte', 'tinyint', '', ''), ('p_short', 'smallint', '', ''), ('p_int', 'integer', '', ''), ('p_long', 'bigint', '', ''), ('p_decimal', 'decimal(38,18)', '', ''), ('p_boolean', 'boolean', '', ''), ('p_float', 'real', '', ''), ('p_double', 'double', '', ''), ('p_date', 'date', '', ''), ('p_timestamp', 'timestamp(3) with time zone', '', ''), ('t_string', 'varchar', '', ''), ('t_byte', 'tinyint', '', ''), ('t_short', 'smallint', '', ''), ('t_int', 'integer', '', ''), ('t_long', 'bigint', '', ''), ('t_decimal', 'decimal(38,18)', '', ''), ('t_boolean', 'boolean', '', ''), ('t_float', 'real', '', ''), ('t_double', 'double', '', ''), ('t_date', 'date', '', ''), ('t_timestamp', 'timestamp(3) with time zone', '', ''), ('t_phones', 'array(row(number varchar, label varchar))', '', ''), ('t_address', 'row(street varchar, city varchar, state varchar, zip varchar)', '', '')");
    }

    @Test
    public void testReadAllTypes() {
        this.assertQuery("SELECT p_string, p_byte, p_short, p_int, p_long, p_decimal, p_boolean, p_float, p_double, p_date, CAST(p_timestamp AS VARCHAR), t_string, t_byte, t_short, t_int, t_long, t_decimal, t_boolean, t_float, t_double, t_date, CAST(t_timestamp AS VARCHAR), t_phones[1].number, t_address.street FROM partitions ORDER BY t_int LIMIT 1 ", "VALUES ('Alice', 123, 12345, 123456789, 1234567890123456789, 12345678901234567890.123456789012345678, true, 3.1415927, 3.141592653589793, DATE '2014-01-01', '2014-01-01 23:00:01.123 UTC', 'Bob', -77, 23456, 1, 2345678901234567890, 23456789012345678901.234567890123456789, false, 2.7182817, 2.718281828459045, DATE '2020-01-01', '2020-01-01 23:00:01.123 UTC', '123-555-0000', '100 Main St')");
    }

    @Test
    public void testReadAllTypesPartitionsSystemTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT partition.p_string, partition.p_byte, partition.p_short, partition.p_int, partition.p_long, partition.p_decimal, partition.p_boolean, partition.p_float, partition.p_double, partition.p_date, partition.p_timestamp, file_count, total_size FROM \"partitions$partitions\" "))).matches("VALUES (VARCHAR 'Alice', TINYINT '123', SMALLINT '12345', 123456789, 1234567890123456789, 12345678901234567890.123456789012345678, true, REAL '3.1415927', DOUBLE '3.141592653589793', DATE '2014-01-01', TIMESTAMP '2014-01-01 23:00:01.123 UTC', BIGINT '30', BIGINT '136080' )");
    }

    @Test
    public void testPartitioningWithSpecialCharactersInPartitionColumn() {
        String dataPath = ((Object)((Object)this)).getClass().getClassLoader().getResource("deltalake").toExternalForm() + "/special_char" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE special_chars (id, col_name) WITH(partitioned_by = ARRAY['col_name'], location = '" + dataPath + "') AS VALUES(1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslash'),(6, 'with=equal'),(7, 'with?question'),(8, 'with!exclamation'),(9, 'with%%percent')", 9L);
        this.assertQuery("SELECT * FROM special_chars", "VALUES (1, 'with-hyphen'), (2, 'with.dot'), (3, 'with:colon'),(4, 'with/slash'), (5, 'with\\\\backslash'), (6, 'with=equal'), (7, 'with?question'), (8, 'with!exclamation'), (9, 'with%%percent')");
    }

    @Test
    public void testRevealPartitionColumnInExplain() {
        this.assertExplain("EXPLAIN SELECT * FROM partitions", new String[]{"p_string := p_string:varchar:PARTITION_KEY"});
    }
}

