/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.Session;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.metastore.MetastoreInvocations;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.HashMap;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestDeltaLakePerTransactionMetastoreCache {
    private static QueryRunner createQueryRunner(boolean enablePerTransactionHiveMetastoreCaching) throws Exception {
        HashMap<String, String> deltaLakeProperties = new HashMap<String, String>();
        deltaLakeProperties.put("delta.register-table-procedure.enabled", "true");
        if (!enablePerTransactionHiveMetastoreCaching) {
            deltaLakeProperties.put("delta.per-transaction-metastore-cache-maximum-size", "1");
        }
        return DeltaLakeQueryRunner.builder().setDeltaProperties(deltaLakeProperties).setInitialTables(List.of(TpchTable.NATION, TpchTable.REGION)).build();
    }

    @Test
    public void testPerTransactionHiveMetastoreCachingEnabled() throws Exception {
        try (QueryRunner queryRunner = TestDeltaLakePerTransactionMetastoreCache.createQueryRunner(true);){
            TestDeltaLakePerTransactionMetastoreCache.assertMetastoreInvocations(queryRunner, "SELECT * FROM nation JOIN region ON nation.regionkey = region.regionkey", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
        }
    }

    @Test
    public void testPerTransactionHiveMetastoreCachingDisabled() throws Exception {
        try (QueryRunner queryRunner = TestDeltaLakePerTransactionMetastoreCache.createQueryRunner(false);){
            TestDeltaLakePerTransactionMetastoreCache.assertMetastoreInvocations(queryRunner, "SELECT * FROM nation JOIN region ON nation.regionkey = region.regionkey", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
        }
    }

    private static void assertMetastoreInvocations(QueryRunner queryRunner, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        MetastoreInvocations.assertMetastoreInvocationsForQuery((QueryRunner)queryRunner, (Session)queryRunner.getDefaultSession(), (String)query, expectedInvocations);
    }
}

