/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakePlugin {
    @Test
    public void testCreateConnector() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testTestingFileMetastore() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"file", (Object)"hive.metastore.catalog.dir", (Object)"/tmp", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testThriftMetastore() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"thrift", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"thrift", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"delta.hide-non-delta-lake-tables", (Object)"true", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext())).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("Error: Configuration property 'delta.hide-non-delta-lake-tables' was not used");
    }

    @Test
    public void testGlueMetastore() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue", (Object)"hive.metastore.glue.region", (Object)"us-east-2", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore", (Object)"glue", (Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext())).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("Error: Configuration property 'hive.metastore.uri' was not used");
    }

    @Test
    public void testNoCaching() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"delta.metadata.cache-ttl", (Object)"0s", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testNoActiveDataFilesCaching() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"delta.metadata.live-files.cache-ttl", (Object)"0s", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testHiveConfigIsNotBound() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        Assertions.assertThatThrownBy(() -> factory.create("test", (Map)ImmutableMap.of((Object)"hive.metastore.uri", (Object)"thrift://foo:1234", (Object)"hive.partition-projection-enabled", (Object)"true", (Object)"bootstrap.quiet", (Object)"true"), (ConnectorContext)new TestingConnectorContext())).hasMessageContaining("Error: Configuration property 'hive.partition-projection-enabled' was not used");
    }

    @Test
    public void testReadOnlyAllAccessControl() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        factory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"delta.security", (Object)"read-only").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testSystemAccessControl() {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        Connector connector = factory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"delta.security", (Object)"system").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext());
        Assertions.assertThatThrownBy(() -> ((Connector)connector).getAccessControl()).isInstanceOf(UnsupportedOperationException.class);
        connector.shutdown();
    }

    @Test
    public void testFileBasedAccessControl() throws Exception {
        ConnectorFactory factory = TestDeltaLakePlugin.getConnectorFactory();
        File tempFile = File.createTempFile("test-delta-lake-plugin-access-control", ".json");
        Files.writeString(tempFile.toPath(), (CharSequence)"{}", new OpenOption[0]);
        factory.create("test", (Map)ImmutableMap.builder().put((Object)"hive.metastore.uri", (Object)"thrift://foo:1234").put((Object)"delta.security", (Object)"file").put((Object)"security.config-file", (Object)tempFile.getAbsolutePath()).put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
        Verify.verify((boolean)tempFile.delete());
    }

    private static ConnectorFactory getConnectorFactory() {
        return (ConnectorFactory)Iterables.getOnlyElement((Iterable)new DeltaLakePlugin().getConnectorFactories());
    }
}

