/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import io.trino.testing.containers.Minio;
import java.util.Map;
import java.util.UUID;
import org.junit.jupiter.api.Test;

public class TestDeltaLakePreferredPartitioning
extends AbstractTestQueryFramework {
    private static final int WRITE_PARTITIONING_TEST_PARTITIONS_COUNT = 101;
    private final String bucketName = "mock-delta-lake-bucket-" + TestingNames.randomNameSuffix();
    protected Minio minio;

    protected QueryRunner createQueryRunner() throws Exception {
        this.minio = (Minio)this.closeAfterClass((AutoCloseable)Minio.builder().build());
        this.minio.start();
        this.minio.createBucket(this.bucketName);
        String schema = "default";
        Session session = TestingSession.testSessionBuilder().setCatalog("delta").setSchema(schema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            queryRunner.installPlugin((Plugin)new DeltaLakePlugin());
            queryRunner.createCatalog("delta", "delta_lake", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)queryRunner.getCoordinator().getBaseDataDir().resolve("file-metastore").toString()).put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.max-partitions-per-writer", (Object)String.valueOf(100)).buildOrThrow());
            queryRunner.execute("CREATE SCHEMA " + schema + " WITH (location = 's3://" + this.bucketName + "/" + schema + "')");
        }
        catch (Throwable e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
        return queryRunner;
    }

    @Test
    public void testPreferredWritePartitioningCreateTable() {
        String partitionedTableName1 = TestDeltaLakePreferredPartitioning.generateRandomTableName();
        String partitionedTableName2 = TestDeltaLakePreferredPartitioning.generateRandomTableName();
        this.assertUpdate(this.withForcedPreferredPartitioning(), String.format("CREATE TABLE IF NOT EXISTS %s WITH (location = '%s', partitioned_by = ARRAY['partkey']) AS SELECT orderkey, partkey %% %d AS partkey FROM tpch.tiny.lineitem", partitionedTableName1, this.getLocationForTable(partitionedTableName1), 101), 60175L);
        this.assertQueryFails(this.withoutPreferredPartitioning(), String.format("CREATE TABLE IF NOT EXISTS %s WITH (location = '%s', partitioned_by = ARRAY['partkey']) AS SELECT orderkey, partkey %% %d AS partkey FROM tpch.tiny.lineitem", partitionedTableName2, this.getLocationForTable(partitionedTableName2), 101), "Exceeded limit of 100 open writers for partitions");
    }

    @Test
    public void testPreferredWritePartitioningInsertIntoTable() {
        String partitionedTableName = TestDeltaLakePreferredPartitioning.generateRandomTableName();
        this.createEmptyPartitionedTable(partitionedTableName);
        this.assertUpdate(this.withForcedPreferredPartitioning(), String.format("INSERT INTO %s SELECT orderkey, partkey %% %d AS partkey FROM tpch.tiny.lineitem", partitionedTableName, 101), 60175L);
        this.assertQueryFails(this.withoutPreferredPartitioning(), String.format("INSERT INTO %s SELECT orderkey, partkey %% %d AS partkey FROM tpch.tiny.lineitem", partitionedTableName, 101), "Exceeded limit of 100 open writers for partitions");
    }

    private void createEmptyPartitionedTable(String tableName) {
        this.getQueryRunner().execute(this.withForcedPreferredPartitioning(), String.format("CREATE TABLE IF NOT EXISTS %s (orderkey bigint, partkey bigint) WITH (location = '%s', partitioned_by = ARRAY['partkey'])", tableName, this.getLocationForTable(tableName)));
    }

    private static String generateRandomTableName() {
        return "table_" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    private String getLocationForTable(String tableName) {
        return String.format("s3://%s/%s", this.bucketName, tableName);
    }

    private Session withForcedPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("task_max_writer_count", "1").build();
    }

    private Session withoutPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "false").setSystemProperty("task_max_writer_count", "1").build();
    }
}

