/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.TestingDeltaLakePlugin;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePushdownPlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinType;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeProjectionPushdownPlans
extends BasePushdownPlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final String SCHEMA = "test_schema";
    private Path baseDir;

    protected PlanTester createPlanTester() {
        Session session = TestingSession.testSessionBuilder().setCatalog("delta").setSchema(SCHEMA).build();
        try {
            this.baseDir = Files.createTempDirectory("delta_lake_projection_pushdown", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        PlanTester planTester = PlanTester.create((Session)session);
        planTester.installPlugin((Plugin)new TestingDeltaLakePlugin(this.baseDir));
        planTester.createCatalog("delta", "delta_lake", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.baseDir.toString()).put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow());
        HiveMetastore metastore = TestingDeltaLakeUtils.getConnectorService(planTester, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        Database database = Database.builder().setDatabaseName(SCHEMA).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).build();
        metastore.createDatabase(database);
        return planTester;
    }

    @AfterAll
    public void cleanup() throws Exception {
        if (this.baseDir != null) {
            MoreFiles.deleteRecursively((Path)this.baseDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    @Test
    public void testPushdownDisabled() {
        String testTable = "test_pushdown_disabled_" + TestingNames.randomNameSuffix();
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setCatalogSessionProperty("delta", "projection_pushdown_enabled", "false").build();
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (col0) AS SELECT CAST(row(5, 6) AS row(a bigint, b bigint)) AS col0 WHERE false", testTable));
        this.assertPlan(String.format("SELECT col0.a expr_a, col0.b expr_b FROM %s", testTable), session, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 0)), (Object)"expr_2", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "col0"), 1))), (PlanMatchPattern)PlanMatchPattern.tableScan((String)testTable, (Map)ImmutableMap.of((Object)"col0", (Object)"col0")))}));
    }

    @Test
    public void testDereferencePushdown() {
        String testTable = "test_simple_projection_pushdown" + TestingNames.randomNameSuffix();
        QualifiedObjectName completeTableName = new QualifiedObjectName("delta", SCHEMA, testTable);
        this.getPlanTester().executeStatement(String.format("CREATE TABLE %s (col0, col1) WITH (partitioned_by = ARRAY['col1']) AS SELECT CAST(row(5, 6) AS row(x bigint, y bigint)) AS col0, 5 AS col1", testTable));
        Session session = this.getPlanTester().getDefaultSession();
        Optional tableHandle = this.getTableHandle(session, completeTableName);
        ((OptionalAssert)Assertions.assertThat((Optional)tableHandle).as("expected the table handle to be present", new Object[0])).isPresent();
        Map columns = this.getColumnHandles(session, completeTableName);
        DeltaLakeColumnHandle column0Handle = (DeltaLakeColumnHandle)columns.get("col0");
        DeltaLakeColumnHandle column1Handle = (DeltaLakeColumnHandle)columns.get("col1");
        DeltaLakeColumnHandle columnX = this.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)0), (List<String>)ImmutableList.of((Object)"x"));
        DeltaLakeColumnHandle columnY = this.createProjectedColumnHandle(column0Handle, (List<Integer>)ImmutableList.of((Object)1), (List<String>)ImmutableList.of((Object)"y"));
        this.assertPlan("SELECT col0.x expr_x, col0.y expr_y FROM " + testTable, PlanMatchPattern.any((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)((DeltaLakeTableHandle)((TableHandle)tableHandle.get()).connectorHandle()).withProjectedColumns(Set.of(columnX, columnY))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0.x", (Object)Predicates.equalTo((Object)columnX), (Object)"col0.y", (Object)Predicates.equalTo((Object)columnY)))}));
        PlanMatchPattern source2 = PlanMatchPattern.tableScan(table -> {
            DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)table;
            TupleDomain unenforcedConstraint = deltaLakeTableHandle.getNonPartitionConstraint();
            return ((Set)deltaLakeTableHandle.getProjectedColumns().orElseThrow()).equals(ImmutableSet.of((Object)column1Handle, (Object)columnX, (Object)columnY)) && unenforcedConstraint.equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnY, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"y", arg_0 -> ((DeltaLakeColumnHandle)columnY).equals(arg_0), (Object)"x", arg_0 -> ((DeltaLakeColumnHandle)columnX).equals(arg_0), (Object)"col1", arg_0 -> ((DeltaLakeColumnHandle)column1Handle).equals(arg_0)));
        this.assertPlan(String.format("SELECT col0.x FROM %s WHERE col0.x = col1 + 3 and col0.y = 2", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "y"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Cast((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "col1"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)3L))), (Type)BigintType.BIGINT)))), (PlanMatchPattern)source2)}));
        PlanMatchPattern source1 = PlanMatchPattern.tableScan(table -> {
            DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)table;
            TupleDomain unenforcedConstraint = deltaLakeTableHandle.getNonPartitionConstraint();
            return ((Set)deltaLakeTableHandle.getProjectedColumns().orElseThrow()).equals(ImmutableSet.of((Object)column0Handle, (Object)columnX)) && unenforcedConstraint.equals((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L))));
        }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"col0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"x", (Object)Predicates.equalTo((Object)columnX)));
        this.assertPlan(String.format("SELECT col0, col0.y expr_y FROM %s WHERE col0.x = 5", testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanMatchPattern)source1)}));
        this.assertPlan(String.format("SELECT T.col0.x, T.col0, T.col0.y FROM %s T join %s S on T.col1 = S.col1 WHERE (T.col0.x = 2)", testTable, testTable), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.project((Map)ImmutableMap.of((Object)"expr_0_x", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0"), 0)), (Object)"expr_0", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0")), (Object)"expr_0_y", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}), "expr_0"), 1))), (PlanMatchPattern)PlanMatchPattern.join((JoinType)JoinType.INNER, builder -> {
            PlanMatchPattern source = PlanMatchPattern.tableScan(table -> {
                DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)table;
                TupleDomain unenforcedConstraint = deltaLakeTableHandle.getNonPartitionConstraint();
                ImmutableSet expectedProjections = ImmutableSet.of((Object)column0Handle, (Object)column1Handle, (Object)columnX);
                TupleDomain expectedUnenforcedConstraint = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnX, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
                return ((Set)deltaLakeTableHandle.getProjectedColumns().orElseThrow()).equals(expectedProjections) && unenforcedConstraint.equals((Object)expectedUnenforcedConstraint);
            }, (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"x", (Object)Predicates.equalTo((Object)columnX), (Object)"expr_0", (Object)Predicates.equalTo((Object)column0Handle), (Object)"t_expr_1", (Object)Predicates.equalTo((Object)column1Handle)));
            builder.equiCriteria("t_expr_1", "s_expr_1").left(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (PlanMatchPattern)source)})).right(PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.tableScan((Predicate)Predicates.equalTo((Object)((DeltaLakeTableHandle)((TableHandle)tableHandle.get()).connectorHandle()).withProjectedColumns(Set.of(column1Handle))), (TupleDomain)TupleDomain.all(), (Map)ImmutableMap.of((Object)"s_expr_1", (Object)Predicates.equalTo((Object)column1Handle)))}));
        }))}));
    }

    private DeltaLakeColumnHandle createProjectedColumnHandle(DeltaLakeColumnHandle baseColumnHandle, List<Integer> dereferenceIndices, List<String> dereferenceNames) {
        return new DeltaLakeColumnHandle(baseColumnHandle.baseColumnName(), baseColumnHandle.baseType(), baseColumnHandle.baseFieldId(), baseColumnHandle.basePhysicalColumnName(), baseColumnHandle.basePhysicalType(), DeltaLakeColumnType.REGULAR, Optional.of(new DeltaLakeColumnProjectionInfo((Type)BigintType.BIGINT, dereferenceIndices, dereferenceNames)));
    }
}

