/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.spi.type.TimeZoneKey;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeReadTimestamps
extends AbstractTestQueryFramework {
    private static final Logger log = Logger.get(TestDeltaLakeReadTimestamps.class);
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final ZoneId TEST_TIME_ZONE = ZoneId.of("America/Bahia_Banderas");
    private static final DateTimeFormatter EXPECTED_VALUES_FORMATTER = new DateTimeFormatterBuilder().appendLiteral('\'').appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 3, 9, true).appendLiteral('Z').appendLiteral('\'').toFormatter(Locale.ENGLISH).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    private static final DateTimeFormatter WHERE_VALUE_FORMATTER = DateTimeFormatter.ofPattern("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.SSS VV''").withZone(UTC);

    public static ZoneId getJvmTestTimeZone() {
        ZoneId zone = ZoneId.systemDefault();
        Preconditions.checkState((boolean)TEST_TIME_ZONE.equals(zone), (Object)("Assumed JVM time zone was " + TEST_TIME_ZONE.getId() + ", but found " + zone.getId()));
        return zone;
    }

    protected QueryRunner createQueryRunner() throws Exception {
        return DeltaLakeQueryRunner.builder().addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
    }

    @BeforeAll
    public void registerTables() {
        String dataPath = ((Object)((Object)this)).getClass().getClassLoader().getResource("databricks73/read_timestamps").toExternalForm();
        this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, 'read_timestamps', '%s')", dataPath));
    }

    @Test
    @Disabled(value="This test assumes specific tzdb version and it will fail on mismatch between Spark and Trino tzdb versions")
    public void timestampReadMapping() {
        ZoneId jvmZone = TestDeltaLakeReadTimestamps.getJvmTestTimeZone();
        Verify.verify((boolean)jvmZone.getRules().getValidOffsets(LocalDateTime.parse("1970-01-01T00:05:00.123")).isEmpty());
        Verify.verify((jvmZone.getRules().getValidOffsets(LocalDateTime.parse("1996-10-27T01:05:00.987")).size() == 2 ? 1 : 0) != 0);
        ZoneId vilniusZone = ZoneId.of("Europe/Vilnius");
        Verify.verify((boolean)vilniusZone.getRules().getValidOffsets(LocalDateTime.parse("1983-04-01T00:05:00.345")).isEmpty());
        Verify.verify((vilniusZone.getRules().getValidOffsets(LocalDateTime.parse("1983-09-30T23:59:00.654")).size() == 2 ? 1 : 0) != 0);
        ImmutableList.Builder testCases = ImmutableList.builder();
        testCases.add((Object)Instant.parse("1900-01-01T00:00:00.000Z"));
        testCases.add((Object)Instant.parse("1952-04-03T01:02:03.456Z"));
        testCases.add((Object)Instant.parse("1970-01-01T00:00:00.000Z"));
        testCases.add((Object)Instant.parse("1970-02-03T04:05:06.789Z"));
        testCases.add((Object)Instant.parse("2017-07-01T00:00:00.000Z"));
        testCases.add((Object)Instant.parse("1970-01-01T00:05:00.123Z"));
        testCases.add((Object)Instant.parse("1969-12-31T23:05:00.123Z"));
        testCases.add((Object)Instant.parse("1970-01-01T01:05:00.123Z"));
        testCases.add((Object)Instant.parse("1996-10-27T01:05:00.987Z"));
        testCases.add((Object)Instant.parse("1996-10-27T00:05:00.987Z"));
        testCases.add((Object)Instant.parse("1996-10-27T02:05:00.987Z"));
        testCases.add((Object)Instant.parse("1983-04-01T00:05:00.345Z"));
        testCases.add((Object)Instant.parse("1983-03-31T23:05:00.345Z"));
        testCases.add((Object)Instant.parse("1983-04-01T01:05:00.345Z"));
        testCases.add((Object)Instant.parse("1983-09-30T23:59:00.654Z"));
        testCases.add((Object)Instant.parse("1983-09-30T22:59:00.654Z"));
        testCases.add((Object)Instant.parse("1983-10-01T00:59:00.654Z"));
        testCases.add((Object)Instant.parse("9999-12-31T23:59:59.999Z"));
        for (String zone : ImmutableList.of((Object)TimeZoneKey.UTC_KEY.getId(), (Object)jvmZone.getId(), (Object)vilniusZone.getId())) {
            this.runTestInTimeZone(zone, (List<Instant>)testCases.build());
        }
    }

    private void runTestInTimeZone(String zone, List<Instant> testCases) {
        log.info("Starting test in time zone %s", new Object[]{zone});
        Session.SessionBuilder sessionBuilder = Session.builder((Session)this.getQueryRunner().getDefaultSession());
        if (zone != null) {
            sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)zone));
        }
        String projections = IntStream.range(1, 37).mapToObj(columnIndex -> String.format("to_iso8601(col_%s)", columnIndex)).collect(Collectors.joining(", "));
        String expectedPartitionedTimestamps = testCases.stream().map(x -> EXPECTED_VALUES_FORMATTER.format(x.atZone(ZoneId.of(zone)).withZoneSameLocal(UTC))).collect(Collectors.joining(", "));
        String expectedValues = testCases.stream().map(x -> EXPECTED_VALUES_FORMATTER.format(x.atZone(UTC))).collect(Collectors.joining(", "));
        String expected = "VALUES ('" + zone + "', " + expectedPartitionedTimestamps + ", " + expectedValues + ")";
        String actual = "SELECT col_0, " + projections + " FROM read_timestamps WHERE col_0 = '" + zone + "'";
        Session session = sessionBuilder.build();
        this.assertQuery(session, actual, expected);
        actual = "SELECT col_0, " + projections + " FROM read_timestamps WHERE " + this.buildTrinoWhereClauses(zone, testCases);
        this.assertQuery(session, actual, expected);
    }

    private String buildTrinoWhereClauses(String zone, List<Instant> testCases) {
        Instant stored;
        int i;
        ArrayList<String> predicates = new ArrayList<String>();
        for (i = 0; i < testCases.size(); ++i) {
            stored = testCases.get(i).atZone(ZoneId.of(zone)).withZoneSameLocal(UTC).toInstant();
            predicates.add(String.format("col_%d = %s", i + 1, WHERE_VALUE_FORMATTER.format(stored)));
        }
        for (i = 0; i < testCases.size(); ++i) {
            stored = testCases.get(i);
            predicates.add(String.format("col_%d = %s", testCases.size() + i + 1, WHERE_VALUE_FORMATTER.format(stored)));
        }
        return String.join((CharSequence)" AND ", predicates);
    }
}

