/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.deltalake.BaseDeltaLakeSharedMetastoreWithTableRedirectionsTest;
import io.trino.plugin.deltalake.TestingDeltaLakePlugin;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeSharedFileMetastoreWithTableRedirections
extends BaseDeltaLakeSharedMetastoreWithTableRedirectionsTest {
    private Path dataDirectory;

    protected QueryRunner createQueryRunner() throws Exception {
        Session deltaLakeSession = TestingSession.testSessionBuilder().setCatalog("delta_with_redirections").setSchema(this.schema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)deltaLakeSession).build();
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("data");
        queryRunner.installPlugin((Plugin)new TestingDeltaLakePlugin(this.dataDirectory));
        ImmutableMap deltaLakeProperties = ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.dataDirectory.toString()).put((Object)"delta.enable-non-concurrent-writes", (Object)"true").put((Object)"delta.hive-catalog-name", (Object)"hive_with_redirections").put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow();
        queryRunner.createCatalog("delta_with_redirections", "delta_lake", (Map)deltaLakeProperties);
        queryRunner.execute("CREATE SCHEMA " + this.schema);
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(this.dataDirectory));
        queryRunner.createCatalog("hive_with_redirections", "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)this.dataDirectory.toString()).put((Object)"hive.delta-lake-catalog-name", (Object)"delta_with_redirections").put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow());
        queryRunner.execute("CREATE TABLE hive_with_redirections." + this.schema + ".hive_table (a_integer) WITH (format='PARQUET') AS VALUES 1, 2, 3");
        queryRunner.execute("CREATE TABLE delta_with_redirections." + this.schema + ".delta_table (a_varchar) AS VALUES 'a', 'b', 'c'");
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        this.getQueryRunner().execute("DROP TABLE IF EXISTS hive_with_redirections." + this.schema + ".region");
        this.getQueryRunner().execute("DROP TABLE IF EXISTS delta_with_redirections." + this.schema + ".nation");
        this.getQueryRunner().execute("DROP SCHEMA IF EXISTS hive." + this.schema);
    }

    @Override
    protected String getExpectedHiveCreateSchema(String catalogName) {
        String expectedHiveCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s/%s'\n)";
        return String.format(expectedHiveCreateSchema, catalogName, this.schema, this.dataDirectory, this.schema);
    }

    @Override
    protected String getExpectedDeltaLakeCreateSchema(String catalogName) {
        String expectedDeltaLakeCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s/%s'\n)";
        return String.format(expectedDeltaLakeCreateSchema, catalogName, this.schema, this.dataDirectory, this.schema);
    }
}

