/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.deltalake.BaseDeltaLakeSharedMetastoreWithTableRedirectionsTest;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.spi.Plugin;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.nio.file.Path;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.TableInput;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeSharedGlueMetastoreWithTableRedirections
extends BaseDeltaLakeSharedMetastoreWithTableRedirectionsTest {
    private Path dataDirectory;
    private GlueHiveMetastore glueMetastore;

    protected QueryRunner createQueryRunner() throws Exception {
        Session deltaLakeSession = TestingSession.testSessionBuilder().setCatalog("delta_with_redirections").setSchema(this.schema).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)deltaLakeSession).build();
        this.dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("delta_lake_data");
        queryRunner.installPlugin((Plugin)new DeltaLakePlugin());
        queryRunner.createCatalog("delta_with_redirections", "delta_lake", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"glue").put((Object)"hive.metastore.glue.default-warehouse-dir", (Object)this.dataDirectory.toUri().toString()).put((Object)"delta.hive-catalog-name", (Object)"hive_with_redirections").put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow());
        TestDeltaLakeSharedGlueMetastoreWithTableRedirections testDeltaLakeSharedGlueMetastoreWithTableRedirections = this;
        this.glueMetastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)this.dataDirectory, x$0 -> testDeltaLakeSharedGlueMetastoreWithTableRedirections.closeAfterClass((AutoCloseable)x$0));
        queryRunner.installPlugin((Plugin)new TestingHivePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data"), (HiveMetastore)this.glueMetastore));
        queryRunner.createCatalog("hive_with_redirections", "hive", (Map)ImmutableMap.of((Object)"hive.delta-lake-catalog-name", (Object)"delta_with_redirections", (Object)"fs.hadoop.enabled", (Object)"true"));
        queryRunner.execute("CREATE SCHEMA " + this.schema + " WITH (location = '" + String.valueOf(this.dataDirectory.toUri()) + "')");
        queryRunner.execute("CREATE TABLE hive_with_redirections." + this.schema + ".hive_table (a_integer) WITH (format='PARQUET') AS VALUES 1, 2, 3");
        queryRunner.execute("CREATE TABLE delta_with_redirections." + this.schema + ".delta_table (a_varchar) AS VALUES 'a', 'b', 'c'");
        return queryRunner;
    }

    @AfterAll
    public void cleanup() {
        this.glueMetastore.dropDatabase(this.schema, false);
        this.glueMetastore.shutdown();
    }

    @Override
    protected String getExpectedHiveCreateSchema(String catalogName) {
        String expectedHiveCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s'\n)";
        return String.format(expectedHiveCreateSchema, catalogName, this.schema, this.dataDirectory.toUri());
    }

    @Override
    protected String getExpectedDeltaLakeCreateSchema(String catalogName) {
        String expectedDeltaLakeCreateSchema = "CREATE SCHEMA %s.%s\nWITH (\n   location = '%s'\n)";
        return String.format(expectedDeltaLakeCreateSchema, catalogName, this.schema, this.dataDirectory.toUri());
    }

    @Test
    public void testUnsupportedHiveTypeRedirect() {
        String location;
        String tableName = "unsupported_types";
        try (GlueClient glueClient = GlueClient.create();){
            GetTableResponse existingTable = glueClient.getTable((GetTableRequest)GetTableRequest.builder().databaseName(this.schema).name("delta_table").build());
            location = existingTable.table().storageDescriptor().location();
        }
        Column timestampColumn = (Column)Column.builder().name("last_hour_load").type("timestamp_ntz").build();
        StorageDescriptor sd = (StorageDescriptor)StorageDescriptor.builder().columns(new Column[]{timestampColumn}).location(location).inputFormat("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").outputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat").serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").parameters(Map.of("serialization.format", "1", "path", location)).build()).build();
        TableInput tableInput = (TableInput)TableInput.builder().name(tableName).storageDescriptor(sd).parameters(Map.of("spark.sql.sources.provider", "delta")).tableType("EXTERNAL_TABLE").partitionKeys(new Column[]{timestampColumn}).build();
        CreateTableRequest createTableRequest = (CreateTableRequest)CreateTableRequest.builder().databaseName(this.schema).tableInput(tableInput).build();
        try (GlueClient glueClient = GlueClient.create();){
            glueClient.createTable(createTableRequest);
            String tableDefinition = (String)this.computeScalar("SHOW CREATE TABLE hive_with_redirections." + this.schema + "." + tableName);
            String expected = "CREATE TABLE delta_with_redirections.%s.%s (\n   a_varchar varchar\n)\nWITH (\n   location = '%s'\n)";
            Assertions.assertThat((String)tableDefinition).isEqualTo(expected.formatted(this.schema, tableName, location));
            glueClient.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().databaseName(this.schema).name(tableInput.name()).build());
        }
    }
}

