/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.TestingHivePlugin;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeSharedHiveMetastoreWithViews
extends AbstractTestQueryFramework {
    private final String bucketName = "delta-lake-shared-hive-with-views-" + TestingNames.randomNameSuffix();
    private Hive3MinioDataLake hiveMinioDataLake;
    private String schema;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        DistributedQueryRunner queryRunner = DeltaLakeQueryRunner.builder().addMetastoreProperties(this.hiveMinioDataLake.getHiveHadoop()).addS3Properties(this.hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
        try {
            queryRunner.installPlugin((Plugin)new TestingHivePlugin(queryRunner.getCoordinator().getBaseDataDir().resolve("hive_data")));
            queryRunner.createCatalog("hive", "hive", (Map)ImmutableMap.builder().put((Object)"hive.metastore", (Object)"thrift").put((Object)"hive.metastore.uri", (Object)this.hiveMinioDataLake.getHiveMetastoreEndpoint().toString()).put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.hiveMinioDataLake.getMinio().getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"s3.streaming.part-size", (Object)"5MB").buildOrThrow());
            this.schema = (String)queryRunner.getDefaultSession().getSchema().orElseThrow();
            queryRunner.execute("CREATE TABLE hive." + this.schema + ".hive_table (a_integer integer)");
            this.hiveMinioDataLake.runOnHive("CREATE VIEW " + this.schema + ".hive_view AS SELECT *  FROM " + this.schema + ".hive_table");
            queryRunner.execute("CREATE TABLE delta." + this.schema + ".delta_table (a_varchar varchar)");
            return queryRunner;
        }
        catch (Exception e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
    }

    @AfterAll
    public void cleanup() {
        this.assertQuerySucceeds("DROP TABLE IF EXISTS hive." + this.schema + ".hive_table");
        this.hiveMinioDataLake.runOnHive("DROP VIEW IF EXISTS " + this.schema + ".hive_view");
        this.assertQuerySucceeds("DROP TABLE IF EXISTS delta." + this.schema + ".delta_table");
        this.assertQuerySucceeds("DROP SCHEMA IF EXISTS hive." + this.schema);
    }

    @Test
    public void testReadInformationSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM hive.information_schema.tables WHERE table_name = 'hive_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT table_schema FROM delta.information_schema.tables WHERE table_name = 'delta_table' AND table_schema='" + this.schema + "'"))).skippingTypesCheck().containsAll("VALUES '" + this.schema + "'");
        this.assertQuery("SELECT table_name, column_name from hive.information_schema.columns WHERE table_schema = '" + this.schema + "'", "VALUES ('hive_table', 'a_integer')");
        this.assertQuery("SELECT table_name, column_name from delta.information_schema.columns WHERE table_schema = '" + this.schema + "'", "VALUES ('delta_table', 'a_varchar')");
    }

    @Test
    public void testShowTables() {
        this.assertQuery("SHOW TABLES FROM delta." + this.schema, "VALUES 'hive_table', 'hive_view', 'delta_table'");
        this.assertQuery("SHOW TABLES FROM hive." + this.schema, "VALUES 'hive_table', 'hive_view', 'delta_table'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW CREATE TABLE delta." + this.schema + ".hive_table"))).failure().hasMessageContaining("not a Delta Lake table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW CREATE TABLE delta." + this.schema + ".hive_view"))).failure().hasMessageContaining("not a Delta Lake table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW CREATE TABLE hive." + this.schema + ".delta_table"))).failure().hasMessageContaining("Cannot query Delta Lake table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE delta." + this.schema + ".hive_table"))).failure().hasMessageContaining("not a Delta Lake table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("DESCRIBE hive." + this.schema + ".delta_table"))).failure().hasMessageContaining("Cannot query Delta Lake table");
    }
}

