/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeSystemTables
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return DeltaLakeQueryRunner.builder().addDeltaProperty("delta.register-table-procedure.enabled", "true").addDeltaProperty("delta.enable-non-concurrent-writes", "true").build();
    }

    @Test
    public void testHistoryTable() {
        try {
            this.assertUpdate("CREATE TABLE test_simple_table (_bigint BIGINT)");
            this.assertUpdate("INSERT INTO test_simple_table VALUES 1, 2, 3", 3L);
            this.assertQuery("SELECT count(*) FROM test_simple_table", "VALUES 3");
            this.assertUpdate("CREATE TABLE test_checkpoint_table (_bigint BIGINT, _date DATE) WITH (partitioned_by = ARRAY['_date'] )");
            this.assertUpdate("INSERT INTO test_checkpoint_table VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO test_checkpoint_table VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
            this.assertUpdate("UPDATE test_checkpoint_table SET _bigint = 50 WHERE _bigint =  BIGINT '5'", 1L);
            this.assertUpdate("DELETE FROM test_checkpoint_table WHERE _date =  DATE '2019-09-08'", 1L);
            this.assertQuerySucceeds("ALTER TABLE test_checkpoint_table EXECUTE OPTIMIZE");
            this.assertQuery("SELECT count(*) FROM test_checkpoint_table", "VALUES 5");
            this.assertQuery("SHOW COLUMNS FROM \"test_checkpoint_table$history\"", "VALUES\n('version', 'bigint', '', ''),\n('timestamp', 'timestamp(3) with time zone', '', ''),\n('user_id', 'varchar', '', ''),\n('user_name', 'varchar', '', ''),\n('operation', 'varchar', '', ''),\n('operation_parameters', 'map(varchar, varchar)', '', ''),\n('cluster_id', 'varchar', '', ''),\n('read_version', 'bigint', '', ''),\n('isolation_level', 'varchar', '', ''),\n('is_blind_append', 'boolean', '', ''),\n('operation_metrics', 'map(varchar, varchar)', '', '')\n");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT version, operation, read_version, isolation_level, is_blind_append FROM \"test_simple_table$history\""))).matches("VALUES\n    (BIGINT '1', VARCHAR 'WRITE', BIGINT '0', VARCHAR 'WriteSerializable', true),\n    (BIGINT '0', VARCHAR 'CREATE TABLE', BIGINT '0', VARCHAR 'WriteSerializable', true)\n");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT version, operation, read_version, isolation_level, is_blind_append FROM \"test_checkpoint_table$history\""))).matches("VALUES\n    (BIGINT '5', VARCHAR 'OPTIMIZE', BIGINT '4', VARCHAR 'WriteSerializable', false),\n    (BIGINT '4', VARCHAR 'DELETE', BIGINT '3', VARCHAR 'WriteSerializable', false),\n    (BIGINT '3', VARCHAR 'MERGE', BIGINT '2', VARCHAR 'WriteSerializable', false),\n    (BIGINT '2', VARCHAR 'WRITE', BIGINT '1', VARCHAR 'WriteSerializable', true),\n    (BIGINT '1', VARCHAR 'WRITE', BIGINT '0', VARCHAR 'WriteSerializable', true),\n    (BIGINT '0', VARCHAR 'CREATE TABLE', BIGINT '0', VARCHAR 'WriteSerializable', true)\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS test_simple_table");
            this.assertUpdate("DROP TABLE IF EXISTS test_checkpoint_table");
        }
    }

    @Test
    void testTransactionsTable() {
        try (TestTable table = this.newTrinoTable("test_transactions", "(col int)");){
            Assertions.assertThat((String)((String)this.computeScalar("SELECT transaction FROM \"" + table.getName() + "$transactions\""))).contains(new CharSequence[]{"commitInfo", "protocol", "metaData"});
        }
    }

    @Test
    void testTransactionsTableAccessControl() {
        try (TestTable table = this.newTrinoTable("test_transactions", "(col int)");){
            this.assertAccessAllowed("SELECT * FROM \"" + table.getName() + "$transactions\"", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)table.getName(), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
            this.assertAccessDenied("SELECT * FROM \"" + table.getName() + "$transactions\"", "Cannot select from columns .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(table.getName() + "$transactions"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        }
    }

    @Test
    public void testPropertiesTable() {
        String tableName = "test_simple_properties_table";
        try {
            this.assertUpdate("CREATE TABLE " + tableName + " (_bigint BIGINT) WITH (change_data_feed_enabled = true, checkpoint_interval = 5)");
            this.assertQuery("SELECT * FROM \"" + tableName + "$properties\"", "VALUES ('delta.enableChangeDataFeed', 'true'),('delta.enableDeletionVectors', 'false'),('delta.checkpointInterval', '5'),('delta.minReaderVersion', '1'),('delta.minWriterVersion', '4')");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTable() {
        String tableName = "test_simple_partitions_table_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _date DATE) WITH (partitioned_by = ARRAY['_date'])");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (6, NULL)", 1L);
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 7");
            this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 4");
            this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('partition', 'row(_date date)', '', ''),\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(_bigint row(min bigint, max bigint, null_count bigint))', '', '')\n");
            this.assertQuery("SELECT partition._date FROM \"" + tableName + "$partitions\"", " VALUES DATE '2019-09-08', DATE '2019-09-09', DATE '2019-09-10', NULL");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._bigint AS ROW(BIGINT, BIGINT, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES\nROW(ROW(BIGINT '0', BIGINT '0', BIGINT '0')),\nROW(ROW(BIGINT '1', BIGINT '3', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '5', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '6', BIGINT '0'))\n");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (NULL, CAST('2019-09-09' AS DATE))", 1L);
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 8");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._bigint AS ROW(BIGINT, BIGINT, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES\nROW(ROW(BIGINT '0', BIGINT '0', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '5', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '6', BIGINT '0')),\nROW(ROW(NULL, NULL, BIGINT '1'))\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTableCaseSensitiveColumns() throws Exception {
        String tableName = "test_partitions_table_case_sensitive_columns_" + TestingNames.randomNameSuffix();
        Path tableLocation = Files.createTempFile(tableName, null, new FileAttribute[0]);
        TestingDeltaLakeUtils.copyDirectoryContents(new File(Resources.getResource((String)"databricks133/partition_values_parsed_case_sensitive").toURI()).toPath(), tableLocation);
        this.assertUpdate("CALL system.register_table('%s', '%s', '%s')".formatted(this.getSession().getSchema().orElseThrow(), tableName, tableLocation.toUri()));
        this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 3");
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (100, 1, 'ala'), (200, 2, 'kota'), (300, 3, 'osla')");
        this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 3");
        this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('partition', 'row(part_NuMbEr integer, part_StRiNg varchar)', '', ''),\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(id row(min integer, max integer, null_count bigint))', '', '')\n");
        this.assertQuery("SELECT partition.part_NuMbEr, partition.part_StRiNg FROM \"" + tableName + "$partitions\"", "VALUES (1, 'ala'), (2, 'kota'), (3, 'osla')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data.id AS ROW(INTEGER, INTEGER, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES ROW(ROW(100, 100, BIGINT '0')), ROW(ROW(200, 200, BIGINT '0')), ROW(ROW(300, 300, BIGINT '0'))");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES (1, 1, 'ala'), (2, 2, 'kota'), (3, 3, 'osla')", 3L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data.id AS ROW(INTEGER, INTEGER, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES ROW(ROW(1, 100, BIGINT '0')), ROW(ROW(2, 200, BIGINT '0')), ROW(ROW(3, 300, BIGINT '0'))");
    }

    @Test
    public void testColumnMappingModePartitionsTable() {
        for (String columnMappingMode : ImmutableList.of((Object)"id", (Object)"name", (Object)"none")) {
            this.testColumnMappingModePartitionsTable(columnMappingMode);
        }
    }

    private void testColumnMappingModePartitionsTable(String columnMappingMode) {
        String tableName = "test_simple_column_mapping_mode_" + columnMappingMode + "_partitions_table_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _date DATE) WITH (column_mapping_mode = '" + columnMappingMode + "', partitioned_by = ARRAY['_date'])");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (6, NULL), (NULL, CAST('2019-09-08' AS DATE)), (NULL, CAST('2019-09-08' AS DATE))", 3L);
            this.assertQuerySucceeds("SELECT * FROM " + tableName);
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 9");
            this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 4");
            this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('partition', 'row(_date date)', '', ''),\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(_bigint row(min bigint, max bigint, null_count bigint))', '', '')\n");
            this.assertQuery("SELECT partition._date FROM \"" + tableName + "$partitions\"", " VALUES DATE '2019-09-08', DATE '2019-09-09', DATE '2019-09-10', NULL");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._bigint AS ROW(BIGINT, BIGINT, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES\nROW(ROW(BIGINT '1', BIGINT '3', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '5', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '6', BIGINT '0')),\nROW(ROW(CAST(NULL AS BIGINT), CAST(NULL AS BIGINT), BIGINT '2'))\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTableMultipleColumns() {
        String tableName = "test_partitions_table_multiple_columns_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _date DATE, _varchar VARCHAR) WITH (partitioned_by = ARRAY['_date', '_varchar'])");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (0, CAST('2019-09-08' AS DATE), 'a'), (1, CAST('2019-09-09' AS DATE), 'b'), (2, CAST('2019-09-09' AS DATE), 'c')", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, CAST('2019-09-09' AS DATE), 'd'), (4, CAST('2019-09-10' AS DATE), 'e'), (5, CAST('2019-09-10' AS DATE), 'f'), (4, CAST('2019-09-10' AS DATE), 'f')", 4L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (6, null, 'g'), (6, CAST('2019-09-10' AS DATE), null), (7, null, null), (8, null, 'g')", 4L);
            this.assertUpdate("UPDATE " + tableName + " SET _bigint = 50 WHERE _bigint =  BIGINT '5'", 1L);
            this.assertUpdate("DELETE FROM " + tableName + " WHERE _date =  DATE '2019-09-08'", 1L);
            this.assertQuerySucceeds("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 10");
            this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 8");
            this.assertQuery("SELECT count(partition._varchar) FROM \"" + tableName + "$partitions\"", "VALUES 6");
            this.assertQuery("SELECT count(distinct partition._date) FROM \"" + tableName + "$partitions\"", "VALUES 2");
            this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('partition', 'row(_date date, _varchar varchar)', '', ''),\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(_bigint row(min bigint, max bigint, null_count bigint))', '', '')\n");
            this.assertQuery("SELECT partition._date, partition._varchar FROM \"" + tableName + "$partitions\"", "VALUES\n(DATE '2019-09-09', 'b'),\n(DATE '2019-09-09', 'c'),\n(DATE '2019-09-09', 'd'),\n(DATE '2019-09-10', 'e'),\n(DATE '2019-09-10', 'f'),\n(DATE '2019-09-10', null),\n(null, 'g'),\n(null, null)\n");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._bigint AS ROW(BIGINT, BIGINT, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES\nROW(ROW(BIGINT '1', BIGINT '1', BIGINT '0')),\nROW(ROW(BIGINT '2', BIGINT '2', BIGINT '0')),\nROW(ROW(BIGINT '3', BIGINT '3', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '4', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '50', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '6', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '8', BIGINT '0')),\nROW(ROW(BIGINT '7', BIGINT '7', BIGINT '0'))\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTableDifferentOrderFromDefinitionMultipleColumns() {
        String tableName = "test_partitions_table_different_order_from_definition_multiple_columns_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _date DATE, _varchar VARCHAR) WITH (partitioned_by = ARRAY['_varchar', '_date'])");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (0, CAST('2019-09-08' AS DATE), 'a'), (1, CAST('2019-09-09' AS DATE), 'b'), (2, CAST('2019-09-09' AS DATE), 'c')", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, CAST('2019-09-09' AS DATE), 'd'), (4, CAST('2019-09-10' AS DATE), 'e'), (5, CAST('2019-09-10' AS DATE), 'f'), (4, CAST('2019-09-10' AS DATE), 'f')", 4L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (6, null, 'g'), (6, CAST('2019-09-10' AS DATE), null), (7, null, null), (8, null, 'g')", 4L);
            this.assertUpdate("UPDATE " + tableName + " SET _bigint = 50 WHERE _bigint =  BIGINT '5'", 1L);
            this.assertUpdate("DELETE FROM " + tableName + " WHERE _date =  DATE '2019-09-08'", 1L);
            this.assertQuerySucceeds("ALTER TABLE " + tableName + " EXECUTE OPTIMIZE");
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 10");
            this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 8");
            this.assertQuery("SELECT count(partition._varchar) FROM \"" + tableName + "$partitions\"", "VALUES 6");
            this.assertQuery("SELECT count(distinct partition._date) FROM \"" + tableName + "$partitions\"", "VALUES 2");
            this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('partition', 'row(_varchar varchar, _date date)', '', ''),\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(_bigint row(min bigint, max bigint, null_count bigint))', '', '')\n");
            this.assertQuery("SELECT partition._varchar, partition._date FROM \"" + tableName + "$partitions\"", "VALUES\n('b', DATE '2019-09-09'),\n('c', DATE '2019-09-09'),\n('d', DATE '2019-09-09'),\n('e', DATE '2019-09-10'),\n('f', DATE '2019-09-10'),\n(null, DATE '2019-09-10'),\n('g', null),\n(null, null)\n");
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._bigint AS ROW(BIGINT, BIGINT, BIGINT)) FROM \"" + tableName + "$partitions\""))).matches("VALUES\nROW(ROW(BIGINT '1', BIGINT '1', BIGINT '0')),\nROW(ROW(BIGINT '2', BIGINT '2', BIGINT '0')),\nROW(ROW(BIGINT '3', BIGINT '3', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '4', BIGINT '0')),\nROW(ROW(BIGINT '4', BIGINT '50', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '6', BIGINT '0')),\nROW(ROW(BIGINT '6', BIGINT '8', BIGINT '0')),\nROW(ROW(BIGINT '7', BIGINT '7', BIGINT '0'))\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTableColumnTypes() {
        this.testPartitionsTableColumnTypes("BOOLEAN", "VALUES (true, 'a'), (false, 'a'), (false, 'b'), (false, 'b')", 4, "VALUES\nROW(ROW(CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN), BIGINT '0')),\nROW(ROW(CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN), BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("INTEGER", "VALUES (3, 'a'), (6, 'a'), (0, 'b'), (9, 'b')", 4, "VALUES\nROW(ROW(0, 9, BIGINT '0')),\nROW(ROW(3, 6, BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("TINYINT", "VALUES (3, 'a'), (6, 'a'), (0, 'b'), (9, 'b')", 4, "VALUES\nROW(ROW(TINYINT '0', TINYINT '9', BIGINT '0')),\nROW(ROW(TINYINT '3', TINYINT '6', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("SMALLINT", "VALUES (3, 'a'), (6, 'a'), (0, 'b'), (9, 'b')", 4, "VALUES\nROW(ROW(SMALLINT '0', SMALLINT '9', BIGINT '0')),\nROW(ROW(SMALLINT '3', SMALLINT '6', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("BIGINT", "VALUES (3, 'a'), (6, 'a'), (0, 'b'), (9, 'b')", 4, "VALUES\nROW(ROW(BIGINT '0', BIGINT '9', BIGINT '0')),\nROW(ROW(BIGINT '3', BIGINT '6', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("REAL", "VALUES (10.3, 'a'), (15.7, 'a'), (3.2, 'b'), (6.1, 'b')", 4, "VALUES\nROW(ROW(REAL '3.2', REAL '6.1', BIGINT '0')),\nROW(ROW(REAL '10.3', REAL '15.7', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("DOUBLE", "VALUES (3.2, 'a'), (7.25, 'a'), (7.25, 'b'), (18.9382, 'b')", 4, "VALUES\nROW(ROW(DOUBLE '3.2', DOUBLE '7.25', BIGINT '0')),\nROW(ROW(DOUBLE '7.25', DOUBLE '18.9382', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("DECIMAL(10)", "VALUES (5.6, 'a'), (1.2, 'a'), (532.62, 'b'), (153.27, 'b')", 4, "VALUES\nROW(ROW(CAST(1.2 AS DECIMAL(10)), CAST(5.6 AS DECIMAL(10)), BIGINT '0')),\nROW(ROW(CAST(153.27 AS DECIMAL(10)), CAST(532.62 AS DECIMAL(10)), BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("DECIMAL(20)", "VALUES (0.64525495002404036507, 'a'), (0.77003757467454995626, 'a'), (0.05016312397354421814, 'b'), (0.69575427222174470843, 'b')", 4, "VALUES\nROW(ROW(CAST(0.05016312397354421814 AS DECIMAL(20)), CAST(0.69575427222174470843 AS DECIMAL(20)), BIGINT '0')),\nROW(ROW(CAST(0.64525495002404036507 AS DECIMAL(20)), CAST(0.77003757467454995626 AS DECIMAL(20)), BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("DATE", "VALUES (CAST('2019-09-08' AS DATE), 'a'), (CAST('2020-09-08' AS DATE), 'a'), (CAST('2019-09-07' AS DATE), 'b'), (CAST('2019-09-08' AS DATE), 'b')", 4, "VALUES\nROW(ROW(DATE '2019-09-07', DATE '2019-09-08', BIGINT '0')),\nROW(ROW(DATE '2019-09-08', DATE '2020-09-08', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("TIMESTAMP(6)", "VALUES (TIMESTAMP '2001-05-06 12:34:56.123456', 'a'), (TIMESTAMP '2001-05-06 12:34:56.567890', 'a'), (TIMESTAMP '2001-05-06 12:34:56.123456', 'b'), (TIMESTAMP '2001-05-06 12:34:56.123457', 'b')", 4, "VALUES\nROW(ROW(TIMESTAMP '2001-05-06 12:34:56.123000', TIMESTAMP '2001-05-06 12:34:56.568000', BIGINT '0')),\nROW(ROW(TIMESTAMP '2001-05-06 12:34:56.123000', TIMESTAMP '2001-05-06 12:34:56.124000', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("TIMESTAMP(3) WITH TIME ZONE", "VALUES (TIMESTAMP '2001-05-06 12:34:56.123 UTC', 'a'), (TIMESTAMP '2001-05-06 12:34:56.234 -08:30', 'a'), (TIMESTAMP '2001-05-06 12:34:56.567 GMT-08:30', 'b'), (TIMESTAMP '2001-05-06 12:34:56.789 America/New_York', 'b')", 4, "VALUES\nROW(ROW(TIMESTAMP '2001-05-06 12:34:56.123 UTC', TIMESTAMP '2001-05-06 21:04:56.234 UTC', BIGINT '0')),\nROW(ROW(TIMESTAMP '2001-05-06 16:34:56.789 UTC', TIMESTAMP '2001-05-06 21:04:56.567 UTC', BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("VARCHAR", "VALUES ('z', 'a'), ('x', 'a'), ('a', 'b'), ('b', 'b')", 4, "VALUES\nROW(ROW(CAST('a' AS VARCHAR), CAST('b' AS VARCHAR), BIGINT '0')),\nROW(ROW(CAST('x' AS VARCHAR), CAST('z' AS VARCHAR), BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("VARBINARY", "VALUES (VARBINARY 'abcd', 'a'), (VARBINARY 'jkl', 'a'), (VARBINARY 'mno', 'b'), (VARBINARY 'xyzz', 'b')", 4, "VALUES\nROW(ROW(CAST(NULL AS VARBINARY), CAST(NULL AS VARBINARY), BIGINT '0')),\nROW(ROW(CAST(NULL AS VARBINARY), CAST(NULL AS VARBINARY), BIGINT '0'))\n");
        this.testPartitionsTableColumnTypes("ARRAY(INTEGER)", "VALUES (ARRAY[3, 2, null, 5, null, 1, 2], 'a'), (ARRAY[null, 1, 3, 5, 7, 9, 11], 'a'), (ARRAY[7, 3, 2, 6, 5, 4, 3], 'b'), (ARRAY[2, 6, 3, 5, null, 1, 6], 'b')", 4, "VALUES\nROW(ROW(CAST(NULL AS ARRAY(INTEGER)), CAST(NULL AS ARRAY(INTEGER)), CAST(NULL AS BIGINT))),\nROW(ROW(CAST(NULL AS ARRAY(INTEGER)), CAST(NULL AS ARRAY(INTEGER)), CAST(NULL AS BIGINT)))\n");
        this.testPartitionsTableColumnTypes("MAP(INTEGER, INTEGER)", "VALUES (MAP(ARRAY[1,3], ARRAY[2,4]), 'a'), (MAP(ARRAY[1,2], ARRAY[3,4]), 'a'), (MAP(ARRAY[8,3], ARRAY[7,4]), 'b'), (MAP(ARRAY[1,5], ARRAY[2,7]), 'b')", 4, "VALUES\nROW(ROW(CAST(NULL AS MAP(INTEGER, INTEGER)), CAST(NULL AS MAP(INTEGER, INTEGER)), CAST(NULL AS BIGINT))),\nROW(ROW(CAST(NULL AS MAP(INTEGER, INTEGER)), CAST(NULL AS MAP(INTEGER, INTEGER)), CAST(NULL AS BIGINT)))\n");
        this.testPartitionsTableColumnTypes("ROW(row_integer_1 INTEGER, row_integer_2 INTEGER)", "VALUES (ROW(1,3), 'a'), (ROW(1,2), 'a'), (ROW(8,3), 'b'), (ROW(1,5), 'b')", 4, "VALUES\nROW(ROW(CAST(NULL AS ROW(row_integer_1 INTEGER, row_integer_2 INTEGER)), CAST(NULL AS ROW(row_integer_1 INTEGER, row_integer_2 INTEGER)), CAST(NULL AS BIGINT))),\nROW(ROW(CAST(NULL AS ROW(row_integer_1 INTEGER, row_integer_2 INTEGER)), CAST(NULL AS ROW(row_integer_1 INTEGER, row_integer_2 INTEGER)), CAST(NULL AS BIGINT)))\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPartitionsTableColumnTypes(String type, @Language(value="SQL") String insertIntoValues, int insertIntoValuesCount, @Language(value="SQL") String expectedDataColumn) {
        String tableName = "test_partitions_table_data_column_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_nonpartition " + type + ", _partition VARCHAR) WITH (partitioned_by = ARRAY['_partition'])");
            this.assertUpdate("INSERT INTO " + tableName + " " + insertIntoValues, insertIntoValuesCount);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(data._nonpartition AS ROW(" + type + "," + type + ", BIGINT)) FROM \"" + tableName + "$partitions\""))).matches(expectedDataColumn);
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }

    @Test
    public void testPartitionsTableUnpartitioned() {
        String tableName = "test_partitions_table_unpartitioned_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate("CREATE TABLE " + tableName + "(_bigint BIGINT, _date DATE)");
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (0, CAST('2019-09-08' AS DATE)), (1, CAST('2019-09-09' AS DATE)), (2, CAST('2019-09-09' AS DATE))", 3L);
            this.assertUpdate("INSERT INTO " + tableName + " VALUES (3, CAST('2019-09-09' AS DATE)), (4, CAST('2019-09-10' AS DATE)), (5, CAST('2019-09-10' AS DATE))", 3L);
            this.assertQuery("SELECT count(*) FROM " + tableName, "VALUES 6");
            this.assertQuery("SELECT count(*) FROM \"" + tableName + "$partitions\"", "VALUES 0");
            this.assertQueryReturnsEmptyResult("SELECT * FROM \"" + tableName + "$partitions\"");
            this.assertQuery("SHOW COLUMNS FROM \"" + tableName + "$partitions\"", "VALUES\n('file_count', 'bigint', '', ''),\n('total_size', 'bigint', '', ''),\n('data', 'row(_bigint row(min bigint, max bigint, null_count bigint), _date row(min date, max date, null_count bigint))', '', '')\n");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + tableName);
        }
    }
}

