/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeTableName;
import io.trino.plugin.deltalake.DeltaLakeTableType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeTableName {
    @Test
    public void testParse() {
        TestDeltaLakeTableName.assertParseNameAndType("abc", "abc", DeltaLakeTableType.DATA);
        TestDeltaLakeTableName.assertParseNameAndType("abc$history", "abc", DeltaLakeTableType.HISTORY);
        TestDeltaLakeTableName.assertParseNameAndType("abc$properties", "abc", DeltaLakeTableType.PROPERTIES);
        TestDeltaLakeTableName.assertParseNameAndType("abc$partitions", "abc", DeltaLakeTableType.PARTITIONS);
        TestDeltaLakeTableName.assertNoValidTableType("abc$data");
        TestDeltaLakeTableName.assertInvalid("abc@123", "Invalid Delta Lake table name: abc@123");
        TestDeltaLakeTableName.assertInvalid("abc@xyz", "Invalid Delta Lake table name: abc@xyz");
        TestDeltaLakeTableName.assertNoValidTableType("abc$what");
        TestDeltaLakeTableName.assertInvalid("abc@123$data@456", "Invalid Delta Lake table name: abc@123$data@456");
        TestDeltaLakeTableName.assertInvalid("xyz$data@456", "Invalid Delta Lake table name: xyz$data@456");
    }

    @Test
    public void testIsDataTable() {
        Assertions.assertThat((boolean)DeltaLakeTableName.isDataTable((String)"abc")).isTrue();
        Assertions.assertThat((boolean)DeltaLakeTableName.isDataTable((String)"abc$data")).isFalse();
        Assertions.assertThat((boolean)DeltaLakeTableName.isDataTable((String)"abc$history")).isFalse();
        Assertions.assertThat((boolean)DeltaLakeTableName.isDataTable((String)"abc$partitions")).isFalse();
        Assertions.assertThat((boolean)DeltaLakeTableName.isDataTable((String)"abc$invalid")).isFalse();
    }

    @Test
    public void testTableNameFrom() {
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc")).isEqualTo("abc");
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc$data")).isEqualTo("abc");
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc$history")).isEqualTo("abc");
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc$properties")).isEqualTo("abc");
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc$partitions")).isEqualTo("abc");
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)"abc$invalid")).isEqualTo("abc");
    }

    @Test
    public void testTableTypeFrom() {
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc")).isEqualTo(Optional.of(DeltaLakeTableType.DATA));
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc$data")).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc$history")).isEqualTo(Optional.of(DeltaLakeTableType.HISTORY));
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc$properties")).isEqualTo(Optional.of(DeltaLakeTableType.PROPERTIES));
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc$partitions")).isEqualTo(Optional.of(DeltaLakeTableType.PARTITIONS));
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)"abc$invalid")).isEqualTo(Optional.empty());
    }

    private static void assertNoValidTableType(String inputName) {
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)inputName)).isEmpty();
    }

    private static void assertInvalid(String inputName, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> DeltaLakeTableName.tableTypeFrom((String)inputName)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage(message);
    }

    private static void assertParseNameAndType(String inputName, String tableName, DeltaLakeTableType tableType) {
        Assertions.assertThat((String)DeltaLakeTableName.tableNameFrom((String)inputName)).isEqualTo(tableName);
        Assertions.assertThat((Optional)DeltaLakeTableName.tableTypeFrom((String)inputName)).isEqualTo(Optional.of(tableType));
    }
}

