/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.deltalake.BaseDeltaLakeTableWithCustomLocation;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingNames;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeTableWithCustomLocationUsingGlueMetastore
extends BaseDeltaLakeTableWithCustomLocation {
    private GlueHiveMetastore metastore;
    private String schema;

    protected QueryRunner createQueryRunner() throws Exception {
        Path warehouseDir = Files.createTempDirectory("warehouse-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)warehouseDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        TestDeltaLakeTableWithCustomLocationUsingGlueMetastore testDeltaLakeTableWithCustomLocationUsingGlueMetastore = this;
        this.metastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)warehouseDir, x$0 -> testDeltaLakeTableWithCustomLocationUsingGlueMetastore.closeAfterClass((AutoCloseable)x$0));
        this.schema = "test_tables_with_custom_location" + TestingNames.randomNameSuffix();
        return DeltaLakeQueryRunner.builder(this.schema).addDeltaProperty("hive.metastore", "glue").addDeltaProperty("hive.metastore.glue.region", SystemEnvironmentUtils.requireEnv((String)"AWS_REGION")).addDeltaProperty("hive.metastore.glue.default-warehouse-dir", warehouseDir.toUri().toString()).build();
    }

    @AfterAll
    public void tearDown() {
        this.metastore.dropDatabase(this.schema, false);
        this.metastore.shutdown();
    }
}

