/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slices;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeltaLakeWriter {
    @Test
    public void testMergeIntStatistics() {
        String columnName = "t_int";
        PrimitiveType intType = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, intType, 10L, Statistics.getBuilderForReading((PrimitiveType)intType).withMin(TestDeltaLakeWriter.getIntByteArray(-100)).withMax(TestDeltaLakeWriter.getIntByteArray(250)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, intType, 10L, Statistics.getBuilderForReading((PrimitiveType)intType).withMin(TestDeltaLakeWriter.getIntByteArray(-200)).withMax(TestDeltaLakeWriter.getIntByteArray(150)).withNumNulls(7L).build()));
        DeltaLakeColumnHandle intColumn = new DeltaLakeColumnHandle(columnName, (Type)IntegerType.INTEGER, OptionalInt.empty(), columnName, (Type)IntegerType.INTEGER, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)IntegerType.INTEGER), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(intColumn)).isEqualTo(Optional.of(-200L));
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(intColumn)).isEqualTo(Optional.of(250L));
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.of(13L));
    }

    @Test
    public void testMergeFloatStatistics() {
        String columnName = "t_float";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getFloatByteArray(0.01f)).withMax(TestDeltaLakeWriter.getFloatByteArray(1.0f)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getFloatByteArray(-2.001f)).withMax(TestDeltaLakeWriter.getFloatByteArray(0.0f)).withNumNulls(7L).build()));
        DeltaLakeColumnHandle floatColumn = new DeltaLakeColumnHandle(columnName, (Type)RealType.REAL, OptionalInt.empty(), columnName, (Type)RealType.REAL, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)RealType.REAL), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(floatColumn)).isEqualTo(Optional.of(Long.valueOf(Float.floatToRawIntBits(-2.001f))));
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(floatColumn)).isEqualTo(Optional.of(Long.valueOf(Float.floatToRawIntBits(1.0f))));
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.of(13L));
    }

    @Test
    public void testMergeFloatNaNStatistics() {
        String columnName = "t_float";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getFloatByteArray(0.01f)).withMax(TestDeltaLakeWriter.getFloatByteArray(1.0f)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getFloatByteArray(Float.NaN)).withMax(TestDeltaLakeWriter.getFloatByteArray(1.0f)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getFloatByteArray(-2.001f)).withMax(TestDeltaLakeWriter.getFloatByteArray(0.0f)).withNumNulls(7L).build()));
        DeltaLakeColumnHandle floatColumn = new DeltaLakeColumnHandle(columnName, (Type)RealType.REAL, OptionalInt.empty(), columnName, (Type)RealType.REAL, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)RealType.REAL), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(floatColumn)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(floatColumn)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.empty());
    }

    @Test
    public void testMergeDoubleNaNStatistics() {
        String columnName = "t_double";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getDoubleByteArray(0.01f)).withMax(TestDeltaLakeWriter.getDoubleByteArray(1.0)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getDoubleByteArray(Double.NaN)).withMax(TestDeltaLakeWriter.getDoubleByteArray(1.0)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin(TestDeltaLakeWriter.getDoubleByteArray(-2.001f)).withMax(TestDeltaLakeWriter.getDoubleByteArray(0.0)).withNumNulls(7L).build()));
        DeltaLakeColumnHandle doubleColumn = new DeltaLakeColumnHandle(columnName, (Type)DoubleType.DOUBLE, OptionalInt.empty(), columnName, (Type)DoubleType.DOUBLE, DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)DoubleType.DOUBLE), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(doubleColumn)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(doubleColumn)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.empty());
    }

    @Test
    public void testMergeStringStatistics() {
        String columnName = "t_string";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin("aba".getBytes(StandardCharsets.UTF_8)).withMax("ab\u2318".getBytes(StandardCharsets.UTF_8)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin("aba".getBytes(StandardCharsets.UTF_8)).withMax("abc".getBytes(StandardCharsets.UTF_8)).withNumNulls(6L).build()));
        DeltaLakeColumnHandle varcharColumn = new DeltaLakeColumnHandle(columnName, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), columnName, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)VarcharType.createUnboundedVarcharType()), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(varcharColumn)).isEqualTo(Optional.of(Slices.utf8Slice((String)"aba")));
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(varcharColumn)).isEqualTo(Optional.of(Slices.utf8Slice((String)"ab\u2318")));
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.of(12L));
    }

    @Test
    public void testMergeStringUnicodeStatistics() {
        String columnName = "t_string";
        PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, columnName);
        ImmutableList metadata = ImmutableList.of((Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin("aba".getBytes(StandardCharsets.UTF_8)).withMax("ab\ufad8".getBytes(StandardCharsets.UTF_8)).withNumNulls(6L).build()), (Object)this.createMetaData(columnName, type, 10L, Statistics.getBuilderForReading((PrimitiveType)type).withMin("aba".getBytes(StandardCharsets.UTF_8)).withMax("ab\ud83d\udd74".getBytes(StandardCharsets.UTF_8)).withNumNulls(6L).build()));
        DeltaLakeColumnHandle varcharColumn = new DeltaLakeColumnHandle(columnName, (Type)VarcharType.createUnboundedVarcharType(), OptionalInt.empty(), columnName, (Type)VarcharType.createUnboundedVarcharType(), DeltaLakeColumnType.REGULAR, Optional.empty());
        DeltaLakeJsonFileStatistics fileStats = DeltaLakeWriter.mergeStats(this.buildMultimap(columnName, (List<ColumnChunkMetadata>)metadata), (Map)ImmutableMap.of((Object)columnName, (Object)VarcharType.createUnboundedVarcharType()), (long)20L);
        Assertions.assertThat((Optional)fileStats.getNumRecords()).isEqualTo(Optional.of(20L));
        Assertions.assertThat((Optional)fileStats.getMinColumnValue(varcharColumn)).isEqualTo(Optional.of(Slices.utf8Slice((String)"aba")));
        Assertions.assertThat((Optional)fileStats.getMaxColumnValue(varcharColumn)).isEqualTo(Optional.of(Slices.utf8Slice((String)"ab\ud83d\udd74")));
        Assertions.assertThat((Optional)fileStats.getNullCount(columnName)).isEqualTo(Optional.of(12L));
    }

    private ColumnChunkMetadata createMetaData(String columnName, PrimitiveType columnType, long valueCount, Statistics<?> statistics) {
        return ColumnChunkMetadata.get((ColumnPath)ColumnPath.fromDotString((String)columnName), (PrimitiveType)columnType, (CompressionCodecName)CompressionCodecName.SNAPPY, (EncodingStats)new EncodingStats.Builder().build(), (Set)ImmutableSet.of(), statistics, (long)0L, (long)0L, (long)valueCount, (long)0L, (long)0L);
    }

    private Multimap<String, ColumnChunkMetadata> buildMultimap(String columnName, List<ColumnChunkMetadata> metadata) {
        return ImmutableMultimap.builder().putAll((Object)columnName, metadata).build();
    }

    static byte[] getIntByteArray(int i) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(i).array();
    }

    static byte[] getFloatByteArray(float f) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putFloat(f).array();
    }

    static byte[] getDoubleByteArray(double d) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putDouble(d).array();
    }
}

