/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.MoreCollectors;
import io.trino.Session;
import io.trino.operator.OperatorStats;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.spi.QueryId;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.OptionalLongAssert;
import org.junit.jupiter.api.Test;

public class TestPredicatePushdown
extends AbstractTestQueryFramework {
    private static final Path RESOURCE_PATH = Path.of("databricks73/pushdown/", new String[0]);
    private final String bucketName = "delta-test-pushdown-" + TestingNames.randomNameSuffix();
    private final TableResource testTable = new TableResource("custkey_15rowgroups");
    private Hive3MinioDataLake hiveMinioDataLake;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass((AutoCloseable)new Hive3MinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        return DeltaLakeQueryRunner.builder().addMetastoreProperties(this.hiveMinioDataLake.getHiveHadoop()).addS3Properties(this.hiveMinioDataLake.getMinio(), this.bucketName).addDeltaProperty("delta.enable-non-concurrent-writes", "true").addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
    }

    @Test
    public void testSelectPushdown() {
        String table = this.testTable.register("select_pushdown");
        this.assertPushdown(String.format("SELECT custkey FROM %s WHERE custkey > 1495", table), "SELECT * FROM UNNEST(ARRAY[1496, 1497, 1498, 1499, 1500])", 100L);
        this.assertPushdown(String.format("SELECT custkey FROM %s WHERE custkey = 500", table), "SELECT 500", 700L);
    }

    @Test
    public void testDeletePushdown() {
        String table = this.testTable.register("delete_pushdown");
        this.assertPushdownUpdate(String.format("DELETE FROM %s WHERE custkey > 1300", table), 200L, 500L);
        Assertions.assertThat((Collection)this.execute(String.format("SELECT custkey FROM %s", table)).getOnlyColumnAsSet()).isEqualTo((Object)ContiguousSet.closed((long)1L, (long)1300L));
        table = this.testTable.register("delete_pushdown_disjoint");
        this.assertPushdownUpdate(String.format("DELETE FROM %s WHERE custkey <= 500 OR custkey > 1100", table), 900L, 1100L);
        Assertions.assertThat((Collection)this.execute(String.format("SELECT custkey FROM %s", table)).getOnlyColumnAsSet()).isEqualTo((Object)ContiguousSet.closed((long)501L, (long)1100L));
    }

    @Test
    public void testUpdatePushdown() {
        String table = this.testTable.register("update_pushdown_simple");
        this.assertPushdownUpdate(String.format("UPDATE %s SET phone = 'phone number' WHERE custkey = 500", table), 1L, 700L);
        this.assertQuery(String.format("SELECT phone FROM %s WHERE custkey = 500", table), "VALUES 'phone number'");
        table = this.testTable.register("update_pushdown_range");
        this.assertPushdownUpdate(String.format("UPDATE %s SET mktsegment = phone WHERE 1000 < custkey AND custkey <= 1200", table), 200L, 900L);
        this.assertQueryReturnsEmptyResult(String.format("SELECT * FROM %s WHERE mktsegment = phone AND NOT (1000 < custkey AND custkey <= 1200)", table));
    }

    @Test
    public void testIgnoreParquetStatistics() {
        String table = this.testTable.register("ignore_parquet_statistics");
        String query = "SELECT * FROM " + table + " WHERE custkey = 1450";
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        QueryRunner.MaterializedResultWithPlan resultWithoutParquetStatistics = queryRunner.executeWithPlan(Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "parquet_ignore_statistics", "true").build(), query);
        OperatorStats queryStatsWithoutParquetStatistics = this.getOperatorStats(resultWithoutParquetStatistics.queryId());
        Assertions.assertThat((long)queryStatsWithoutParquetStatistics.getPhysicalInputPositions()).isGreaterThan(0L);
        QueryRunner.MaterializedResultWithPlan resultWithParquetStatistics = queryRunner.executeWithPlan(this.getSession(), query);
        OperatorStats queryStatsWithParquetStatistics = this.getOperatorStats(resultWithParquetStatistics.queryId());
        Assertions.assertThat((long)queryStatsWithParquetStatistics.getPhysicalInputPositions()).isGreaterThan(0L);
        Assertions.assertThat((long)queryStatsWithParquetStatistics.getPhysicalInputPositions()).isLessThan(queryStatsWithoutParquetStatistics.getPhysicalInputPositions());
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)resultWithParquetStatistics.result(), (Iterable)resultWithoutParquetStatistics.result());
    }

    private OperatorStats getOperatorStats(QueryId queryId) {
        return (OperatorStats)this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(queryId).getQueryStats().getOperatorSummaries().stream().filter(summary -> summary.getOperatorType().startsWith("TableScan") || summary.getOperatorType().startsWith("Scan")).collect(MoreCollectors.onlyElement());
    }

    private void assertPushdown(String actual, String expected, long countProcessed) {
        QueryRunner.MaterializedResultWithPlan result = this.executeWithQueryId(actual);
        Set actualRows = Set.copyOf(result.result().getMaterializedRows());
        Set expectedRows = Set.copyOf(this.computeExpected(expected, result.result().getTypes()).getMaterializedRows());
        ((OptionalAssert)Assertions.assertThat((Optional)result.result().getUpdateType()).describedAs("Query should not have update type", new Object[0])).isEmpty();
        Assertions.assertThat(actualRows).isEqualTo(expectedRows);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getProcessedPositions(result.queryId())).describedAs("Wrong number of rows processed after pushdown to Parquet", new Object[0])).isEqualTo(countProcessed);
    }

    private void assertPushdownUpdate(String sql, long count, long countProcessed) {
        QueryRunner.MaterializedResultWithPlan result = this.executeWithQueryId(sql);
        OptionalLong actualCount = result.result().getUpdateCount();
        ((OptionalLongAssert)Assertions.assertThat((OptionalLong)actualCount).describedAs("Missing update count", new Object[0])).isPresent();
        ((AbstractLongAssert)Assertions.assertThat((long)actualCount.getAsLong()).describedAs("Wrong number of rows updated", new Object[0])).isEqualTo(count);
        ((AbstractLongAssert)Assertions.assertThat((long)this.getProcessedPositions(result.queryId())).describedAs("Wrong amount of data filtered by pushdown to Parquet", new Object[0])).isEqualTo(countProcessed);
    }

    private QueryRunner.MaterializedResultWithPlan executeWithQueryId(String sql) {
        return this.getDistributedQueryRunner().executeWithPlan(this.getSession(), sql);
    }

    private MaterializedResult execute(String sql) {
        return this.getQueryRunner().execute(sql);
    }

    private long getProcessedPositions(QueryId query) {
        return this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(query).getQueryStats().getProcessedInputPositions();
    }

    private class TableResource {
        private final String resourcePath;

        private TableResource(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        String register(String namePrefix) {
            String name = String.format("%s_%s", namePrefix, TestingNames.randomNameSuffix());
            TestPredicatePushdown.this.hiveMinioDataLake.copyResources(RESOURCE_PATH.resolve(this.resourcePath).toString(), name);
            TestPredicatePushdown.this.getQueryRunner().execute(String.format("CALL system.register_table(CURRENT_SCHEMA, '%2$s', 's3://%1$s/%2$s')", TestPredicatePushdown.this.bucketName, name));
            return name;
        }
    }
}

