/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestReadJsonTransactionLog {
    private final ObjectMapper objectMapper = new ObjectMapperProvider().get();

    @Test
    public void testAdd() {
        Assertions.assertThat((long)this.readJsonTransactionLogs("databricks73/person/_delta_log").map(this::deserialize).map(DeltaLakeTransactionLogEntry::getAdd).filter(Objects::nonNull).map(AddFileEntry::getPath).filter(Objects::nonNull).count()).isEqualTo(18L);
        Assertions.assertThat((long)this.readJsonTransactionLogs("deltalake/person/_delta_log").map(this::deserialize).map(DeltaLakeTransactionLogEntry::getAdd).filter(Objects::nonNull).map(AddFileEntry::getPath).filter(Objects::nonNull).count()).isEqualTo(18L);
    }

    @Test
    public void testRemove() {
        Assertions.assertThat((long)this.readJsonTransactionLogs("databricks73/person/_delta_log").map(this::deserialize).map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull).map(RemoveFileEntry::path).filter(Objects::nonNull).count()).isEqualTo(6L);
        Assertions.assertThat((long)this.readJsonTransactionLogs("deltalake/person/_delta_log").map(this::deserialize).map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull).map(RemoveFileEntry::path).filter(Objects::nonNull).count()).isEqualTo(6L);
    }

    @Test
    public void testReadLastCheckpointFile() throws JsonProcessingException {
        LastCheckpoint lastCheckpoint = (LastCheckpoint)this.objectMapper.readValue("{\"version\":10,\"size\":17}", LastCheckpoint.class);
        Assertions.assertThat((long)lastCheckpoint.version()).isEqualTo(10L);
        Assertions.assertThat((long)lastCheckpoint.size()).isEqualTo(17L);
        Assertions.assertThat((Optional)lastCheckpoint.parts()).isEmpty();
    }

    @Test
    public void testReadLastCheckpointFileForMultipart() throws JsonProcessingException {
        LastCheckpoint lastCheckpoint = (LastCheckpoint)this.objectMapper.readValue("{\"version\":237580,\"size\":658573,\"parts\":2}", LastCheckpoint.class);
        Assertions.assertThat((long)lastCheckpoint.version()).isEqualTo(237580L);
        Assertions.assertThat((long)lastCheckpoint.size()).isEqualTo(658573L);
        Assertions.assertThat((Optional)lastCheckpoint.parts()).hasValue((Object)2);
    }

    private Stream<String> readJsonTransactionLogs(String location) {
        File directory = this.directoryForResource(location);
        File[] files = directory.listFiles((dir, name) -> name.matches("[0-9]{20}\\.json"));
        Verify.verify((files != null ? 1 : 0) != 0);
        return Arrays.stream(files).sorted().flatMap(TestReadJsonTransactionLog::lines).map(line -> line.endsWith("x") ? line.substring(0, line.length() - 1) : line);
    }

    private static Stream<String> lines(File file) {
        Stream stream;
        block8: {
            Stream<String> lines = Files.lines(file.toPath());
            try {
                stream = ((ImmutableList)lines.collect(ImmutableList.toImmutableList())).stream();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            lines.close();
        }
        return stream;
    }

    private DeltaLakeTransactionLogEntry deserialize(String json) {
        try {
            return (DeltaLakeTransactionLogEntry)this.objectMapper.readValue(json, DeltaLakeTransactionLogEntry.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to parse " + json, e);
        }
    }

    private File directoryForResource(String location) {
        try {
            return new File(this.getClass().getClassLoader().getResource(location).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

