/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import io.airlift.configuration.ConfigBinder;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeConnectorFactory;
import io.trino.plugin.deltalake.DeltaLakePlugin;
import io.trino.plugin.deltalake.TestingDeltaLakeExtensionsModule;
import io.trino.plugin.deltalake.transactionlog.writer.LocalTransactionLogSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.plugin.hive.metastore.file.FileHiveMetastoreConfig;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingDeltaLakePlugin
extends DeltaLakePlugin {
    private final Path localFileSystemRootPath;
    private final Optional<Module> metastoreModule;

    public TestingDeltaLakePlugin(Path localFileSystemRootPath) {
        this(localFileSystemRootPath, Optional.empty());
    }

    public TestingDeltaLakePlugin(Path localFileSystemRootPath, Optional<Module> metastoreModule) {
        this.localFileSystemRootPath = Objects.requireNonNull(localFileSystemRootPath, "localFileSystemRootPath is null");
        this.metastoreModule = Objects.requireNonNull(metastoreModule, "metastoreModule is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return List.of(new ConnectorFactory(){

            public String getName() {
                return "delta_lake";
            }

            public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
                TestingDeltaLakePlugin.this.localFileSystemRootPath.toFile().mkdirs();
                return DeltaLakeConnectorFactory.createConnector((String)catalogName, config, (ConnectorContext)context, TestingDeltaLakePlugin.this.metastoreModule, binder -> {
                    binder.install((Module)new TestingDeltaLakeExtensionsModule());
                    LocalFileSystemFactory localFileSystemFactory = new LocalFileSystemFactory(TestingDeltaLakePlugin.this.localFileSystemRootPath);
                    MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class).addBinding((Object)"local").toInstance((Object)localFileSystemFactory);
                    MapBinder.newMapBinder((Binder)binder, String.class, TransactionLogSynchronizer.class).addBinding((Object)"local").toInstance((Object)new LocalTransactionLogSynchronizer((TrinoFileSystemFactory)localFileSystemFactory));
                    ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(FileHiveMetastoreConfig.class, defaults -> defaults.setCatalogDirectory("local:///"));
                });
            }
        });
    }
}

