/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeConnector;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.testing.PlanTester;
import io.trino.testing.QueryRunner;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class TestingDeltaLakeUtils {
    private TestingDeltaLakeUtils() {
    }

    public static <T> T getConnectorService(PlanTester planTester, Class<T> clazz) {
        return (T)((DeltaLakeConnector)planTester.getConnector("delta")).getInjector().getInstance(clazz);
    }

    public static <T> T getConnectorService(QueryRunner queryRunner, Class<T> clazz) {
        return (T)((DeltaLakeConnector)queryRunner.getCoordinator().getConnector("delta")).getInjector().getInstance(clazz);
    }

    public static List<AddFileEntry> getTableActiveFiles(TransactionLogAccess transactionLogAccess, String tableLocation) throws IOException {
        SchemaTableName dummyTable = new SchemaTableName("dummy_schema_placeholder", "dummy_table_placeholder");
        transactionLogAccess.flushCache();
        TableSnapshot snapshot = transactionLogAccess.loadSnapshot(DeltaTestingConnectorSession.SESSION, dummyTable, tableLocation, Optional.empty());
        MetadataEntry metadataEntry = transactionLogAccess.getMetadataEntry(DeltaTestingConnectorSession.SESSION, snapshot);
        ProtocolEntry protocolEntry = transactionLogAccess.getProtocolEntry(DeltaTestingConnectorSession.SESSION, snapshot);
        try (Stream addFileEntries = transactionLogAccess.getActiveFiles(DeltaTestingConnectorSession.SESSION, snapshot, metadataEntry, protocolEntry, TupleDomain.all(), (Predicate)Predicates.alwaysTrue());){
            List list = (List)addFileEntries.collect(ImmutableList.toImmutableList());
            return list;
        }
    }

    public static void copyDirectoryContents(Path source, Path destination) throws IOException {
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
            stream.forEach(file -> {
                try {
                    Files.copy(file, destination.resolve(source.relativize((Path)file)), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

