/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import com.google.common.io.Resources;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.plugin.deltalake.DeltaTestingConnectorSession;
import io.trino.plugin.deltalake.delete.DeletionVectors;
import io.trino.plugin.deltalake.delete.RoaringBitmapArray;
import io.trino.plugin.deltalake.transactionlog.DeletionVectorEntry;
import io.trino.plugin.hive.HiveTestUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.OptionalInt;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeletionVectors {
    @Test
    public void testUuidStorageType() throws Exception {
        Path path = new File(Resources.getResource((String)"databricks122/deletion_vectors").toURI()).toPath();
        TrinoFileSystem fileSystem = HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY.create(DeltaTestingConnectorSession.SESSION);
        DeletionVectorEntry deletionVector = new DeletionVectorEntry("u", "R7QFX3rGXPFLhHGq&7g<", OptionalInt.of(1), 34, 1L);
        RoaringBitmapArray bitmaps = DeletionVectors.readDeletionVectors((TrinoFileSystem)fileSystem, (Location)Location.of((String)path.toString()), (DeletionVectorEntry)deletionVector);
        Assertions.assertThat((boolean)bitmaps.contains(0L)).isFalse();
        Assertions.assertThat((boolean)bitmaps.contains(1L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(2L)).isFalse();
    }

    @Test
    public void testUnsupportedInlineStorageType() {
        TrinoFileSystem fileSystem = HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY.create(DeltaTestingConnectorSession.SESSION);
        DeletionVectorEntry deletionVector = new DeletionVectorEntry("i", "wi5b=000010000siXQKl0rr91000f55c8Xg0@@D72lkbi5=-{L", OptionalInt.empty(), 40, 1L);
        Assertions.assertThatThrownBy(() -> DeletionVectors.readDeletionVectors((TrinoFileSystem)fileSystem, (Location)Location.of((String)"s3://bucket/table"), (DeletionVectorEntry)deletionVector)).hasMessageContaining("Unsupported storage type for deletion vector: i");
    }

    @Test
    public void testToFileName() {
        Assertions.assertThat((String)DeletionVectors.toFileName((String)"R7QFX3rGXPFLhHGq&7g<")).isEqualTo("deletion_vector_a52eda8c-0a57-4636-814b-9c165388f7ca.bin");
        Assertions.assertThat((String)DeletionVectors.toFileName((String)"ab^-aqEH.-t@S}K{vb[*k^")).isEqualTo("ab/deletion_vector_d2c639aa-8816-431a-aaf6-d3fe2512ff61.bin");
    }
}

