/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.delete;

import io.trino.plugin.deltalake.delete.RoaringBitmapArray;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestRoaringBitmapArray {
    TestRoaringBitmapArray() {
    }

    @Test
    void testIsEmpty() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        Assertions.assertThat((boolean)bitmaps.isEmpty()).isTrue();
        bitmaps.add(0L);
        Assertions.assertThat((boolean)bitmaps.isEmpty()).isFalse();
    }

    @Test
    void testLength() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        Assertions.assertThat((long)bitmaps.length()).isZero();
        bitmaps.add(0L);
        Assertions.assertThat((long)bitmaps.length()).isEqualTo(1L);
        bitmaps.add(1L);
        Assertions.assertThat((long)bitmaps.length()).isEqualTo(1L);
    }

    @Test
    void testCardinality() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        Assertions.assertThat((long)bitmaps.cardinality()).isZero();
        bitmaps.add(0L);
        Assertions.assertThat((long)bitmaps.cardinality()).isEqualTo(1L);
        bitmaps.add(1L);
        Assertions.assertThat((long)bitmaps.cardinality()).isEqualTo(2L);
    }

    @Test
    void testSerializedSizeInBytes() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        Assertions.assertThat((int)bitmaps.serializedSizeInBytes()).isZero();
        bitmaps.add(0L);
        Assertions.assertThat((int)bitmaps.serializedSizeInBytes()).isEqualTo(22);
        bitmaps.add(1L);
        Assertions.assertThat((int)bitmaps.serializedSizeInBytes()).isEqualTo(24);
    }

    @Test
    void testAdd() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        bitmaps.add(0L);
        Assertions.assertThat((boolean)bitmaps.contains(0L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(1L)).isFalse();
        bitmaps.add(0x80000000L);
        Assertions.assertThat((boolean)bitmaps.contains(Integer.MAX_VALUE)).isFalse();
        Assertions.assertThat((boolean)bitmaps.contains(0x80000000L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(0x80000001L)).isFalse();
    }

    @Test
    void testAddRange() {
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        bitmaps.addRange(3L, 5L);
        Assertions.assertThat((boolean)bitmaps.contains(2L)).isFalse();
        Assertions.assertThat((boolean)bitmaps.contains(3L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(4L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(5L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(6L)).isFalse();
        bitmaps.addRange(7L, 8L);
        Assertions.assertThat((boolean)bitmaps.contains(2L)).isFalse();
        Assertions.assertThat((boolean)bitmaps.contains(3L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(4L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(5L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(6L)).isFalse();
        Assertions.assertThat((boolean)bitmaps.contains(7L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(8L)).isTrue();
        Assertions.assertThat((boolean)bitmaps.contains(9L)).isFalse();
    }

    @Test
    void testOr() {
        RoaringBitmapArray bitmapsOr = new RoaringBitmapArray();
        bitmapsOr.add(2L);
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        bitmaps.add(3L);
        bitmapsOr.or(bitmaps);
        Assertions.assertThat((boolean)bitmapsOr.contains(1L)).isFalse();
        Assertions.assertThat((boolean)bitmapsOr.contains(2L)).isTrue();
        Assertions.assertThat((boolean)bitmapsOr.contains(3L)).isTrue();
        Assertions.assertThat((boolean)bitmapsOr.contains(4L)).isFalse();
    }

    @Test
    void testAndNot() {
        RoaringBitmapArray bitmapsAndNot = new RoaringBitmapArray();
        bitmapsAndNot.addRange(1L, 5L);
        RoaringBitmapArray bitmaps = new RoaringBitmapArray();
        bitmaps.addRange(2L, 4L);
        bitmapsAndNot.andNot(bitmaps);
        Assertions.assertThat((boolean)bitmapsAndNot.contains(1L)).isTrue();
        Assertions.assertThat((boolean)bitmapsAndNot.contains(2L)).isFalse();
        Assertions.assertThat((boolean)bitmapsAndNot.contains(3L)).isFalse();
        Assertions.assertThat((boolean)bitmapsAndNot.contains(4L)).isFalse();
        Assertions.assertThat((boolean)bitmapsAndNot.contains(5L)).isTrue();
    }
}

