/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import io.trino.plugin.deltalake.expression.ArithmeticBinaryExpression;
import io.trino.plugin.deltalake.expression.Identifier;
import io.trino.plugin.deltalake.expression.SparkExpression;
import io.trino.plugin.deltalake.expression.SparkExpressionParser;
import io.trino.plugin.deltalake.expression.StringLiteral;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSparkExpressionParser {
    @Test
    public void testStringLiteral() {
        TestSparkExpressionParser.assertStringLiteral("''", "");
        TestSparkExpressionParser.assertStringLiteral("'abc'", "abc");
        TestSparkExpressionParser.assertStringLiteral("'NULL'", "NULL");
        TestSparkExpressionParser.assertStringLiteral("'\u3042'", "\u3042");
        TestSparkExpressionParser.assertStringLiteral("'\\u3042'", "\u3042");
        TestSparkExpressionParser.assertStringLiteral("'\ud83d\udc4d'", "\ud83d\udc4d");
        TestSparkExpressionParser.assertStringLiteral("'\\U0001F44D'", "\ud83d\udc4d");
        TestSparkExpressionParser.assertStringLiteral("'a''quote'", "a'quote");
        TestSparkExpressionParser.assertStringLiteral("\"double-quote\"", "double-quote");
        TestSparkExpressionParser.assertStringLiteral("\"a\"\"double-quote\"", "a\"double-quote");
    }

    @Test
    public void testUnsupportedStringLiteral() {
        TestSparkExpressionParser.assertParseFailure("r'raw literal'", "extraneous input ''raw literal'' expecting <EOF>");
        TestSparkExpressionParser.assertParseFailure("r\"'\\n' represents newline character.\"", "extraneous input '\"'\\n' represents newline character.\"' expecting <EOF>");
        TestSparkExpressionParser.assertParseFailure("r 'a space after prefix'", "extraneous input ''a space after prefix'' expecting <EOF>");
        TestSparkExpressionParser.assertParseFailure("r  'two spaces after prefix'", "extraneous input ''two spaces after prefix'' expecting <EOF>");
    }

    @Test
    public void testArithmeticBinary() {
        Assertions.assertThat((Object)SparkExpressionParser.createExpression((String)"a + b * c")).isEqualTo((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (SparkExpression)new Identifier("a"), (SparkExpression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (SparkExpression)new Identifier("b"), (SparkExpression)new Identifier("c"))));
        Assertions.assertThat((Object)SparkExpressionParser.createExpression((String)"a * b + c")).isEqualTo((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (SparkExpression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (SparkExpression)new Identifier("a"), (SparkExpression)new Identifier("b")), (SparkExpression)new Identifier("c")));
    }

    private static void assertStringLiteral(String sparkExpression, String expected) {
        SparkExpression expression = SparkExpressionParser.createExpression((String)sparkExpression);
        Assertions.assertThat((Object)expression).isEqualTo((Object)new StringLiteral(expected));
    }

    private static void assertParseFailure(String sparkExpression, String reason) {
        Assertions.assertThatThrownBy(() -> SparkExpressionParser.createExpression((String)sparkExpression)).hasMessage("Cannot parse Spark expression [%s]: %s", new Object[]{sparkExpression, reason});
    }
}

