/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import io.trino.plugin.deltalake.expression.ParsingException;
import io.trino.plugin.deltalake.expression.SparkExpressionParser;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestSparkExpressions {
    @Test
    public void testBoolean() {
        TestSparkExpressions.assertExpressionTranslates("a = true", "(\"a\" = true)");
        TestSparkExpressions.assertExpressionTranslates("true", "true");
    }

    @Test
    public void testString() {
        TestSparkExpressions.assertExpressionTranslates("a = 'test'", "(\"a\" = 'test')");
        TestSparkExpressions.assertExpressionTranslates("a = '\\u3042'", "(\"a\" = '\u3042')");
        TestSparkExpressions.assertExpressionTranslates("a = '\\U0001F44D'", "(\"a\" = '\ud83d\udc4d')");
        TestSparkExpressions.assertExpressionTranslates("a = 'quote'", "(\"a\" = 'quote')");
        TestSparkExpressions.assertExpressionTranslates("a = 'a''quote'", "(\"a\" = 'a''quote')");
        TestSparkExpressions.assertExpressionTranslates("a = \"double-quote\"", "(\"a\" = 'double-quote')");
        TestSparkExpressions.assertExpressionTranslates("a = \"a\"\"double-quote\"", "(\"a\" = 'a\"double-quote')");
        TestSparkExpressions.assertParseFailure("a = 'a\\nwrap'");
    }

    @Test
    public void testNumber() {
        TestSparkExpressions.assertExpressionTranslates("a = -1", "(\"a\" = -1)");
    }

    @Test
    public void testEquals() {
        TestSparkExpressions.assertExpressionTranslates("a = 1", "(\"a\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("a = 'test'", "(\"a\" = 'test')");
    }

    @Test
    public void testNotEquals() {
        TestSparkExpressions.assertExpressionTranslates("a <> 1", "(\"a\" <> 1)");
        TestSparkExpressions.assertExpressionTranslates("a != 1", "(\"a\" <> 1)");
    }

    @Test
    public void testLessThan() {
        TestSparkExpressions.assertExpressionTranslates("a < 1", "(\"a\" < 1)");
    }

    @Test
    public void testLessThanOrEquals() {
        TestSparkExpressions.assertExpressionTranslates("a <= 1", "(\"a\" <= 1)");
    }

    @Test
    public void testGraterThan() {
        TestSparkExpressions.assertExpressionTranslates("a > 1", "(\"a\" > 1)");
    }

    @Test
    public void testGraterThanOrEquals() {
        TestSparkExpressions.assertExpressionTranslates("a >= 1", "(\"a\" >= 1)");
    }

    @Test
    public void testAnd() {
        TestSparkExpressions.assertExpressionTranslates("a > 1 AND a < 10", "((\"a\" > 1) AND (\"a\" < 10))");
    }

    @Test
    public void testOr() {
        TestSparkExpressions.assertExpressionTranslates("a > 1 OR a < 10", "((\"a\" > 1) OR (\"a\" < 10))");
    }

    @Test
    public void testIdentifier() {
        TestSparkExpressions.assertExpressionTranslates("`a` = 1", "(\"a\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`UPPERCASE` = 1", "(\"UPPERCASE\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`123` = 1", "(\"123\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a.dot` = 1", "(\"a.dot\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a``backtick` = 1", "(\"a`backtick\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a,comma` = 1", "(\"a,comma\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a;semicolon` = 1", "(\"a;semicolon\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a{}braces` = 1", "(\"a{}braces\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a()parenthesis` = 1", "(\"a()parenthesis\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a\nnewline` = 1", "(\"a\nnewline\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a\ttab` = 1", "(\"a\ttab\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a.dot` = 1", "(\"a.dot\" = 1)");
        TestSparkExpressions.assertExpressionTranslates("`a=equal` = 1", "(\"a=equal\" = 1)");
        TestSparkExpressions.assertParseFailure("`a`b` = 1");
    }

    @Test
    public void testArithmeticBinary() {
        TestSparkExpressions.assertExpressionTranslates("a = b % 1", "(\"a\" = (\"b\" % 1))");
        TestSparkExpressions.assertExpressionTranslates("a = b * 1", "(\"a\" = (\"b\" * 1))");
        TestSparkExpressions.assertExpressionTranslates("a = b + 1", "(\"a\" = (\"b\" + 1))");
        TestSparkExpressions.assertExpressionTranslates("a = b - 1", "(\"a\" = (\"b\" - 1))");
        TestSparkExpressions.assertExpressionTranslates("a = b / 1", "(\"a\" = (\"b\" / 1))");
        TestSparkExpressions.assertExpressionTranslates("a = b & 1", "(\"a\" = (bitwise_and(\"b\", 1)))");
        TestSparkExpressions.assertExpressionTranslates("a = b ^ 1", "(\"a\" = (bitwise_xor(\"b\", 1)))");
    }

    @Test
    public void testBetween() {
        TestSparkExpressions.assertExpressionTranslates("a BETWEEN 1 AND 10", "(\"a\" BETWEEN 1 AND 10)");
        TestSparkExpressions.assertExpressionTranslates("a NOT BETWEEN 1 AND 10", "(\"a\" NOT BETWEEN 1 AND 10)");
        TestSparkExpressions.assertExpressionTranslates("a BETWEEN NULL AND 10", "(\"a\" BETWEEN NULL AND 10)");
        TestSparkExpressions.assertExpressionTranslates("a BETWEEN 1 AND NULL", "(\"a\" BETWEEN 1 AND NULL)");
        TestSparkExpressions.assertExpressionTranslates("a NOT BETWEEN NULL AND NULL", "(\"a\" NOT BETWEEN NULL AND NULL)");
        TestSparkExpressions.assertExpressionTranslates("a not between null and null", "(\"a\" NOT BETWEEN NULL AND NULL)");
        TestSparkExpressions.assertExpressionTranslates("a BETWEEN b AND c", "(\"a\" BETWEEN \"b\" AND \"c\")");
    }

    @Test
    public void testInvalidNotBoolean() {
        TestSparkExpressions.assertParseFailure("'Spark' || 'SQL'");
    }

    @Test
    public void testUnsupportedRawStringLiteral() {
        TestSparkExpressions.assertParseFailure("a = r'Some\nText'");
    }

    @Test
    public void testUnsupportedNot() {
        TestSparkExpressions.assertParseFailure("NOT a = 1");
    }

    @Test
    public void testUnsupportedOperator() {
        TestSparkExpressions.assertParseFailure("a <=> 1");
        TestSparkExpressions.assertParseFailure("a == 1");
        TestSparkExpressions.assertParseFailure("a = b::INTEGER");
        TestSparkExpressions.assertParseFailure("a = json_column:root");
        TestSparkExpressions.assertParseFailure("a IS NULL");
        TestSparkExpressions.assertParseFailure("a IS DISTINCT FROM b");
        TestSparkExpressions.assertParseFailure("a IS true");
        TestSparkExpressions.assertParseFailure("a = 'Spark' || 'SQL'");
        TestSparkExpressions.assertParseFailure("a = 3 | 5");
        TestSparkExpressions.assertParseFailure("a = ~ 0");
        TestSparkExpressions.assertParseFailure("a = cast(TIMESTAMP'1970-01-01 00:00:01' AS LONG)");
    }

    @Test
    public void testUnsupportedTypes() {
        TestSparkExpressions.assertParseFailure("a = 123.456");
        TestSparkExpressions.assertParseFailure("a = x'123456'");
        TestSparkExpressions.assertParseFailure("a = date '2021-01-01'");
        TestSparkExpressions.assertParseFailure("a = timestamp '2021-01-01 00:00:00'");
        TestSparkExpressions.assertParseFailure("a = array(1, 2, 3)");
        TestSparkExpressions.assertParseFailure("a = map(1.0, '2', 3.0, '4')");
        TestSparkExpressions.assertParseFailure("a = struct(1, 2, 3)");
        TestSparkExpressions.assertParseFailure("a[0] = 1");
    }

    @Test
    public void testUnsupportedCallFunction() {
        TestSparkExpressions.assertParseFailure("a = abs(-1)");
    }

    private static void assertExpressionTranslates(@Language(value="SQL") String sparkExpression, @Language(value="SQL") String trinoExpression) {
        Assertions.assertThat((String)TestSparkExpressions.toTrinoExpression(sparkExpression)).isEqualTo(trinoExpression);
    }

    private static String toTrinoExpression(@Language(value="SQL") String sparkExpression) {
        return SparkExpressionParser.toTrinoExpression((String)sparkExpression);
    }

    private static void assertParseFailure(@Language(value="SQL") String sparkExpression) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSparkExpressions.toTrinoExpression(sparkExpression)).isInstanceOf(ParsingException.class)).hasMessageContaining("Cannot parse Spark expression");
    }
}

