/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.Table;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.deltalake.TestingDeltaLakeUtils;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableMetadataScheduler;
import io.trino.plugin.hive.metastore.MetastoreInvocations;
import io.trino.plugin.hive.metastore.MetastoreMethod;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.TestTable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestDeltaLakeMetastoreAccessOperations
extends AbstractTestQueryFramework {
    private HiveMetastore metastore;
    private DeltaLakeTableMetadataScheduler metadataScheduler;

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DeltaLakeQueryRunner.builder().addDeltaProperty("delta.register-table-procedure.enabled", "true").addDeltaProperty("delta.metastore.store-table-metadata", "true").addDeltaProperty("delta.metastore.store-table-metadata-threads", "0").addDeltaProperty("delta.metastore.store-table-metadata-interval", "30m").build();
        this.metastore = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, HiveMetastoreFactory.class).createMetastore(Optional.empty());
        this.metadataScheduler = TestingDeltaLakeUtils.getConnectorService((QueryRunner)queryRunner, DeltaLakeTableMetadataScheduler.class);
        return queryRunner;
    }

    @Test
    public void testCreateTable() {
        this.assertMetastoreInvocations("CREATE TABLE test_create (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testCreateOrReplaceTable() {
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.CREATE_TABLE).build());
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_create_or_replace (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.REPLACE_TABLE).build());
    }

    @Test
    public void testCreateTableAsSelect() {
        this.assertMetastoreInvocations("CREATE TABLE test_ctas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.CREATE_TABLE).add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testCreateOrReplaceTableAsSelect() {
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_cortas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.CREATE_TABLE).build());
        this.assertMetastoreInvocations("CREATE OR REPLACE TABLE test_cortas AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.REPLACE_TABLE).build());
    }

    @Test
    public void testSelect() {
        this.assertUpdate("CREATE TABLE test_select_from (id VARCHAR, age INT)");
        this.assertMetastoreInvocations("SELECT * FROM test_select_from", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_from_where AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SELECT * FROM test_select_from_where WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectFromView() {
        this.assertUpdate("CREATE TABLE test_select_view_table (id VARCHAR, age INT)");
        this.assertUpdate("CREATE VIEW test_select_view_view AS SELECT id, age FROM test_select_view_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_view", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_view_where_table AS SELECT 2 as age", 1L);
        this.assertUpdate("CREATE VIEW test_select_view_where_view AS SELECT age FROM test_select_view_where_table");
        this.assertMetastoreInvocations("SELECT * FROM test_select_view_where_view WHERE age = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelectFromMaterializedView() {
        this.assertUpdate("CREATE TABLE test_select_mview_table (id VARCHAR, age INT)");
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_select_mview_view AS SELECT id, age FROM test_select_mview_table", "This connector does not support creating materialized views");
    }

    @Test
    public void testSelectFromMaterializedViewWithFilter() {
        this.assertUpdate("CREATE TABLE test_select_mview_where_table AS SELECT 2 as age", 1L);
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_select_mview_where_view AS SELECT age FROM test_select_mview_where_table", "This connector does not support creating materialized views");
    }

    @Test
    public void testRefreshMaterializedView() {
        this.assertUpdate("CREATE TABLE test_refresh_mview_table (id VARCHAR, age INT)");
        this.assertQueryFails("CREATE MATERIALIZED VIEW test_refresh_mview_view AS SELECT id, age FROM test_refresh_mview_table", "This connector does not support creating materialized views");
    }

    @Test
    public void testJoin() {
        this.assertUpdate("CREATE TABLE test_join_t1 AS SELECT 2 as age, 'id1' AS id", 1L);
        this.assertUpdate("CREATE TABLE test_join_t2 AS SELECT 'name1' as name, 'id1' AS id", 1L);
        this.assertMetastoreInvocations("SELECT name, age FROM test_join_t1 JOIN test_join_t2 ON test_join_t2.id = test_join_t1.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().addCopies((Object)MetastoreMethod.GET_TABLE, 2).build());
    }

    @Test
    public void testSelfJoin() {
        this.assertUpdate("CREATE TABLE test_self_join_table AS SELECT 2 as age, 0 parent, 3 AS id", 1L);
        this.assertMetastoreInvocations("SELECT child.age, parent.age FROM test_self_join_table child JOIN test_self_join_table parent ON child.parent = parent.id", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testExplainSelect() {
        this.assertUpdate("CREATE TABLE test_explain AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("EXPLAIN SELECT * FROM test_explain", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTable() {
        this.assertUpdate("CREATE TABLE test_show_stats AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR test_show_stats", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testShowStatsForTableWithFilter() {
        this.assertUpdate("CREATE TABLE test_show_stats_with_filter AS SELECT 2 as age", 1L);
        this.assertMetastoreInvocations("SHOW STATS FOR (SELECT * FROM test_show_stats_with_filter where age >= 2)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testDropTable() {
        this.assertUpdate("CREATE TABLE test_drop_table AS SELECT 20050910 as a_number", 1L);
        this.assertMetastoreInvocations("DROP TABLE test_drop_table", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.DROP_TABLE).build());
    }

    @Test
    public void testShowTables() {
        this.assertMetastoreInvocations("SHOW TABLES", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_ALL_DATABASES).add((Object)MetastoreMethod.GET_TABLES).build());
    }

    @Test
    public void testSelectWithoutMetadataInMetastore() {
        this.assertUpdate("CREATE TABLE test_select_without_cache (id VARCHAR, age INT)");
        this.removeMetadataCachingPropertiesFromMetastore("test_select_without_cache");
        this.assertMetastoreInvocations(this.getSession(), "SELECT * FROM test_select_without_cache", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build(), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(true));
        this.assertMetastoreInvocations("SELECT * FROM test_select_without_cache", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testUnionWithoutMetadataInMetastore() {
        this.assertUpdate("CREATE TABLE test_union_without_cache (id VARCHAR, age INT)");
        this.assertMetastoreInvocations("SELECT * FROM test_union_without_cache UNION ALL SELECT * FROM test_union_without_cache", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
        this.removeMetadataCachingPropertiesFromMetastore("test_union_without_cache");
        this.assertMetastoreInvocations(this.getSession(), "SELECT * FROM test_union_without_cache UNION ALL SELECT * FROM test_union_without_cache", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build(), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(true));
        this.assertMetastoreInvocations("SELECT * FROM test_union_without_cache UNION ALL SELECT * FROM test_union_without_cache", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testSelectVersionedWithoutMetadataInMetastore() {
        this.assertUpdate("CREATE TABLE test_select_versioned_without_cache AS SELECT 2 as age", 1L);
        this.removeMetadataCachingPropertiesFromMetastore("test_select_versioned_without_cache");
        this.assertMetastoreInvocations("SELECT * FROM test_select_versioned_without_cache FOR VERSION AS OF 0", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_TABLE).build());
    }

    @Test
    public void testStoreMetastoreCreateOrReplaceTable() {
        this.testStoreMetastoreCreateOrReplaceTable(true);
        this.testStoreMetastoreCreateOrReplaceTable(false);
    }

    private void testStoreMetastoreCreateOrReplaceTable(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        this.assertMetastoreInvocations(session, "CREATE OR REPLACE TABLE test_create_or_replace_without_cache (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)(storeTableMetadata ? MetastoreMethod.CREATE_TABLE : MetastoreMethod.REPLACE_TABLE)).build());
        this.removeMetadataCachingPropertiesFromMetastore("test_create_or_replace_without_cache");
        this.assertMetastoreInvocations(session, "CREATE OR REPLACE TABLE test_create_or_replace_without_cache (id VARCHAR, age INT)", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.REPLACE_TABLE).build(), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
    }

    @Test
    public void testStoreMetastoreCreateTableOrReplaceTableAsSelect() {
        this.testStoreMetastoreCreateTableOrReplaceTableAsSelect(true);
        this.testStoreMetastoreCreateTableOrReplaceTableAsSelect(false);
    }

    private void testStoreMetastoreCreateTableOrReplaceTableAsSelect(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        this.assertMetastoreInvocations(session, "CREATE OR REPLACE TABLE test_ctas_without_cache AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)(storeTableMetadata ? MetastoreMethod.CREATE_TABLE : MetastoreMethod.REPLACE_TABLE)).add((Object)MetastoreMethod.GET_TABLE).build());
        this.removeMetadataCachingPropertiesFromMetastore("test_ctas_without_cache");
        this.assertMetastoreInvocations(session, "CREATE OR REPLACE TABLE test_ctas_without_cache AS SELECT 1 AS age", (Multiset<MetastoreMethod>)ImmutableMultiset.builder().add((Object)MetastoreMethod.GET_DATABASE).add((Object)MetastoreMethod.GET_TABLE).add((Object)MetastoreMethod.REPLACE_TABLE).build(), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
    }

    @Test
    public void testStoreMetastoreCommentTable() {
        this.testStoreMetastoreCommentTable(true);
        this.testStoreMetastoreCommentTable(false);
    }

    private void testStoreMetastoreCommentTable(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            this.assertMetastoreInvocations(session, "COMMENT ON TABLE " + table.getName() + " IS 'test comment'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    @Test
    public void testStoreMetastoreCommentColumn() {
        this.testStoreMetastoreCommentColumn(true);
        this.testStoreMetastoreCommentColumn(false);
    }

    private void testStoreMetastoreCommentColumn(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int COMMENT 'test comment')");){
            this.assertMetastoreInvocations(session, "COMMENT ON COLUMN " + table.getName() + ".col IS 'new test comment'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    @Test
    public void testStoreMetastoreAlterColumn() {
        this.testStoreMetastoreAlterColumn(true);
        this.testStoreMetastoreAlterColumn(false);
    }

    private void testStoreMetastoreAlterColumn(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int NOT NULL) WITH (column_mapping_mode = 'name')");){
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " ALTER COLUMN col DROP NOT NULL", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " ADD COLUMN new_col int COMMENT 'test comment'", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " RENAME COLUMN new_col TO renamed_col", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " DROP COLUMN renamed_col", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertQueryFails(session, "ALTER TABLE " + table.getName() + " ALTER COLUMN col SET DATA TYPE bigint", "This connector does not support setting column types");
        }
    }

    @Test
    public void testStoreMetastoreSetTableProperties() {
        this.testStoreMetastoreSetTableProperties(true);
        this.testStoreMetastoreSetTableProperties(false);
    }

    private void testStoreMetastoreSetTableProperties(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " SET PROPERTIES change_data_feed_enabled = true", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    @Test
    public void testStoreMetastoreOptimize() {
        this.testStoreMetastoreOptimize(true);
        this.testStoreMetastoreOptimize(false);
    }

    private void testStoreMetastoreOptimize(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            this.assertMetastoreInvocations(session, "ALTER TABLE " + table.getName() + " EXECUTE optimize", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    @Test
    public void testStoreMetastoreVacuum() {
        this.testStoreMetastoreVacuum(true);
        this.testStoreMetastoreVacuum(false);
    }

    private void testStoreMetastoreVacuum(boolean storeTableMetadata) {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "store_table_metadata", Boolean.toString(storeTableMetadata)).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "vacuum_min_retention", "0s").build();
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "AS SELECT 1 a");){
            this.assertUpdate("UPDATE " + table.getName() + " SET a = 2", 1L);
            this.assertMetastoreInvocations(session, "CALL system.vacuum(schema_name => CURRENT_SCHEMA, table_name => '" + table.getName() + "', retention => '0s')", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE));
        }
    }

    @Test
    public void testStoreMetastoreRegisterTable() {
        this.testStoreMetastoreRegisterTable(true);
        this.testStoreMetastoreRegisterTable(false);
    }

    private void testStoreMetastoreRegisterTable(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int) COMMENT 'test comment'");){
            this.assertUpdate("INSERT INTO " + table.getName() + " VALUES 1", 1L);
            String tableLocation = ((Table)this.metastore.getTable("tpch", table.getName()).orElseThrow()).getStorage().getLocation();
            this.metastore.dropTable("tpch", table.getName(), false);
            this.assertMetastoreInvocations(session, "CALL system.register_table('%s', '%s', '%s')".formatted("tpch", table.getName(), tableLocation), (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_DATABASE, (Object)MetastoreMethod.CREATE_TABLE));
        }
    }

    @Test
    public void testStoreMetastoreDataManipulation() {
        this.testStoreMetastoreDataManipulation(true);
        this.testStoreMetastoreDataManipulation(false);
    }

    private void testStoreMetastoreDataManipulation(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        String schemaString = "{\"type\":\"struct\",\"fields\":[{\"name\":\"col\",\"type\":\"integer\",\"nullable\":true,\"metadata\":{}}]}";
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "(col int)");){
            Assertions.assertThat((Map)((Table)this.metastore.getTable("tpch", table.getName()).orElseThrow()).getParameters()).contains(new Map.Entry[]{Map.entry("trino_last_transaction_version", "0"), Map.entry("trino_metadata_schema_string", schemaString)});
            this.assertMetastoreInvocations(session, "INSERT INTO " + table.getName() + " VALUES 1", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "UPDATE " + table.getName() + " SET col = 2", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "MERGE INTO " + table.getName() + " t USING (SELECT * FROM (VALUES 2)) AS s(col) ON (t.col = s.col) WHEN MATCHED THEN UPDATE SET col = 3", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "DELETE FROM " + table.getName() + " WHERE col = 3", (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
            this.assertMetastoreInvocations(session, "DELETE FROM " + table.getName(), (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    @Test
    public void testStoreMetastoreTruncateTable() {
        this.testStoreMetastoreTruncateTable(true);
        this.testStoreMetastoreTruncateTable(false);
    }

    private void testStoreMetastoreTruncateTable(boolean storeTableMetadata) {
        Session session = this.sessionWithStoreTableMetadata(storeTableMetadata);
        try (TestTable table = this.newTrinoTable("test_cache_metastore", "AS SELECT 1 col");){
            this.assertMetastoreInvocations(session, "TRUNCATE TABLE " + table.getName(), (Multiset<MetastoreMethod>)ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE), TestDeltaLakeMetastoreAccessOperations.asyncInvocations(storeTableMetadata));
        }
    }

    private void removeMetadataCachingPropertiesFromMetastore(String tableName) {
        Table table = (Table)this.metastore.getTable((String)this.getSession().getSchema().orElseThrow(), tableName).orElseThrow();
        Table newMetastoreTable = Table.builder((Table)table).setParameters(Maps.filterKeys((Map)table.getParameters(), key -> !key.equals("trino_last_transaction_version"))).build();
        this.metastore.replaceTable(table.getDatabaseName(), table.getTableName(), newMetastoreTable, MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow())), (Map)ImmutableMap.of());
    }

    private Session sessionWithStoreTableMetadata(boolean storeTableMetadata) {
        return Session.builder((Session)this.getSession()).setCatalogSessionProperty((String)this.getSession().getCatalog().orElseThrow(), "store_table_metadata", Boolean.toString(storeTableMetadata)).build();
    }

    private void assertMetastoreInvocations(@Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        this.assertMetastoreInvocations(this.getSession(), query, expectedInvocations, (Multiset<MetastoreMethod>)ImmutableMultiset.of());
    }

    private void assertMetastoreInvocations(Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations) {
        this.assertMetastoreInvocations(session, query, expectedInvocations, (Multiset<MetastoreMethod>)ImmutableMultiset.of());
    }

    private void assertMetastoreInvocations(Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations, Multiset<MetastoreMethod> asyncInvocations) {
        this.assertUpdate("CALL system.flush_metadata_cache()");
        this.metadataScheduler.clear();
        TestDeltaLakeMetastoreAccessOperations.assertMetastoreInvocationsForQuery((QueryRunner)this.getDistributedQueryRunner(), session, query, expectedInvocations, () -> this.metadataScheduler.process(), asyncInvocations);
    }

    private static Multiset<MetastoreMethod> asyncInvocations(boolean storeTableParameter) {
        return storeTableParameter ? ImmutableMultiset.of((Object)MetastoreMethod.GET_TABLE, (Object)MetastoreMethod.REPLACE_TABLE) : ImmutableMultiset.of();
    }

    private static void assertMetastoreInvocationsForQuery(QueryRunner queryRunner, Session session, @Language(value="SQL") String query, Multiset<MetastoreMethod> expectedInvocations, Runnable asyncOperation, Multiset<MetastoreMethod> expectedInvocationsAfterAsync) {
        queryRunner.execute(session, query);
        List spansBeforeAsync = queryRunner.getSpans();
        asyncOperation.run();
        Sets.SetView spansAfterAsync = Sets.difference(new HashSet(queryRunner.getSpans()), new HashSet(spansBeforeAsync));
        Multiset invocations = MetastoreInvocations.filterInvocations((List)spansBeforeAsync);
        MultisetAssertions.assertMultisetsEqual((Multiset)invocations, expectedInvocations);
        Multiset asyncInvocations = MetastoreInvocations.filterInvocations((List)((List)spansAfterAsync.stream().collect(ImmutableList.toImmutableList())));
        MultisetAssertions.assertMultisetsEqual((Multiset)asyncInvocations, expectedInvocationsAfterAsync);
    }
}

