/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Reflection;
import com.google.common.util.concurrent.Uninterruptibles;
import io.trino.Session;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.deltalake.TestingDeltaLakePlugin;
import io.trino.plugin.deltalake.metastore.TestingDeltaLakeMetastoreModule;
import io.trino.plugin.hive.metastore.file.FileHiveMetastore;
import io.trino.plugin.hive.metastore.file.TestingFileHiveMetastore;
import io.trino.plugin.jmx.JmxPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

final class TestDeltaLakeTableMetadataScheduler
extends AbstractTestQueryFramework {
    TestDeltaLakeTableMetadataScheduler() {
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("delta").setSchema("default").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        Path dataDirectory = queryRunner.getCoordinator().getBaseDataDir().resolve("delta");
        FileHiveMetastore metastore = TestingFileHiveMetastore.createTestingFileHiveMetastore((File)dataDirectory.toFile());
        HiveMetastore proxiedMetastore = (HiveMetastore)Reflection.newProxy(HiveMetastore.class, (arg_0, arg_1, arg_2) -> TestDeltaLakeTableMetadataScheduler.lambda$createQueryRunner$0((HiveMetastore)metastore, arg_0, arg_1, arg_2));
        queryRunner.installPlugin((Plugin)new TestingDeltaLakePlugin(dataDirectory, Optional.of(new TestingDeltaLakeMetastoreModule(proxiedMetastore))));
        queryRunner.createCatalog("delta", "delta_lake", (Map)ImmutableMap.of((Object)"delta.metastore.store-table-metadata", (Object)"true"));
        queryRunner.installPlugin((Plugin)new JmxPlugin());
        queryRunner.createCatalog("jmx", "jmx");
        queryRunner.execute("CREATE SCHEMA delta.default");
        return queryRunner;
    }

    @Test
    @Disabled
    void testFailureStopScheduler() {
        String coordinatorId = (String)this.computeScalar("SELECT node_id FROM system.runtime.nodes WHERE coordinator = true");
        IntStream.range(0, 11).forEach(i -> this.assertUpdate("CREATE TABLE test_" + i + "(x int) WITH (column_mapping_mode = 'name')"));
        this.assertQuery("SELECT shutdown FROM jmx.current.\"trino.plugin.deltalake.metastore:catalog=delta,name=delta,type=deltalaketablemetadatascheduler\" WHERE node = '" + coordinatorId + "'", "VALUES false");
        IntStream.range(0, 11).forEach(i -> {
            this.assertUpdate("ALTER TABLE test_" + i + " RENAME COLUMN x to y");
            this.assertUpdate("COMMENT ON TABLE test_" + i + " IS 'test comment'");
        });
        Uninterruptibles.sleepUninterruptibly((Duration)Duration.of(1L, ChronoUnit.SECONDS));
        this.assertQuery("SELECT shutdown FROM jmx.current.\"trino.plugin.deltalake.metastore:catalog=delta,name=delta,type=deltalaketablemetadatascheduler\" WHERE node = '" + coordinatorId + "'", "VALUES true");
        this.assertQuery("SELECT table_name, column_name FROM information_schema.columns WHERE table_schema = CURRENT_SCHEMA", "VALUES ('test_0', 'y'), ('test_1', 'y'), ('test_2', 'y'), ('test_3', 'y'), ('test_4', 'y'), ('test_5', 'y'), ('test_6', 'y'), ('test_7', 'y'), ('test_8', 'y'), ('test_9', 'y'), ('test_10', 'y')");
        this.assertQuery("SELECT table_name, comment FROM system.metadata.table_comments WHERE schema_name = CURRENT_SCHEMA", "VALUES ('test_0', 'test comment'), ('test_1', 'test comment'), ('test_2', 'test comment'), ('test_3', 'test comment'), ('test_4', 'test comment'), ('test_5', 'test comment'), ('test_6', 'test comment'), ('test_7', 'test comment'), ('test_8', 'test comment'), ('test_9', 'test comment'), ('test_10', 'test comment')");
    }

    private static /* synthetic */ Object lambda$createQueryRunner$0(HiveMetastore metastore, Object object, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("replaceTable")) {
                throw new UnsupportedOperationException();
            }
            return method.invoke((Object)metastore, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

