/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.deltalake.AllowDeltaLakeManagedTableRename;
import io.trino.plugin.deltalake.MaxTableParameterLength;
import io.trino.plugin.deltalake.metastore.DeltaLakeTableOperationsProvider;
import io.trino.plugin.deltalake.metastore.file.DeltaLakeFileMetastoreTableOperationsProvider;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.CachingHiveMetastoreModule;
import java.util.Objects;

public class TestingDeltaLakeMetastoreModule
extends AbstractConfigurationAwareModule {
    private final HiveMetastore metastore;

    public TestingDeltaLakeMetastoreModule(HiveMetastore metastore) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public void setup(Binder binder) {
        binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).toInstance((Object)HiveMetastoreFactory.ofInstance((HiveMetastore)this.metastore));
        this.install((Module)new CachingHiveMetastoreModule());
        binder.bind(DeltaLakeTableOperationsProvider.class).to(DeltaLakeFileMetastoreTableOperationsProvider.class).in(Scopes.SINGLETON);
        binder.bind(Key.get(Boolean.TYPE, HideDeltaLakeTables.class)).toInstance((Object)false);
        binder.bind(Key.get(Boolean.TYPE, AllowDeltaLakeManagedTableRename.class)).toInstance((Object)true);
        binder.bind(Key.get(Integer.TYPE, MaxTableParameterLength.class)).toInstance((Object)Integer.MAX_VALUE);
    }
}

