/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import io.airlift.log.Logger;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;

public class TestDeltaLakeCleanUpGlueMetastore {
    private static final Logger log = Logger.get(TestDeltaLakeCleanUpGlueMetastore.class);
    private static final String TEST_DATABASE_NAME_PREFIX = "test_";
    private static final Duration CLEANUP_THRESHOLD = Duration.ofDays(1L);

    @Test
    public void cleanupOrphanedDatabases() {
        GlueClient glueClient = GlueClient.create();
        Instant creationTimeThreshold = Instant.now().minus(CLEANUP_THRESHOLD);
        List<String> orphanedDatabases = glueClient.getDatabasesPaginator(builder -> {}).stream().map(GetDatabasesResponse::databaseList).flatMap(Collection::stream).filter(database -> database.name().startsWith(TEST_DATABASE_NAME_PREFIX)).filter(database -> database.createTime().isBefore(creationTimeThreshold)).map(Database::name).toList();
        if (!orphanedDatabases.isEmpty()) {
            log.info("Found %s %s* databases that look orphaned, removing", new Object[]{orphanedDatabases.size(), TEST_DATABASE_NAME_PREFIX});
            orphanedDatabases.forEach(database -> {
                try {
                    log.info("Deleting %s database", new Object[]{database});
                    glueClient.deleteDatabase(builder -> builder.name(database));
                }
                catch (EntityNotFoundException e) {
                    log.info("Database [%s] not found, could be removed by other cleanup process", new Object[]{database});
                }
                catch (RuntimeException e) {
                    log.warn((Throwable)e, "Failed to remove database [%s]", new Object[]{database});
                }
            });
        }
    }
}

