/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonModule;
import io.airlift.testing.Closeables;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.metastore.Column;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.HiveType;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeModule;
import io.trino.plugin.deltalake.DeltaLakeSecurityModule;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastoreModule;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.TableType;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.TypeManager;
import io.trino.testing.TestingConnectorContext;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingNames;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDeltaLakeGlueMetastore {
    private File tempDir;
    private LifeCycleManager lifeCycleManager;
    private HiveMetastore metastoreClient;
    private DeltaLakeMetadataFactory metadataFactory;
    private String databaseName;
    private TestingConnectorSession session;

    @BeforeAll
    public void setUp() throws Exception {
        this.tempDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        String temporaryLocation = this.tempDir.toURI().toString();
        ImmutableMap config = ImmutableMap.builder().put((Object)"hive.metastore", (Object)"glue").put((Object)"delta.hide-non-delta-lake-tables", (Object)"true").put((Object)"fs.hadoop.enabled", (Object)"true").buildOrThrow();
        TestingConnectorContext context = new TestingConnectorContext();
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), arg_0 -> TestDeltaLakeGlueMetastore.lambda$setUp$0((ConnectorContext)context, arg_0), new DeltaLakeMetastoreModule(), new DeltaLakeModule(), new DeltaLakeSecurityModule(), new FileSystemModule("test", context.getNodeManager(), context.getOpenTelemetry(), false)});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties((Map)config).initialize();
        this.lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        this.metastoreClient = ((HiveMetastoreFactory)injector.getInstance(HiveMetastoreFactory.class)).createMetastore(Optional.empty());
        this.metadataFactory = (DeltaLakeMetadataFactory)injector.getInstance(DeltaLakeMetadataFactory.class);
        this.session = TestingConnectorSession.builder().setPropertyMetadata((List)((Set)injector.getInstance((Key)new Key<Set<SessionPropertiesProvider>>(this){})).stream().map(SessionPropertiesProvider::getSessionProperties).flatMap(Collection::stream).collect(ImmutableList.toImmutableList())).build();
        this.databaseName = "test_delta_glue" + TestingNames.randomNameSuffix();
        this.metastoreClient.createDatabase(Database.builder().setDatabaseName(this.databaseName).setOwnerName(Optional.of("public")).setOwnerType(Optional.of(PrincipalType.ROLE)).setLocation(Optional.of(temporaryLocation)).build());
    }

    @AfterAll
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{() -> this.metastoreClient.dropDatabase(this.databaseName, true), () -> this.lifeCycleManager.stop(), () -> {
            if (this.tempDir.exists()) {
                MoreFiles.deleteRecursively((Path)this.tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
        }});
        this.databaseName = null;
        this.lifeCycleManager = null;
        this.tempDir = null;
    }

    @Test
    public void testHideNonDeltaLakeTable() throws Exception {
        SchemaTableName deltaLakeTable = new SchemaTableName(this.databaseName, "delta_lake_table_" + TestingNames.randomNameSuffix());
        SchemaTableName nonDeltaLakeTable1 = new SchemaTableName(this.databaseName, "hive_table_" + TestingNames.randomNameSuffix());
        SchemaTableName nonDeltaLakeTable2 = new SchemaTableName(this.databaseName, "hive_table_" + TestingNames.randomNameSuffix());
        SchemaTableName nonDeltaLakeView1 = new SchemaTableName(this.databaseName, "hive_view_" + TestingNames.randomNameSuffix());
        String deltaLakeTableLocation = this.tableLocation(deltaLakeTable);
        this.createTable(deltaLakeTable, deltaLakeTableLocation, tableBuilder -> {
            tableBuilder.setParameter("spark.sql.sources.provider", "DELTA");
            tableBuilder.setParameter("location", deltaLakeTableLocation);
            tableBuilder.getStorageBuilder().setStorageFormat(DeltaLakeMetadata.DELTA_STORAGE_FORMAT).setSerdeParameters((Map)ImmutableMap.of((Object)"path", (Object)deltaLakeTableLocation)).setLocation(deltaLakeTableLocation);
        });
        this.createTransactionLog(deltaLakeTableLocation);
        this.createTable(nonDeltaLakeTable1, this.tableLocation(nonDeltaLakeTable1), tableBuilder -> {});
        this.createTable(nonDeltaLakeTable2, this.tableLocation(nonDeltaLakeTable2), tableBuilder -> tableBuilder.setParameter("spark.sql.sources.provider", "foo"));
        this.createView(nonDeltaLakeView1, this.tableLocation(nonDeltaLakeTable1), tableBuilder -> {});
        DeltaLakeMetadata metadata = this.metadataFactory.create(TestingConnectorSession.SESSION.getIdentity());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> metadata.getTableHandle((ConnectorSession)this.session, nonDeltaLakeTable1, Optional.empty(), Optional.empty())).isInstanceOf(TrinoException.class)).hasMessage(String.format("%s is not a Delta Lake table", nonDeltaLakeTable1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> metadata.getTableHandle((ConnectorSession)this.session, nonDeltaLakeTable2, Optional.empty(), Optional.empty())).isInstanceOf(TrinoException.class)).hasMessage(String.format("%s is not a Delta Lake table", nonDeltaLakeTable2));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)metadata.listTables((ConnectorSession)this.session, Optional.empty())).contains((Object[])new SchemaTableName[]{deltaLakeTable})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable1})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable2});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)metadata.listTables((ConnectorSession)this.session, Optional.of(this.databaseName))).contains((Object[])new SchemaTableName[]{deltaLakeTable})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable1})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable2});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(this.listTableColumns(metadata, new SchemaTablePrefix(this.databaseName))).contains((Object[])new SchemaTableName[]{deltaLakeTable})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable1})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable2});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat(this.listTableColumns(metadata, new SchemaTablePrefix(this.databaseName, deltaLakeTable.getTableName()))).contains((Object[])new SchemaTableName[]{deltaLakeTable})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable1})).doesNotContain((Object[])new SchemaTableName[]{nonDeltaLakeTable2});
        Assertions.assertThat(this.listTableColumns(metadata, new SchemaTablePrefix(this.databaseName, nonDeltaLakeTable1.getTableName()))).isEmpty();
        Assertions.assertThat(this.listTableColumns(metadata, new SchemaTablePrefix(this.databaseName, nonDeltaLakeTable2.getTableName()))).isEmpty();
        Assertions.assertThat(this.listTableColumns(metadata, new SchemaTablePrefix(this.databaseName, nonDeltaLakeView1.getTableName()))).isEmpty();
        metadata.cleanupQuery((ConnectorSession)this.session);
    }

    private Set<SchemaTableName> listTableColumns(DeltaLakeMetadata metadata, SchemaTablePrefix tablePrefix) {
        Iterator relationColumnsIterator = metadata.streamRelationColumns((ConnectorSession)this.session, tablePrefix.getSchema(), schemaTableNames -> (Set)schemaTableNames.stream().filter(arg_0 -> ((SchemaTablePrefix)tablePrefix).matches(arg_0)).collect(ImmutableSet.toImmutableSet()));
        ImmutableList relations = ImmutableList.copyOf((Iterator)relationColumnsIterator);
        Set redirectedTables = (Set)relations.stream().filter(RelationColumnsMetadata::redirected).map(RelationColumnsMetadata::name).collect(ImmutableSet.toImmutableSet());
        if (!redirectedTables.isEmpty()) {
            throw new IllegalStateException("Unexpected redirects reported for tables: " + String.valueOf(redirectedTables));
        }
        return (Set)relations.stream().map(RelationColumnsMetadata::name).collect(ImmutableSet.toImmutableSet());
    }

    private void createTransactionLog(String deltaLakeTableLocation) throws IOException {
        File deltaTableLogLocation = new File(new File(URI.create(deltaLakeTableLocation)), "_delta_log");
        Verify.verify((boolean)deltaTableLogLocation.mkdirs(), (String)"mkdirs() on '%s' failed", (Object)deltaTableLogLocation);
        String entry = Resources.toString((URL)Resources.getResource((String)"deltalake/person/_delta_log/00000000000000000000.json"), (Charset)StandardCharsets.UTF_8);
        Files.writeString(new File(deltaTableLogLocation, "00000000000000000000.json").toPath(), (CharSequence)entry, new OpenOption[0]);
    }

    private String tableLocation(SchemaTableName tableName) {
        return new File(this.tempDir, tableName.getTableName()).toURI().toString();
    }

    private void createTable(SchemaTableName tableName, String tableLocation, Consumer<Table.Builder> tableConfiguration) {
        Table.Builder table = Table.builder().setDatabaseName(tableName.getSchemaName()).setTableName(tableName.getTableName()).setOwner(Optional.of(this.session.getUser())).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(List.of(new Column("a_column", HiveType.HIVE_STRING, Optional.empty(), Map.of())));
        table.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat()).setLocation(tableLocation);
        tableConfiguration.accept(table);
        PrincipalPrivileges principalPrivileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
        this.metastoreClient.createTable(table.build(), principalPrivileges);
    }

    private void createView(SchemaTableName viewName, String tableLocation, Consumer<Table.Builder> tableConfiguration) {
        Table.Builder table = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(Optional.of(this.session.getUser())).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns(List.of(new Column("a_column", HiveType.HIVE_STRING, Optional.empty(), Map.of())));
        table.getStorageBuilder().setStorageFormat(HiveStorageFormat.PARQUET.toStorageFormat()).setLocation(tableLocation);
        tableConfiguration.accept(table);
        PrincipalPrivileges principalPrivileges = new PrincipalPrivileges((Multimap)ImmutableMultimap.of(), (Multimap)ImmutableMultimap.of());
        this.metastoreClient.createTable(table.build(), principalPrivileges);
    }

    private static /* synthetic */ void lambda$setUp$0(ConnectorContext context, Binder binder) {
        binder.bind(CatalogName.class).toInstance((Object)new CatalogName("test"));
        binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
        binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
        binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
        binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion("test_version"));
        binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
        binder.bind(Tracer.class).toInstance((Object)context.getTracer());
    }
}

