/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.deltalake.BaseDeltaLakeRegisterTableProcedureTest;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingNames;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.AfterAll;

public class TestDeltaLakeRegisterTableProcedureWithGlue
extends BaseDeltaLakeRegisterTableProcedureTest {
    private GlueHiveMetastore metastore;
    private String schema;

    protected QueryRunner createQueryRunner() throws Exception {
        Path warehouseDir = Files.createTempDirectory("warehouse-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)warehouseDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        TestDeltaLakeRegisterTableProcedureWithGlue testDeltaLakeRegisterTableProcedureWithGlue = this;
        this.metastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)warehouseDir, x$0 -> testDeltaLakeRegisterTableProcedureWithGlue.closeAfterClass((AutoCloseable)x$0));
        this.schema = "test_delta_lake_register_table" + TestingNames.randomNameSuffix();
        return DeltaLakeQueryRunner.builder(this.schema).addDeltaProperty("hive.metastore", "glue").addDeltaProperty("hive.metastore.glue.region", SystemEnvironmentUtils.requireEnv((String)"AWS_REGION")).addDeltaProperty("hive.metastore.glue.default-warehouse-dir", warehouseDir.toUri().toString()).addDeltaProperty("delta.unique-table-location", "true").addDeltaProperty("delta.register-table-procedure.enabled", "true").build();
    }

    @AfterAll
    public void tearDown() {
        this.metastore.dropDatabase(this.schema, false);
        this.metastore.shutdown();
    }
}

