/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeRenameToWithGlueMetastore
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        Path warehouseDir = Files.createTempDirectory("warehouse-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)warehouseDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        return DeltaLakeQueryRunner.builder("test_delta_lake_rename_to_with_glue_" + TestingNames.randomNameSuffix()).setDeltaProperties((Map<String, String>)ImmutableMap.of((Object)"hive.metastore", (Object)"glue")).addDeltaProperty("hive.metastore.glue.default-warehouse-dir", warehouseDir.toUri().toString()).build();
    }

    @AfterAll
    public void cleanup() {
        this.assertUpdate("DROP SCHEMA " + (String)this.getSession().getSchema().orElseThrow() + " CASCADE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameOfExternalTable() {
        String oldTable = "test_table_external_to_be_renamed_" + TestingNames.randomNameSuffix();
        String newTable = "test_table_external_renamed_" + TestingNames.randomNameSuffix();
        Path tableLocation = this.getQueryRunner().getCoordinator().getBaseDataDir().resolve(oldTable);
        try {
            this.assertUpdate(String.format("CREATE TABLE %s WITH (location = '%s') AS SELECT 1 AS val ", oldTable, tableLocation.toFile().toURI()), 1L);
            String oldLocation = (String)this.computeScalar("SELECT \"$path\" FROM " + oldTable);
            this.assertQuery("SELECT val FROM " + oldTable, "VALUES (1)");
            this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
            this.assertQueryReturnsEmptyResult("SHOW TABLES LIKE '" + oldTable + "'");
            this.assertQuery("SELECT val FROM " + newTable, "VALUES (1)");
            this.assertQuery("SELECT \"$path\" FROM " + newTable, "SELECT '" + oldLocation + "'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + oldTable);
            this.assertUpdate("DROP TABLE IF EXISTS " + newTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameOfManagedTable() {
        String oldTable = "test_table_managed_to_be_renamed_" + TestingNames.randomNameSuffix();
        String newTable = "test_table_managed_renamed_" + TestingNames.randomNameSuffix();
        try {
            this.assertUpdate(String.format("CREATE TABLE %s AS SELECT 1 AS val ", oldTable), 1L);
            String oldLocation = (String)this.computeScalar("SELECT \"$path\" FROM " + oldTable);
            this.assertQuery("SELECT val FROM " + oldTable, "VALUES (1)");
            this.assertUpdate("ALTER TABLE " + oldTable + " RENAME TO " + newTable);
            this.assertQueryReturnsEmptyResult("SHOW TABLES LIKE '" + oldTable + "'");
            this.assertQuery("SELECT val FROM " + newTable, "VALUES (1)");
            this.assertQuery("SELECT \"$path\" FROM " + newTable, "SELECT '" + oldLocation + "'");
        }
        finally {
            this.assertUpdate("DROP TABLE IF EXISTS " + oldTable);
            this.assertUpdate("DROP TABLE IF EXISTS " + newTable);
        }
    }
}

