/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore.glue;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.deltalake.DeltaLakeQueryRunner;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.TestingGlueHiveMetastore;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.SystemEnvironmentUtils;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import io.trino.testing.sql.TestView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestDeltaLakeViewsGlueMetastore
extends AbstractTestQueryFramework {
    private GlueHiveMetastore metastore;
    private String schema;

    protected QueryRunner createQueryRunner() throws Exception {
        Path warehouseDir = Files.createTempDirectory("warehouse-dir", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)warehouseDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        TestDeltaLakeViewsGlueMetastore testDeltaLakeViewsGlueMetastore = this;
        this.metastore = TestingGlueHiveMetastore.createTestingGlueHiveMetastore((Path)warehouseDir, x$0 -> testDeltaLakeViewsGlueMetastore.closeAfterClass((AutoCloseable)x$0));
        this.schema = "test_delta_lake_glue_views_" + TestingNames.randomNameSuffix();
        return DeltaLakeQueryRunner.builder(this.schema).addDeltaProperty("hive.metastore", "glue").addDeltaProperty("hive.metastore.glue.region", SystemEnvironmentUtils.requireEnv((String)"AWS_REGION")).addDeltaProperty("hive.metastore.glue.default-warehouse-dir", warehouseDir.toUri().toString()).build();
    }

    @AfterAll
    public void cleanup() throws IOException {
        this.metastore.dropDatabase(this.schema, false);
        this.metastore.shutdown();
    }

    @Test
    public void testCreateView() {
        String tableName = "test_glue_table_" + TestingNames.randomNameSuffix();
        String viewName = "test_glue_view_" + TestingNames.randomNameSuffix();
        try (TestTable table = this.newTrinoTable(tableName, "AS SELECT 'test' x");
             TestView view = new TestView(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), viewName, "SELECT * FROM " + table.getName());){
            this.assertQuery(String.format("SELECT * FROM %s", view.getName()), "VALUES 'test'");
            this.assertQuery(String.format("SELECT table_type FROM information_schema.tables WHERE table_name = '%s' AND table_schema='%s'", view.getName(), this.schema), "VALUES 'VIEW'");
            this.assertQuery(String.format("SELECT table_type FROM information_schema.tables WHERE table_name LIKE '%%%s' AND table_schema='%s'", view.getName(), this.schema), "VALUES 'VIEW'");
        }
    }
}

